     
     
     
     
      
     
     
     
     
     
     
     
                       The Install-Pro Reference Manual
     
                        Version 1.64 February 19, 1992
     
                     Copyright 1992 DB/Soft Publishing Co.
     
                              All Rights Reserved
     
     
     
     
     
     
     
     
     
     
     
     
                            DB/Soft Publishing Co.
                            3200 Truxel Rd.
                            #199 Sacramento, CA 95833
     
                            Sole Proprietor: Jeff Dunlop
                            Voice: (916) 927-6951
                            Data: (916) 927-2349
                            Fidonet Address: 1:203/16
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
           
     
     
     
      
                               Table of Contents
     
     
     
      Introduction ..................................... 1
      Program Requirements (Programmer) ................ 3
      Program Requirements (User) ...................... 3
      Distribution Files ............................... 3
      Registration ..................................... 3
      Shareware License ................................ 4
      Shareware Warranty ............................... 4
      Registered License ............................... 4
      Registered Warranty .............................. 4
      Registered Support ............................... 5
      Frankness Clause ................................. 5
      Disclaimer ....................................... 6
      About Config.sys and Autoexec.bat ................ 6
      Contacting the Author ............................ 6
      Upgrade Policy ................................... 7
      Script Syntax .................................... 7
      Script Tokens .................................... 10
          BANNER ....................................... 10
          HELLO ........................................ 10
          HELLOBREAK ................................... 11
          USER ......................................... 11
          SUBDIR ....................................... 14
          FILE ......................................... 15
                  Splitting Files ...................... 17
          SPACE ........................................ 18
          UNZIP ........................................ 19
          RUN .......................................... 20
          GOODBYE ...................................... 23
          GOODBYEBREAK ................................. 23
          FIRSTDISK .................................... 23
          DISK ......................................... 24
          END .......................................... 24
          CHAIN ........................................ 25
          AUTHORIZATION ................................ 25
      Script Debugging ................................. 25
      Error Messages ................................... 26
      Critical Errors .................................. 29
      Registration Keys ................................ 30
     
     
     
     
     
     
     
     
     
     
     
     
           
     
     
     
      
     
                                    Introduction
     
     
     
     Once upon a time I wrote a program that was (and is) distributed
     nationwide. This program, like most, needs to be installed on the
     customers' hard drives.  I investigated every installation utility
     that I could find, and came away convinced that none of them had been
     done very well.  Under no circumstances could I justify $150, up to
     $250, for any of them.
     
     I wrote Install-Pro.
     
     Install-Pro is a script driven professional installation program that
     you as a programmer (or consultant) can use to install your
     applications or information bases on your customers' computers. My
     personal goal with this program was to never write an installation
     again (heaven forbid a batch file!) which meant that the entire
     installation procedure HAD to be configurable quickly and easily.  Any
     application can be ready to install to multiple directories from
     multiple disks in a matter of minutes.  A brief list of features
     includes:
     
             -     Professional look and feel for a better first
                   impression.
     
             -     You customize multiple welcome screens and good-bye
                   screens to your own needs. (Welcome screen -  registered
                   version only)
     
             -     Up to 999 installation disks.
     
             -     Unlimited installation files.
     
             -     Files may be split into up to 9 pieces for huge files
                   spanning multiple disks.
     
             -     Files in the .zip format may be extracted.  All
                   directories stored in a .zip file are automatically
                   created.
     
             -     You define the directory prompts that the user sees.
     
             -     You define the default destination directories that the
                   user sees.
     
             -     You optionally define the installation disk names (such
                   as "Utilities Disk" or "Install Disk")
     
     
     
                          Install-Pro Reference Manual
                                      - 1 -
           
     
     
     
      
             -     You optionally specify the disk space requirements
                   associated with all portions of the installation,
                   including optional portions.  (The user is given the
                   option to try to continue with installation if short on
                   disk space.)
     
             -     Up to 8 user-defined destination directories.
     
             -     Unlimited programmer-defined directories child to
                   user-defined directories.
     
             -     Destination directories may either be optionally locked
                   or the user may be allowed to change it.
     
             -     "Run" commands allow your installation to include custom
                   auxiliary programs or batch files to complete special
                   tasks. The installation diskette directory(s), any of
                   the user-defined directories, and any other arguments
                   you choose can be specified anywhere on the command
                   line.
     
             -     Portions of an installation may be specified as
                   optional, prompting the user whether the optional
                   portion should be installed.
     
             -     Multi-Module installations handled seamlessly.
     
             -     Files may be automatically overwritten, prompted before
                   overwriting a newer file, or prompted before overwriting
                   any file.
     
             -     Supports VGA/EGA 50/43 line text modes if detected.
     
             -     Robust error handling, including a custom critical error
                   handler that won't scare the dickens out of your users,
                   and including descriptive fatal error messages (no "error
                   14 at xxxx:yyyy" found in this program!)
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
                          Install-Pro Reference Manual
                                      - 2 -
           
     
     
     
      
     
                       Program Requirements (Programmer)
     
     
           1. Text editor for creating and modifying the script file(s).
              This text editor must not insert tab characters into your
              screen definition lines.
           2. MSDos 3.0 or higher.
           3. IBM PC bios compatible MS-Dos computer with at least 200k
              free ram.
           4. Standard CGA or Hercules compatible video subsystem.
     
     
                          Program Requirements (User)
     
     
           1. MS-DOS 3.0 or higher.
           2. IBM PC bios-compatible MS-DOS computer with 200k free ram
              (more ram needed for RUN commands)
           3. Standard CGA or Hercules compatible video subsystem.
     
     
                              Distribution Files
     
     
     Install-Pro comes distributed with the following files:
     
             instpro.exe - the executable
             instpro.man - this reference manual
             install.001 - sample script file #1
             order.doc   - order form
             read.me     - quick hello
             example.001 - script examples to get you started
             split.exe   - utility to chop files into pieces (eek!)
             split.doc   - caveats and instructions for split
     
     If any of these files were missing, feel free to download the latest
     version from the DB/Soft Online.  Also, when you distribute
     Install-Pro with your applications, feel encouraged to rename it
     'install.exe.'  I refrained from naming the executable that way to
     avoid accidentally having it write over one of the other install.exe's
     you may have lying around.
     
     
                                 Registration
     
     
     Upon receipt of the registration price of $32.50 (U.S. funds only) you
     will be sent a disk with the most current version that will enable you
     to display your application's name instead of my shareware notice. Use
     
     
                          Install-Pro Reference Manual
                                      - 3 -
           
     
     
     
      
     the file "order.doc" to order. Sorry, MC/Visa not accepted.
     
     
                               Shareware License
     
     
     You are free to distribute shareware copies of Install-Pro provided
     that none of the included files are modified or removed, and provided
     that no additional files are included in the archive.  Modifying the
     archive format (from .zip to some other format perhaps more
     convenient) is permitted.
     
     
     
                              Shareware Warranty
     
     
     The shareware version of Install-Pro is guaranteed to take up disk
     space. The author of this product is more than happy to hear about any
     bugs or unexpected behavior through non-voice channels (netmail, US
     Postal Service, or logging on to the DB/Soft BBS), but will not
     guarantee that immediate bug fixes will be forthcoming.
     
     
                              Registered License
     
     
     You are free to make unlimited backup copies of this program for
     archival purposes.  You may not distribute copies of this program
     except under the following provisions:  You may at your choosing give
     away or sell your program with its accompanying key to ONE party,
     provided you destroy all copies of the software in your possession
     after the time of the transaction.  The copies of the program that are
     used to install your applications MUST NOT be distributed with the key
     that enables script modifications.
     
     Pursuant to United States copyright laws and international copyright
     aggreements, Install-Pro must be treated as if it were a book.  Just
     as two people cannot read a book in front of separate computers, two
     people must not simultaneously use the same registered copy of
     Install-Pro.  The sole purpose of archival copies of Install-Pro is
     to be for protection against hardware or diskette failure.
     
     
                              Registered Warranty
     
     
     The registered version (original copy) is warranted to meet in all key
     aspects its defined behavior as listed in the documentation.  Key
     aspects are those features without which the program will fail in some
     
     
                          Install-Pro Reference Manual
                                      - 4 -
           
     
     
     
      
     gross manner to transfer an application.  Minor specifications (such
     as prompt lengths, etc.) are subject to change without notice.  The
     final arbiter as to the interpretation of the documentation shall be
     the author of the program. The sole remedy available to the purchaser
     of Install-Pro shall be bug fixes or a refund, as determined by the
     author.  Work-arounds (eg syntax modifications) for the purposes of
     warranty consideration will be considered acceptable if they make
     possible the same task that any bug renders impossible.  If verified
     bugs are not corrected within 30 days of notification, and if the
     purchaser is working in good faith to keep in contact with the author,
     the purchaser at his option is entitled to a refund. Verified bugs are
     those which the author is able to duplicate on machines that fall
     within the equipment requirements list.
     
     Upgraded versions of Install-Pro will be handled in a slightly
     different fashion.  Unless demonstrated otherwise, it is assumed by
     the author that free upgrades obtained by the purchaser are so
     obtained as a matter of the purchaser's convenience, and it is thus
     assumed that the original, purchased copy of Install-Pro is not
     defective.  It is further assumed that if a bug is discovered in a
     free upgrade, the purchaser is still able to use his older version of
     Install-Pro.  Therefore, unresolved bugs found in a free upgrade of
     Install-Pro are not subject to a refund of monies paid should such
     bugs remain unresolved after 30 days.  Any bugs found should still be
     reported to the author, as he will give all bug reports due attention
     in his attempts to resolve them.
     
     There is one exception to this previous provision.  If the author
     represents an upgrade as a fix to a bug reported by the purchaser,
     then the full original warranty shall be extended to cover the
     upgrade.
     
     
                              Registered Support
     
     
     The registered version entitles the purchaser to unlimited support via
     netmail, the DB/Soft BBS or via US Mail.  I am unable, however, to
     provide telephone support.
     
     
                               Frankness Clause
     
     
     As you well know, it's darned difficult to get a publisher to stand
     behind his product.  He usually guarantees the diskette (what a joke)
     and hangs you out to dry.  If there is an error in the program, I will
     do anything possible to correct it in a timely fashion.  I am also
     very interested in any ambiguities or errors in this documentation.
     Whatever problems you do find, I would appreciate a note.
     
     
                          Install-Pro Reference Manual
                                      - 5 -
           
     
     
     
      
     
     
                                  Disclaimer
     
     
     While every effort has been made by the author to ensure the fitness
     for use and integrity of Install-Pro, the author cannot and will not
     accept responsibility for any damage, physical or otherwise, to any
     equipment owned by the purchaser.  The author habitually recommends
     that all customers back up their data regularly and frequently;  that
     recommendation applies here as well.  The maximum remedy available to
     the purchaser in the event of any type of dispute is the purchase cost
     of the software.
     
     
                       About Config.sys and Autoexec.bat
     
     
     This is a controversial subject if I've ever seen one.  I have seen
     opinions ranging from "My users are too stupid to know about these
     things" to "No programmer had better touch it!"  I choose to leave it
     up to you the programmer.  If you want to write a routine modifying
     system files, have at it, and run it with the RUN command, described
     later.
     
     
                             Contacting the Author
     
     
     If you have access to Fidonet netmail, contacting me at 1:203/16 will
     get the fastest response.  The DB/Soft Online is available 24 hours a
     day if netmail is not available to you - just leave a comment to the
     sysop when logging off.  If you leave a netmail or snail-mail return
     address, you won't have to call back for a response, I'll be happy to
     drop the price of postage or a crash netmail message.  Failing that,
     mailing me at 3200 Truxel Rd. #199 Sacramento CA 95833 will get a
     prompt response, but will take about a week for the two-ended
     delivery.  My voice number has been included on page one, but should
     only be used by those interested in ordering the software.
     
     The following steps will greatly aid technical support and speed of
     problem resolution:
     
          1. If a specific command is not working as expected, does your
             usage of the command comply with its description in the
             appropriate section of the documentation?
     
          2. To avoid my needing to resort to guesswork, send the exact
             script that is not working for you with your question.
     
     
     
                          Install-Pro Reference Manual
                                      - 6 -
           
     
     
     
      
          3. If logging onto the DB/Soft Online for technical support,
             prepare your message in advance.  The Message Menu of the BBS
             has an Upload feature that will allow you to upload your
             message with most any protocol.  This will greatly reduce
             connect time and increase accuracy.  Be sure to include your
             entire script as part of the message, or as its own message.
     
          4. Be sure to indicate exactly which error messages, if any, are
             accompanying unexpected behavior.
     
     
                                Upgrade Policy
     
     
     "Once bought, always bought."  Purchasers of Install-Pro will be
     entitled to free upgrades indefinitely.  I will notify you of the
     first significant upgrade of Install-Pro after registration, and I
     keep the current registered version of Install-Pro available for
     download in the 'Registered User' file section of the DB/Soft Online.
     
     
                                 Script Syntax
     
     
     When install.exe is executed, the first file it looks for is
     install.001 in the same directory as Install-Pro.  If install.001 is
     not available, the program terminates. If install.001 is processed
     successfully, and an additional installation disk is specified, then
     the user will be prompted for the correct disk to insert to continue.
     After the disk has been swapped, Install-Pro looks for install.002.
     This continues until an END command is encountered in the current
     script.
     
     Before beginning immediately with the syntax proper, an explanation of
     how Install-Pro functions is in order:
     
     The concept of Install-Pro centers around what I call a label name. A
     label name is simply an arbitrary name that you give to the
     characteristics of a single installation directory. These
     characteristics include the prompt that user is going to see when
     asked where to put this directory, the default that the user is going
     to see when prompted, the subdirectories that are going to be created
     child to this directory, and the files that are going to be
     transferred to this directory or one of its children. Since you the
     programmer don't know what a user is going to name his installation
     directory, a label name provides you with an alias to refer to it by.
     Before you can refer to a label name, it must first exist.
     
     The USER token, discussed below, is the token that creates space for a
     label name and all of its associated characteristics.  FILE, SUBDIR,
     
     
                          Install-Pro Reference Manual
                                      - 7 -
           
     
     
     
      
     UNZIP and RUN tokens that refer to a label must come after the USER
     token that defines it.  It's that simple.
     
     
                               INSTALL.001
                               -----------
     
     The following is a brief overview of the syntax needed for
     install.001:
     
     BANNER "Banner goes here"
     HELLO "Welcome text goes here"
             (additional HELLO lines)
     HELLOBREAK
     HELLO "More hello lines if you wish"
     
     [OPTION] USER <label name> "User prompt" [Default Destination] [NOMOD]
             (additional USER lines)
     
     SUBDIR <label name> <child subdirectory>
             (additional SUBDIR lines)
     
     FILE <label name> <filename> [UPGRADE or VERIFY]
             (additional FILE lines)
     
     UNZIP <filename> [UPGRADE or VERIFY]
             (additional UNZIP commands)
     
     RUN "command line in quotes"
             (additional RUN commands)
     
     ; goodbye text if last floppy of installation
     
     GOODBYE "So-long text goes here"
             (additional GOODBYE lines)
     GOODBYEBREAK
     GOODBYE "More good-bye lines if desired"
     
     SPACE <labelname> <nnnnn>
     
     DISK [diskname] -or- END -or- CHAIN
     AUTHORIZATION <nnnnn>
     
     
                                 INSTALL.002+
                                 ------------
     
     
     The syntax for install.002 through install.999 is slightly different,
     as follows:
     
     
                          Install-Pro Reference Manual
                                      - 8 -
           
     
     
     
      
     
     FILE <label name> <filename> [UPGRADE or VERIFY]
             (additional FILE lines)
     
     UNZIP <filename> [UPGRADE or VERIFY]
             (additional UNZIP commands)
     
     RUN "command line in quotes"
             (additional RUN commands)
     GOODBYE "So-long text goes here"
             (additional GOODBYE lines)
     DISK [diskname] -or- END -or- CHAIN
     
     
     Please note that HELLO, BANNER and USER tokens are not allowed, as
     they must get processed from the first disk.
     
     
     
     In both of these examples, the order that the tokens appear is the
     most logical, but is not strictly required.  The following is a list
     of token order requirements:
     
           1.    HELLO and BANNER tokens must appear before the first DISK
                 token (if any) in install.001.
     
           2.    RUN commands are executed BEFORE disk swaps, but after all
                 other processing.  This means that the files on the
                 current installation diskette are guaranteed to exist for
                 the current commands.  Furthermore, this guarantees that
                 directories created with SUBDIR, files transferred with
                 FILE, files unzipped with UNZIP, and directories created
                 by the user with USER tokens will exist at the time of any
                 RUN. Essentially, the final state of a particular
                 installation disk exists for the RUN.
     
           3.    AUTHORIZATION nnnnn must occupy the last line of install.001
                 (Registered versions only.)
     
           4.    DISK must occupy the line directly before AUTHORIZATION on
                 install.001, or the last line on all other installation
                 disks. In effect, DISK flushes the accumulated tokens into
                 actual processing, and is followed by a disk swap.
     
           5.    FILE, SUBDIR, RUN and UNZIP lines MUST come AFTER the USER
                 line that defines any label names used for these commands.
     
           6.    Lines with a preceding semicolon, or empty lines are
                 ignored by Install-Pro.  An empty line is a line with all
                 whitespace, with no tokens detected by the parser.
     
     
                          Install-Pro Reference Manual
                                      - 9 -
           
     
     
     
      
     
           7.    FILE tokens transfer files on the CURRENT installation
                 diskette when END or DISK [diskname] is encountered.  The
                 filename specified with FILE must be on the same
                 installation diskette as the FILE token.
     
           8.    The SPACE command must come after at least one USER
                 command.
     
     
                                 Script Tokens
     
     
                                    BANNER
                                    ------
     
     Syntax:  BANNER "Any text enclosed in quotes"
     
     The BANNER token identifies the line of text to be shown to the user
     as the program name on the opening screen.  Up to 71 characters are
     allowed, and a box surrounding the text auto-sizes for a neat
     appearance.  If the particular text used creates unbalanced sides,
     insert an extra space on the errant side to even things out.
     
     If quotes are omitted, only the first word after BANNER will be
     detected. If no text is detected after BANNER, Install-Pro will abort
     with an error message.
     
     BANNER overwrites any previous BANNER definitions.
     
     BANNER is recognized only in install.001, on any line previous to DISK
     [diskname] (or AUTHORIZATION on single-disk installations.)  If BANNER
     appears in install.002+, it will be ignored.
     
     If DISK or End-of-file are reached in install.001 and no BANNER has
     been found, a very small message-less box will be formed - harmless
     but unattractive.
     
     Shareware note:  Although the BANNER token will be recognized and
     parsed, it is ignored in unregistered versions of Install-Pro. It
     makes no difference if it is included or not.
     
     
                                     HELLO
                                     -----
     
     Syntax:  HELLO  "Any text enclosed in quotes"
     
     The HELLO token identifies a line of text to be shown to the user on
     the welcome screen.  Each line may have a maximum length of 71
     
     
                          Install-Pro Reference Manual
                                      - 10 -
           
     
     
     
      
     characters.  Characters in excess of 71 are ignored (truncated.)  All
     of the HELLO text lines are displayed in the order detected in a
     single window, which automatically sizes itself to the length and
     height of the combined HELLO display.  If you want empty lines
     included, indicate this with a set of empty quotes ("").
     
     If quotes are omitted, only the first word after HELLO will be
     detected.
     
     If no text is detected after HELLO ("" DOES qualify as text) then
     Install-Pro will abort with a message.
     
     Up to 13 HELLO lines will fit on a single screen.  If more than 13
     HELLO lines are defined without any intervening HELLOBREAK commands
     (described below), the subsequent lines will be displayed on the next
     screen.  Any number of HELLO screens (each autosizing, with a capacity
     of up to 13 lines) can be defined.
     
     HELLO is recognized in install.001, on any line previous to DISK 2 (or
     AUTHORIZATION on single-disk installations.)  If HELLO appears in
     install.002+, it will be ignored.
     
     If DISK or End-of-file are reached in install.001 and no HELLO has
     been found, a very small message-less box will be formed - harmless
     but unattractive.
     
     Shareware note:  Although HELLO tokens will be recognized and parsed,
     they are not displayed in unregistered versions of Install-Pro.  It
     makes no difference if it is included or not.
     
     
                                  HELLOBREAK
                                  ----------
     
                         --- New with version 1.60 ---
     
     Syntax:  HELLOBREAK
     
     This command signifies that the following HELLO command is to be
     displayed on a new screen.  Use this if you have special formatting
     needs that require fewer than 13 lines to a screen.
     
                                     USER
                                     ----
     
     Syntax:  [OPTION] USER <label> "prompt" [default directory] [NOMOD]
     
     This token is used to assign a prompt and a default destination to a
     label that is specified by the programmer.  When the user inputs his
     destination directory it will be associated with this label name. This
     
     
                          Install-Pro Reference Manual
                                      - 11 -
           
     
     
     
      
     token also creates the space needed for FILE, RUN and SUBDIR tokens to
     function.
     
     [OPTION]:
     
             This modifies the behavior of the installation as follows:
     
                               --- New behavior with 1.61 ---
     
                     Before he is shown the destination directory Entry
                     Screen, all OPTION USER lines will be resolved by
                     displaying a form with radio buttons that allow the
                     user to toggle on or off any or all of the optional
                     label that have been defined.  Non-OPTIONal labels are
                     not displayed on this form.  After the user accepts
                     this form, any OPTIONal labels that he had selected
                     are displayed on the destination directory entry
                     screen along with all non-OPTIONal labels.
     
                     For each OPTIONal label, if the user toggles its
                     button on, then all activities associated with the
                     labelname allocated in this USER command will occur
                     normally.
     
                     Any buttons toggled off will cause all of the
                     activities (FILE, SUBDIR or UNZIP) associated with
                     this labelname to be cancelled.
     
                                --- New with version 1.58 ---
     
                     Any RUN commands that access an unaccepted OPTIONal
                     label will be ignored.  This allows RUN commands to be
                     conditional on specific portions of an installation
                     being installed.
     
             Please note that using the OPTION modifier on a USER command
             does not change the syntax of any other command in any way.
     
             If all aspects of an installation are made OPTIONal (not TOO
             farfetched) and the user declines all of them, then nothing
             will occur (although some messages, including your GOODBYE
             screen, will still be displayed.)
     
     label:
     
             The label name can be any single word of up to 40 characters,
             although less than ten characters is usually more than enough.
             A typical label name might be prog_files, data_files, etc.
     
     prompt:
     
     
                          Install-Pro Reference Manual
                                      - 12 -
           
     
     
     
      
     
             The user prompt can be up to 23 characters.  Examples of
             typical prompts are "Help Files", or "Data Files".  The quotes
             are required if more than one word is in the prompt.
     
     default directory:
     
             A default directory is optional.  If specified, the directory
             must be in the form of a fully qualified DOS path, complete
             with drive and semicolon.  Keep in mind your default will not
             be checked for validity until it is accepted by the user.
     
                             --- New with 1.60 ---
     
     [NOMOD]:
     
             This optional modifier is used to disable the directory field
             for this label in the destination entry screen.  This option
             should be used if the application being installed relies on
             specific directories existing.  To be able to use NOMOD,
             [default directory] must be an explicitly defined valid path.
             Note that the destination drive is still changeable.
     
     Up to 8 USER lines may be specified.  Any additional USER lines will
     cause a less attractive entry screen to be displayed, since some of
     the windows will start running into each other.
     
     The Destination Directory Entry screen that the list of USER prompts
     generates autosizes around the prompts for the neatest appearance.
     
     If no labelname or user prompt are detected, Install-Pro will abort
     with an error message.  Only the default destination is optional.
     
     USER lines may occur anywhere in install.001 prior to DISK or
     End-of-file (in the absence of DISK.)
     
     
     Example 1:
     
     USER prog_files "Program Files" C:\MYPROG
     
     This line would assign a "Program Files:" prompt and C:\MYPROG default
     directory to the prog_files label.  The user would see a line on his
     entry form similar to the following:
     
     Program Files                   C:\MYPROG
     
     
     Example 2:
     
     
     
                          Install-Pro Reference Manual
                                      - 13 -
           
     
     
     
      
     USER prog_files "Program Files" C:\MYPROG
     OPTION USER sample_files "Sample Files" C:\MYPROG\SAMPLE
     
     This partial script would first ask the user if he wanted to install
     Sample Files (the question includes the prompt as part of the text.)
     If he responds yes, he would be presented with an entry form similar
     to the following:
     
     Program Files                    C:\MYPROG
     Sample Files                     C:\MYPROG\SAMPLE
     
     If he had responded no, then he would have seen the same entry screen
     as in example #1.
     
     Example 3:
     
     USER prog_files "Program Files" C:\MYPROG NOMOD
     
     The user would be allowed to change the destination drive, but not the
     path.  All files associated with prog_files would be transferred to
     \MYPROG.
     
     
                                    SUBDIR
                                    ------
     
     Syntax: SUBDIR <label_name> <dirname>
     
     This optional token defines any directories that the programmer wishes
     created as children to the user-specified directories. The specified
     label name must match one of the label names defined under the USER
     token, described above.  Any number of SUBDIR lines may be used in the
     script.
     
     label_name:
     
             The label name specified here MUST have been previously
             defined with a USER token.
     
     dirname:
     
             The directory structure is not required to start with a
             leading backslash, but it may be less confusing if it does.
             Either way, the directory will be created as a child as
             expected.
     
     SUBDIR lines may exist anywhere in any install.??? file, but must
     precede the first use of its created directory or the program will
     error out with a Subdirectory Error.  SUBDIR must also come after the
     USER line that defines the label name to which SUBDIR refers.
     
     
                          Install-Pro Reference Manual
                                      - 14 -
           
     
     
     
      
     
     For example, assume the following partial script:
     
     USER label_1 "Data Files" C:\MYAPP\DATA
     SUBDIR label_1 \MOREDATA
     
     If the user accepted the default, the C:\MYAPP\DATA directory would be
     created.  Also, as a result of the SUBDIR line, the
     C:\MYAPP\DATA\MOREDATA directory would be created.  Furthermore, if
     the SUBDIR line had instead read:
     
     SUBDIR label_1 \MOREDATA\DATADATA
     
     all directories parent to DATADATA will created as well as DATADATA.
     That is to say, you don't have to specify explicitly all directories
     that you want created, just the entire chain that you want to be
     ensured exists.  In a more extreme example to illustrate this point,
     assume:
     
     USER label_1 "Data Files" C:\DATA
     SUBDIR label_1 MORE\DATA\DATA\DATA
     
     All five of the specified directories would be created.
     
     CAUTION:  The DOS limit for subdirectory length is 65 characters,
     including drive and colon.  Keep in mind the maximum user-entered
     directory is up to 40 characters, leaving you up to 24 characters with
     any margin of safety.  If the total exceeds 65 characters, DOS returns
     a directory creation error.
     
                                     FILE
                                     ----
     
     Syntax: FILE <label_name> <filename> [UPGRADE or VERIFY]
     
     This token defines a file that is to be transferred from the current
     installation diskette.  The word following the FILE token must be a
     label defined on one of the USER lines.
     
     label_name:
     
             The label name specified here MUST already have been created
             with a USER token.
     
     filename:
     
             The filespec can take one of two forms.  First, it can be a
             regular dos filename, in which case it would be transferred to
             the directory associated with the specified label.  Or second,
             it can include an optional directory chain child to the
     
     
                          Install-Pro Reference Manual
                                      - 15 -
           
     
     
     
      
             directory associated with the specified label, in which case
             it would be transferred to that child directory.  For that
             child directory to exist, it would be necessary to previously
             create it with a SUBDIR line, described previously. Any number
             of FILE lines can be specified.  Two examples follow:
     
                             --- New with 1.60 ---
     
     UPGRADE:
     
             This modifier indicates that any files newer than the file
             being transferred are to be overwritten only with permission
             from the user.  This modifier is reliant on the user's machine
             having a functional clock, and that the files on the user's
             machine reflect actual dates.
     
     VERIFY:
     
             This modifier directs Install-Pro to verify all file
             overwrites.
     
     Assume the following partial script:
     
     USER label_1 "Data Files" C:\DATA
     FILE label_1 main.exe
     FILE label_1 main2.exe
     
     This script would transfer main.exe and main2.exe from the root
     directory of the current installation diskette to the directory that
     the user entered when prompted with "Data Files", perhaps the default
     directory presented to him, "C:\DATA".
     
     Now, consider this more advanced example:
     
     USER label_1 "Data Files" C:\DATA
     SUBDIR label_1 \HELP
     FILE label_1 main.exe
     
     FILE label_1 main2.exe
     FILE label_1 help\help.dat
     
     Assuming that the user accepts the default C:\DATA, this script would
     transfer main.exe and main2.exe from the root directory of the current
     installation diskette to C:\DATA, just as in the previous example.
     Also, as child to the user-entered directory would be created a help
     directory, to which would be transferred help.dat.
     
     The final structure if all defaults were accepted by the user would
     be:
     
     
     
                          Install-Pro Reference Manual
                                      - 16 -
           
     
     
     
      
     C:\DATA\MAIN.EXE
     C:\DATA\MAIN2.EXE
     C:\DATA\HELP\HELP.DAT
     
     If no label or filename are detected, Install-Pro will abort with an
     error message.
                                Splitting Files
                                ---------------
     
     If you have files that just cannot fit onto a distribution diskette,
     Install-Pro has the ability to handle split files.  First an example
     of how to accomplish this:
     
     FILE label_1 main.ex1e
     FILE label_1 main.ex2e
     
     These two file lines would create a file called main.exe in the
     label_1 directory, from TWO files main.ex1 and main.ex2.  What
     Install-Pro does is looks to see if an extra character has been added
     to a filename.  If there is an extra character:
     
             1. The source filename is assigned an extension of the first
                three characters of the filename's extension.  This file
                should exist on the current distribution floppy.
     
             2. The destination filename has the third character replaced with
                the fourth, and the fourth character removed.
     
     Please note that:
     
             1. main.ex1e and main.ex2f would not cause an append to occur.
                The filenames (with the exception of the third character of
                a four-character extension) MUST match.  In this case,
                main.exe would be created from main.ex1, but main.exf would
                NOT be created.
     
             2. The files MUST have the same label name assigned to each of
                them.  If main.ex1e and main.ex2e were assigned different
                labels, \directory1\main.exe would be created, but
                \directory2\main.exe would NOT.
     
             3. I strongly urge that multiple split files of the SAME name
                NOT be installed.  For example, if you had two huge, but
                different, files called main.dat, and wanted them both
                split using main.da1t and main.da2t for each of them, but
                assigning different labels to them, the user COULD still
                assign both labels to the same directory, with
                unpredictable results.  This is an extreme example that I
                don't think you will run into.
     
     
     
                          Install-Pro Reference Manual
                                      - 17 -
           
     
     
     
      
     
     The append/create decision is resolved as follows:
     
             1. If third character of the extension is a '1' and the fourth
                character exists, the file is CREATED.
     
             2. If the third character is greater than a '1' and the fourth
                character exists, the file is APPENDED.  Note that trying
                to append to to a file that does not yet exist will cause
                DOS to return a 'file not found' error, and is used to
                prevent accidentally append filename.ex2t on top of an
                existing file.  The practical limit to the number of splits
                is up to 9.
     
             3. If the third character is a number, but no fourth character
                exists, no split-file decision occurs - the file will be
                created.
     
             4. Note that main.0011, for example, is perfectly legal.  What
                it specifies is that main.001 is to be created, and that
                it's the first file of a split file.   Main.0021 would be
                appended to main.0011.
     
     
     This type of file transfer can be especially touchy if the order of
     files transferred and then appended is incorrect.  If you split files,
     I strongly recommend that you debug your script carefully and compare
     the created file with the original (using the DOS program 'COMP') to be
     sure that they are identical to before releasing your application.
     
     There is an accompanying utility called split.exe which will split
     your large files for you if needed.  It comes with its own
     documentation.
     
                                     SPACE
                                     -----
                     --- New syntax with version 1.60 ---
     
     Syntax: SPACE <label_name> <nnnnn>
     
     The syntax of SPACE has changed.  Each SPACE command must reference a
     defined label (via the USER command.)  After the user chooses his
     destination drive and directories in the entry screen, all labels that
     access each drive are added together to determine if enough free disk
     space exists.
     
     This token allows you to warn the user if his destination directory
     has less space available than needed for the installation.  Since it
     is often possible that the installation is occurring over a current
     installation, the lack of space is treated as a warning.  If, during
     
     
                          Install-Pro Reference Manual
                                      - 18 -
           
     
     
     
      
     the transfer of any of the files, disk space runs out, the user will
     be told of this.
     
     A non-positive number or the existence of any non-numeric characters
     where the number is expected will cause a program abort with a
     descriptive error message.
     
     The disk check(s) occur directly after the user has finished with the
     destination directory entry screen.  Any OPTIONal installation
     segments that are declined by the user are not counted when
     determining adequate disk space.
     
                                UNZIP
                                -----
     
     Syntax: UNZIP <labelname> <zipfile> [VERIFY or UPGRADE]
     
     This token specifies a zip file that needs to be uncompressed.  The
     following assumptions are made with this command:
     
             1. The zip file is to be deleted from the destination disk
                after decompression.  (Under no circumstances is it
                possible to delete a zip file on the distribution disk.)
     
             2. The base destination for the extracted files is to be the
                same directory that the zip file is in.  That is,
                subdirectory information stored in the zip file is to be
                used relative to the current zip file directory.
     
             3. The filename's default extension is 'zip'.
     
             4. The file was compressed with a version of Phil Katz' PKZIP
                1.10 or earlier (or a 100% compatible .zip file creator.)
                All storage methods used by this archiver (Explode,
                Unshrink, etc.) are supported.
     
             5. The file was NOT encrypted with a password.
     
     labelname:
     
             The label specified here must have been previously defined
             with a USER command.
     
     zipfile:
     
             The zipfile must have been transferred via a FILE command.
             The extension is optional.
     
                             --- New with 1.60 ---
     
     
     
                          Install-Pro Reference Manual
                                      - 19 -
           
     
     
     
      
     UPGRADE:
     
             This modifier indicates that any files newer than the file
             being transferred are to be overwritten only with permission
             from the user.  This modifier is reliant on the user's machine
             having a functional clock, and that the files on the user's
             machine reflect actual dates.
     
     
                             --- New with 1.60 ---
     VERIFY:
     
             This modifier directs Install-Pro to verify all file
             overwrites.
     
                             --- New with 1.60 ---
     
             Any directory information packed in a zip file is
             automatically created as needed during the unzip process.
             Under no circumstances will a file stored in a zip file with
             subdirectory information be unpacked into the current
             directory.
     
     
     
     Example:
     
     UNZIP label1 zipfile
     
     would unzip zipfile.zip in the directory associated with label1.
     
     Any number of UNZIP commands may be specified.
     
     If UNZIP refers to an OPTIONal label, the UNZIP will only occur if the
     user chose to include that part of the installation.
     
     Since an error extracting a zip file must be considered as dangerous
     as an error copying an installation file, crc or other unzip errors
     must be treated as fatal errors, with program abort, so double-check
     the integrity of your .zip files before distribution.
     
     
                                      RUN
                                      ---
     
     Syntax: RUN "any command line in quotes"
     
     This token defines a command line to be built to execute any special
     programs or batch files that are needed to customize an installation.
     One use for this might be to run a config.exe program that will bring
     
     
                          Install-Pro Reference Manual
                                      - 20 -
           
     
     
     
      
     the user straight into configuring the application he is installing.
     Another use might be to create application menu definition files that
     couldn't be built at install-time otherwise.
     
     Run works by one of two methods.  If the command specified on the
     command line has the extension ".EXE" or ".COM", the program is
     executed directly by Install-Pro.  If no .EXE or .COM extension is
     specified, your command is run by invoking a command processor shell
     and passing it the command line that you specify.  There must be
     enough memory to load both your program or command shell in addition
     to that used by Install-Pro - about 200k.  Run command lines of longer
     than one word must be enclosed in quotes.
     
     Any number of RUN command lines can be defined.
     
     Further, the directory(s) that the user enters at runtime are
     available on the RUN command lines.  Simply specify any label with a
     preceding exclamation point (!) and the user-entered directory will be
     directly substituted for that portion of the text.  The directory is
     inserted without any leading or trailing spaces, but the spaces on the
     RUN command line are UNTOUCHED. That means that the following RUN
     commands would work:
     
     RUN "dir !label_1"
     RUN "!label_1\myprog.exe"
     RUN "copy !label_1\this.fil !label_2"
     RUN "anydir\anyprog.exe"
     
     Finally, a special sequence, !home, signifies that you wish to specify
     the installation directory of the installation disk.  For obvious
     reasons, don't create any labels called 'home' with the USER command,
     or the !home sequence will no longer point at the home directory, but
     rather at the directory entered by the user for this labelname.
     
     RUN "!home\myprog.exe"
     
     would execute myprog from the installation directory of the
     installation disk.
     
     When a RUN command is executed, the screen is saved and cleared first.
     After it has completed, the screen is restored.
     
     If the command shell attempt fails, the user will be notified of the
     reason (usually memory) but the INSTALLATION WILL NOT ABORT.  If there
     is a critical part of your installation occurring with a RUN command,
     be sure to document it in your manual installation instructions for
     the user.
     
     A few points to keep in mind:
     
     
     
                          Install-Pro Reference Manual
                                      - 21 -
           
     
     
     
      
             1.  The error trapping is much more solid if Install-Pro
                 directly executes your program.  This is due to the fact
                 that if the command shell is used instead, success
                 constitutes the shell having successfully loaded.  Whether
                 enough ram existed for your program or your program was
                 found is not detectable by Install-Pro.  Whats worse, in
                 the case of older versions of the alternative command
                 processor 4dos, the command shell load process occurs in
                 two parts.  The first part of 4dos can load successfully
                 but fail to load the rest of itself and still return
                 success to Install-Pro.
     
             2.  Memory requirements for command shell RUN commands can be
                 significantly higher, especially if COMMAND.COM is the
                 target of COMSPEC (about 27k).
     
             3.  A single RUN command in .EXE mode is allowed up to 9
                 arguments. Additional arguments are ignored.  In command
                 shell mode, there is no limit to the number of arguments
                 allowed.
     
             4.  A single RUN command in .EXE mode is allowed a length of
                 up to 256 characters.  The length of any single argument
                 is restricted to 128 characters.  If argument zero (the
                 directory, path and filename of the executing program) is
                 longer than 128 characters, DOS will return an error
                 message back to Install-Pro.  If any other argument is
                 longer than 128 characters, the argument will be truncated
                 (undesirable, indeed.)
     
             5.  A single RUN command in command shell mode is allowed a
                 total length of up to 256 characters, but keep in mind
                 that the widely-used command interpreter COMMAND.COM will
                 only allow 128 characters total.  4dos, among others,
                 allows up to 256 characters.
     
             6.  I gave consideration to errorlevels from executed
                 programs (they are not available from shelled commands),
                 but considering the fact that the only recourse is to
                 report the errorlevel to the user as a 'possible error' or
                 alternatively to abort the installation, I abstained.
                 Registered users with special errorlevel needs are free to
                 contact me for a custom version of Install-Pro that will
                 handle errorlevels in one of these two fashions.
     
                             --- New with version 1.58 ---
     
             7.  RUN commands MAY access OPTIONal directories.  However, if
                 any of the optional directories listed in a RUN command
                 line were not accepted by the user (even if the directory
     
     
                          Install-Pro Reference Manual
                                      - 22 -
           
     
     
     
      
                 already exists), the command will be be ignored.  This
                 allows RUN commands to be conditional on whether an OPTION
                 was accepted.  If an OPTION is declined, you can be sure
                 that the associated RUN commands will not be executed.
     
                                    GOODBYE
                                    -------
     
     Syntax: GOODBYE "So-long text goes here"
     
     This token is used to build an end-of-install message to display to
     your users after successful completion of installation.  It can be up
     to 71 characters long, and like the HELLO lines, the GOODBYE text is
     displayed in an auto-sizing window.  If you want to specify an empty
     line, use GOODBYE "".  The lack of any GOODBYE lines would cause a
     small, empty box to appear, harmless but silly looking.  Somewhere
     near the bottom of the GOODBYE text, you should include something to
     the effect that a keypress will exit the program.
     
     Any number of GOODBYE lines can be defined, anywhere in the script
     file(s). After 14 GOODBYE lines have been encountered without an
     intervening GOODBYEBREAK command (described below), a page break is
     automatically inserted by Install-Pro.
     
     When an install.??? file is processed that is terminated with an END
     token, after all transfers have taken place, the GOODBYE messages are
     displayed, after which the program terminates.
     
                                 GOODBYEBREAK
                                 ------------
     
                      --- New with Version 1.60 ---
     
     Syntax: GOODBYEBREAK
     
     This token tells Install-Pro that the next GOODBYE line defined in the
     script is to appear at the top of a new page.
     
                                   FIRSTDISK
                                   ---------
     
     Syntax: FIRSTDISK [disk name]
     
     This token allows you to name the first disk of the installation
     something besides "Disk 1" (for example, "Install Disk").  Other than
     slightly changing screen appearance and prompts, this token does not
     affect the physical operation of Install-Pro in any way.  If no
     argument follows the FIRSTDISK token, the default of "Disk 1" will be
     used.  If this token is omitted, "Disk 1" will be used as well.
     
     
     
                          Install-Pro Reference Manual
                                      - 23 -
           
     
     
     
      
     FIRSTDISK MUST come before DISK in install.001 to have any affect.
     
                                     DISK
                                     ----
     
     Syntax: DISK [disk name]
     
     This token specifies that the user is to be prompted to insert the
     next numbered disk.  The extension of the script file increments with
     each successive disk.  For example, if the disk being processed is
     disk 1 with install.001, specifying DISK would cause the user to be
     prompted to insert disk #2. If the user presses enter and the disk in
     the drive in which install.exe exists does not have install.002 in the
     root directory, the user will be instructed to try again.  This loop
     repeats until the user inserts the correct disk (if you've ensured
     that the user received it) or until the user presses Escape, which
     would terminate the program.
     
     The optional [disk name] argument allows you to name the following
     disk something besides "Disk n".  Common uses are "Utilities Disk",
     "Fonts Disk" or what-have-you.  If you adopt this or another naming
     convention, be sure to look up the FIRSTDISK token for instructions on
     naming the FIRST disk (since the DISK token always names the FOLLOWING
     disk.)
     
     DISK MUST come before AUTHORIZATION in install.001
     
     
                                      END
                                      ---
     
     Syntax: END
     
     This token indicates that the end of the last installation script has
     been reached.  Just like DISK, END forces all information stored in
     all labels to be processed.  However, unlike DISK, when this
     processing is completed, the program displays the GOODBYE messages and
     exits.
     
     This token is mutually exclusive of the DISK token.  Whichever is
     encountered first on any given diskette will dictate the processing
     that will occur, and the other will be ignored.
     
     END MUST come before AUTHORIZATION in install.001.
     
     
     
     
     
     
     
     
                          Install-Pro Reference Manual
                                      - 24 -
           
     
     
     
      
                                     CHAIN
                                     -----
     
     Syntax: CHAIN
     
     This token indicates that the end of the last installation script has
     been reached, just like END.  When this token is reached, all
     work accumulated is processed.  Unlike END, however, CHAIN is a
     conditional installation terminator.  The user is presented with "Do
     you wish to install another module (Yes/No)".  If the user selects NO,
     then the GOODBYE screen is displayed and Install-Pro terminates.
     
     If the user selects YES, then he is prompted to insert Disk 1 of the
     next module and Install-Pro transfers control to another copy of
     itself on the new diskette, and the old copy of Install-Pro in memory
     is discarded.  Any GOODBYE screen will be handled by the new copy of
     Install-Pro.
     
     The actual filename that is looked for with CHAIN is the identical
     path and filename of the currently executing process.  So, if you have
     renamed one copy of Install-Pro to INSTALL.EXE, they all must be
     renamed that way.
     
     The traditional use for this type of termination is in the case of
     integrated accounting software, where it is unknown at runtime how
     many modules (General Ledger, System Manager, Accounts Receivable,
     etc.) have been purchased.
     
                                 AUTHORIZATION
                                 -------------
     
     Syntax: AUTHORIZATION 00000
     
     This token is only required on the last line of install.001.  Its
     function is solely to create a space for Install-Pro to write an
     authorization code. After you have run Install-Pro with your key on
     the command line, this line will be updated with the appropriate
     authorization code for the current script.
     
     If you are evaluating an unregistered copy of Install-Pro, you need
     not worry about this line. The authorization concept is used purely to
     ensure the integrity of registered versions.
     
     
                               Script Debugging
     
     
     Before you send your latest sale to your customers, you are going to
     want to make sure that the installation as you envision it is actually
     going to happen.  I have made a great effort to make all error
     
     
                          Install-Pro Reference Manual
                                      - 25 -
           
     
     
     
      
     messages as descriptive as possible.  In the cases of DOS returning an
     error, the error message is given verbatim back to you.  I have taken
     great lengths to make the parser as smart as possible; however, it is
     possible to make any parser look stupid with intentional or lucky
     entries (just leave a terminating curly bracket off a c function if
     you need proof.)  If you follow the syntax closely, the parser will
     make both Install-Pro and your application look great.  If you feel
     that your syntax is correct, or should be, but the parser seems to
     disagree with you, leave me a note through the channels described in
     "Contacting the Author."
     
     
                                Error Messages
     
     
     The following are the standard error messages built into Install-Pro.
     The nature of these errors is such that Install-Pro cannot continue,
     so these error messages can probably be classified as Fatal Errors.
     Of course, the message the user sees doesn't include the word 'Fatal'
     for obvious reasons.  The message the user sees is similar to the one
     that follows:
     
          Ŀ
                                                                      
               The following unrecoverable error has occurred:        
                                                                      
                           Error opening install.001                  
                                                                      
           Please refer to your documentation for manual installation 
           instructions if the problem cannot be corrected.           
                                                                      
                          Press a key to terminate...                 
          
     
     Any application should be distributed with manual installation
     instructions to help alleviate the unexpected, hence the wordage of
     the error message.  The documentation that you provide your users
     should include a telephone number in case of installation
     difficulties, or in case manual procedures also didn't succeed.
     
     DOS version 3.0 or higher required
     
           A DOS version prior to 3.0 was detected.  Install-Pro requires
           MS-DOS 3.0 or later.
     
     Error opening install.001
     
           INSTALL.001 was not found in the same directory as Install-Pro,
           or there were no file handles available.
     
     
     
                          Install-Pro Reference Manual
                                      - 26 -
           
     
     
     
      
     Token was expected but not found: line nn
     
           A token was expected but not found on the indicated line. This
           usually means that one or more words is missing on this line.
     
     Memory allocation error
     
           A request for more memory was denied.  This is extremely
           unlikely to occur, as Install-Pro requires under 200k of free
           RAM.
     
     Error copying xxxxxxx
     
           DOS returned an error while trying to transfer the indicated
           file to the indicated destination.
     
     Cannot copy a file onto itself
     
           The user specified the installation diskette as the destination.
     
     Error creating directory: zzzzz
     
           DOS returned an error while trying to create the indicated
           directory.  The most likely cause is if the user tries to
           install the application to a directory that is the same name as
           an existing file.
     
     Authorization Error (registered versions only)
     
           Install-Pro detected an authorization code that did not match
           the accompanying script file (install.001).  Run Install-Pro
           again with your key to authorize your script.
     
     Executable integrity Error - bad executable
     
           Install-Pro detected internal errors in its executable file.
           This usually means that the file has become corrupted.  Restore
           an original from your backup and retry.
     
     Label not found: xxxxx, line nn
     
           The token in the <label name> position on the specified line
           does not correspond to a previously defined label name created
           with a USER line.
     
     Invalid Disk Space Number
     
           Either no token, or an invalid token, was detected after the
           SPACE token.
     
     
     
                          Install-Pro Reference Manual
                                      - 27 -
           
     
     
     
      
     Unexpected EOF - AUTHORIZATION, END or DISK expected
     
           If Install-Pro parses to the end of a script without finding
           some indication of how to terminate, it returns this error.
     
     Zip output file creation error
     
           An error was detected while trying to create a file embedded in
           a zip file.  The usual causes are out of disk space, an existing
           directory of the same name, or an embedded subdirectory that
           wasn't created with a SUBDIR command.
     
     Zip file open error
     
           The zip file was not found, or no file handles were available.
     
     Invalid zip file header
     
           An inconsistency was detected in the zip file.
     
     Zip file corrupted
     
           An extracted file's crc did not match its reported crc.
     
     Zip file encrypted
     
           Encrypted zip files (and the inherent password needed to build
           the decryption key) are not supported.
     
     USER must precede SPACE
     
           A label's disk space requirements are stored within the
           structure that is created when USER defines the associated
           label.
     
     Error chaining to new program
     
           An error was encountered while trying to load a new copy of
           Install-Pro.  Possible causes are insufficient memory or file
           not found.
     
     System Error - current directory not available
     
           Install-Pro requested from DOS the name of the current
           directory, but DOS returned an error.
     
     System Error - change directory failed
     
           An attempt by Install-Pro to change to another directory (to
           unzip a file) failed.
     
     
                          Install-Pro Reference Manual
                                      - 28 -
           
     
     
     
      
     
     Unexpected end of file
     
           The end of a zip file was encountered unexpectedly.
     
     Disk Write Error - target disk full?
     
           The majority of disk write errors are a full disk, but they
           could also be caused by hard disk failure or logical errors in
           the FAT table.
     
     Directories must be 65 characters or less
     
           The path entered by the user plus the SUBDIR attached to it
           exceeded DOS' maximum.  Don't define SUBDIRs longer than 20
           characters to be safe.
     
     UPGRADE and VERIFY are not supported with split files
     
           Split files cannot be designated for UPGRADE or VERIFY.  This is
           because the trailing portion of a split file has no way of
           knowing if its existing target was verified or not.
     
     Unsupported ZIP version
     
           A ZIP version of higher than 1.1 was detected in a zip file.
           Since no version of ZIP greater than 1.1 currently exists, this
           error may likely indicate zip file corruption.
     
     Invalid command
     
           The first token encountered on the indicated line in the script
           was not a valid command.
     
     
                                Critical Errors
     
     
     Should a disk door be left open (or any other critical error trapped
     by DOS, for that matter) a Critical Error handler built into
     Install-Pro will take control and provide the user with a menu similar
     to this one:
     
     
     
     
     
     
     
     
     
     
                          Install-Pro Reference Manual
                                      - 29 -
           
     
     
     
      
                   [DOS Critical Error]Ŀ
                                                           
                      [Abort]  [Retry]  [Ignore]  [Fail]   
                                                           
                   
     
     If the user accepts retry, he will be in most cases safe.  Of course,
     if his computer picked the exact moment that he's installing your
     application to crash its hard drive, no Critical Error handler is
     going to recover very gracefully.
     
     
     
                               Registration Keys
     
     
     This section deals only with registered copies of Install-Pro.
     Shareware versions have no distribution protection built in
     whatsoever.
     
     With your registered Install-Pro diskette you received a key in the
     form of a series of characters.  This key protects copies of
     Install-Pro that are released with your applications from being used
     with scripts other than the one you defined.  This key is utilized
     simply by you the programmer including it with absolutely no
     accompanying punctuation whatsoever as the only argument on the
     install.exe command line.  The result is that the script is processed
     normally, with an authorization code created on the AUTHORIZATION
     line.  Observing this procedure ensures that your scripts never cause
     Install-Pro to abort with an Authorization Error message.  For
     development purposes, just create a batch file to save repeatedly
     typing in your key.  Then, when you release your product, the script
     has the latest AUTHORIZATION (see above) encoded in your script,
     enabling Install-Pro to only to work with the unmodified script.  This
     protects my product, as well as protects your installation from
     unwanted tampering.
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
     
                          Install-Pro Reference Manual
                                      - 30 -
      
