-----------------------------------------------------------------
VOUCH  version  1.1.  Copyright (c) 1993, 1994  Awais M. Hussain.
-----------------------------------------------------------------
<feal.c>

Encryption/Decryption routines.  The algorithm used is the expanded
fast encipherment algorithm (FEAL-N/X) described in [1].  The
secret-key is 128-bits long.  Cipher-feedback mode is used. For
files, double-encryption (in forward and reverse direction) is done.
The FEAL-"rounds" parameter N=32.

====================================================================

1. void  cryptLN( int  enc, char  *pswd, lenLN  *Lvv, ptrLN  vv ) ;

Encrypts/Decrypts LN (Lvv,vv) with a 8-32 character password (pswd).
For maximum security, a full 32-character password should be used.
enc=1 => encrypt.
enc=0 => decrypt.
If Lvv is odd, the returned LN has Lvv incremented by 1.
Sixty-four-bit stream-cipher mode is used.

I: enc : {0,1}-flag.
I: pswd : 8-32 character password string.
I/O: Lvv : Length of the LN.
I/O: vv : the LN.

2. int 	fecrypt( char *infile, char *outfile ) ;

Encrypt file <infile> and store the cipher in <outfile>.  The
caller must fill key[] with the hex password.  Sixty-four-bit
stream-cipher mode (cipher-feedback mode) is used.  The routine
implements double encryption: blocks of 4096 bytes are enciphered,
first from the beginning and then starting at the end of the block.
This is equivalent to enciphering from start to end of the file on
the first pass; on the second pass the blocks are processed starting
at the bottom of each block (starting at the first block). This
causes diffusion in both directions within blocks.

The input data length is increased by 1 to 8 bytes, since at least
one byte has to be appended containing the number of extra bytes
appended and feal_e() acts on 64-bit chunks. For the stream-cipher
mode, only the basic-feal-encryptor feal_e() is needed for both
encryption and decryption.

I: infile : input filename.
I: outfile: output filename.

3. int 	fdcrypt( char *infile, char *outfile ) ;

Decrypts file <infile>, encrypted earlier with fecrypt(). The
plaintext is written in <outfile>. The caller must fill key[] with
the hex password. 

First two lines of <infile> are skipped since they contain the
VCH-header and a LN as required by the VOUCH cipher-file format.

I: infile : input filename.
I: outfile: output filename.


4. void  str2key( char *pswd ) ;

Converts 32-character "pswd" into 16-byte-hex-key filling the array
key[].  Only the lower nibble of a character is used, making the
password case-insensitive.

I: pswd: 8-32 character password string.
=================================================================

5. void feal_e( long unsigned *Lf, long unsigned *Rf )  ;

Basic FEAL-N/X algorithm for encrypting the tuple (Lf,Rf).

I/O: Lf : left-half 32-bits of the 64-bit data-block.
I/O: Rf : right-half 32-bits of the 64-bit data-block.


6. static void keySchedule() ;

Expands the hex-key key[4] into Kw[NN+7+1] as required by the FEAL
algorithm. Before any calls to feal_e(), this function must be called
once. 


7. static long unsigned  f_K( long unsigned awp, long unsigned bwp) ;

A function used by keySchedule(), described in [1].

I: awp, bwp


8. long unsigned reverse( long unsigned xx ) ;

Reverse the order of bytes in xx and return the reversed number. For
example, 0x12345678 becomes 0x78563412.

I: xx
====================================================================

9. long unsigned  key[4] = {0,0,0,0};

Hex-password. Before calls to fecrypt(), fdcrypt(), feal_e(), this
must be filled with the proper hex-password.

====================================================================

[1]  S. Miyaguchi, S. Kurihara, K. Ohta, and H. Morita, 
     "Expansion of FEAL cipher," 
     NTT Review, Vol. 2, No. 6, Nov. 1990.
     (Also in CRYPTO '90 Proceedings. LNCS, Springer-Verlag 1991.)
