/**<a2b.c>***************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <a2b.man> and <vouch.man> for documentation. 
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

char buffR[6600], buffW[4800] ;

void byte2six( int *nW )
{
  int i,j, nR ;
  char bx1, bx2 ;

  *nW = 0 ;
  for (i=0; i<100; ++i)
    for (j=0; j<16; ++j) {
      nR = i*66 + 4*j ;
      bx1 = buffR[nR] - 48 ;
      bx2 = buffR[nR+1] - 48 ;
      buffW[(*nW)++] = (bx1 << 2) | (bx2 >> 4 ) ;
      bx1 = buffR[nR+2] - 48 ;
      buffW[(*nW)++] = (bx2 << 4) | (bx1 >> 2 ) ;
      bx2 = buffR[nR+3] - 48 ;
      buffW[(*nW)++] = (bx1 << 6) | bx2 ;
    }
}/*byte2six*/


void text2bin( char *fnr, char *fnw )
{
  int nW, cnt, rcnt, wcnt, d66, m66, d04, m04 ;
  FILE  *fr, *fw ;

  if ( (fr=fopen( fnr, "rb")) == (FILE*) NULL ) exit(errno) ;
  if ( (fw=fopen( fnw, "wb")) == (FILE*) NULL ) exit(errno) ;
  cnt = 6600 ; rcnt = cnt ;
  fgets( buffR, cnt, fr ) ;
  while (rcnt==cnt) {
    nW = 0 ;
    rcnt = fread( buffR, 1, cnt, fr ) ;
    byte2six( &nW ) ;
    if (rcnt<cnt) {
      if ( (rcnt % 66) != 0 )  rcnt -= 2  ;
      d66 = rcnt / 66 ;
      m66 = rcnt % 66 ;
      d04 = m66 / 4 ;
      m04 = m66 % 4 ;
      nW = d66 * 48 + d04 * 3 ;
      if (m04==2) nW++ ;
      if (m04==3) nW += 2 ;
      if (nW<0) nW = 0 ;
      if (rcnt<=0) nW = 0 ;
    }
    wcnt = fwrite( buffW, 1, nW, fw ) ;
    if (wcnt<nW) {
      perror("disk write error. ") ;
      fclose(fr) ; fclose(fw) ;
      exit(5) ;
    }
  }
  fclose(fr) ;
  fclose(fw) ;
}/*text2bin*/

main( int argc, char *argv[] )
{
/*1*/
 if (argc!=3) {
    puts("A2B 1.1, VOUCH Utility, Copyright (c) 1993, 1994  Awais M. Hussain") ;
    puts("    Decode file encoded with <b2a.exe>.\n") ;
    puts("Usage: a2b.exe <inFile> <outFile>" ) ;
    exit(1) ;
  }
  text2bin( argv[1], argv[2] ) ;
}