/**<vstd.c>**************************************************
*                       V O U C H                           *
*   VOUCH 1.1  Copyright (c) 1993, 1994  Awais M Hussain    *
*                   All rights reserved                     *
*************************************************************/
/* Consult <vstd.man> for documentation. 
SecurityTool (deCap) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dir.h>
#include <io.h>
#include <time.h>
#include <process.h>
#include "vst.h"


/** ID Strings **/
const char   
   *txtID = "vch 1.1 utility :6-bit alphabet encoded" ,
   *cphID = "vch 1.1 :cipher (feal-x/64/2)" ,
   *sgnID = "vch 1.1 :digital signature msg [nist]" ,
   *sigID = "vch 1.1 :digital signature [nist]" ,
   *hashID = "vch 1.1 :hash standard [nist]" ;


int cap( char *fn, char *hdr )
{
  FILE *ff ;

  if ( (ff = fopen( fn, "r" )) == (FILE*) NULL ) return(-1) ;
  fgets( hdr, 100, ff ) ;
  fclose( ff ) ;
  if (strstr( hdr, txtID) != (char*) NULL) return(1) ;
  if (strstr( hdr, cphID) != (char*) NULL) return(2) ;
  if (strstr( hdr, sgnID) != (char*) NULL) return(3) ;
  if (strstr( hdr, sigID) != (char*) NULL) return(4) ;
  if (strstr( hdr, hashID) != (char*) NULL) return(5) ;
  return(0) ;
}/* cap */


main( int argc, char *argv[] )
{

  char fn[80], fno[80], fnp[80], frname[80], vpath[76], xpath[76],
       drv[4], dir[76], name1[14], name2[14], msg[200], hdr[100],
       ext1[5], ext2[5] ;
  char *cDir ;
  int kind, err ;
  time_t tx ;

/*1*/
  if ((argc<2) || (argc>3)) {
    puts("  SecurityTool (deCap): VCH 1.1: Copyright (c) 1993, 1994  Awais M. Hussain") ;
    puts("Usage: vSTd.exe  <inFile>  [vch_path]" ) ;
    exit(1) ;
  }
  strcpy( fn, argv[1] ) ;
  if (access(fn,0)) {
    printf("File <%s> not found.\n", fn) ;
    exit(errno) ;
  }
  randomize() ;
/*2*/
  if (argc==1) strcpy(vpath, "c:\\vch" ) ;
    else strcpy( vpath, argv[2] ) ;
  strcat( vpath, "\\" ) ;
  strcpy(fnp, "") ;
/*3*/
  strcpy(msg,"\n==========================\nVCH SecurityTool STD 1.1 #  ") ;
  time( &tx ) ;
  strcat(msg,ctime(&tx)) ;
  writeLog( msg ) ;

  strcpy(msg,"VOUCH_Directory = ") ;
  cDir = getenv( "VCH" ) ;
  if (cDir==NULL) {
    getcwd(fno, 80) ;
    strcat(msg,fno) ;
  } else strcat(msg,cDir) ;
  writeLog(msg) ;
/*4*/
  do {
    if ( (kind=cap(fn,hdr)) == -1 ) {
      printf("** File <%s> error\n", fn ) ;
      exit(13) ;
    }
    strcpy(xpath, vpath) ;
    switch (kind) {
      case 1: /* decode 6-bit alphabet */
	strcpy(msg,"STD: SIX-BIT DECODING. . .<") ;
	strcat(msg, fn) ;
	strcat(msg, "\n") ;
	strcat(msg, hdr ) ;
	writeLog(msg) ;
	geName( frname ) ;
	fExt( frname, ".bbb", fno ) ;
	strcat(xpath,"a2b.exe") ;
	err = spawnl( P_WAIT, xpath, "a2b.exe", fn, fno, (char*)0 ) ;
	strcpy(fn, fno) ;
	break ;
      case 2:/* decrypt */
	strcpy(msg, "STD: DECRYPTING. . .<" ) ;
	strcat(msg, fn) ;
	strcat(msg, "\n") ;
	strcat(msg, hdr ) ;
	writeLog(msg) ;
	geName( frname ) ;
	fExt( frname, ".pln", fno ) ;
        strcat(xpath, "vch.exe") ;
	err = spawnl( P_WAIT, xpath, "vch.exe", "/d", fn, fno, (char*)0 ) ;
	strcpy(fn, fno) ;
	break ;
      case 3: /* verify signed message */
	strcpy(msg, "STD: SIGNED MESSAGE. . .<") ;
	strcat(msg, fn) ;
	strcat(msg, "\n") ;
	strcat(msg, hdr ) ;
	writeLog(msg) ;
	field_n( hdr, 5, dir ) ;
	keyMatch( fno, dir ) ;
	while (kbhit()) getch() ;
	printf("Enter signer's public_key filename: <%s> : ", fno ) ;
	gets( fnp ) ;
	if (strlen(fnp)!=0)  strcpy(fno,fnp) ;
	strcat(xpath,"vch.exe") ;
	err = spawnl( P_WAIT, xpath, "vch.exe", "/vsgn", fn, fno, (char*)0 ) ;
        if (err) {
          puts("Halting.") ; exit(19) ;
        }
	geName( frname ) ;
	fExt( frname, ".msg", fno ) ;
        strcpy(xpath, vpath) ;
	strcat(xpath, "rmln.exe") ;
	err = spawnl( P_WAIT, xpath, "rmln.exe", "3", fn, fno, (char*)0 ) ;
        strcpy(fn,fno) ;
	break ;
      case 4: /* verify signature */
	strcpy(msg, "STD: SIGNATURE. . .<") ;
	strcat(msg, fn) ;
	strcat(msg, "\n") ;
	strcat(msg, hdr ) ;
	writeLog(msg) ;
	field_n( hdr, 5, dir ) ;
	keyMatch( fno, dir ) ;
	while (kbhit()) getch() ;
	printf("Enter signer's public_key filename: <%s> : ", fno ) ;
	gets( fnp ) ;
	if (strlen(fnp)!=0) strcpy(fno,fnp) ;
	strcat(xpath,"vch.exe") ;
	err = spawnl( P_WAIT, xpath, "vch.exe", "/vsig", fn, fno, (char*)0 ) ;
        if (err) {
          puts("Halting.") ; exit(19) ;
        }
	geName( frname ) ;
	fExt( frname, ".hsh", fno ) ;
        strcpy(xpath, vpath) ;
	strcat(xpath, "rmln.exe") ;
	err = spawnl( P_WAIT, xpath, "rmln.exe", "3", fn, fno, (char*)0 ) ;
        strcpy( fnp, fn ) ;
	strcpy( fn, fno ) ;
        break;
      case 5: /* verify hash */
	strcpy(msg,"STD: HASH. . .<") ;
	strcat(msg, fn) ;
	strcat(msg, "\n") ;
	strcat(msg, hdr ) ;
	writeLog(msg) ;
	while (kbhit()) getch() ;
	cputs("Enter filename for hashing: ") ; gets( fno ) ;
        strcat(xpath, "vch.exe") ;
	err =
        spawnl( P_WAIT, xpath, "vch.exe", "/h", fno, "nul", fnp, (char*)0 ) ;
        exit(0) ;
    }
  } while ( (kind!=0) && (err==0) ) ;
  if (err) {
    puts("Halting.") ; exit(19) ;
  }
/*5*/
  fnsplit( fn, drv, dir, name1, ext1 ) ;
  fnsplit( argv[1], drv, dir, name2, ext2 ) ;
  fnmerge( fnp, drv, dir, name2, ext1 ) ;
  if (access(fnp,0)) {
    rename( fn, fnp ) ;
    strcpy( fn, fnp ) ;
  }
  strcpy(msg, "STD: OutFile: >") ;
  strcat( msg, fn ) ;
  writeLog( msg ) ;

}
