/******************************************************************************
* Procedures to print/change the current directory.			      *
* Both routine assume the usage of GraphGen.c graphic module, and use the     *
* MenuArea (MSG_AREA_X/Y) as i/o (print and read).			      *
*									      *
*				Ver 0.2		Gershon Elber	      May. 89 *
******************************************************************************/

#include <stdio.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>
#include <graphics.h>
#include "GraphGnG.h"
#include "Dir-Graf.h"

#ifndef LINE_LEN
#define LINE_LEN 128
#endif

#define READ_COLOR  GREEN

/******************************************************************************
* Procedure to print the current directory content in menu area:	      *
* Print file name and size in k bytes one per line. if page is full	      *
* (> ~20 lines) it pause and continue in next page. No sort is perform.       *
* Note it is the responsibility of the caller to clean the menu area on exit. *
******************************************************************************/
void PrintDir(char *FileToDir)
{
    int i, j;
    char s[128], Ctemp;
    double Ylevel = 0.9;
    struct ffblk ffblk;

    GGClearMenuArea();
    GGMySetColor(MAGENTA);

    if (FileToDir == NULL) FileToDir = DEFAULT_FILE_TO_DIR;

    getcwd(s, 127);			   /* Might be 64 chars at the most. */
    j = 0;
    i = strlen(s);	/* Test if length greater than possible in one line. */
    while (i > j) {
	Ctemp = s[j+MAX_HELP_MENU_CHAR];
	s[j+MAX_HELP_MENU_CHAR] = 0;		/* Put temporary NULL there. */
	GGPutMsgXY(&s[j], MSG_AREA_X, Ylevel);
	s[j+MAX_HELP_MENU_CHAR] = Ctemp;	     /* Put the char back... */
	j += MAX_HELP_MENU_CHAR;
	Ylevel -= 0.09;
    }
    Ylevel -= 0.09;		   /* Make some space from directory name... */

    GGMySetColor(GREEN);
    if (!findfirst(FileToDir, &ffblk, 0))
	do {
	    sprintf(s, "%3dk   %s", (int) ((ffblk.ff_fsize+1023)/1024),
								ffblk.ff_name);
	    if (Ylevel < -0.7) {
		GGPutErrorMsg("");
		GGClearMenuArea();
		GGMySetColor(GREEN);
		Ylevel = 0.9;
	    }
	    GGPutMsgXY(s, MSG_AREA_X, Ylevel);
	    Ylevel -= 0.09;
	}
	while (!findnext(&ffblk));
    else {
	sprintf(s, "NO '%s' FILE(S)", FileToDir);
	GGPutMsgXY(s, MSG_AREA_X, Ylevel);
	Ylevel -= 0.09;
    }

    if (!findfirst("*.*", &ffblk, FA_DIREC))
	do {
	    switch (ffblk.ff_attrib) {
		case FA_DIREC:				       /* Directory. */
		    sprintf(s, "<DIR>  %s", ffblk.ff_name);
		    if (Ylevel < -0.7) {
			GGPutErrorMsg("");
			GGClearMenuArea();
			GGMySetColor(GREEN);
			Ylevel = 0.9;
		    }
		    GGPutMsgXY(s, MSG_AREA_X, Ylevel);
		    Ylevel -= 0.09;
		    break;
	    }
	}
	while (!findnext(&ffblk));

    GGPutErrorMsg("");
}

/*****************************************************************************
*   Routine to change current directory					     *
*****************************************************************************/
void ChangeDir(void)
{
    int i, j;
    char s[LINE_LEN], cwd[LINE_LEN], Ctemp, *sptr;
    double Ylevel;

    GGMySetColor(READ_COLOR);
    getcwd(cwd, LINE_LEN-1);		   /* Might be 64 chars at the most. */
    Ylevel = 0.38;
    j = 0;
    i = strlen(cwd);	/* Test if length greater than possible in one line. */
    while (i>j) {
	Ctemp = cwd[j+MAX_HELP_MENU_CHAR];
	cwd[j+MAX_HELP_MENU_CHAR] = 0;		/* Put temporary NULL there. */
	GGPutMsgXY(&cwd[j], MSG_AREA_X, MSG_AREA_Y+Ylevel);
	cwd[j+MAX_HELP_MENU_CHAR] = Ctemp;	     /* Put the char back... */
	j += MAX_HELP_MENU_CHAR;
	Ylevel -= 0.09;
    }
    GGPutMsgXY("Enter New Dir :", MSG_AREA_X, MSG_AREA_Y+0.2);

    s[0] = s[1] = s[2] = 0;   /* Make sure that no old data remains there... */
    GGGetGraphicLine(MSG_AREA_X, MSG_AREA_Y, s, READ_COLOR);

    GGMySetColor(BLACK);
    GGPutMsgXY("Enter New Dir :", MSG_AREA_X, MSG_AREA_Y+0.2);
    Ylevel = 0.38;
    j = 0;
    i = strlen(cwd);	/* Test if length greater than possible in one line. */
    while (i>j) {
	Ctemp = cwd[j+MAX_HELP_MENU_CHAR];
	cwd[j+MAX_HELP_MENU_CHAR] = 0;		/* Put temporary NULL there. */
	GGPutMsgXY(&cwd[j], MSG_AREA_X, MSG_AREA_Y+Ylevel);
	cwd[j+MAX_HELP_MENU_CHAR] = Ctemp;	     /* Put the char back... */
	j += MAX_HELP_MENU_CHAR;
	Ylevel -= 0.09;
    }

    if (s[1] == ':') sptr = &s[2];	    /* sptr points on the path only. */
    else sptr = s;

    if (strlen(sptr) != 0 && chdir(s)) GGPutErrorMsg("No Such Dir!");
    else if (s[1] == ':') {
	if (islower(s[0])) s[0] = toupper(s[0]);
	setdisk(s[0] - 'A');			    /* Move to the new disk. */
	if (getdisk() != s[0] - 'A') GGPutErrorMsg("No Such Disk!");
    }

    if (getcwd(s, LINE_LEN-1) == NULL) {      /* Test if directory is valid! */
	GGPutErrorMsg("CD error - ignored");

	/* Restore old working directory: */
	if (strlen(&cwd[2]) != 0) chdir(cwd); /* If directory is not root... */
	if (islower(cwd[0])) cwd[0] = toupper(cwd[0]);
	setdisk(cwd[0] - 'A');		       /* Move to the original disk. */
    }
}
