/******************************************************************************
* MSDOS interaction library low level graphics routines.		      *
*									      *
*					Written by Gershon Elber,  Oct. 1990  *
*******************************************************************************
* Supported device:							      *
* 1. CGA.								      *
* 2. EGA/VGA.								      *
* 3. Hercules.								      *
* 4. Super VGA.								      *
*******************************************************************************
* History:								      *
*  15 Oct 90 - Version 1.0 by Gershon Elber.				      *
******************************************************************************/

#ifndef INTR_GR_H
#define INTR_GR_H

#define GR_SOLID_FILL 1

typedef enum {		/* Line styles for Get/SetLineStyle. */
    GR_SOLID_LINE  = 0,
    GR_DOTTED_LINE = 1,
    GR_DASHED_LINE = 3
} GRLineStypeType;

typedef enum {		/* Line widths for Get/SetLineStyle. */
    GR_NORM_WIDTH  = 1,
    GR_THICK_WIDTH = 3
} GRLineWidthType;

typedef enum {
    GR_HORIZ_DIR = 0,	/* Left to right. */
    GR_VERT_DIR  = 1	/* Bottom to top. */
} GRTextDirType;

typedef enum {
    GR_TEXT_HJUSTIFY_LEFT = 0,
    GR_TEXT_HJUSTIFY_CENTER,
    GR_TEXT_HJUSTIFY_RIGHT
} GRTextHorizJustifyType;

typedef enum {
    GR_TEXT_VJUSTIFY_BOTTOM = 0,
    GR_TEXT_VJUSTIFY_CENTER,
    GR_TEXT_VJUSTIFY_TOP
} GRTextVertJustifyType;

typedef enum {
    GR_FONT_DEFAULT = 0
} GRFontType;

typedef enum {
    GR_TEXT_MAG_1 = 1
} GRTextmagnificationType;

typedef enum {
    GR_COPY_PUT = 0,
    GR_XOR_PUT = 1
} GRWriteModeType;

extern int GRScreenMaxX, GRScreenMaxY;  /* The maximum resolution of screen. */
extern int GRScreenMaxColors;          /* The maximum # of colors available. */
extern IntrRType GRScreenAspect;/* Screen aspect ratio (pixel width/height). */
extern int GRFontName, GRFontSize;	 /* Global information on font used. */
extern int GRCurrentCursorX, GRCurrentCursorY;   /* Cursor current position. */
extern int GRDrawText;		   /* If can not zoom down text, force draw. */
extern int GRGraphMode, GRGraphDriver;        /* What driver/mode are we in. */

void GRInstallSVGA(char *NameMode);
void GRSetBGIPath(char *BGIPath);
void GRSetDefaultDriver(int GraphDriver);

void GRInitGraph(void);
void GRCloseGraph(void);
void GRPutArrowCursor(int x, int y);
void GRSetZoomFactor(int ZoomFactor);
void GRSetPanFactors(int PanFactorX, int PanFactorY);
void GRSetLineStyle(int LineStyle, unsigned int Pattern, int Thickness);
void GRSetFillStyle(int Pattern, int Color);
void GRSetWriteMode(int DrawMode);
void GRSetTextJustify(int HorizCenter, int VertCenter);
void GRSetTextStyle(int GRFontName, int Direction, int Size);
void GRSetSTextStyle(int GRFontName, int Direction, int Size);
unsigned GRGetImageBufferSize(int x1, int y1, int x2, int y2);
void GRGetImageBuffer(int x1, int y1, int x2, int y2, VoidPtr Buffer);
void GRPutImageBuffer(int x1, int y1, VoidPtr Buffer);
void GRXORRectangle(int x1, int y1, int x2, int y2);
int GRMapX(int x);
int GRMapY(int y);
int GRInvMapX(int x);
int GRInvMapY(int y);
void GRLine(int x1, int y1, int x2, int y2);
void GRSLine(int x1, int y1, int x2, int y2);
void GRMoveTo(int x, int y);
void GRSMoveTo(int x, int y);
void GRLineTo(int x, int y);
void GRSLineTo(int x, int y);
void GRMoveRel(int x, int y);
void GRSMoveRel(int x, int y);
void GRLineRel(int x, int y);
void GRSLineRel(int x, int y);
void GRPoly(int n, int *Points, int Fill);
void GRBar(int x1, int y1, int x2, int y2);
void GRSBar(int x1, int y1, int x2, int y2);
void GRCircle(int x, int y, int r);
void GRArc(int x, int y, int StAngle, int EndAngle, int r);
IntrBType GRDrawingText(void);
void GRText(int x, int y, char *s);
void GRSText(int x, int y, char *s);
void GRSTextShadow(int x, int y, int Color, char *s);
int GRGetTextWidth(char *Str);
int GRGetTextHeight(char *Str);
void GRPushTextSetting(void);
void GRPopTextSetting(void);
void GRSetColor(int Color);
int GRGetColor(void);
void GRSetRGBPalette(int Index, int Red, int Green, int Blue);
void GRDrawPoint(int x, int y, char title[], int PointColor);
void GRClearViewPort(int x1, int y1, int x2, int y2);
void GRGetViewPort(int *x1, int *y1, int *x2, int *y2);
void GRSetViewPort(int x1, int y1, int x2, int y2);
void GRPopViewPort(void);
void GRPushViewPort(void);
void GRClearAllScreen(void);
void GRPutMsgXY(char *s, int x, int y);
void GRGetGraphicLine(int WindowID, int x, int y, char s[], int SLen,
		      int WindowLen, int ForeColor, int BackColor);
void GRSetGetKeyFunc(IntrInt2PtrFunc GetChFunc);
void GRTone(int Frequency, int Time);

#endif /* INTR_GR_H */
