/*****************************************************************************
* Generic parser for the "Irit" solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Sep. 1991   *
*****************************************************************************/

#ifndef	IRIT_PRSR_GH
#define	IRIT_PRSR_GH

#include "cagd_lib.h"
#include "genmat.h"

typedef enum {
    IP_POLYGON = 1,
    IP_POLYLINE,
    IP_POINTLIST
} IPPolyStructType;

typedef enum {
    IP_OBJ_UNDEF,
    IP_OBJ_POLY,
    IP_OBJ_SURFACE,
    IP_OBJ_CURVE
} IPObjStructType;

#define MAX_NUM_ATTRS		10

/*****************************************************************************
* Attributes - an attribute is a pair of strings consists of a key and the   *
* data. Up to MAX_NUM_ATTRS are supported.		                     *
*****************************************************************************/
typedef struct IPAttributeStruct {
    int NumStrAttribs;
    char *StrAttrName[MAX_NUM_ATTRS];		    /* Generic string attrs. */
    char *StrAttrData[MAX_NUM_ATTRS];
} IPAttributeStruct;


#define IP_IS_VRTX_INTERNAL(V)		(V -> VTags & 0x01)
#define IP_SET_VRTX_INTERNAL(V)		(V -> VTags |= 0x01)
#define IP_RST_VRTX_INTERNAL(V)		(V -> VTags &= ~0x01)
#define IP_HAS_VRTX_NORMAL(V)		(V -> VTags & 0x02)
#define IP_SET_VRTX_NORMAL(V)		(V -> VTags |= 0x02)
#define IP_RST_VRTX_NORMAL(V)		(V -> VTags &= ~0x02)

typedef struct IPVertexStruct {
    struct IPVertexStruct *Pnext;		        /* To next in chain. */
    VoidPtr VAux;
    unsigned int VTags;					 /* Some attributes. */
    int Color;
    RealType Coord[3];			       /* Holds X, Y, Z coordinates. */
    RealType Normal[3];		       /* Hold Vertex normal into the solid. */
} IPVertexStruct;

#define IP_HAS_POLY_PLANE(P)		(P -> PTags & 0x01)
#define IP_SET_POLY_PLANE(P)		(P -> PTags |= 0x01)
#define IP_RST_POLY_PLANE(P)		(P -> PTags &= ~0x01)
#define IP_HAS_POLY_BBOX(P)		(P -> PTags & 0x02)
#define IP_SET_POLY_BBOX(P)		(P -> PTags |= 0x02)
#define IP_RST_POLY_BBOX(P)		(P -> PTags &= ~0x02)

typedef struct IPPolygonStruct {
    struct IPPolygonStruct *Pnext;		        /* To next in chain. */
    VoidPtr PAux;
    unsigned int PTags;				         /* Some attributes. */
    IPPolyStructType Type;
    RealType Plane[4];			 /* Holds Plane as Ax + By + Cz + D. */
    RealType Xmin, Xmax, Ymin, Ymax;         /* Bounding box of the polygon. */
    IPVertexStruct *PVertex;		    		/* To vertices list. */
} IPPolygonStruct;

#define IP_HAS_OBJ_RGB(P)		(P -> OTags & 0x01)
#define IP_SET_OBJ_RGB(P)		(P -> OTags |= 0x01)
#define IP_RST_OBJ_RGB(P)		(P -> OTags &= ~0x01)
#define IP_HAS_OBJ_COLOR(P)		(P -> OTags & 0x02)
#define IP_SET_OBJ_COLOR(P)		(P -> OTags |= 0x02)
#define IP_RST_OBJ_COLOR(P)		(P -> OTags &= ~0x02)

typedef struct IPObjectStruct {
    struct IPObjectStruct *Pnext;
    struct IPObjectStruct *FFPolylines, *FFPolygons;    /* Freeform approx.. */
    struct IPAttributeStruct Attrs;
    VoidPtr OAux;
    char Name[OBJ_NAME_LEN];
    unsigned char RGB[3];
    unsigned int OTags;				         /* Some attributes. */
    IPObjStructType Type;
    int Color;
    union {
	IPPolygonStruct *PPolygon;
	CagdCrvStruct *PCrvs;
	CagdSrfStruct *PSrfs;
    } U;
} IPObjectStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif
IPObjectStruct *IritPrsrGetObjects(FILE *f);
int IritPrsrParseError(char **ErrorMsg);
IPVertexStruct *IritPrsrNewVertexStruct(void);
IPPolygonStruct *IritPrsrNewPolygonStruct(void);
IPObjectStruct *IritPrsrNewObjectStruct(void);

void IritPrsrSetStrAttrib(IPObjectStruct *PObj, char *Name, char *Data);
char *IritPrsrGetStrAttrib(IPObjectStruct *PObj, char *Name);

/* If set to TRUE (default) polygons will have their vertex lists circular   */
/* or last vertex point on first. If set to FALSE, regular list list.	     */
extern int IritPrsrPolyListCirc;

/* Will be set to VIEW_MAT and PERS_MAT respectively if found in parsed data.*/
extern MatrixType IritPrsrViewMat, IritPrsrPrspMat;
extern int IritPrsrWasViewMat, IritPrsrWasPrspMat;

/* External variables/functions that should be provided by the application:  */

/* Gets two list of all curves and surfaces in the datafile and process them */
/* as needed. May return a processed version to be put on returned list from */
/* IritPrsrGetObjects (polygonal approximation of the free form data for     */
/* example), or NULL otherwise.						     */
/* This function is responsible to free crvs/srfs if not needed any more.    */
IPObjectStruct *IritPrsrProcessFreeForm(IPObjectStruct *CrvObjs,
					IPObjectStruct *SrfObjs);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	/* IRIT_PRSR_GH */
