/*****************************************************************************
* A replacer for the MSDOS functions.					     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Aug. 1991   *
*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "irit_sm.h"

/*****************************************************************************
*   Routine to move a block in memory. Unlike memcpy/bcopy, this routine     *
* should support overlaying blocks. This stupid implemetation will copy it   *
* twice - to a temporary block and back again. The temporary block size will *
* be allocated by demand.						     *
*****************************************************************************/
void movmem(VoidPtr Src, VoidPtr Dest, int Len)
{
    VoidPtr p = malloc(Len);

    memcpy(p, Src, Len);
    memcpy(Dest, p, Len);

    free(p);
}

/*****************************************************************************
*   Routine to concat a full path to a given name - used in non MSDOS        *
* environment only, and in that case assumes path is in IRIT_PATH variable.  *
*****************************************************************************/
char *searchpath(char *Name)
{
    static char FullPath[LINE_LEN_LONG];
    char *p;

    if (p = getenv("IRIT_PATH")) {
	strcpy(FullPath, p);
	strcat(FullPath, Name);
    }
    else {
	static int Printed = FALSE;
	
	strcpy(FullPath, Name);

	if (!Printed)
	{
	    fprintf(stderr,
		    "IRIT_PATH env. not set. Only current directory is being searched.\n");
	    Printed = TRUE;
	}
    }
    return FullPath;
}

#ifdef STRICMP
/*****************************************************************************
*   Routine to compare two strings, ignoring case, up to given length.       *
*****************************************************************************/
int strnicmp(char *s1, char *s2, int n)
{
    /* Use to be simply 'return strncasecmp(s1, s2, n);' but seems that some */
    /* unix systems (sun4?) does have it so here it is explicitly.	     */
    /* Written by Reiner Wilhelms <reiner@shs.ohio-state.edu>.		     */
    int i;
    char c1, c2;

    for (i = 0; i < n; i++) {
        if (islower(s1[i]))
	    c1 = toupper(s1[i]);
        else
	    c1 = s1[i];
        if (islower(s2[i]))
	    c2 = toupper(s2[i]);
        else
	    c2 = s2[i];

        if (c1 != c2) {
	    if (c1 > c2) return 1;
            if (c1 < c2) return -1;
	}
    }
    return 0;
}

/*****************************************************************************
*   Routine to compare two strings, ignoring their case.		     *
*****************************************************************************/
int stricmp(char *s1, char *s2)
{
    int i;
    char *u1, *u2;

    if (s1 == NULL)
	return s2 != NULL;
    else if (s2 == NULL)
	return 1;

    u1 = strdup(s1);
    u2 = strdup(s2);

    for (i = 0; i < (int) strlen(u1); i++)
	if (islower(u1[i])) u1[i] = toupper(u1[i]);
    for (i = 0; i < (int) strlen(u2); i++)
	if (islower(u2[i])) u2[i] = toupper(u2[i]);

    i = strcmp(u1, u2);

    free(u1);
    free(u2);

    return i;
}
#endif /* STRICMP */

#ifdef STRSTR
/*****************************************************************************
*   Routine to search for pattern (no regular expression) in s. Returns      *
* address in s of first occurance of patern, NULL if non found.		     *
*****************************************************************************/
char *strstr(char *s, char *Pattern)
{
    int Len = strlen(Pattern);
    char *p = (char *) s;

    while (p = strchr(p, Pattern[0]))
	if (strncmp(p, Pattern, Len) == 0)
	    return p;
	else
	    p++;

    return NULL;
}
#endif /* STRSTR */

#ifdef STRDUP
/*****************************************************************************
*   Routine to compare to strings, ignoring their case.			     *
*****************************************************************************/
char *strdup(char *s)
{
    char *p = malloc(strlen(s) + 1);

    if (p == NULL) return NULL;

    strcpy(p, s);

    return p;
}
#endif /* STRDUP */

#ifdef GETCWD
/*****************************************************************************
*   Get current working directory - BSD4.3.				     *
*****************************************************************************/
char *getcwd(char *s, int Len)
{
    getwd(s);

    return s;
}
#endif /* GETCWD */
