;  Copyright (c) 1988  Thomas G. Hanlin III
;  FIX101KY.ASM
;  remaps the 101-key "enhanced" keyboard to a semblence of sanity
;  initial version, 07/24/88


ResLength equ Install - Main + 256


Sseg          segment byte stack 'prog'    ; dummy stack segment
Sseg          ends


Cseg          segment byte public 'prog'
              assume  cs:Cseg, ds:Cseg, ss:Sseg

              org     100h


Main          proc    far
              jmp     Install
Main          endp



Intrpt        proc    far
              cmp     ah,4Fh             ; do we need to worry about it?
              jne     OrigHandler        ;   no, let old handler take it

              cmp     al,38h             ; Alt make code?
              je      mAlt               ;   yes
              cmp     al,0B8h            ; Alt break code?
              je      bAlt               ;   yes

              cmp     al,3Ah             ; CapsLock make code?
              je      mCapsLock          ;   yes
              cmp     al,0BAh            ; CapsLock break code?
              je      bCapsLock          ;   yes

              cmp     al,1Dh             ; Control make code?
              je      mControl           ;   yes
              cmp     al,9Dh             ; Control break code?
              je      bControl           ;   yes

              cmp     al,1               ; Esc make code?
              je      mEsc               ;   yes
              cmp     al,81h             ; Esc break code?
              je      bEsc               ;   yes

              cmp     al,29h             ; Tilde make code?
              je      mTilde             ;   yes
              cmp     al,0A9h            ; Tilde break code?
              je      bTilde             ;   yes

OrigHandler:  stc                        ; give it to original kbd handler

              db 0EAh      ; self-modifying code: JMP FAR PTR xxxx:yyyy
      VOFS    dw ?         ; original INT 15h vector ("misc system services")
      VSEG    dw ?

mAlt:         mov     al,3Ah             ; xlate to CapsLock key "make" code
              jmp     OrigHandler
bAlt:         mov     al,0BAh            ; xlate to CapsLock key "break" code
              jmp     OrigHandler

mCapsLock:    mov     al,1Dh             ; xlate to control key "make" code
              jmp     OrigHandler
bCapsLock:    mov     al,9Dh             ; xlate to control key "break" code
              jmp     OrigHandler

mControl:     mov     al,38h             ; xlate to alt key "make" code
              jmp     OrigHandler
bControl:     mov     al,0B8h            ; xlate to alt key "break" code
              jmp     OrigHandler

mEsc:         mov     al,29h             ; xlate to ~` "make" code
              jmp     OrigHandler
bEsc:         mov     al,0A9h            ; xlate to ~` "break" code
              jmp     OrigHandler

mTilde:       mov     al,1               ; xlate to <ESC> "make" code
              jmp     OrigHandler
bTilde:       mov     al,81h             ; xlate to <ESC> "break" code
              jmp     OrigHandler
Intrpt        endp



Install       proc    near
              mov     dx,offset Msg      ; display copyright/header message
              mov     ah,9
              int     21h
              xor     ax,ax
              mov     es,ax
              and     byte ptr es:[0417h],0DFh ; turn off NumLock
              mov     es,ds:[002Ch]
              mov     ah,49h             ; free up our copy of the environment
              int     21h
              mov     ax,3515h           ; get vector for INT 15h
              int     21h
              mov     VOFS,bx            ; save it away
              mov     VSEG,es            ; (self-modifying code)
              mov     dx,offset Intrpt
              mov     ax,2515h           ; install our keyboard preprocessor
              int     21h
              mov     dx,ResLength       ; size of our interrupt handler
              test    dl,0Fh             ; see if it's on a paragraph boundary
              sahf                       ; save results
              mov     cl,4
              shr     dx,cl              ; convert bytes to paragraphs
              lahf                       ; paragraph-aligned?
              jz      GoTSR              ;   yes, we're done
              inc     dx                 ; round up to next paragraph
GoTSR:        mov     ax,3100h           ; terminate and stay resident
              int     21h
Install       endp

Msg db "Copyright (c) 1988  Thomas G. Hanlin III",13,10
    db 'FIX101KY: remap 101-key "enhanced" keyboard'
    db 13,10,"$"

Cseg          ends
              end            Main
