{==============================================================}
{                         SCANCODE.PAS                         }
{                    By Pat Anderson, Sysop                    }
{          Pascal Alley, Fidonet 343/52, (206) 222-6224        }
{                                                              }
{ Turbo Pascal's ReadKey shows ASCII codes placed in the key-  }
{ board buffer by the BIOS keyboard interrupt handler, Int $09.}
{ The keyboard actually generates two scan codes, a "make" and }
{ a "break" code for each press and release of a key.  This    }
{ program displays the codes the keyboard actually generates.  }
{ Highly recommended: Ohlsen & Stoker, Turbo Pascal Advanced   }
{ Techniques.  Writing your own keyboard interrupt service     }
{ routines opens the way to "event driven" programs by simply  }
{ setting a boolean variable in the keyboard ISR and checking  }
{ it in main program - much faster than polling for key presses}
{ with ReadKey.  It also can let you pop up a menu on the [5]  }
{ key on the numeric keypad, or the ScrollLock key - keys that }
{ the BIOS keyboard ISR and hence ReadKey don't recognize.     }
{ These are definitely tools that Pascal programmers should    }
{ have.  See sample KEYPAD_5.PAS unit for example.  This       }
{ could be expanded to a general purpose unit quite easily.    }
{ Enjoy!                                                       }
{                                                              }
{==============================================================}

program scancode;

uses
  Crt,
  Dos;

var
  P, NewP, OldP : byte;
  PChanged : boolean;
  SaveInt09, OldExitProc : pointer;
  IsMake : boolean;

{$F+}
procedure NewInt09; interrupt;             { replace BIOS keyboard handler }
  begin
    P := Port [$60];                       { Read the value on the }
                                           { keyboard port }
    Inline ($E4/$61/$8A/$E0/$0C/$80/       { clean up as BIOS would }
            $E6/$61/$86/$E0/$E6/$61/       { (from Ohlsen & Stoker, }
            $B0/$20/$E6/$20);              { TP Advanced Techniques) }
  end;

procedure MyExit;                          { restore BIOS handler on exit! }
  begin
    ExitProc := OldExitProc;
    SetIntVec (9, SaveInt09);
  end;
{$F-}

begin
  OldExitProc := ExitProc;                 { Install exit procedure to }
  ExitProc := @MyExit;                     { restore old Int09 on exit }
  GetIntVec (9, SaveInt09);                { Save old Int09 }
  SetIntVec (9, @NewInt09);                { Install new Int09 }

  ClrScr;

  NewP := P;                                { get value on kbd port }
  OldP := NewP;                             { save it }
  Write ('Waiting for key press...');       { Some important info }
  Write ('Press Break to exit program.');
  IsMake := true;                           { first press is "make" code }

  repeat                                    { repeat forever }
    NewP := P;                              { get value on port again }

    if P = 70 then                          { Break to terminate! }
      Halt;

    if (NewP <> OldP) and (NewP > 0) then   { see if it is different }
      PChanged := true                      { and set "changed" flag }
    else                                    { accordingly }
      PChanged := false;

    if (PChanged) then begin                { if the value has changed }
      GotoXY (1,1); ClrEOL;                 { show if "make" or "break" }
      if IsMake then
        Write ('MAKE code (key pressed)')
      else
        Write ('BREAK code (key release)');
      IsMake := not IsMake;                 { next code will be opposite! }

      GotoXY (1,2); ClrEOL;                 { display the code }
      Write (NewP);
      OldP := NewP;                         { and save the value for next }
    end;                                    { comparison }
  until 1 = 0;
end.
