
{$I-}   {I/O checking must be off.}

program frmtmail;

uses dos;

const
  initstring    = ^[+'E'+^[+'&a4L';             { initialises printer }
  boldstring    = ^[ + '(s7B';                  { turns bold print on }
  indentstring  = ^[ + '&a14C';                 { indents for header info }
  unboldstring  = ^[ + '(s0B';                  { turns bold print off }
  inheader      : boolean = true;
  writethisline : boolean = false;

var

  infilename    : string;                             {input file name}
  outfilename   : string;                             {output file name}
  line          : string;                             {current line}
  inputfile     : text;
  outputfile    : text;


function match(string1,string2:string):boolean;

{case insensitive check that first string matches start of second string.
 note that match('ab','abc') = true
           match('abc','ab') = false }

  var i:integer;

  begin
    for i:=1 to length(string1) do
      if (i>length(string2)) or (upcase(string1[i])<>upcase(string2[i])) then
        begin
          match:=false;
          exit;
        end;
    match:=true;
  end;


function beautified(line:string):string;

var
  i : word;
  output : string;

begin
  i := 1;
  output := '';
  while (i<=length(line)) and not (line[i] in [' ',^I]) do
    begin
      output := output + line[i];
      inc(i);
    end;
  while (i<=length(line)) and (line[i] in [' ',^I]) do inc(i);
  output := output + boldstring + indentstring;
  while i<=length(line) do
    begin
      output := output + line[i];
      inc(i);
    end;
  beautified := output + unboldstring;
end;


procedure writeout(line:string);

var i : word;

{write a line to output file and check the result}

  begin
    i := 1;
    while i <= length(line) do
      case line[i] of
        ^A : delete(line,i,1);
        ^B : delete(line,i,1);
        ^C : delete(line,i,2);
      else
        if line[i] > char(127) then line[i] := '*';
        inc(i);
      end;
    writeln(outputfile,line);
    if IOresult<>0 then
      begin
        writeln('Can''t write to file '+outfilename+'.');
        halt(5);
      end;
  end;


begin {program}

  if paramcount<2 then
    begin
      writeln('FRMTMAIL: prepares an email message for an HP Laserjet printer - 28 June 1995.');
      writeln('  by Peter Summers <peter@cardiology.medrmh.unimelb.edu.au>');
      writeln;
      writeln('SYNTAX:  FRMTMAIL <inputfile> <outputfile>.');
      halt(1);
    end;

  infilename:=paramstr(1);
  assign(inputfile, infilename);             {open input file}
  reset(inputfile);
  if IOresult<>0 then
    begin
      writeln('Can''t open for reading file '+infilename+'.');
      halt(2);
    end;

  outfilename := paramstr(2);

  assign(outputfile, outfilename);
  rewrite(outputfile);
  write(outputfile,initstring);
  if IOresult=0 then
    write('Formatting '+infilename+' to '+outfilename+'.')
  else
    begin
      writeln('Can''t open for writing file '+outfilename+'.');
      halt(3);
    end;

  while not eof(inputfile) do
    begin
      readln(inputfile,line);               {read a line from input file}
      if IOresult=0 then
        write('.')
      else
        begin
          writeln('Can''t read from file '+infilename+'.');
          halt(4);
        end;

      if line='' then inheader := false;

      if not inheader then
        writeout(line)
      else
        begin
          if match('From:',line) or match('To:',line)
            or match('Subject:',line) or match('Date:',line)
            or match('CC:',line) or match('BCC:',line)
            or match('Resent-from:',line) or match('Resent-to:',line)
            or match('Resent-date:',line)
            or match('Organisation:',line) or match('Priority:',line) then
              writethisline:=true
          else
            if not (match(' ',line) or match(^I,line)) then
              writethisline:=false;
          if writethisline then writeout(beautified(line));
        end;
    end;                                            {end of main loop}

  writeln;
  close(inputfile);
  close(outputfile);
end.
