/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       IPBM.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.00
**     CREATION DATE:       1990/2/1
**
** DESCRIPTION: Supplies interface for the user of IP Buffer Management
**
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   BUFM.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/BUFM/VCS/BUFM.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 10:16:50   etstjan
**              Initial revision.
*************************************************************************/

#ifdef DEBUGBM
#  define IPBufFree(x) IPBufFree2(x, __LINE__, __FILE__)
#else
#  define IPBufFree(x) IPBufFree1(x)
#endif

#define  BM_SIZE_T      unsigned int   /* type of data space size */

/***************************************************************************/
/* Buffer management return codes */

#define NO_ERR            0     /* no error */  
#define GET_ERR          -1     /* error in memory request */
#define IACT_ERR         -2     /* Buffers not closed yet */
#define IMEM_ERR         -3     /* memory allocation error */
#define FREE_ERR         -4     /* block not recognized as an BufMan block */
#define MAGERR           -5     /* a magic error has been found */
#define TOTERR           -6     /* the total size of the buffer ain't correct */
#define CYCERR           -7     /* the order of the linked list is disturbed */

/* prototypes for buffer management */
int           BufInit (void);
int           IPBufInit(unsigned int NrBuffers, BM_SIZE_T BufSize);
void          IPBufEnd(void);
void          *IPBufGet(BM_SIZE_T Size);
int           IPBufFree1(void *Point);
int           IPBufFree2(void *Point, int FileLine, char *FileName);

/* prototypes for buffer management check */
int           IPBMCheck(void);
unsigned long FreeMem(void);
