/* [DOC] File ***************************************************************
** POWER demo source code
** CSE - Computer Systems Expertise
** G. Gezellelaan 49
** 2624 KX  Delft
** The Netherlands
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>                         /* for exit() */
#include <string.h>                         /* for str*() */
#include <ctype.h>                          /* for toupper() */
#include "power3.h"                         /* for pw_*() */

#define MAX_FILES   100

static char *MainMenuTable[] = {
    "Window modes",
    "Open 100 windows",
    "Put 10000 chars",
    "File select",
    "Hexdump",
    "Toggle is OFF",
    NULL
};
static PWWIN *pSourceMenuWin;
static int FileElement;
static char FileName[12+1];

static void SourceMenu(void)
{
    pSourceMenuWin = pw_open(2, pw_ncol()-44-2, 20, 44, "Menu source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);
    pw_puts(pSourceMenuWin,
        " static char *MainMenuTable[] = {\n"
        "    \"Window modes\",\n"
        "       ...\n"
        "    NULL\n"
        " };\n\n"
        " static int ProcMainMenu(int element) {\n"
        "    switch (element) {\n"
        "    case 0: DemoOpenWindows(); break;\n"
        "       ...\n"
        "    }\n"
        "    return element;\n"
        " }\n\n"
        " int main(int argc, char **argv) {\n"
        "       ...\n"
        "    @hpw_menu@p(3,4,PWC_AUTO,PWC_AUTO, \"Main\",\n"
        "       MainMenuTable, ProcMainMenu, NULL);\n"
        "       ...\n"
        " }");
    pw_show(pSourceMenuWin);
}

static void DemoWindowModes(void)
{
    PWWIN *pWin1, *pWin2, *pWin3;
    PWWIN *pSourceWin = pw_open(pw_nrow()-10, PWC_CENTER, 8, 78, "Source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);

    pw_puts(pSourceWin,
        " pWin1 = pw_open(PWC_TOP,    pw_ncol()-12, 1, 7, \"Top\",@hPWM_DEFAULT@p,PWW_DATA);\n"
        " pWin2 = pw_open(PWC_CENTER, PWC_CENTER,   3, 9, \"Center\",\n"
        "    @hPWM_HIDE | PWM_NOBORDER@p, PWW_ERROR);         // invisible & borderless\n"
        " pw_show(pWin2);                                 // make visible\n"
        " pWin3 = pw_open(PWC_BOTTOM, pw_ncol()-12, 1, 7, \"Bottom\",\n"
        "    @hPWM_NOHEADER | PWM_NOSHADE@p, PWW_HELP);       // headerless & shadeless\n"
        " pw_getkey();\n"
        " pw_close(pWin3); pw_close(pWin2); pw_close(pWin1);");
    pw_show(pSourceWin);

    pWin1 = pw_open(PWC_TOP, pw_ncol()-12, 1, 7, "Top", PWM_DEFAULT, PWW_DATA);
    pw_puts(pWin1, " Win 1");
    pWin2 = pw_open(PWC_CENTER, PWC_CENTER, 3, 9, "Center", PWM_HIDE | PWM_NOBORDER, PWW_ERROR);
    pw_puts(pWin2, "\n  Win 2");
    pw_show(pWin2);
    pWin3 = pw_open(PWC_BOTTOM, pw_ncol()-12, 1, 7, "Bottom", PWM_NOHEADER | PWM_NOSHADE, PWW_HELP);
    pw_puts(pWin3, " Win 3");
    pw_keyinfo(pWin3, NULL, NULL);
    pw_getkey();
    pw_close(pWin3); pw_close(pWin2); pw_close(pWin1);
    pw_close(pSourceWin);
}

static void DemoOpenWindows(void)
{
    PWWIN *pSourceWin = pw_open(pw_nrow()-11, 2, 9, 43, "Source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);
    PWWIN *pWin;
    int i;
    int srow, scol, nrow, ncol;

    pw_puts(pSourceWin,
        " PWWIN *pWin;\n"
        " int i;\n\n"
        " for (i=0; i<@h100@p; i++) {\n"
        "    pWin = @hpw_open@p(..random coordinates..,\n"
        "       \"W\", PWM_DEFAULT, ..random type..);\n"
        "    @hpw_close@p(pWin)\n"
        " }\n"
        " pw_getkey();");
    pw_block(pSourceWin, 0, 39, 1, 3, PWT_HIGHLIGHT);
    pw_show(pSourceWin);

    srow=scol=nrow=ncol=1;
    for (i=0; i<100; i++) {
        pWin = pw_open(srow, scol, nrow, ncol, "W", PWM_DEFAULT, rand() % 9);
        pw_printfat(pSourceWin, 0, 39, "%3d", i+1);
        srow = 1+(rand() % (pw_nrow()-4));
        scol = 1+(rand() % (pw_ncol()-4));
        nrow = rand() % (pw_nrow()-1-srow);
        ncol = rand() % (pw_ncol()-1-scol);
        pw_close(pWin);
    }
    pw_putsat(pSourceWin, 0, 39, "   ");
    pw_keyinfo(pSourceWin, NULL, NULL);
    pw_getkey();
    pw_close(pSourceWin);
}

static void DemoPut10000Chars(void)
{
    register int i;
    PWWIN *pSourceWin = pw_open(pw_nrow()-12, 2, 10, 36, "Source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);
    PWWIN *pWin = pw_open(PWC_CENTER, pw_ncol()-39, 19, 36, "Put", PWM_NOHEADER, PWW_DATA);;

    pw_puts(pSourceWin,
        " PWWIN *pWin;\n"
        " int i;\n\n"
        " pWin = pw_open(...);\n"
        " pw_waiton();\n"
        " for (i=0; i<@h10000@p; i++)\n"
        "    @hpw_putc@p(pWin, 'a'+(rand()%26));\n"
        " pw_waitoff();\n"
        " pw_getkey();\n"
        " pw_close(pWin);");
    pw_show(pSourceWin);

    pw_keyinfo(pWin, NULL, NULL);
    pw_waiton();
    for (i=0; i<10000; i++) pw_putc(pWin, 'a'+(rand() % 26));
    pw_waitoff();
    pw_getkey();
    pw_close(pWin);
    pw_close(pSourceWin);
}

static void DemoFileSelect(void)
{
    PWWIN *pSourceWin = pw_open(pw_nrow()-9, PWC_CENTER, 7, 58, "Source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);

    pw_puts(pSourceWin,
        " #define MAX_FILES 100                  // max table size\n\n"
        " static int  FileElement;               // remember index\n"
        " static char FileName[12+1];            // return buffer\n\n"
        " @hpw_selectfile@p(3, PWC_CENTER, 9, MAX_FILES, &FileElement,\n"
        "    \"*.EXE\", FileName);");
    pw_show(pSourceWin);

    pw_selectfile(3, PWC_CENTER, 9, MAX_FILES, &FileElement, "*.EXE", FileName);
    pw_selectdir(3, PWC_CENTER, 9, MAX_FILES, &FileElement, "C:\*.", FileName);
    pw_close(pSourceWin);
}

static void DemoHexdump(void)
{
    PWWIN *pSourceWin = pw_open(2, pw_ncol()-45, 2, 43, "Source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);
    pw_puts(pSourceWin,
        " @hpw_hexdump@p(pw_nrow()-11, PWC_CENTER, 8,\n"
        "    MainMenuTable[0], 20*16);");
    pw_show(pSourceWin);

    pw_hexdump(pw_nrow()-11, PWC_CENTER, 8, (unsigned char far *)MainMenuTable[0], 20*16);
    pw_close(pSourceWin);
}

static void DemoToggle(int element)
{
    static int status;

    if (status) {
        strcpy(MainMenuTable[element]+10, "OFF");
        status = 0;
    } else {
        strcpy(MainMenuTable[element]+10, "ON");
        status = 1;
    }
}

static int ProcMainMenu(int element)
{
    if (element != 5) pw_hide(pSourceMenuWin);
    switch (element) {
    case 0: DemoWindowModes();   break;
    case 1: DemoOpenWindows();   break;
    case 2: DemoPut10000Chars(); break;
    case 3: DemoFileSelect();    break;
    case 4: DemoHexdump();       break;
    case 5: DemoToggle(element); return PWA_UPDATELINE;
    }
    if (element != 5) pw_show(pSourceMenuWin);
    return element;
}

static void DisplayWelcome(void)
{
    PWWIN *pSourceWin = pw_open(pw_nrow()-10, pw_ncol()-35-2, 8, 35, "Source", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_NORMAL);
    PWWIN *pCSEWin = pw_open(pw_nrow()-10, 2, 5, 32, "CSE", PWM_HIDE | PWM_NOBORDER | PWM_NOSHADE, PWW_ERROR);
    PWWIN *pWin    = pw_open(4, PWC_CENTER, 8, 56, "Welcome", PWM_HIDE | PWM_NOHEADER, PWW_HELP);
    pw_puts(pSourceWin,
        " int main(int argc, char **argv) {\n"
        "    @hpw_options@p(argc, argv);\n"
        "    @hpw_init@p(argv[0], 0);\n"
        "    @hpw_header@p(\"POWER v3.20 ...\");\n"
        "       ... program body ...\n"
        "    @hpw_quit@p();\n"
        "    return 0;\n"
        " }");
    pw_puts(pCSEWin,
        " CSE Computer Systems Expertise\n"
        "        G. Gezelleln 49\n"
        "        2624  KX  Delft\n"
        "        The Netherlands\n"
        "  E-Mail: HLThio@@et.tudelft.nl");
    pw_puts(pWin,
        "   Welcome to the @hPOWER v3.20@p  demonstration program.\n\n"
        "   POWER is a text based window library, named after:\n"
        "    @hProgrammer Oriented Window Environment Routines@p.\n\n"
        " Demo source code  is displayed in a borderless window.\n"
        " This program can be terminated by <Esc> or <Shift-F3>.\n"
        "      Relax, sit back and enjoy the demonstration.");
    pw_show(pSourceWin);
    pw_show(pCSEWin);
    pw_show(pWin);
    pw_keyinfo(pWin, NULL, NULL);
    if (pw_getkey() == PWK_ESC) pw_exit(0);
    pw_close(pWin);
    pw_close(pCSEWin);
    pw_close(pSourceWin);
}

static void ArgError(char *progname)
{
    fprintf(stderr, "%s: Argument error.\n", progname);
    fprintf(stderr, "Usage: %s [/MDA] [/MONO] [/COLOR]\n", progname);
}

static int ExitFunc(void)
{
    if (pw_question("Do you relly want to quit? [N/y]", "NY", PWW_ERROR) == 'Y')
        return PWR_QUIT;                        // quit program
    return PWR_CONTINUE;                        // continue program
}

int main(int argc, char **argv)
{
    int narg;

    narg = pw_options(argc, argv);              // parse POWER options
    if (narg != 1) { ArgError(argv[0]); return -1; }
    pw_init(argv[0], ExitFunc);                 // ExitFunc for <Shift-F3>.
    pw_header("POWER v3.20 demonstration program - CSE Computer Systems Expertise");
    DisplayWelcome();
    SourceMenu();
    pw_menu(3, 4, PWC_AUTO, PWC_AUTO, "Main menu", MainMenuTable, ProcMainMenu, NULL);
    pw_close(pSourceMenuWin);
    pw_quit();
    return 0;
}
