#define	LPDPORT	515		/* TCP */

#define	LOGPORT	514		/* UDP */

#define	LOG_TAG	"<54>"		/* LOG_LPR + LOG_INFO */

#define	JDPORT	9100		/* direct to printer */

enum connstate
{
	INIT,
	WAITING,
	QUEUENAME,
	RECVJOB,
	CONTROLINFO,
	CONTROL,
	DATAINFO,
	DATA,
	PRINTING,
	NAKANDCLOSE,
	CLOSING,
	CLOSING_NOSTATS,
	ABORT
};

#define	MAXTURNS	8			/* for initial network reads */
#define	PRINT_CHUNK	2048			/* bytes to print at a time */

struct conn_info
{
	enum connstate	state;			/* of a connection */
	int		nturns;			/* schedule slices */
	int		controlfirst;		/* control data first? */
	int		printer;		/* 0 to 2 */
	tcp_Socket	sock;			/* connection */
	long		bytelen;		/* of current file */
	char far	*buffer;		/* for data */
	char far	*bufip;			/* input point */
	char far	*bufop;			/* output point */
	char		jobname[32];
	char		username[32];
	char		hostname[32];
	time_t		starttime;
	long		joblen;
};

/* kb per buffer. Don't increase this beyond 63. Bad things happen if you do.
   It has to do with far pointers and wraparound of the offset part. */
#define	BUFFER_SIZE	63U

extern unsigned int	buffer_size;

#define	reset_ptrs(c)	(c)->bufip = (c)->bufop = (c)->buffer
#define	buffer_room(c)	((c)->buffer - (c)->bufip + buffer_size)
#define	queue_empty(c)	((c)->bufip == (c)->bufop)
#define	queue_room(c)	((c)->bufip < (c)->bufop ? \
				(c)->bufop - (c)->bufip - 1 : \
				buffer_size - 1 - ((c)->bufip - (c)->bufop))

enum pstate
{
	NONESUCH = 0,
	DISABLED,
	FREE,
	BUSY,
};

struct lpt_info
{
	enum pstate	avail;			/* active? */
	int		status;			/* from last biosprint */
	int		hwaddr;			/* port address, != 0 == use */
};

#define	bios_printer_init(i)	biosprint(1,0,i)
#define	bios_printer_status(i)	biosprint(2,0,i)
#define	bios_printer_outch(i,c)	biosprint(0,c,i)

/* printer status bits */
#define	P_TIMEOUT	0x01
#define	P_IOERROR	0x08
#define	P_SELECTED	0x10
#define	P_NOPAPER	0x20
#define	P_ACK		0x40
#define	P_IDLE		0x80

#define	P_CHANGES	(P_TIMEOUT|P_IOERROR|P_SELECTED|P_NOPAPER)
#define	P_READY		(P_SELECTED|P_IDLE)

/* key definitions */
#define	CF1	0x5e				/* CTRL-F1 */
#define	CF2	0x5f
#define	CF3	0x60
