#define	encnyb(c)	((c)+'A')

/* opcode field */

enum dnsopcode { op_query, op_reg = 5, op_release, op_wack, op_refresh };

/* nm_flags field */

#define	FLAG_AA		(1<<6)			/* authoritative answer */
#define	FLAG_TC		(1<<5)			/* truncation */
#define	FLAG_RD		(1<<4)			/* recursion desired */
#define	FLAG_RA		(1<<3)			/* recursion available */
#define	FLAG_B		1			/* broadcast */

/* question_type */

#define	QT_NB		0x20
#define	QT_NBSTAT	0x21

/* question_class */

#define	QC_IN		1			/* Internet class */

/* rr_type */

#define	RT_A		0x1
#define	RT_NS		0x2
#define	RT_NULL		0xA
#define	RT_NB		0x20
#define	RT_NBSTAT	0x21

/* rr_class */

#define	RC_IN		1			/* Internet class */

/* nbflags */

#define	NBF_G		(1<<15)			/* group name */
#define	NBF_BNODE	(0<<13)			/* broadcast node */
#define	NBF_PNODE	(1<<13)			/* point-point node */
#define	NBF_MNODE	(2<<13)			/* mixed node */

struct dnsheader
{
	unsigned short	id;			/* transaction id */
	unsigned short	flags;			/* opcode, nm_flags, etc */
	unsigned short	qdcount;		/* # questions */
	unsigned short	ancount;		/* # answer RRs */
	unsigned short	nscount;		/* # authority RRs */
	unsigned short	adcount;		/* # additional RRs */
};

struct qdtail
{
	unsigned short	qdtype;			/* question type */
	unsigned short	qdclass;		/* question class */
};

struct rrtail
{
	unsigned short	rrtype;			/* resource record type */
	unsigned short	rrclass;		/* resource record class */
	unsigned long	ttl;			/* time to live in seconds */
	unsigned short	rdlength;		/* length(nbflags+ipaddr) = 6 */
};

#define	RR_SIZE		10			/* avoid padding with sizeof */

struct addr_entry
{
	unsigned short	pad;			/* to align nb_address */
	unsigned short	nb_flags;
	unsigned long	nb_address;
};

#define	ADDR_ENTRY_LEN	6

extern void		init_ns(void);
extern void		ns_request(void);
