#include	<string.h>
#include	<time.h>
#include	<ctype.h>

#include	"util.h"

char *ptime()
{
	time_t	t = time(0);
	char	*p = ctime(&t);
	p[24] = '\0';
	return (p);
}

/* like strncpy but guarantee null byte terminator */
char *Strncpy(char *dst, const char *src, int n)
{
	char		*r;

	r = strncpy(dst, src, n);
	dst[n-1] = '\0';
	return (r);
}

long get_smb_length(unsigned char *s)
{
	return (s[3] | s[2] << 8 | (s[1] & 0x1) << 16);
}

void set_smb_length(long length, unsigned char *s)
{
	s[1] = (length & 0x10000) >> 16;
	s[2] = (length & 0xFF00) >> 8;
	s[3] = length & 0xFF;
}

int uc2tohs(unsigned char *s)
{
	return (s[0] | s[1] << 8);
}

void hstouc2(unsigned short w, unsigned char *s)
{
	s[1] = (w & 0xFF00) >> 8;
	s[0] = w & 0xFF;
}

void hltouc4(unsigned long l, unsigned char *s)
{
	s[3] = (l & 0xFF000000) >> 24;
	s[2] = (l & 0xFF0000) >> 16;
	s[1] = (l & 0xFF00) >> 8;
	s[0] = l & 0xFF;
}

/*
 * Point to resource part of path: \\machine\resource
 */
char *get_resource(char *path)
{
	char		*p;

	if (strncmp(path, "\\\\", 2) != 0)
		return (path);
	if ((p = strchr(path+2, '\\')) == 0)
		return (path);
	return (p+1);
}

/*
 * Following routines taken from Andrew Tridgell's Samba software
 */

/*
 * Convert Netbios encodng to ASCII
 */
int nbtoasc(char *in, char *out)
{
	int             len = (*in++) / 2;
	int		ret = len;

	*out = '\0';
	if (len > 30 || len <= 0)
		return (0);
	while (len--)
	{
		if (in[0] < 'A' || in[0] > 'P' || in[1] < 'A' || in[1] > 'P')
		{
			*out = '\0';
			return (0);
		}
		*out++ = ((in[0] - 'A') << 4) + (in[1] - 'A');
		in += 2;
	}
	*out = '\0';
	return (ret);
}

/*
 * Return the total storage length of a mangled name
 */
int nb_name_len(char *s)
{
	char           *s0 = s;
	unsigned char   c = *(unsigned char *) s;
	if ((c & 0xC0) == 0xC0)
		return (2);
	while (*s)
		s += (*s) + 1;
	return (s - s0 + 1);
}

/*
 * Remove trailing spaces from string
 */
void trim_space(char *name)
{
	char		*s = name;

	while (*s != '\0')
		++s;
	--s;
	while (isspace(*s) && s != name)
		--s;
	*++s = '\0';
}

/*
 * Convert ASCII to Netbios representation, assume >= 34 bytes in out
 */
int asctonb(char *in, char *out)
{
	int		i, c;

	*out++ = 0x20;		/* 32 bytes long */
	for (i = 16; i > 0; --i)
	{
		/* stop at end of name or at . */
		if ((c = *in) == '\0' || c == '.')
			c = ' ';
		else
			++in;
		*out++ = ((c >> 4) & 0xF) + 'A';
		*out++ = (c & 0xF) + 'A';
	}
	*out = '\0';		/* root label */
	return (34);
}

/*
 * Create a 16 bit dos packed date
 */
unsigned short make_dos_date(struct tm *t)
{
	unsigned short		ret = 0;
	ret = (((unsigned)(t->tm_mon + 1)) >> 3) | ((t->tm_year - 80) << 1);
	ret = ((ret & 0xFF) << 8) | (t->tm_mday | (((t->tm_mon + 1) & 0x7) << 5));
	return (ret);
}

/*
 * Create a 16 bit dos packed time
 */
unsigned short make_dos_time(struct tm *t)
{
	unsigned short		ret = 0;
	ret = ((((unsigned)t->tm_min >> 3) & 0x7) | (((unsigned)t->tm_hour) << 3));
	ret = ((ret & 0xFF) << 8) | ((t->tm_sec / 2) | ((t->tm_min & 0x7) << 5));
	return (ret);
}
