
//	NWADDR.C
//	Netware Address - Asks the IPX for the hardware address of our card
//		returns a 0 if ipx is not loaded.

#include <dos.h>
#include <stdio.h>
#include <stdlib.h>

int		get_ipx_spx_pointer (void) ;// gets ipx address
void far	(*ipx_spx)(void) ;	    // far pointer to ipx functions
struct reply_buffer {
	unsigned char	network_number[4] ;
	unsigned char	node_address[6] ;
} myRB ;

void NW_getaddr( struct reply_buffer *vRB ){

	_BX = 0x09 ;
	_ES = FP_SEG (vRB) ;
	_SI = FP_OFF (vRB) ;
	ipx_spx () ;
}


int check_nwaddr( char *s )
{
  int 	i ;
  char Hex[] = "0123456789ABCDEF";        // Hex conversion array


	if (get_ipx_spx_pointer()) { //IPX Driver is not installed!
		strcpy("NONE:",s);
		return 0;
	}


	NW_getaddr( &myRB );

	for (i=0; i<6; i++){
		*s++ = Hex[( myRB.node_address[i] & 0xf0 ) >> 4 ];
		*s++ = Hex[ myRB.node_address[i] & 0x0f ];
		if (i < 5) *s++ = ':';
	}

	return (1) ;
}


int	get_ipx_spx_pointer (void)
{
union REGS     regs ;
struct SREGS    sregs ;

	regs.x.ax = 0x7a00 ;
	int86x (0x2f, &regs, &regs, &sregs) ;
	if (regs.h.al != 0xff)
		return -1 ;

	ipx_spx = (void (far *)()) MK_FP (sregs.es, regs.x.di) ;
	return 0 ;
}