/********************************************************************
**                                                                 **
**  UserPref.exe - Define user environment variables via the       **
**                address of the network card.                     **
**                                                                 **
**  Version 1.0; 3/25/91 millsm                                    **
**      - First version.  Looks up hardware addresses for WD cards **
**      - Reads in environment variable from text file and sets    **
**        the parent environment variable table.                   **
**  Version 1.01; 3/29/91 millsm                                   **
**      - Added a GLOBAL address that contains settings for ALL    **
**        addresses.                                               **
**  Version 1.02; 6/10/91 millsm                                   **
**      - Remove environment variable with the same name.          **
**      - Add a DOS command in the parsing.                        **
**  Version 1.02a; 8/26/91 millsm                                  **
**      - Wouldn't you know it, there already is a program called  **
**        userdef in the Novell stuff. Changed name to userpref    **
**  Version 1.03; 6/26/92 millsm				   **
**	- Add WIPE command to erase all environment variables	   **
**	- Check for Netware and get hardware address from SPX      **
**	- Add /i switch for info display only			   **
**	- Add environment variables inside the parsing		   **
**	- Split up files and made a project file		   **
**								   **
*********************************************************************
** If you have any suggestions, or make any changes to this        **
** source please EMAIL me at millsm@csus.edu                       **
*********************************************************************
** Written with Borland C++                                        **
********************************************************************/

#include <stdio.h>
#include <dos.h>

typedef char byte;
typedef short int word;

typedef struct {                        // This structure describes
	word    psp_int20;              // some of the more interesting
	word    psp_top;                // parts of the PSP
	byte    psp_reserv1[6];
	word    psp_termIP;
	word    psp_termCS;
	word    psp_ctlbrkIP;
	word    psp_ctlbrkCS;
	word    psp_critIP;
	word    psp_critCS;
	word    psp_parentpsp;
	byte    psp_reserv2[20];
	word    psp_environ;
	byte    psp_reserv3[34];
	word    psp_dos;
	byte    psp_reserv4[10];
	byte    psp_fcb1[16];
	byte    psp_fcb2[20];
	byte    psp_parmlen;
	byte    psp_parms[127];
	} psp, far *pspPtr;


char ProgTitle[]="UserPref Ver 1.03 - 6/28/92 - Matthew Mills";

char HWADDR[20];                        // Hardware address string

char instring[255];                     // Input file string
char lookstring[255];			// Environment Lookup string
FILE *datFile;                          // File Handle to Definition File
int  verboseflag;                       // How noisy the output should be
int  infoonlyflag;			// We only want the NIC

void initialize( s )
char *s;
{
	datFile = fopen( s , "r" );
	if ( datFile == NULL ) {
		printf("Unable to open data file '%s'.\07\n", s );
		exit( 1 );
	}
}


char far *getParentEnv()
{
pspPtr temp;

	temp = MK_FP(_psp,0x00);
	temp =(pspPtr) MK_FP(temp->psp_parentpsp,0x00); // Offset to parents psp
	return((char far *) MK_FP(temp->psp_environ, 0x00)); // Offset to Environment address
}


void clearParentEnv()
{
char far *env;

	env = getParentEnv();		// Get Parent Environment space
	*env++ = 0;
	*env++ = 0;	// double null is the end of the table
}

char far *lookupEnv ( s )
char *s;
{
char far *env;
char *s1;

	env = getParentEnv();		// Get parent Environment space

	s1 = s;
	while( *env ) {
		if((*env == '=') && (*s1 == 0)) return( ++env ); // match
		if( *env != *s1 ) {  // not a match
			while( *env ++ ); // skip to next variable
			s1 = s;	// reset search pointer
		} else {
			env++; s1++;  // advance character
		}
	}
	return( env );	// no match ( env should be a null )
}

void setParentEnv( s )
char *s;
{
char far *env,far *e1,far *e2;
char *s1;

	env = getParentEnv();           // Get parent Environment space

	e1 = env;
	while( *e1 ) {
		e2 = e1;
		s1 = s;
		while( *e2 ){
			if( *e2 != *s1 ) {      // this is a unique variable
				while( *e1 ) *env++ = *e1++; // copy this var
				*env++ = 0;     // add the null
				e1++;           // skip passed the null
				break;          // end the comparison
			}
			if( *s1 == '=' ) {      // we matched a variable
				while( *e2++ ); // find the end of the var
				e1 = e2;        // skip the entire entry
				break;          // leave our comparison loop
			}
			s1++; e2++;             // set to the next characters
		}
	}  // We should be at the end of our environment space

	while( *s ) *env++ = *s++;      // copy passed string into space
	*env++ = 0; *env = 0;           // make it a double null
}



void parsefile()
{
char *s,*s1,c;
char far *es;
int  flag;              // reading flag
int  found = 0;         // Found HWADDR in table flag
int  parse = 0;         // Parse Flag


while(1) {
	s = instring;
	flag = 1;
	while( flag ) {
		c = fgetc( datFile );
		switch( c ){
		case '\n':			// End of line
			*s = 0;
			flag = 0;
			break;
		case EOF:                       // End of file
			return;
		case ' ':                       // Space
			if (flag == 2) *s++ = c;// remove leading white space
			break;
		case ';':                       // Comment flag
			while( fgetc( datFile ) != '\n' );
			*s = 0;
			flag = 0;
			break;
		case '%':                       // Lookup Environment variable
			s1 = lookstring;
			while(1){
				c = fgetc( datFile );
				if (( c == '%' ) || ( c == '\n') ||
				    ( c == EOF )) break;
				*s1++ = c;
				}
			if( c == '%' ) {
				if (s1 == lookstring) { // %% symbol
					*s++ = '%';
					break;
				}
				*s1 = 0;
				es = lookupEnv( lookstring );
				while ( *es ) *s++ = *es++;
				}
			break;
		default:
			*s++ = c;
			flag = 2;
		}
	}
	if (verboseflag == 2) printf("%s\n", instring);
	if (parse) {
		if ( instring[0] == ':' ) parse = 0;    // End of definition
							// is the start of the
							// next definition

		if ((verboseflag == 1) && parse) printf("%s\n",instring);

		if ( strncmp( &instring[0] , "set " , 4) == 0 ) {
			setParentEnv( &instring[4] );   // Set Env.Variable
		}
		if ( strncmp( &instring[0] , "dos " , 4) == 0 ) {
			system( &instring[4] );         // Issue Dos command
		}
		if ( strncmp( &instring[0] , "echo ", 5) == 0 ) {
			puts( &instring[5] );           // Echo a message
		}
		if ( strncmp( &instring[0] , "wipe ", 5) == 0 ) {
			clearParentEnv( );		// erase all Env. variables
		}
	}
	if (!parse) {
		if ( strncmp( &instring[0] , ":GLOBALS" , 8) == 0 ) parse = 1;
		if(( strncmp( &instring[0] , ":DEFAULT" , 8) == 0 ) && !(found))
			parse = 1;
		if ( strncmp( &instring[1] , HWADDR ,
			strlen( HWADDR) ) == 0 ){
			parse = 1;
			found = 1;
			}
	}
   }
}



void main( argc, argv )
int argc;
char *argv[];
{
int     i;
char    *s;
int     printhelp = 0;                 // Flag Modifiers
int     doitflag = 1;
char    datafilename[255] = "userpref.dat";  // Default data file

	verboseflag = 0;
	infoonlyflag = 0;
	i = 1;
	while( argc > i ){
		s = argv[i];
		if (s[0] == '/') {
			if ((s[1] == '?') || (s[1] == 'h')){
				printhelp = 1;
				doitflag = 0;
			}
			if (s[1] == 'i') infoonlyflag = 1;
			if (s[1] == 'v') verboseflag = 1;
			if (s[1] == 'd') verboseflag = 2; // debug level
		}
		else {
			strcpy( datafilename , s );   // passed data file
		}
		i++;
	}

if (doitflag) {
	if (verboseflag) printf("Using file:%s\n",&datafilename);
	if( !infoonlyflag) initialize( &datafilename );
	GetHWAddr(HWADDR);
	if (verboseflag || infoonlyflag ) printf("My Hardware address is %s\n",HWADDR);
	if (!infoonlyflag) parsefile();
	}
if (printhelp) {
	printf( "%s\n",ProgTitle);
	printf( "USERPREF <filename> </<h,?,v>>\n");
	printf( "       : filename = definition table path\n");
	printf( "                    defaults to USERPREF.DAT\n");
	printf( "       : /h,/?    = Help info (this screen)\n");
	printf( "       : /i       = Print Card Info Only\n");
	printf( "       : /v       = Verbose mode\n");
	}

	exit(0);
}
				
