/*
 *      JET PAK - HP DeskJet and LaserJet series printer utilities
 *
 *      JETMEAN module - field meaning utilities
 *
 *      Version 1.1 (Public Domain)
 */

/* system include files */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* application include files */
#include "jetfont.h"
#include "jetmean.h"

static char retstr[100];

char *header_format_meaning(header_format)
UNSIGNEDBYTE header_format;
{
    switch (header_format)
    {
    case    LJFONTFORMAT: return("LaserJet");
    case    DJFONTFORMAT: return("DeskJet Series");
    case   DJPFONTFORMAT: return("DeskJet PLUS");
    case DJ500FONTFORMAT: return("DeskJet 500");
    default             : sprintf(retstr, "Unrecognised [%u]", header_format);
                          return(retstr);
    }
}

char *font_type_meaning(font_type)
UNSIGNEDBYTE font_type;
{
    switch (font_type)
    {
    case FONT_TYPE_7BIT: return("7-bit");
    case FONT_TYPE_8BIT: return("8-bit");
    case  FONT_TYPE_IBM: return("PC-8");
    default            : sprintf(retstr, "Unrecognised [%u]", font_type);
                         return(retstr);
    }
}

char *orientation_meaning(orientation)
UNSIGNEDBYTE orientation;
{
    switch (orientation)
    {
    case   PORTRAIT: return("Portrait");
    case  LANDSCAPE: return("Landscape");
    default        : sprintf(retstr, "Unrecognised [%u]", orientation);
                     return(retstr);
    }
}

char *spacing_meaning(spacing)
BOOLEAN spacing;
{
    switch (spacing)
    {
    case         FIXED: return("Fixed");
    case  PROPORTIONAL: return("Proportional");
    default           : sprintf(retstr, "Unrecognised [%u]", spacing);
                        return(retstr);
    }
}

char *style_meaning(style)
UNSIGNEDINT style;
{
    switch (style)
    {
    case  0: return("Upright");
    case  1: return("Italics");
    case  2: return("Slant");
    default: sprintf(retstr, "Unrecognised [%u]", style);
             return(retstr);
    }
}

char *symbol_set_meaning(symbol_set)
UNSIGNEDINT symbol_set;
{

    sprintf(retstr, "%d%c ", symbol_set/32, '@'+symbol_set%32);

    switch (symbol_set)
    {
    case   1: strcat(retstr, "[HP Math-7]"); break;
    case   2: strcat(retstr, "[HP Line Draw]"); break;
    case   4: strcat(retstr, "[ISO 60: Norwegian version 1]"); break;
    case  36: strcat(retstr, "[ISO 61: Norwegian version 2]"); break;
    case   5: strcat(retstr, "[HP Roman Extensions]"); break;
    case  37: strcat(retstr, "[ISO 4: United Kingdom]"); break;
    case   6: strcat(retstr, "[ISO 25: French]"); break;
    case  38: strcat(retstr, "[ISO 69: French]"); break;
    case   7: strcat(retstr, "[HP German]"); break;
    case  39: strcat(retstr, "[ISO 21: German]"); break;
    case 263: strcat(retstr, "[HP Greek-8]"); break;
    case   9: strcat(retstr, "[ISO 15: Italian]"); break;
    case  11: strcat(retstr, "[ISO 14: JIS ASCII]"); break;
    case  75: strcat(retstr, "[ISO 57: Chinese]"); break;
    case 267: strcat(retstr, "[Kana-8]"); break;
    case  12: strcat(retstr, "[LineDraw]"); break;
    case  13: strcat(retstr, "[Math7]"); break;
    case  45: strcat(retstr, "[Technical-7]"); break;
    case 269: strcat(retstr, "[HP Math-8]"); break;
    case  14: strcat(retstr, "[ISO 100: ECMA-94 (Latin 1)]"); break;
    case  15: strcat(retstr, "[OCR A]"); break;
    case  47: strcat(retstr, "[OCR B]"); break;
    case  17: strcat(retstr, "[Math8a]"); break;
    case  49: strcat(retstr, "[Math8b]"); break;
    case  81: strcat(retstr, "[Pi Font A]"); break;
    case  19: strcat(retstr, "[ISO 11: Swedish]"); break;
    case  51: strcat(retstr, "[HP Spanish]"); break;
    case  83: strcat(retstr, "[ISO 17: Spanish]"); break;
    case 115: strcat(retstr, "[ISO 10: Spanish]"); break;
    case 147: strcat(retstr, "[ISO 16: Portuguese]"); break;
    case 179: strcat(retstr, "[ISO 84: Portuguese]"); break;
    case 211: strcat(retstr, "[ISO 85: Spanish]"); break;
    case  21: strcat(retstr, "[ISO 6: ASCII]"); break;
    case  53: strcat(retstr, "[HP Legal]"); break;
    case  85: strcat(retstr, "[ISO 2: Intl Reference Version]"); break;
    case 245: strcat(retstr, "[OEM-1]"); break;
    case 277: strcat(retstr, "[HP Roman-8]"); break;
    case 341: strcat(retstr, "[PC-8]"); break;
    case 373: strcat(retstr, "[PC-8 (D/N)]"); break;
    case 405: strcat(retstr, "[PC-850]"); break;
    case 501: strcat(retstr, "[HP Pi Font]"); break;
    default : strcat(retstr, "[Unrecognised]"); break;
    }

    return(retstr);
}

char *width_type_meaning(width_type)
SIGNEDBYTE width_type;
{
    switch (width_type)
    {
    case -2: return("Condensed");
    case -1: return("Semi-condensed");
    case  0: return("Normal");
    case  1: return("Semi-expanded");
    case  2: return("Expanded");
    default: sprintf(retstr, "Unrecognised [%d]", width_type);
             return(retstr);
    }
}

char *typeface_meaning(typeface)
UNSIGNEDINT typeface;
{
    switch (typeface)
    {
    case    0: return("Line Printer");
    case    1: return("Pica");
    case    2: return("Elite");
    case    3: return("Courier");
    case    4: return("Helvetica");
    case    5: return("Times Roman");
    case    6: return("Letter Gothic");
    case    7: return("Script");
    case    8: return("Prestige");
    case    9: return("Caslon");
    case   10: return("Orator");
    case   11: return("Presentations");
    case   12: return("Helvetica Condensed");
    case   13: return("Serifa");
    case   14: return("Futura");
    case   15: return("Palatino");
    case   16: return("ITC-Souvenir");
    case   17: return("Optima");
    case   18: return("Garamond");
    case   19: return("Cooper Black");
    case   20: return("Coronet Bold");
    case   21: return("Broadway");
    case   22: return("Bauer Bodoni Black Condensed");
    case   23: return("Century Schoolbook");
    case   24: return("University Roman");
    case   25: return("Helvetica Outline");
    case   26: return("Futura Condensed");
    case   27: return("ITC-Korinna");
    case   28: return("Arabic");
    case   29: return("Cloister Black");
    case   30: return("ITC-Galliard");
    case   31: return("Avant Garde");
    case   32: return("Brush");
    case   33: return("Blippo");
    case   34: return("Hobo");
    case   35: return("Windsor");
    case   36: return("Helvetica Compressed");
    case   37: return("Helvetica Extra Condensed");
    case   38: return("Peignot");
    case   39: return("Baskerville");
    case   40: return("Garamond Condensed");
    case   41: return("Trade Gothic");
    case   42: return("Goudy Old Style");
    case   43: return("Zapf-Chancery");
    case   44: return("Clarendon");
    case   45: return("Zapf-Dingbats");
    case   46: return("Cooper");
    case   47: return("ITC-Bookman");
    case   48: return("Stick");
    case   49: return("HP-GLSpline");
    case   50: return("HP-GLDrafting");
    case   51: return("Gill Sans");
    case   52: return("Univers");
    case   53: return("Bodini");
    case   54: return("Rockwell");
    case   55: return("Melior");
    case   56: return("ITC-Tiffany");
    case   57: return("ITC-Clearface");
    case   58: return("Amelia");
    case   59: return("Park Avenue");
    case   60: return("Handel Gothic");
    case   61: return("Dom Casual");
    case   62: return("ITC-Benguiat");
    case   63: return("ITC-Cheltenham");
    case   64: return("Century Expanded");
    case   65: return("Franklin Gothic");
    case   66: return("Franklin Expressed");
    case   67: return("Franklin Extra Condensed");
    case   68: return("Plantin");
    case   69: return("Trump Medieval");
    case   70: return("Futura Black");
    case   72: return("Chancelor");
    case   73: return("Broadway");
    case   75: return("Greek");
    case   85: return("Univers Condensed");
    case  100: return("Logo");
    case  103: return("Symbol");
    case  118: return("Coop");
    case  119: return("Abbey");
    case  120: return("Beget");
    case  121: return("Orna");
    case  122: return("Avanti");
    case  123: return("American Type");
    case  124: return("Basque");
    case  125: return("Gillies");
    case  126: return("Olivia");
    case  127: return("Galaxy");
    case  136: return("Bitstream Charter");
    case  200: return("Old English");
    case  230: return("Rockland");
    case 4101: return("CG Times Ver. 0");
    default  : sprintf(retstr, "Unrecognised [%u]", typeface);
               return(retstr);

    }
}

char *stroke_weight_meaning(stroke_weight)
SIGNEDBYTE stroke_weight;
{
    switch (stroke_weight)
    {
    case -7: return("Thin");
    case -6:
    case -5:
    case -4: return("Thin to Light");
    case -3: return("Light");
    case -2:
    case -1: return("Light to Medium");
    case  0: return("Medium");
    case  1:
    case  2: return("Medium to Bold");
    case  3: return("Bold");
    case  4:
    case  5:
    case  6: return("Bold to Thick");
    case  7: return("Thick");
    default: sprintf(retstr, "Unrecognised [%d]", stroke_weight);
             return(retstr);
    }
}

char *serif_style_meaning(serif_style)
UNSIGNEDBYTE serif_style;
{
    switch (serif_style)
    {
    case  0: return("Sans Serif Square");
    case  1: return("Sans Serif Round");
    case  2: return("Serif Line");
    case  3: return("Serif Triangle");
    case  4: return("Serif Swath");
    case  5: return("Serif Block");
    case  6: return("Serif Bracket");
    case  7: return("Rounded Bracket");
    case  8: return("Flair Stroke");
    default: sprintf(retstr, "Unrecognised [%u]", serif_style);
             return(retstr);
    }
}

char *quality_meaning(quality)
UNSIGNEDBYTE quality;
{
    switch (quality)
    {
    case  0: return("Data Processing (Draft)");
    case  1: return("Near Letter Quality");
    case  2: return("Letter Quality");
    default: sprintf(retstr, "Unrecognised [%u]", quality);
             return(retstr);
    }
}

char *placement_meaning(placement)
SIGNEDBYTE placement;
{
    switch (placement)
    {
    case -1: return("Superior (superscript)");
    case  0: return("Normal");
    case  1: return("Inferior (subscript)");
    default: sprintf(retstr, "Unrecognised [%d]", placement);
             return(retstr);
    }
}

char *char_format_meaning(char_format)
UNSIGNEDBYTE char_format;
{
    switch (char_format)
    {
    case    LJCHARFORMAT: return("LJ");
    case    DJCHARFORMAT: return("DJ");
    case   DJPCHARFORMAT: return("DJ+");
    case DJ500CHARFORMAT: return("DJ500");
    default             : return("?");
    }
}

char *char_type_meaning(char_type)
UNSIGNEDBYTE char_type;
{
    switch (char_type)
    {
    case CHAR_TYPE_NORMAL: return("SP");
    case  CHAR_TYPE_PASS1: return("MP 1");
    case  CHAR_TYPE_PASS2: return("MP 2");
    case  CHAR_TYPE_PASS3: return("MP 3");
    case  CHAR_TYPE_PASS4: return("MP 4");
    default              : return("?");
    }
}

char *boolean_meaning(which)
BOOLEAN which;
{
    switch (which)
    {
    case  0: return("No");
    case  1: return("Yes");
    default: sprintf(retstr, "Unrecognised [%u]", which);
             return(retstr);
    }
}
