;adjectiv.lex  9-May-91
;INCLUDE file for english.lex

;Copyright (C) 1991, Summer Institute of Linguistics, Inc.
;All rights reserved
;See ENGLEX.DOC for fair use policy.

;edit history
;18-Nov-91	version 0.9
;26-Nov-91	version 1.0

;The ADJ lexicon may contain words that can also be 
;adverbs without +ly. Their gloss should be changed to AJ/AV.

;File Contents
;LEXICON ADJ
;  irregular adjectives
;  regular adjectives
;    color terms

LEXICON ADJ
;irregular adjectives (see also minor.lex)
`good	AJ	"AJ/AV"
`better	AJ	"AJ/AV(`good/`well).CMP"
`best	AJ	"AJ/AV(`good/`well).SPR"
`bad	AJ	"AJ/AV"
`worse	AJ	"AJ/AV(`bad).CMP"
`worst	AJ	"AJ/AV(`bad).SPR"
`elder	AJ-to-N	"AJ.CMP"
`eldest	AJ	"AJ.SPR"
`far	AJ	"AJ/AV"
`farther	AJ	"AJ/AV(`far).CMP"
`farthest	AJ	"AJ/AV(`far).SPR"
`further	AJ	"AJ/AV(`far).CMP"
`furthest	AJ	"AJ/AV(`far).SPR"

`lesser	AJ	"AJ"

;regular adjectives

;color terms
`amber	AJ-to-N	"AJ"
`aqua	AJ-to-N	"AJ"
`auburn	AJ-to-N	"AJ"
`azure	AJ-to-N	"AJ"
`beige	AJ-to-N	"AJ"
`black	AJ-to-N	"AJ"
`blond	AJ-to-N	"AJ"
`blonde	AJ-to-N	"AJ"
`blue	AJ-to-N	"AJ"
`brown	AJ-to-N-V	"AJ"
char`treuse	AJ-to-N	"AJ"
`crimson	AJ-to-N-V	"AJ"
`fuchia	AJ-to-N	"AJ"
`gray	AJ-to-N-V	"AJ"
`green	AJ-to-N	"AJ"
`grey	AJ-to-N-V	"AJ"
`lavender	AJ-to-N	"AJ"
ma`genta	AJ-to-N	"AJ"
`mauve	AJ-to-N	"AJ"
`orange	AJ-to-N	"AJ"
`pink	AJ-to-N	"AJ"
`puce	AJ-to-N	"AJ"
`purple	AJ-to-N	"AJ"
`red	AJ-to-N	"AJ"
`scarlet	AJ-to-N	"AJ"
`sepia	AJ-to-N	"AJ"
`turquoise	AJ-to-N	"AJ"
`umber	AJ-to-N	"AJ"
ver`milion	AJ-to-N	"AJ"
`white	AJ-to-N	"AJ"
`yellow	AJ-to-N-V	"AJ"

ab`dominal	AJ	"N(`abdomen)+AJR17"
a`bed	AJ	"AJR1+N(`bed)"
a`berrant	AJ	"AJ"
a`beyant	AJ	"AJ"
`abject	AJ	"AJ"
`ablative	AJ-to-N	"AJ"
a`blaze	AJ	"AJR1+V(`blaze)"
`able	AJ	"AJ"
ab`normal	AJ	"NEG5+N(`norm)+AJR17"
a`boil	AJ	"AJR1+V(`boil)"
a`bominable	AJ	"AJ"
a`boveground	AJ	"AJ"
a`bovementioned	AJ	"AV(a`bove)+V(`mention)+PTC"
a`brasive	AJ	"V(a`brade)+AJR26"
a`brupt	AJ	"AJ"
`abscessed	AJ	"N(`abscess)+AJR8"
`absent	AJ-to-V	"AJ"
absent`minded	AJ	"AJ(`absent)+N(`mind)+AJR8"
abso`lute	AJ-to-N	"AJ"
ab`stemious	AJ	"AJ"
`abstinent	AJ	"V(ab`stain)+AJR27"
ab`stract	AJ	"AJ"
ab`struse	AJ	"AJ"
ab`surd	AJ	"AJ"
a`building	AJ	"AJR1+V(`build)+PRG"
a`bundant	AJ	"V(a`bound)+AJR27"
a`bysmal	AJ	"N(a`byss)+AJR17"
`accurate	AJ	"AJ"
ac`cursed	AJ	"AJ"
ac`curst	AJ	"AJ"
ac`cusative	AJ	"AJ"
a`cerbic	AJ_ic	"AJ"
`acid	AJ-to-N	"AJ"
a`cidulous	AJ	"AJ"
a`coustic	AJ_ic	"AJ"
ac`quisitive	AJ	"V(ac`quire)+AJR26"
`acrid	AJ	"AJ"
a`crylic	AJ-to-N	"AJ"
`actionable	AJ	"N(`action)+AJR25"
`actual	AJ	"AJ"
a`cute	AJ	"AJ"
a`cyclic	AJ_ic	"NEG1+N(`cycle)+AJR20"
a`dagio	AJ	"AJ"
`adamant	AJ	"AJ"
`additive	AJ-to-N	"V(`add)+AJR26"
a`dept	AJ	"AJ"
`adequate	AJ	"AJ"
ad`hesive	AJ-to-N	"V(ad`here)+AJR26"
ad`jacent	AJ	"AJ"
ad`joint	AJ	"AJ"
ad`ministrable	AJ	"V(ad`ministrate)+AJR25"
ad`missible	AJ	"V(ad`mit)+AJR25"
ad`monitory	AJ	"V(ad`monish)+AJR28"
ado`lescent	AJ-to-N	"AJ"
ad`renal	AJ	"AJ"
ad`rift	AJ	"AJR1+V(`drift)"
ad`roit	AJ	"AJ"
a`dult	AJ-to-N	"AJ"
a`dulterous	AJ	"N(a`dultery)+AJR21"
ad`vantaged	AJ	"N(ad`vantage)+AJR8"
adven`titious	AJ	"AJ"
adventuresome	AJ	"N(ad`venture)+AJR15"
ad`verse	AJ	"AJ"
ae`olian	AJ	"AJ"
`aerial	AJ	"AJ"
aer`obic	AJ_ic	"AJ"
aerody`namic	AJ_ic	"AJ"
aero`nautic	AJ_ic	"AJ"
`affable	AJ	"AJ"
af`fectionate	AJ	"N(af`fection)+AJR24"
`afferent	AJ	"AJ"
af`firmative	AJ	"V(af`firm)+AJR26"
`affluent	AJ	"AJ"
a`field	AJ	"AJR1+N(`field)"
a`fire	AJ	"AJR1+N(`fire)"
a`flame	AJ	"AJR1+N(`flame)"
a`float	AJ	"AJR1+V(`float)"
a`foot	AJ	"AJR1+N(`foot)"
a`forementioned	AJ	"AV(a`fore)+V(`mention)+PTC"
a`foresaid	AJ	"AV(a`fore)+V(`say)+PTC"
a`forethought	AJ	"AV(a`fore)+V(`think)+PTC"
a`foul	AJ	"AJ"
a`fraid	AJ	"AJ"
a`fresh	AJ	"AJR1+AJ(`fresh)"
`aft	Clitics	"AV/AJ"
`aggregate	AJ-to-N-V	"AJ"
ag`gressive	AJ	"AJ"
a`ghast	AJ	"AJ"
`agile	AJ	"AJ"
a`gleam	AJ	"AJR1+V(`gleam)"
a`glow	AJ	"AJR1+V(`glow)"
a`go	AJ	"AJ/AV"
a`gone	AJ	"AJ"
ag`rarian	AJ	"AJ"
`airborne	AJ	"AJ"
`airtight	AJ	"AJ"
a`jar	AJ	"AJ"
a`kimbo	AJ	"AJ"
a`kin	AJ	"AJ"
a`lert	AJ-to-V	"AJ"
al`fresco	AJ	"AJ"
`algal	AJ	"N(`alga)+AJR17"
a`like	AJ	"AJR1+AJ(`like)"
a`live	AJ	"AJR1+AJ(`live)"
`alkaline	AJ	"N(`alkali)+AJR38"
al`legiant	AJ	"AJ"
alle`goric	AJ_ic	"N(`allegory)+AJR20"
al`legro	AJ	"AJ"
al`lergic	AJ_ic	"N(`allergy)+AJR20"
`allocable	AJ	"V(`allocate)+AJR25"
al`luvial	AJ	"AJ"
al`mighty	AJ	"AJ"
a`lone	AJ	"AJR1+AJ(`lone)"
a`loof	AJ	"AJ"
alpha`meric	AJ	"AJ"
alphanu`meric	AJ_ic	"AJ"
`alpine	AJ	"N" ;AJR38?
al`taic	AJ	"AJ"
alve`olar	AJ-to-N	"AJ"
`amatory	AJ	"AJ"
ambi`dextrous	AJ	"AJ"
`ambient	AJ	"AJ"
am`biguous	AJ	"AJ"
am`bitious	AJ	"AJ"
am`bivalent	AJ	"AJ"
am`brosial	AJ	"(am`brosia)+AJR17"
`ambulant	AJ	"AJ"
a`menable	AJ	"AJ"
`amiable	AJ	"AJ"
`amicable	AJ	"AJ"
a`mino	AJ	"AJ"
a`moral	AJ	"NEG1+AJ(`moral)"
`amorous	AJ	"AJ"
a`morphous	AJ	"AJ"
am`phibious	AJ	"AJ"
`ample	AJ	"AJ"
anachro`nistic	AJ_ic	"AJ"
a`nachronous	AJ	"AJ"
anae`robic	AJ_ic	"AJ"
anaes`thetic	AJ_ic	"AJ"
`anal	AJ	"N(`anus)+AJR17"
ana`leptic	AJ_ic	"AJ"
anal`gesic	AJ_ic	"AJ"
a`nalogous	AJ	"N(a`nalogy)+AJR21"
ana`lytic	AJ_ic	"N(a`nalysis)+AJR20"
ana`phoric	AJ_ic	"(a`naphora)+AJR20"
an`cestral	AJ	"N(`ancestor)+AJR17"
`ancient	AJ-to-N	"AJ"
`ancillary	AJ	"AJ"
anes`thetic	AJ_ic	"AJ"
`anglican	AJ-to-N	"AJ"
`angry	AJ	"AJ"
`anguished	AJ	"N(`anguish)+AJR8"
`angular	AJ	"N(`angle)+AJR31"
`animate	AJ	"AJ(`animate)" ;[-@t]
`annual	AJ-to-N	"AJ"
`annular	AJ	"AJ"
a`nomalous	AJ	"N(a`nomaly)+AJR21"
a`nonymous	AJ	"AJ"
ante`bellum	AJ	"AJ"
an`terior	AJ	"AJ"
anthropo`genic	AJ_ic	"AJ"
anthropo`morphic	AJ_ic	"AJ"
antibi`otic	AJ_ic	"AJ"
antipa`thetic	AJ_ic	"N(an`tipathy)+AJR20"
an`tiphonal	AJ	"N(`antiphon)+AJR17"
anti`podean	AJ	"AJ"
anti`thetic	AJ_ic	"AJ"
`antlered	AJ	"N(`antler)+AJR8"
`anxious	AJ	"AJ"
apa`thetic	AJ_ic	"N(`apathy)+AJR20"
aperi`odic	AJ_ic	"NEG1+N(`period)+AJR20"
`aphasic	AJ_ic	"N(a`phasia)+AJR20"
apoca`lyptic	AJ_ic	"N(a`pocalypse)+AJR20"
a`pocryphal	AJ	"N(a`pocrypha)+AJR17"
apo`litical	AJ	"NEG1+AJ(po`litical)"
apolo`getic	AJ_ic	"N(a`pology)+AJR20"
apop`lectic	AJ_ic	"N(`apoplexy)+AJR20"
apos`tolic	AJ_ic	"N(a`postle)+AJR20"
ap`parent	AJ	"AJ"
ap`pellate	AJ	"V(ap`peal)+AJR24"
ap`pellative	AJ	"AJ"
`appetizing	AJ	"AJ"
`applicable	AJ	"V(ap`ply)+AJR25"
`apposite	AJ	"AJ"
ap`preciable	AJ	"V(ap`preciate)+AJR25"
appre`hensive	AJ	"V(appre`hend)+AJR26"
ap`propriable	AJ	"V(ap`propriate)+AJR25"
ap`propriate	AJ	"AJ" ;[-@t]
ap`proximable	AJ	"AJ"
ap`proximate	AJ-to-V	"AJ" ;[-@t]
apro`pos	AJ	"AJ/AV"
`apt	AJ	"AJ"
a`quatic	AJ_ic	"AJ"
`aqueous	AJ	"AJ"
`arable	AJ	"AJ"
`arbitrary	AJ	"AJ"
ar`boreal	AJ	"AJ"
ar`cane	AJ	"AJ"
ar`chaic	AJ_ic	"AJ"
arche`typic	AJ_ic	"N(`archetype)+AJR20"
architec`tonic	AJ_ic	"AJ"
`arctic	AJ	"AJ"
`ardent	AJ	"AJ"
`arduous	AJ	"AJ"
`areawide	AJ	"AJ"
argu`mentative	AJ	"V(`argue)+NR25+AJR26"
`arid	AJ	"AJ"
aro`matic	AJ_ic	"N(a`roma)+AJR20"
`arrant	AJ	"AJ"
`arrogant	AJ	"AJ"
ar`ticulate	AJ-to-V	"AJ" ;[-@t]
as`cetic	AJ_ic	"AJ"
a`septic	AJ_ic	"NEG1+AJ(`septic)"
a`stern	AJ	"AJR1+N(`stern)"
a`sexual	AJ	"NEG1+N(`sex)+AJR17"
a`shamed	AJ	"AJ"
`ashen	AJ	"N(`ash)+AJR30"
`asinine	AJ	"AJ"
a`skew	AJ	"AJ/AV"
a`sleep	AJ	"AJR1+V(`sleep)"
a`social	AJ	"NEG1+AJ(`social)"
a`spheric	AJ_ic	"NEG1+N(`sphere)+AJR20"
as`siduous	AJ	"AJ"
as`similable	AJ	"V(as`similate)+AJR25"
as`sociable	AJ	"V(as`sociate)+AJR25"
`assonant	AJ	"AJ"
a`stir	AJ	"AJR1+V(`stir)"
`astral	AJ	"AJ"
as`tringent	AJ	"AJ"
astro`nomical	AJ	"N(as`tronomy)+AJR20+AJR17"
astro`physical	AJ	"N(`astrophysics)+AJR17"
as`tute	AJ	"AJ"
asym`metric	AJ_ic	"NEG1+N(`symmetry)+AJR20"
a`synchronous	AJ	"N(a`synchrony)+AJR21"
ata`vistic	AJ_ic	"AJ"
a`thirst	AJ	"AJ"
at`lantic	AJ	"AJ"
a`tonal	AJ	"NEG1+N(`tone)+AJR17"
a`trocious	AJ	"AJ"
a`trophic	AJ_ic	"N(`atrophy)+AJR20"
at`tentive	AJ	"V(at`tend)+AJR26"
atti`tudinal	AJ	"N(`attitude)+AJR17"
a`typic	AJ_ic	"NEG1+N(`type)+AJR20"
ava`ricious	AJ	"N(`avarice)+AJR21"
a`verse	AJ	"AJ"
`avid	AJ	"AJ"
avi`onic	AJ_ic	"AJ"
au`dacious	AJ	"AJ"
`audible	AJ	"AJ"
audio`visual	AJ-to-N	"AJ"
`auditory	AJ	"AJ"
au`gust	AJ	"AJ"
`aural	AJ	"AJ"
`auric	AJ_ic	"AJ"
aus`picious	AJ	"AJ"
aus`tere	AJ	"AJ"
au`thentic	AJ_ic	"AJ"
authori`tarian	AJ-to-N	"N(au`thority)+AJR4"
au`thoritative	AJ	"N(au`thority)+AJR26"
au`tistic	AJ_ic	"AJ"
auto`matic	AJ_ic	"AJ"
auto`morphic	AJ_ic	"AJ"
au`tonomic	AJ_ic	"AJ"
au`tonomous	AJ	"AJ"
a`vuncular	AJ	"AJ"
a`ware	AJ	"AJ"
a`wash	AJ	"AJ"
`awesome	AJ	"N(`awe)+AJR15"
`awestruck	AJ	"AJ"
`awestricken	AJ	"AJ"
`awful	AJ	"AJ"
`awkward	AJ	"AJ"
a`wry	AJ	"AJ"
`axial	AJ	"N(`axis)+AJR17"
axio`matic	AJ_ic	"N(`axiom)+AJR20"

bac`terial	AJ	"N(bac`teria)+AJR17"
`bald	AJ-to-V	"AJ"
bal`letic	AJ_ic	"N(bal`let)+AJR20" ;exception to Gemination
bal`listic	AJ_ic	"AJ"
`banal	AJ	"AJ"
`bankrupt	AJ-to-V	"AJ"
bar`barian	AJ-to-N	"AJ"
bar`baric	AJ_ic	"AJ"
`barbarous	AJ	"AJ"
`bare	AJ	"AJ"
`barefaced	AJ	"AJ(`bare)+N(`face)+AJR8"
`barefoot	AJ	"AJ"
`barnacled	AJ	"N(`barnacle)+AJR8"
baro`metric	AJ	"N(ba`rometer)+AJR20"
ba`roque	AJ	"AJ"
`barren	AJ-to-N	"AJ"
`basilar	AJ	"AJ"
baso`philic	AJ_ic	"AJ"
`bawdy	AJ	"AJ"
`beaked	AJ	"N(`beak)+AJR8"
`bearded	AJ	"N(`beard)+AJR8"
bea`tific	AJ_ic	"AJ"
`beauteous	AJ	"N(`beauty)+AJR21"
`bedfast	AJ	"AJ"
`bedridden	AJ	"AJ"
be`lated	AJ	"AJ"
`bellicose	AJ	"AJ"
`bellied	AJ	"N(`belly)+AJR8"
bel`ligerent	AJ	"AJ"
be`loved	AJ	"VR2+V(`love)+AJR8"
be`neficent	AJ	"N(`benefice)+AJR27"
be`nevolent	AJ	"AJ"
be`nign	AJ	"AJ"
ber`serk	AJ	"AJ"
be`spectacled	AJ	"VR2+N(`spectacle)+AJR8"
`bestial	AJ	"N(`beast)+AJR17"
best`selling	AJ	"AJ"
bi`cameral	AJ	"AJ"
bi`ennial	AJ	"AJ"
`big	AJ	"AJ"
`bigoted	AJ	"N(`bigot)+AJR8"
bi`lingual	AJ	"AJ"
`bilious	AJ	"N(`bile)+AJR21"
`binary	AJ	"AJ"
bi`naural	AJ	"AJ"
bi`nocular	AJ	"AJ"
bi`nomial	AJ	"AJ"
bi`partite	AJ	"AJ"
`bistate	AJ	"AJ"
`bitter	AJ	"AJ"
`bittersweet	AJ	"AJ"
bi`tuminous	AJ	"AJ"
bi`zarre	AJ	"AJ"
`bland	AJ	"AJ"
`blank	AJ-to-N	"AJ"
`blasphemous	AJ	"N(`blasphemy)+AJR21"
`blatant	AJ	"AJ"
`bleak	AJ	"AJ"
`bleary	AJ	"AJ"
`blest	AJ	"AJ"
`blind	AJ-to-V	"AJ"
`blithe	AJ	"AJ"
`blooded	AJ	"N(`blood)+AJR8"
`bloodshot	AJ	"AJ"
`bloodthirsty	AJ	"AJ"
`blunt	AJ-to-V	"AJ"
`blustery	AJ	"AJ"
`bodied	AJ	"N(`body)+AJR8"
`bogus	AJ	"AJ"
`boisterous	AJ	"AJ"
`bold	AJ	"AJ"
`boldface	AJ	"AJ"
`bombproof	AJ	"AJ"
`bony	AJ	"N(`bone)+AJR14"
`borderline	AJ	"AJ"
`boric	AJ	"AJ"
`born	AJ	"AJ"
bo`tanical	AJ	"N(`botany)+AJR20+AJR17"
`bothersome	AJ	"V(`bother)+AJR15"
bouf`fant	AJ	"AJ"
`boolean	AJ-to-N	"PN(boole)+NR29"
`boozy	AJ	"N(`booze)+AJR14"
`bouncy	AJ	"V(`bounce)+AJR14"
`bound	AJ	"AJ"
`bounteous	AJ	"N(`bounty)+AJR21"
bour`geois	AJ	"AJ"
`bovine	AJ	"AJ"
`brackish	AJ	"AJ"
`brained	AJ	"N(`brain)+AJR8"
`brash	AJ	"AJ"
`brave	AJ-to-V	"AJ"
`brazen	AJ-to-V	"AJ"
`breasted	AJ	"N(`breast)+AJR8"
`breathtaking	AJ	"AJ"
`breezy	AJ	"N(`breeze)+AJR14"
`brief	AJ	"AJ"
`bright	AJ	"AJ"
`brighteyed	AJ	"AJ(`bright)+N(`eye)+AJR8"
`brilliant	AJ	"AJ"
`brindled	AJ	"AJ"
`briny	AJ	"N(`brine)+AJR14"
`brisk	AJ	"AJ"
`brittle	AJ	"AJ"
`broad	AJ	"AJ"
broken`hearted	AJ	"AJ"
`bronchial	AJ	"AJ"
`bronze	AJ	"N(`bronze)+AJR14"
`brusque	AJ	"AJ"
`bubbly	AJ	"N(`bubble)+AJR14"
bu`colic	AJ_ic	"AJ"
`budgetary	AJ	"N(`budget)+AJR22"
`bugeyed	AJ	"N(`bugeye)+AJR8"
`builtin	AJ	"AJ"
`bumptious	AJ	"AJ"
`buoyant	AJ	"V(`buoy)+AJR27"
`burdensome	AJ	"N(`burden)+AJR15"
`burglarproof	AJ	"AJ"
`burly	AJ	"AJ"
`busy	AJ-to-V	"AJ"
`buxom	AJ	"AJ"
`bygone	AJ	"AJ"

`cabled	AJ	"N(`cable)+AJR8"
`cadent	AJ	"AJ"
cae`sarean	AJ	"N(`caesar)+AJR4"
cae`sarian	AJ	"N(`caesar)+AJR4"
`cagey	AJ	"AJ"
`cagy	AJ	"AJ"
`caged	AJ	"N(`cage)+AJR8"
ca`lamitous	AJ	"N(ca`lamity)+AJR21"
cal`careous	AJ	"AJ"
`calculable	AJ	"V(`calculate)+AJR25"
ca`lendric	AJ_ic	"N(`calendar)+AJR20"
`callous	AJ	"AJ"
`callused	AJ	"N(`callus)+AJR8"
`calm	AJ-to-V	"AJ"
ca`loric	AJ_ic	"N(`calorie)+AJR20"
can`descent	AJ	"AJ"
`candid	AJ	"AJ"
`candlelit	AJ	"AJ"
`canny	AJ	"AJ"
can`tankerous	AJ	"AJ"
`capable	AJ	"AJ"
ca`pacious	AJ	"AJ"
ca`pacitive	AJ	"AJ"
ca`pricious	AJ	"N(ca`price)+AJR21"
`captious	AJ	"AJ"
`captive	AJ-to-N	"AJ"
`cardiac	AJ	"AJ"
`cardioid	AJ	"AJ"
cardio`vascular	AJ	"AJ"
`carefree	AJ	"AJ"
`careworn	AJ	"AJ"
`carnal	AJ	"AJ"
car`tesian	AJ	"AJ"
carto`graphic	AJ_ic	"AJ"
`carven	AJ	"AJ"
`casual	AJ	"AJ"
cata`bolic	AJ_ic	"AJ"
cata`lytic	AJ_ic	"AJ"
cata`tonic	AJ_ic	"AJ"
cate`goric	AJ_ic	"V(`category)+AJR20"
`catholic	AJ_ic	"AJ"
`causative	AJ	"V(`cause)+AJR26"
`caustic	AJ_ic	"AJ"
`cautionary	AJ	"N(`caution)+AJR22"
`cautious	AJ	"AJ"
cava`lier	AJ	"AJ"
`celsius	AJ	"AJ"
ce`lestial	AJ	"AJ"
`cellular	AJ	"N(`cell)+AJR31"
cen`sorial	AJ	"V(`censor)+AJR17"
cen`sorious	AJ	"V(`censor)+AJR21"
cen`tennial	AJ-to-N	"AJ"
`central	AJ	"N(`center)+AJR17"
`centric	AJ_ic	"N(`center)+AJR20"
cen`trifugal	AJ	"AJ"
`centum	AJ	"AJ"
ce`ramic	AJ_ic	"AJ"
ce`rebral	AJ	"AJ"
`certain	AJ	"AJ"
`cervical	AJ	"N(`cervix)+AJR17"
ce`rulean	AJ	"AJ"
ce`sarean	AJ	"N(`caesar)+AJR4"
ce`sarian	AJ	"N(`caesar)+AJR4"
`chancy	AJ	"N(`chance)+AJR14"
cha`otic	AJ_ic	"N(`chaos)+AJR20"
character`istic	AJ_ic	"AJ"
charis`matic	AJ_ic	"N(cha`risma)AJR20"
`charitable	AJ	"AJ"
`chaste	AJ	"AJ"
`cheap	AJ	"AJ/AV"
`cheeked	AJ	"N(`cheek)+AJR8"
`cheesy	AJ	"N(`cheese)+AJR14"
`chelate	AJ	"AJ"
`chemical	AJ-to-N	"AJ"
`chested	AJ	"N(`chest)+AJR8"
`chic	AJ	"AJ"
`chief	AJ-to-N	"AJ"
`chimeric	AJ	"AJ"
`chivalric	AJ_ic	"N(`chivalry)+AJR20"
`chivalrous	AJ	"N(`chivalry)+AJR21"
`choosy	AJ	"V(`choose)+AJR14"
`choral	AJ	"AJ"
`chronic	AJ_ic	"AJ"
`chubby	AJ	"AJ"
cine`matic	AJ_ic	"N(`cinema)+AJR20"
`circular	AJ-to-N	"N(`circle)+AJR31"
circumfer`ential	AJ	"N(cir`cumference)+AJR17"
`circumspect	AJ	"AJ"
circum`stantial	AJ	"N(`circumstance)+AJR17"
`citric	AJ_ic	"AJ"
`citywide	AJ	"AJ"
`civic	AJ	"AJ"
`civil	AJ	"AJ"
`clandestine	AJ	"AJ"
`classic	AJ-to-N	"AJ"
`classificatory	AJ	"N(`class)+VR5+AJR23"
claustro`phobic	AJ_ic	"N(claustro`phobia)+AJR20"
`clean	AJ-to-V	"AJ"
`cleanly	AJ	"AJ(`clean)+AJR13"
`clear	AJ-to-V	"AJ/AV"
clear`headed	AJ	"AJ(`clear)+N(`head)+AJR8"
`clement	AJ	"AJ"
`clever	AJ	"AJ"
cli`mactic	AJ_ic	"N(`climax)+AJR20"
`close	AJ	"AJ"
`clothbound	AJ	"AJ"
`clumsy	AJ	"AJ"
co`agulable	AJ	"V(co`agulate)+AJR25"
`coarse	AJ	"AJ"
`cochineal	AJ	"AJ"
`cockeyed	AJ	"AJ"
`cocksure	AJ	"AJ"
`cocky	AJ	"AJ"
`cogent	AJ	"AJ"
`cognitive	AJ	"AJ"
`cognizable	AJ	"AJ"
`cognizant	AJ	"AJ"
co`hesive	AJ	"V(co`here)+AJR26"
coinci`dental	AJ	"N(co`incidence)+AJR17"
`cold	AJ-to-N	"AJ"
`coliform	AJ	"AJ"
`colicky	AJ	"N(`colic)+AJR14"
col`legiate	AJ	"N(`college)+AJR24"
col`linear	AJ	"AJ"
col`loquial	AJ	"AJ"
co`lossal	AJ	"AJ"
`columnar	AJ	"N(`column)+AJR31"
`comatose	AJ	"AJ"
`comely	AJ	"AJ"
co`mestible	AJ-to-N	"AJ"
`comfortable	AJ	"AJ"
`comic	AJ_ic	"AJ"
com`mendatory	AJ	"V(com`mend)+AJR28"
com`mensurable	AJ	"AJ"
com`mensurate	AJ	"AJ"
com`modious	AJ	"AJ"
`common	AJ	"AJ"
`commonplace	AJ-to-N	"AJ"
com`municable	AJ	"V(com`municate)+AJR25"
com`pact	AJ-to-V	"AJ"
com`panionable	AJ	"N(com`panion)+AJR25"
com`parative	AJ	"V(com`pare)+AJR26"
com`passionate	AJ	"N(com`passion)+AJR24"
com`patible	AJ-to-N	"AJ"
com`pendious	AJ	"AJ"
com`pensable	AJ	"V(`compensate)+AJR25"
`competent	AJ	"AJ"
com`petitive	AJ	"V(com`pete)+AJR26"
com`placent	AJ	"AJ"
com`plaisant	AJ	"AJ"
com`pleat	AJ	"AJ"
comple`mentary	AJ	"N(`complement)+AJR22"
com`plete	AJ-to-V	"AJ"
com`plex	AJ	"AJ"
com`plexioned	AJ	"N(com`plexion)+AJR8"
compli`mentary	AJ	"N(`compliment)+AJR22"
com`posite	AJ	"AJ"
com`pound	AJ-to-V	"AJ"
com`pulsive	AJ	"V(com`pell)+AJR26"
com`pulsory	AJ	"V(com`pell)+AJR23"
compre`hensible	AJ	"V(compre`hend)+AJR25"
compre`hensive	AJ	"V(compre`hend)+AJR26"
con`cave	AJ	"AJ"
con`ceited	AJ	"N(con`ceit)+AJR8"
con`centric	AJ_ic	"AJ"
con`cise	AJ	"AJ"
con`clusive	AJ	"V(con`clude)+AJR26"
con`comitant	AJ	"AJ"
con`cordant	AJ	"N(`concord)+AJR27"
con`crete	AJ	"AJ"
con`cupiscent	AJ	"AJ"
con`demnatory	AJ	"V(con`demn)+AJR28"
`confident	AJ	"AJ"
confi`dential	AJ	"N(`confidence)+AJR17"
con`firmatory	AJ	"V(con`firm)+AJR28"
con`fiscable	AJ	"V(`confiscate)+AJR25"
con`fluent	AJ	"AJ"
con`focal	AJ	"AJ"
con`genial	AJ	"AJ"
con`genital	AJ	"AJ"
con`gressional	AJ	"N(`congress)+AJR17"
con`gruent	AJ	"AJ"
`congruous	AJ	"AJ"
con`jugal	AJ	"AJ"
con`nubial	AJ	"AJ"
con`sanguine	AJ	"AJ"
consan`guineous	AJ	"AJ(con`sanguine)+AJR21"
consci`entious	AJ	"N(`conscience)+AJR21"
`conscionable	AJ	"AJ"
`conscious	AJ	"AJ"
con`secutive	AJ	"AJ"
con`sensual	AJ	"V(con`sent)+AJR17"
`consequent	AJ-to-N	"AJ"
con`servative	AJ-to-N	"V(`conserve)+AJR26"
con`siderate	AJ	"V(con`sider)+AJR24"
con`spicuous	AJ	"AJ"
con`stabulary	AJ-to-N	"N(`constable)+AJR22"
con`stituent	AJ-to-N	"AJ"
`consular	AJ	"AJ"
`consummate	AJ-to-V	"AJ"
con`sumptive	AJ	"V(con`sume)+AJR26"
con`tagious	AJ	"AJ"
con`temptible	AJ	"N(con`temp)+AJR25"
con`temptuous	AJ	"N(con`temp)+AJR21"
contempo`raneous	AJ	"AJ"
con`temporary	AJ-to-N	"AJ"
con`tent	AJ	"AJ"
con`tentious	AJ	"V(con`tend)+AJR21"
con`tiguous	AJ	"AJ"
con`tinuous	AJ	"V(con`tinue)+AJR21"
`continent	AJ	"AJ"
con`tingent	AJ	"AJ"
contra`ceptive	AJ-to-N	"AJ"
`contrary	AJ	"AJ"
`contrite	AJ	"AJ"
con`venient	AJ	"AJ"
con`vex	AJ	"AJ"
con`vivial	AJ	"AJ"
`cool	AJ-to-V	"AJ"
cool`headed	AJ	"AJ(`cool)+N(`head)+AJR8"
co`ordinate	AJ-to-V	"AJ"
`copious	AJ	"AJ"
`cordial	AJ	"AJ"
`corporate	AJ	"AJ"
cor`poreal	AJ	"AJ"
`corpulent	AJ	"AJ"
cor`puscular	AJ	"N(`corpuscle)+AJR31"
cor`rect	AJ-to-V	"AJ"
`corrigible	AJ	"AJ"
cor`rosive	AJ	"V(cor`rode)+AJR26"
cor`rupt	AJ-to-V	"AJ"
`cortical	AJ	"AJ"
cos`metic	AJ_ic	"AJ"
`cosmic	AJ_ic	"AJ"
cosmo`politan	AJ	"AJ"
`cosy	AJ	"AJ"
`counterfeit	AJ-to-V	"AJ"
`countrywide	AJ	"AJ"
`countywide	AJ	"AJ"
`courteous	AJ	"AJ"
`covert	AJ	"AJ"
`covetous	AJ	"V(`covet)+AJR21"
`coy	AJ	"AJ"
`cozy	AJ	"AJ"
`crafty	AJ	"AJ"
`crass	AJ	"AJ"
`craven	AJ	"AJ"
`crazy	AJ	"AJ"
`credent	AJ	"AJ"
`credible	AJ	"AJ"
`credulous	AJ	"AJ"
`crestfallen	AJ	"AJ"
cre`taceous	AJ	"AJ"
`criminal	AJ-to-N	"N(`crime)+AJR17"
`crisp	AJ	"AJ/AV"
`crooked	AJ	"AJ"
`crucial	AJ	"AJ"
`crude	AJ	"AJ"
`cruel	AJ	"AJ"
`crummy	AJ	"AJ"
cryo`genic	AJ_ic	"AJ"
`cryptic	AJ_ic	"AJ"
`crystalline	AJ	"N(`crystal)+AJR38"
`cuddly	AJ	"V(`cuddle)+AJR14"
`culinary	AJ	"AJ"
`culpable	AJ	"AJ"
`cultivable	AJ	"V(`cultivate)+AJR25"
`cumbersome	AJ	"AJ"
`cumbrous	AJ	"AJ"
`cunning	AJ	"AJ"
`cupric	AJ	"AJ"
`cuprous	AJ	"AJ"
`curious	AJ	"AJ"
`current	AJ	"AJ"
cur`ricular	AJ	"AJ"
`cursive	AJ	"AJ"
`cursory	AJ	"AJ"
`curt	AJ	"AJ"
`curvy	AJ	"N(`curve)+AJR14"
cur`vaceous	AJ	"AJ"
`customary	AJ	"N(`custom)+AJR22"
cu`taneous	AJ	"AJ"
`cute	AJ	"AJ"
`cutesy	AJ	"AJ"
cyber`netic	AJ_ic	"AJ"
`cyclable	AJ	"N(`cycle).VR0+AJR25"
`cyclic	AJ_ic	"V(`cycle)+AJR20"
cyclo`pean	AJ	"AJ"
cy`lindric	AJ_ic	"N(`cylinder)+AJR20"

`daffy	AJ	"AJ"
`daft	AJ	"AJ"
`daily	AJ-to-AV	"N(`day)+AJR13"
`dainty	AJ	"AJ"
`damp	AJ	"AJ"
`dandy	AJ-to-N	"AJ"
`dank	AJ	"AJ"
`dapper	AJ	"AJ"
`dark	AJ	"AJ"
`darling	AJ-to-N	"AJ"
`dauntless	AJ	"V(`daunt)+AJR11"
`daylong	AJ	"AJ"
`dead	AJ	"AJ"
`deadlocked	AJ	"N(`deadlock)+AJR8"
`deadly	AJ	"AJ(`dead)+AJR13"
`deaf	AJ	"AJ"
`dear	AJ-to-N	"AJ"
debo`nair	AJ	"AJ"
`decadent	AJ	"AJ"
de`cennial	AJ	"AJ"
`decent	AJ	"AJ"
de`ceptive	AJ	"V(de`ceive)+AJR26"
de`ciduous	AJ	"AJ"
`decimal	AJ-to-N	"AJ"
de`cisive	AJ	"AJ"
de`clamatory	AJ	"V(de`claim)+AJR28"
de`clarative	AJ	"V(de`clare)+AJR26"
de`claratory	AJ	"V(de`clare)+AJR28"
`decorous	AJ	"AJ"
de`crepit	AJ	"AJ"
`deep	AJ	"AJ"
de`famatory	AJ	"V(de`fame)+AJR28"
de`fensible	AJ	"V(de`fend)+AJR25"
de`fensive	AJ	"V(de`fend)+AJR26"
`deferent	AJ	"V(de`fer)+AJR27" ;exception to Gemination
defer`ential	AJ	"V(de`fer)+NR26+AJR17"
de`ficient	AJ	"AJ"
`definite	AJ	"AJ"
de`finitive	AJ	"V(de`fine)+AJR26"
de`flationary	AJ	"V(de`flate)+NR23+AJR22"
`deft	AJ	"AJ"
de`funct	AJ	"AJ"
de`generate	AJ-to-V	"AJ"
de`lectable	AJ	"AJ"
de`lectate	AJ	"AJ"
`delegable	AJ	"V(`delegate)+AJR25"
dele`terious	AJ	"AJ"
de`liberate	AJ-to-V	"AJ" ;[-@t]
`delicate	AJ	"AJ"
de`licious	AJ	"AJ"
de`linquent	AJ-to-N	"AJ"
de`lirious	AJ	"AJ"
de`lusionary	AJ	"V(de`lude)+NR23+AJR22"
de`luxe	AJ	"AJ"
de`mented	AJ	"AJ"
de`miscible	AJ	"AJ"
de`monstrable	AJ	"V(`demonstrate)+AJR25"
de`mure	AJ	"AJ"
`dense	AJ	"AJ"
`dental	AJ	"AJ"
de`numerable	AJ	"V(de`numerate)+AJR25"
de`preciable	AJ	"V(de`preciate)+AJR25"
`derelict	AJ-to-N	"AJ"
de`rivative	AJ-to-N	"V(de`rive)+AJR26"
de`scriptive	AJ	"V(de`scribe)+AJR26"
`desolate	AJ-to-V	"AJ"
`desperate	AJ	"V(des`pair)+AJR24"
des`picable	AJ	"V(des`pise)+AJR25"
`destitute	AJ	"AJ"
de`sultory	AJ	"AJ"
de`terminate	AJ	"V(de`termine)+AJR24"
`detonable	AJ	"V(`detonate)+AJR25"
`deviant	AJ-to-N	"V(`deviate)+AJR27"
`devious	AJ	"AJ"
de`void	AJ	"AJ"
devo`lutionary	AJ	"V(de`volve)+NR23+AJR22"
de`vout	AJ	"AJ"
`dexter	AJ	"AJ/AV"
`dexterous	AJ	"AJ"
`dextrous	AJ	"AJ"
dia`betic	AJ_ic	"AJ"
dia`bolic	AJ_ic	"AJ"
diag`nostic	AJ_ic	"N(diag`nosis)+AJR20"
di`agonal	AJ-to-N	"AJ"
diagram`matic	AJ_ic	"N(`diagram)+AJR20"
dia`magnetic	AJ_ic	"AJ"
dia`metric	AJ_ic	"N(di`ameter)+AJR20"
di`aphanous	AJ	"AJ"
diato`maceous	AJ	"AJ"
dia`tonic	AJ_ic	"AJ"
di`dactic	AJ_ic	"AJ"
`dietary	AJ	"N(`diet)+AJR22"
;die`tetic	AJ_ic	"N(`diet)+AJR20"
differ`entiable	AJ	"V(differ`entiate)+AJR25"
`difficult	AJ	"AJ"
`diffident	AJ	"AJ"
dif`fuse	AJ	"AJ"
`digitate	AJ	"AJ"
`dilatory	AJ	"AJ"
`diligent	AJ	"AJ"
di`luvial	AJ	"AJ"
di`luvian	AJ	"AJ"
`dim	AJ-to-V	"AJ"
diminutive	AJ	"AJ"
`dingy	AJ	"AJ"
`dire	AJ	"AJ"
`direful	AJ	"AJ(`dire)+AJR9"
di`rect	AJ	"AJ"
di`sastrous	AJ	"N(di`saster)+AJR21"
`disciplinary	AJ	"N(`discipline)+AJR22"
`discoid	AJ	"AJ"
disconsolate	AJ	"REV3+V(con`sole)+AJR27"
dis`cordant	AJ	"N(`discord)+AJR27"
dis`creet	AJ	"AJ"
dis`crepant	AJ	"AJ"
dis`crete	AJ	"AJ"
dis`cretionary	AJ	"AJ(dis`creet)+NR23+AJR22"
dis`criminable	AJ	"V(dis`criminate)+AJR25"
dis`junct	AJ-to-N	"AJ"
dis`junctive	AJ	"AJ(dis`junct)+AJR26"
`dismal	AJ	"AJ"
`disparate	AJ	"AJ"
dispu`tatious	AJ	"V(dis`pute)+AJR21"
dis`sociable	AJ	"REV3+V(as`sociate)+AJR25"
dis`soluble	AJ	"V(dis`solve)+AJR25"
`dissonant	AJ	"AJ"
`distal	AJ	"AJ"
`distant	AJ	"AJ"
dis`tinct	AJ	"AJ"
dis`tinctive	AJ	"AJ(dis`tinct)+AJR26"
dis`traught	AJ	"AJ"
di`urnal	AJ	"AJ"
di`valent	AJ	"AJ"
di`verse	AJ	"AJ"
di`versionary	AJ	"N(di`version)+AJR22"
di`vine	AJ	"AJ"
di`visible	AJ	"V(di`vide)+AJR25"
di`visive	AJ	"V(di`vide)+AJR26"
`dizzy	AJ-to-V	"AJ"
`doable	AJ	"V(`do)+AJR25"
`docile	AJ	"AJ"
doctri`naire	AJ	"AJ"
dog`gone	AJ	"AJ"
dog`matic	AJ_ic	"N(`dogma)+AJR20"
`dolce	AJ	"AJ"
`doleful	AJ	"AJ"
`domed	AJ	"N(`dome)+AJR8"
do`mestic	AJ_ic	"AJ"
`dominant	AJ	"V(`dominate)+AJR27"
`dormant	AJ	"AJ"
`dorsal	AJ	"AJ"
`double	AJ-to-V	"AJ"
`double	AJ-to-N	"AJ"
`douce	AJ	"AJ"
`doughty	AJ	"AJ"
`dour	AJ	"AJ"
`down	AJ	"AJ"
`downbeat	AJ	"AJ"
`downcast	AJ	"AJ"
down`hill	AJ	"AJ"
`downright	AJ	"AJ"
down`river	AJ	"AJ"
down`stairs	AJ	"AJ/AV"
down`stream	AJ	"AJ/AV"
`downtrodden	AJ	"AJ"
down`wind	AJ	"AJ"
`drab	AJ	"AJ"
dra`matic	AJ_ic	"N(`drama)+AJR20"
`drastic	AJ_ic	"AJ"
`drear	AJ	"AJ"
`dreary	AJ	"AJ"
`drizzly	AJ	"N(`drizzle)+AJR14"
`droll	AJ	"AJ"
`droopy	AJ	"V(`droop)+AJR14"
`drowsy	AJ	"V(`drowse)+AJR14"
`drunk	AJ-to-N	"AJ"
`drunken	AJ	"V(`drink)+AJR30"
`dry	AJ-to-V	"AJ"
`dubious	AJ	"AJ"
`dubitable	AJ	"AJ"
`ductile	AJ	"AJ"
`due	AJ-to-N	"AJ"
`dulcet	AJ	"AJ"
`dull	AJ-to-V	"AJ"
`duly	AJ	"AJ"
`dumb	AJ	"AJ"
`dumpy	AJ	"AJ"
`duplex	AJ-to-N	"AJ"
`duplicable	AJ	"V(`duplicate)+AJR25"
`duplicate	AJ-to-V	"AJ" ;[-@t]
`durable	AJ	"AJ"
`durative	AJ	"AJ"
`dusky	AJ	"AJ"
`dutiable	AJ	"N(`duty)+AJR25"
dy`adic	AJ_ic	"AJ"
dy`namic	AJ_ic	"AJ"
dy`nastic	AJ_ic	"N(`dynasty)+AJR20"
dys`peptic	AJ_ic	"AJ"

`eager	AJ	"AJ"
`early	AJ	"AJ/AV"
`earnest	AJ	"AJ"
`earthen	AJ	"N(`earth)+AJR30"
`earthshaking	AJ	"AJ"
`eastbound	AJ	"AJ"
`easterly	AJ	"AJ/AV"
`eastern	AJ	"AJ"
`easy	AJ	"AJ"
easy`going	AJ	"AJ"
e`bullient	AJ	"AJ"
ec`centric	AJ_ic	"AJ"
ecclesi`astic	AJ_ic	"AJ"
ec`lectic	AJ_ic	"AJ"
ec`liptic	AJ_ic	"N(e`clipse)+AJR20"
econo`metric	AJ_ic	"AJ"
ec`static	AJ_ic	"AJ"
ecu`menic	AJ_ic	"AJ"
`edgy	AJ	"N(`edge)+AJR14"
`edible	AJ	"V(`eat)+AJR25"
`educable	AJ	"V(`educate)+AJR25"
`eerie	AJ	"AJ"
`eery	AJ	"AJ"
`effable	AJ	"AJ"
ef`feminate	AJ	"AJ"
`efferent	AJ	"AJ"
ef`fete	AJ	"AJ"
ef`ficient	AJ	"AJ"
`effluent	AJ	"AJ"
ef`fulgent	AJ	"AJ"
egali`tarian	AJ-to-N	"AJ"
ego`centric	AJ_ic	"AJ"
e`gregious	AJ	"AJ"
e`laborate	AJ-to-V	"AJ"
e`lastic	AJ_ic	"AJ"
e`lect	AJ-to-N-V	"AJ"
e`lectric	AJ_ic	"AJ"
`elegant	AJ	"AJ"
ele`giac	AJ	"AJ"
ele`mentary	AJ	"N(`element)+AJR22"
`elephantine	AJ	"N(`elephant)+AJR38"
`elfin	AJ	"AJ"
`eligible	AJ	"AJ"
e`lite	AJ	"AJ"
el`liptic	AJ_ic	"AJ"
`eloquent	AJ	"AJ"
e`lusive	AJ	"AJ"
`elvish	AJ	"N(`elf)+AJR10"
e`lysian	AJ	"AJ"
emble`matic	AJ_ic	"AJ"
embry`onic	AJ_ic	"AJ"
e`mendable	AJ	"AJ"
e`meritus	AJ	"AJ"
`eminent	AJ	"AJ"
em`phatic	AJ_ic	"AJ"
em`piric	AJ_ic	"AJ"
`empty	AJ-to-V	"AJ"
en`cyclical	AJ-to-N	"AJ"
encyclo`pedic	AJ_ic	"AJ"
en`demic	AJ_ic	"AJ"
ener`getic	AJ_ic	"N(`energy)+AJR20"
enig`matic	AJ_ic	"N(e`nigma)+AJR20"
e`normous	AJ	"AJ"
`enterprising	AJ	"AJ"
en`tire	AJ	"AJ"
en`tropic	AJ_ic	"N(`entropy)+AJR20"
e`numerable	AJ	"V(e`numerate)+AJR25"
e`nunciable	AJ	"V(e`nunciate)+AJR25"
enzy`matic	AJ_ic	"N(`enzyme)+AJR25"
e`phemeral	AJ	"AJ"
`epicene	AJ	"AJ"
epi`dermic	AJ_ic	"AJ"
epige`netic	AJ_ic	"AJ"
epigram`matic	AJ_ic	"AJ"
epi`leptic	AJ_ic	"AJ"
e`piscopal	AJ	"AJ"
e`pistolatory	AJ	"AJ"
`equable	AJ	"AJ"
`equal	AJ-to-V	"AJ"
e`questrian	AJ	"AJ"
equi`distant	AJ	"AJ"
equi`lateral	AJ	"AJ"
`equine	AJ	"AJ"
equi`noctial	AJ	"N(`equinox)+AJR17"
equi`potent	AJ	"AJ"
`equitable	AJ	"AJ"
e`quivalent	AJ-to-N	"AJ"
e`quivocal	AJ	"AJ"
e`radicable	AJ	"V(e`radicate)+AJR25"
e`rect	AJ-to-V	"AJ"
e`rosible	AJ	"V(e`rode)+AJR25"
e`rotic	AJ_ic	"AJ"
`errant	AJ	"AJ"
er`ratic	AJ_ic	"AJ"
er`roneous	AJ	"AJ"
er`satz	AJ	"AJ"
e`rudite	AJ	"AJ"
eso`teric	AJ_ic	"AJ"
es`pecial	AJ	"AJ"
es`sential	AJ-to-N	"AJ"
`estimable	AJ	"V(`estimate)+AJR25"
`estuarine	AJ	"N(`estuary)+AJR38"
e`ternal	AJ	"AJ"
e`thereal	AJ	"AJ"
`ethnic	AJ_ic	"AJ"
ethnolin`guistic	AJ_ic	"AJ"
eu`genic	AJ_ic	"AJ"
euphe`mistic	AJ_ic	"AJ"
eu`phoric	AJ_ic	"AJ"
e`valuable	AJ	"V(e`valuate)+AJR25"
eva`nescent	AJ	"AJ"
e`vasive	AJ	"V(e`vade)+AJR26"
`even	AJ-to-V	"AJ"
even`handed	AJ	"AJ(`even)+N(`hand)+AJR8"
e`ventual	AJ	"AJ"
`evergreen	AJ	"AJ"
ever`lasting	AJ	"AJ"
`everyday	AJ	"AJ"
`evident	AJ	"AJ"
evi`dential	AJ	"N(`evidence)+AJR17"
`evil	AJ-to-N	"AJ"
`evitable	AJ	"AJ"
e`vocable	AJ	"V(e`voke)+AJR25"
evo`lutionary	AJ	"V(e`volve)+NR23+AJR22"
ex`act	AJ	"AJ"
`excellent	AJ	"V(ex`cell)+AJR27"
ex`ceptionable	AJ	"N(ex`ception)+AJR25"
ex`cessive	AJ	"N(`excess)+AJR26"
ex`citatory	AJ	"V(ex`cite)+AJR23"
ex`clamatory	AJ	"V(ex`claim)+AJR23"
ex`clusionary	AJ	"V(ex`clude)+NR23+AJR22"
ex`clusive	AJ	"V(ex`clude)+AJR26"
ex`crescent	AJ	"AJ"
`execrable	AJ	"AJ"
ex`empt	AJ-to-V	"AJ"
`exigent	AJ	"AJ"
exis`tential	AJ	"V(ex`ist)+NR26+AJR17"
ex`orbitant	AJ	"AJ"
ex`otic	AJ_ic	"AJ"
ex`pansible	AJ	"V(ex`pand)+AJR25"
ex`pansive	AJ	"V(ex`pand)+AJR26"
ex`pedient	AJ	"AJ"
expe`ditious	AJ	"V(`expedite)+AJR21"
ex`pensive	AJ	"N(ex`pense)+AJR26"
experi`ential	AJ	"V(ex`perience)+AJR17"
`expiable	AJ	"AJ"
ex`planatory	AJ	"V(ex`plain)+AJR28"
`explicable	AJ	"V(`explicate)+AJR25"
ex`plicit	AJ	"AJ"
ex`ploratory	AJ	"V(ex`plore)+AJR23"
ex`plosive	AJ-to-N	"V(ex`plode)+AJR26"
ex`quisite	AJ	"AJ"
`extant	AJ	"AJ"
extempo`raneous	AJ	"AJ"
ex`tempore	AJ	"AJ"
ex`tensible	AJ	"V(ex`tend)+AJR25"
ex`tensive	AJ	"V(ex`tend)+AJR26"
ex`ternal	AJ-to-N	"AJ"
ex`tinct	AJ	"AJ"
`extra	AJ-to-N	"AJ"
;extra`legal	AJ	"AJ"
;extralin`guistic	AJ	"AJ"
;extra`marital	AJ	"AJ"
extra`mural	AJ	"AJ"
ex`traneous	AJ	"AJ"
;extra`ordinary	AJ	"AJ"
;extra`terrestrial	AJ-to-N	"AJ"
ex`travagant	AJ	"AJ"
ex`treme	AJ-to-N	"AJ"
ex`tricable	AJ	"V(`extricate)+AJR25"
ex`trinsic	AJ_ic	"AJ"
`extroverted	AJ	"N(`extrovert)+AJR8"
ex`uberant	AJ	"AJ"
ex`ultant	AJ	"V(ex`ult)+AJR27"
`eyed	AJ	"N(`eye)+AJR8"

`fabled	AJ	"N(`fable)+AJR8"
`fabulous	AJ	"AJ"
`faceted	AJ	"N(`facet)+AJR8"
fa`cetious	AJ	"AJ"
`facile	AJ	"AJ"
`factious	AJ	"AJ"
`facultative	AJ	"AJ"
`fadeless	AJ	"V(`fade)+AJR11"
`fahrenheit	AJ	"AJ"
`failsafe	AJ	"AJ"
`failsoft	AJ	"AJ"
`faint	AJ	"AJ"
`fair	AJ	"AJ"
`fake	AJ	"AJ"
`fallible	AJ	"AJ"
fal`lopian	AJ	"AJ"
`fallow	AJ	"AJ"
`false	AJ	"AJ"
`famed	AJ	"N(`fame)+AJR8"
fa`miliar	AJ	"AJ"
`fancy	AJ	"AJ"
`fanfold	AJ	"AJ"
`fanged	AJ	"N(`fang)+AJR8"
fan`tastic	AJ_ic	"AJ"
far`fetched	AJ	"AJ(`far)+V(`fetch)+PTC"
`fashionable	AJ	"N(`fashion)+AJR25"
far`sighted	AJ	"AJ(`far)+N(`sight)+AJR8"
`fast	AJ	"AJ/AV"
fas`tidious	AJ	"AJ"
`fatal	AJ	"AJ"
`fated	AJ	"N(`fate)+AJR8"
`fatuous	AJ	"AJ"
`favorite	AJ-to-N 	"AJ"
`favourite	AJ-to-N 	"AJ" ;British
`fearsome	AJ	"V(`fear)+AJR15"
`feasible	AJ	"AJ"
`featherbrained	AJ	"N(`featherbrain)+AJR8"
`febrile	AJ	"AJ"
`feckless	AJ	"AJ"
`fecund	AJ	"AJ"
`federal	AJ	"AJ"
`federate	AJ-to-V	"AJ"
`feeble	AJ	"AJ"
feeble`minded	AJ	"AJ"
fe`licitous	AJ	"N(fe`licity)+AJR21"
`feline	AJ-to-N	"AJ"
`female	AJ-to-N	"AJ"
`feminine	AJ	"AJ"
`ferric	AJ_ic	"AJ"
`ferrous	AJ	"AJ"
fe`rocious	AJ	"AJ"
`fertile	AJ	"AJ"
`fervent	AJ	"AJ"
`festive	AJ	"AJ"
`fetal	AJ	"AJ"
`fetid	AJ	"AJ"
`feudal	AJ	"AJ"
`feudatory	AJ	"AJ"
`fibrous	AJ	"N(`fiber)+AJR21"
`fickle	AJ	"AJ"
fic`titious	AJ	"AJ"
fi`ducial	AJ	"AJ"
`fierce	AJ	"AJ"
`fiery	AJ	"N(`fire)+AJR14"
`figurative	AJ	"N(`figure)+AJR26"
fila`mentary	AJ	"N(`filament)+AJR22"
`filial	AJ	"AJ"
`final	AJ	"AJ"
`fine	AJ	"AJ"
`finicky	AJ	"AJ"
`finite	AJ	"AJ"
`fireproof	AJ	"AJ"
`firm	AJ-to-V	"AJ"
`firstborn	AJ	"AJ"
`firsthand	AJ	"AJ"
`fiscal	AJ	"AJ"
`fit	AJ	"AJ"
`flagrant	AJ	"AJ"
flam`boyant	AJ	"AJ"
`flammable	AJ	"N(`flame)+AJR25"
`flappable	AJ	"AJ"
`flat	AJ	"AJ"
`flatulent	AJ	"AJ"
`flawed	AJ	"N(`flaw)+AJR8"
`flaxen	AJ	"N(`flax)+AJR30"
`fleecy	AJ	"N(`fleece)+AJR14"
`fleet	AJ-to-V	"AJ"
`flimsy	AJ	"AJ"
`flippant	AJ	"AJ"
flir`tatious	AJ	"V(`flirt)+AJR21"
`floodlit	AJ	"AJ"
`floral	AJ	"N(`flower)+AJR17"
`florid	AJ	"AJ"
`fluent	AJ	"AJ"
`fluid	AJ	"AJ"
`fluvial	AJ	"AJ"
`focal	AJ	"AJ"
`foetal	AJ	"AJ" ;British
`foetid	AJ	"AJ" ;British
`folksy	AJ	"N(`folk)+PL+AJR14"
`fond	AJ	"AJ"
`foolhardy	AJ	"AJ"
`foolproof	AJ	"AJ"
`foreign	AJ	"AJ"
`foremost	AJ	"AJ"
fo`rensic	AJ_ic	"AJ"
for`ever	AJ	"AJ"
for`getful	AJ	"V(for`get)+AJR9"
for`going	AJ	"AJ"
for`lorn	AJ	"AJ"
`formal	AJ	"AJ"
for`midable	AJ	"AJ"
`forte	AJ	"AJ"
forth`coming	AJ	"AJ"
`forthright	AJ	"AJ"
for`tuitous	AJ	"AJ"
`fortunate	AJ-to-N	"N(`fortune)+AJR24"
`foul	AJ-to-V	"AJ"
`foulmouthed	AJ	"AJ(`foul)+N(`mouth)+AJR8"
`foursquare	AJ	"AJ"
`fractious	AJ	"AJ"
`fragile	AJ	"AJ"
`fragmentary	AJ	"N(`fragment)+AJR22"
`fragrant	AJ	"AJ"
`frail	AJ	"AJ"
`frank	AJ	"AJ"
`frantic	AJ_ic	"AJ"
fra`ternal	AJ	"AJ"
`fraudulent	AJ	"N(`fraud)+AJR27"
`fraught	AJ	"AJ"
`free	AJ-to-V	"AJ"
`freehand	AJ	"AJ"
`freelance	AJ-to-V	"AJ"
free`standing	AJ-to-V	"AJ"
fre`netic	AJ_ic	"AJ"
`frequent	AJ-to-V	"AJ"
`fresh	AJ	"AJ"
`freshwater	AJ	"AJ"
`frigid	AJ	"AJ"
`frisky	AJ	"AJ"
`frivolous	AJ	"AJ"
`frolicky	AJ	"V(`frolic)+AJR14"
`frolicsome	AJ	"V(`frolic)+AJR15"
`froward	AJ	"AJ"
`frowzy	AJ	"AJ"
`frugal	AJ	"AJ"
`fruited	AJ	"N(`fruit)+AJR8"
`fugal	AJ	"N(`fugue)+AJR17"
`full	AJ	"AJ"
full-`blooded	AJ	"AJ(`full)+N(`blood)+AJRR8"
full-`bodied	AJ	"AJ(`full)+N(`body)+AJRR8"
full-`fledged	AJ	"AJ(`full)+V(`fledge)+AJRR8"
`fulsome	AJ	"AJ"
funda`mental	AJ-to-N	"AJ"
fu`nereal	AJ	"N(`funeral)+AJR17"
`fungal	AJ	"N(`fungus)+AJR17"
`funny	AJ	"AJ"
`furtive	AJ	"AJ"
`fusiform	AJ	"AJ"
`fusty	AJ	"AJ"
`futile	AJ	"AJ"
`future	AJ-to-N	"AJ"

`gabled	AJ	"N(`gable)+AJR8"
ga`lactic	AJ_ic	"N(`galaxy)+AJR20"
`gallant	AJ	"AJ"
ga`lore	AJ	"AJ"
gal`vanic	AJ_ic	"AJ"
`gamesome	AJ	"N(`game)+AJR15"
`gamy	AJ	"N(`game)+AJR14"
`gangling	AJ	"AJ"
gar`gantuan	AJ	"AJ"
`garish	AJ	"AJ"
`garlicked	AJ	"N(`garlic)+AJR8"
`garlicky	AJ	"N(`garlic)+AJR14"
`garrulous	AJ	"AJ"
`gaseous	AJ	"AJ" ;exception to Gemination
`gastric	AJ_ic	"AJ"
gastroin`testinal	AJ	"AJ"
`gauche	AJ	"AJ"
`gaudy	AJ	"AJ"
`gaunt	AJ	"AJ"
`gauntleted	AJ	"N(`gauntlet)+AJR8"
`gawky	AJ	"AJ"
`gay	AJ-to-N	"AJ"
`gelable	AJ	"AJ" ;exception to Gemination
`geminate	AJ-to-V	"AJ"
`general	AJ	"AJ"
ge`neric	AJ_ic	"AJ"
`generous	AJ	"AJ"
;ge`netic	AJ_ic	"AJ"
`genial	AJ	"AJ"
`genital	AJ-to-N	"AJ"
`genitive	AJ	"AJ"
gen`teel	AJ	"AJ"
`gentle	AJ	"AJ"
`genuine	AJ	"AJ"
geo`desic	AJ_ic	"AJ"
geo`detic	AJ_ic	"AJ"
geri`atric	AJ_ic	"AJ"
ger`mane	AJ	"AJ"
`germinal	AJ	"N(`germ)+AJR17"
`ghastly	AJ	"AJ"
`gibbous	AJ	"AJ"
`giddy	AJ	"AJ"
`gifted	AJ	"N(`gift)+AJR8"
gi`gantic	AJ_ic	"AJ"
`gilt	AJ	"AJ"
`gimpy	AJ	"AJ"
`glacial	AJ	"N(`glacier)+AJR17"
`glad	AJ	"AJ"
`glandular	AJ	"N(`gland)+AJR31"
`glaucous	AJ	"AJ"
`glib	AJ	"AJ"
`globular	AJ	"N(`globe)+AJR31"
`glottal	AJ	"AJ"
`gloved	AJ	"N(`glove)+AJR8"
`gluier	AJ	"N(`glue)+AJR14+CMP"
`gluiest	AJ	"N(`glue)+AJR14+SPR"
`glum	AJ	"AJ"
`glutinous	AJ	"AJ"
`go-go	AJ	"AJ"
`golden	AJ	"N(`gold)+AJR30"
good`natured	AJ	"AJ(`good)+N(`nature)+AJR8"
`gorgeous	AJ	"AJ"
`gory	AJ	"AJ"
`gothic	AJ_ic	"AJ"
`gowned	AJ	"N(`gown)+AJR8"
`gracious	AJ	"N(`grace)+AJR21"
`gradual	AJ	"AJ"
`graduate	AJ-to-N	"AJ"
`grained	AJ	"N(`grain)+AJR8"
gram`matic	AJ_ic	"AJ"
`grand	AJ	"AJ"
gran`diloquent	AJ	"AJ"
grandi`ose	AJ	"AJ"
`granular	AJ	"N(`grain)+AJR31"
`graphic	AJ_ic	"AJ"
`grateful	AJ	"AJ"
gra`tuitous	AJ	"AJ"
`grave	AJ	"AJ"
`graven	AJ	"AJ"
`gravid	AJ	"AJ"
`greasy	AJ	"N(`grease)+AJR14"
`great	AJ	"AJ"
gre`garious	AJ	"AJ"
`grievous	AJ	"V(`grieve)+AJR21"
`grim	AJ	"AJ"
`grimy	AJ	"N(`grime)+AJR14"
`grisly	AJ	"AJ"
`grizzly	AJ	"AJ"
`groggy	AJ	"AJ"
`gross	AJ	"AJ"
gro`tesque	AJ	"AJ"
`grubby	AJ	"AJ"
`grudging	AJ	"AJ"
`gruesome	AJ	"AJ"
`gruff	AJ	"AJ"
guberna`torial	AJ	"AJ"
`gullible	AJ	"AJ"
`gutsy	AJ	"AJ"
`guttural	AJ	"AJ"

`habitable	AJ	"AJ"
`haggard	AJ	"AJ"
`halcyon	AJ	"AJ"
`hale	AJ	"AJ"
`half	AJ	"AJ"
half`hearted	AJ	"AJ(`half)+N(`heart)+AJR8"
half`way	AJ	"AJ"
`handed	AJ	"N(`hand)+AJR8"
hand`made	AJ	"AJ"
`handsome	AJ	"AJ"
`handy	AJ	"AJ"
hap`hazard	AJ	"AJ"
`hapless	AJ	"AJ"
`happy	AJ	"AJ"
`hard	AJ	"AJ"
hard`headed	AJ	"AJ(`hard)+N(`head)+AJR8"
hard`hearted	AJ	"AJ(`hard)+N(`heart)+AJR8"
hard`working	AJ	"AJ"
`hardy	AJ	"AJ"
`harelipped	AJ	"N(`harelip)+AJR8"
har`monic	AJ_ic	"N(`harmony)+AJR20"
`harsh	AJ	"AJ"
`hasty	AJ	"N(`haste)+AJR14"
`haughty	AJ	"AJ"
`hazy	AJ	"N(`haze)+AJR14"
`headed	AJ	"N(`head)+AJR8"
`headlong	AJ	"AJ/AV"
`headstrong	AJ	"AJ"
`heady	AJ	"AJ"
`heartbreaking	AJ	"AJ"
`heartbroken	AJ	"AJ"
`hearted	AJ	"N(`heart)+AJR8"
`heartfelt	AJ	"AJ"
`heartwarming	AJ	"AJ"
`hearty	AJ-to-N	"AJ"
`heavy	AJ	"AJ"
`hectic	AJ_ic	"AJ"
`hefty	AJ	"AJ"
hege`monic	AJ_ic	"N(he`gemony)+AJR20"
`heinous	AJ	"AJ"
`helical	AJ	"AJ"
`helmeted	AJ	"N(`helmet)+AJR8"
helter-`skelter	AJ	"AJ"
he`reditary	AJ	"N(he`redity)+AJR22"
`heritable	AJ	"AJ"
herme`neutic	AJ_ic	"AJ"
her`metic	AJ_ic	"AJ"
`hesitant	AJ	"V(`hesitate)+AJR27"
`heterodox	AJ	"AJ"
hetero`geneous	AJ	"AJ"
hetero`genous	AJ	"AJ"
hetero`sexual	AJ-to-N	"AJ"
hexa`decimal	AJ	"AJ"
`hideous	AJ	"AJ"
hier`atic	AJ_ic	"AJ"
hiero`glyphic	AJ_ic	"AJ"
hifa`lutin	AJ	"AJ"
`high	AJ-to-N	"AJ"
highfa`lutin	AJ	"AJ"
high`handed	AJ	"AJ(`high)+N(`hand)+AJR8"
hi`larious	AJ	"AJ"
`hind	AJ	"AJ"
`hinder	AJ	"AJ"
hir`sute	AJ	"AJ"
his`toric	AJ_ic	"N(`history)+AJR20"
histri`onic	AJ_ic	"AJ"
`hoarse	AJ	"AJ"
`hoary	AJ	"AJ"
`hollow	AJ-to-V	"AJ"
`holy	AJ	"AJ"
`homebound	AJ	"AJ"
home`made	AJ	"AJ"
homeo`pathic	AJ_ic	"AJ"
`homesick	AJ	"AJ"
homo`geneous	AJ	"AJ"
homo`sexual	AJ-to-N	"AJ"
`homy	AJ	"N(`home)+AJR14"
`honest	AJ	"AJ"
`honorary	AJ	"N(`honor)+AJR22"
hono`rific	AJ_ic	"AJ"
hori`zontal	AJ	"AJ"
`horned	AJ	"N(`horn)+AJR8"
hor`rendous	AJ	"AJ"
`horrible	AJ	"AJ"
`horrid	AJ	"AJ"
`horsy	AJ	"N(`horse)+AJR14"
hos`pitable	AJ	"AJ"
`hostile	AJ	"AJ"
`hot	AJ	"AJ"
hot`tempered	AJ	"AJ(`hot)+N(`temper)+AJR8"
`hued	AJ	"N(`hue)+AJR8"
`huffy	AJ	"AJ"
`huge	AJ	"AJ"
hu`mane	AJ	"AJ"
`humble	AJ-to-V	"AJ"
`humpbacked	AJ	"N(`humpback)+AJR8"
`humped	AJ	"N(`hump)+AJR8"
`humid	AJ	"AJ"
`hunchbacked	AJ	"N(`hunchback)+AJR8"
`hungry	AJ	"N(`hunger)+AJR14"
`husky	AJ	"AJ"
hy`draulic	AJ_ic	"AJ"
`hydro	AJ	"AJ"
hydro`chloric	AJ_ic	"AJ"
hydro`dynamic	AJ_ic	"AJ"
hydro`electric	AJ_ic	"AJ"
hydro`philic	AJ_ic	"AJ"
hydro`phobic	AJ_ic	"N(hydro`phobia)+AJR20"
hydro`static	AJ_ic	"AJ"
hydro`thermal	AJ	"AJ"
hyper`bolic	AJ_ic	"N(hy`perbole)+AJ20"
hyp`notic	AJ_ic	"AJ"
hypo`active	AJ	"AJ"
hypo`chondriac	AJ-to-N	"N(hypo`chondria)+AJR20"
hypo`dermic	AJ_ic	"AJ"
hypo`thetic	AJ_ic	"AJ"
hypo`thyroid	AJ	"AJ"
hys`teric	AJ_ic	"AJ"

i`ambic	AJ_ic	"AJ"
`icy	AJ	"N(`ice)+AJR14"
i`deal	AJ-to-N	"AJ"
i`dentical	AJ	"AJ"
idio`matic	AJ_ic	"AJ"
idiosyn`cratic	AJ_ic	"AJ"
`idle	AJ-to-V	"AJ"
i`dolatrous	AJ	"N(i`dolatry)+AJR21"
`iffy	AJ	"AJ"
`igneous	AJ	"AJ"
ig`noble	AJ	"AJ"
`ignorant	AJ	"AJ"
`ill	AJ-to-N	"AJ"
;il`legal	AJ	"AJ"
;il`legible	AJ	"AJ"
;ille`gitimate	AJ	"AJ"
il`licit	AJ	"AJ"
;il`limitable	AJ	"AJ"
;il`literate	AJ	"AJ"
il`lusionary	AJ	"N(il`lusion)+AJR22"
il`lusory	AJ	"AJ"
il`lustrious	AJ	"AJ"
i`maginary	AJ	"V(i`magine)+AJR22"
i`maginative	AJ	"V(i`magine)+AJR26"
`imitable	AJ	"V(`imitate)+AJR25"
im`maculate	AJ	"AJ"
`immanent	AJ	"AJ"
;imma`terial	AJ	"AJ"
;imma`ture	AJ	"AJ"
;im`measurable	AJ	"AJ"
im`mediate	AJ	"AJ"
imme`morial	AJ	"AJ"
im`mense	AJ	"AJ"
`imminent	AJ	"AJ"
;im`miscible	AJ	"AJ"
im`mitigable	AJ	"AJ"
;im`mobile	AJ	"AJ"
;im`moderate	AJ	"AJ"
;im`modest	AJ	"AJ"
;im`moral	AJ	"AJ"
;im`mortal	AJ	"AJ"
;im`movable	AJ	"AJ"
im`mune	AJ	"AJ"
;im`mutable	AJ	"AJ"
;im`palpable	AJ	"AJ"
;im`partial	AJ	"AJ"
im`passable	AJ	"AJ"
;im`patient	AJ	"AJ"
im`peccable	AJ	"AJ"
;im`penetrable	AJ	"AJ"
im`perative	AJ	"AJ"
;imper`ceivable	AJ	"AJ"
;imper`ceptible	AJ	"AJ"
;im`perfect	AJ	"AJ"
im`perial	AJ	"AJ"
im`perious	AJ	"AJ"
;im`perishable	AJ	"AJ"
;im`permeable	AJ	"AJ"
;imper`missible	AJ	"AJ"
;im`personal	AJ	"AJ"
;im`pertinent	AJ	"AJ"
;imper`turbable	AJ	"AJ"
;im`pervious	AJ	"AJ"
im`petuous	AJ	"AJ"
;im`pious	AJ	"AJ"
im`placable	AJ	"NEG2+V(`placate)+AJR25"
;im`plausible	AJ	"AJ"
im`plicit	AJ	"AJ"
im`plosive	AJ	"V(im`plode)+AJR26"
;impo`lite	AJ	"AJ"
;im`politic	AJ	"AJ"
;im`ponderable	AJ	"AJ"
;im`portant	AJ	"AJ"
im`portunate	AJ	"AJ"
;im`possible	AJ	"AJ"
;`impotent	AJ	"AJ"
;im`practicable	AJ	"AJ"
;im`practical	AJ	"AJ"
;impre`cise	AJ	"AJ"
im`pregnable	AJ	"AJ"
im`pressionable	AJ	"V(im`press)+NR23+AJR25"
;im`probable	AJ	"AJ"
im`promptu	AJ	"AJ"
;im`proper	AJ	"AJ"
;im`provident	AJ	"AJ"
;im`prudent	AJ	"AJ"
`impudent	AJ	"AJ"
;im`pulsive	AJ	"AJ"
;im`pure	AJ	"AJ"
inad`vertent	AJ	"AJ"
in`ane	AJ	"AJ"
in`augural	AJ	"AJ"
`inboard	AJ	"AJ"
`inborn	AJ	"AJ"
in`carnate	AJ-to-V	"AJ"
in`cendiary	AJ	"AJ"
in`cessant	AJ	"AJ"
in`cestuous	AJ	"N(`incest)+AJR21"
in`cipient	AJ	"AJ"
in`cisive	AJ	"AJ"
in`clusive	AJ	"V(in`clude)+AJR26"
incommunicado	AJ	"AJ"
in`corporable	AJ	"V(in`corporate)+AJR25"
in`cumbent	AJ-to-N	"AJ"
in`debted	AJ	"VR1+N(`debt)+AJR8"
inde`fatigable	AJ	"NEG2+REV2+N(fa`tigue)+AJR25"
in`delible	AJ	"AJ"
`indigent	AJ	"AJ"
in`dignant	AJ	"AJ"
`indigo	AJ-to-N	"AJ"
indi`vidual	AJ-to-N	"AJ"
`indolent	AJ	"AJ"
in`domitable	AJ	"AJ"
in`door	AJ	"AJ"
ine`luctable	AJ	"AJ"
in`ept	AJ	"AJ"
in`ert	AJ	"AJ"
in`ertial	AJ	"N(in`ertia)+AJR17"
in`exorable	AJ	"AJ"
`infamous	AJ	"AJ"
`infantile	AJ	"N(`infant)+AJR39"
in`fectious	AJ	"V(in`fect)+AJR21"
in`ferable	AJ	"V(in`fer)+AJR25"
infe`rential	AJ	"V(in`fer)+NR26+AJR17"
in`ferior	AJ-to-N	"AJ"
in`fernal	AJ	"AJ"
infini`tesimal	AJ	"AJ"
in`firm	AJ	"AJ"
in`flammable	AJ	"V(in`flame)+AJR25"
in`flammatory	AJ	"V(in`flame)+AJR28"
in`flationary	AJ	"V(in`flate)+NR23+AJR22"
influ`ential	AJ	"V(in`fluence)+AJR17"
infra`red	AJ	"AJ"
in`genious	AJ	"AJ"
in`genuous	AJ	"AJ"
in`grown	AJ	"AJ"
in`holding	AJ	"AJ"
in`junctive	AJ	"AJ"
i`nimical	AJ	"AJ"
in`iquitous	AJ	"N(i`niquity)+AJR21"
in`itial	AJ	"AJ"
`inlaid	AJ	"AJ"
`inland	AJ	"AJ"
`inmost	AJ	"AJ"
in`nate	AJ	"AJ"
`inner	AJ	"AJ"
`innocent	AJ-to-N	"AJ"
in`nocuous	AJ	"AJ"
in`quisitive	AJ	"V(in`quire)+AJR26"
in`ordinate	AJ	"AJ"
in`scrutable	AJ	"AJ"
in`shore	AJ	"AJ"
in`side	AJ	"AJ"
in`sidious	AJ	"AJ"
in`sipid	AJ	"AJ"
`insolent	AJ	"AJ"
in`souciant	AJ	"AJ"
instan`taneous	AJ	"AJ"
in`stinctive	AJ	"N(`instinct)+AJR26"
`insular	AJ	"AJ"
in`superable	AJ	"AJ"
in`surgent	AJ-to-N	"AJ"
in`tact	AJ	"AJ"
`integrable	AJ	"V(`integrate)+AJR25"
`integral	AJ	"AJ"
in`telligent	AJ	"AJ"
in`telligible	AJ	"AJ"
in`tense	AJ	"AJ"
in`tensive	AJ	"AJ(in`tense)+AJR26"
in`tent	AJ	"AJ"
in`terior	AJ	"AJ"
in`ternal	AJ	"AJ"
inter`mediate	AJ	"AJ"
inter`necine	AJ	"AJ"
in`terpolatory	AJ	"AJ"
inter`rogatory	AJ	"AJ"
inter`stitial	AJ	"N(`interstice)+AJR17"
in`testate	AJ	"AJ"
`intimate	AJ	"AJ"
in`trepid	AJ	"AJ"
in`transigent	AJ	"AJ"
`intricate	AJ	"AJ"
in`trinsic	AJ_ic	"AJ"
intro`ductory	AJ	"V(intro`duce)+AJR28"
in`trusive	AJ	"V(in`trude)+AJR26"
in`variant	AJ	"AJ"
in`vasive	AJ	"V(in`vade)+AJR26"
in`verse	AJ	"AJ"
in`veterate	AJ	"AJ"
in`vidious	AJ	"AJ"
in`violate	AJ	"AJ"
`involute	AJ	"AJ"
i`rascible	AJ	"AJ"
i`rate	AJ	"AJ"
`irksome	AJ	"V(`irk)+AJR15"
i`ronic	AJ	"N(`irony)+AJR20"
;ir`rational	AJ	"AJ"
;irre`claimable	AJ	"AJ"
;irrecon`cilable	AJ	"AJ"
;irre`coverable	AJ	"AJ"
;irre`deemable	AJ	"AJ"
;irre`ducible	AJ	"AJ"
;irre`futable	AJ	"AJ"
;ir`regular	AJ	"AJ"
;ir`relevant	AJ	"AJ"
;irre`mediable	AJ	"AJ"
;irre`movable	AJ	"AJ"
;ir`reparable	AJ	"AJ"
;irre`placeable	AJ	"AJ"
;irre`pressible	AJ	"AJ"
;irre`proachable	AJ	"AJ"
;irrepro`ducible	AJ	"AJ"
;irre`sistible	AJ	"AJ"
;ir`resolute	AJ	"AJ"
;irre`solvable	AJ	"AJ"
;irre`spective	AJ	"AJ"
;irre`sponsible	AJ	"AJ"
;irre`trievable	AJ	"AJ"
;ir`reverent	AJ	"AJ"
;irre`versible	AJ	"AJ"
;ir`revocable	AJ	"AJ"
`irritable	AJ	"V(`irritate)+AJR25"
`issuant	AJ	"V(`issue)+AJR27"
i`talic	AJ_ic	"AJ"
i`tinerant	AJ	"V(i`tinerate)+AJR27"

`jaunty	AJ	"AJ"
`jawed	AJ	"N(`jaw)+AJR8"
`jealous	AJ	"AJ"
je`june	AJ	"AJ"
`jerky	AJ	"V(`jerk)+AJR14"
`jeweled	AJ	"N(`jewel)+AJR8"
`jewelled	AJ	"N(`jewel)+AJR8"
jo`cose	AJ	"AJ"
`jocular	AJ	"AJ"
`jocund	AJ	"AJ"
`jointed	AJ	"N(`joint)+AJR8"
`jolly	AJ	"AJ"
`jovial	AJ	"AJ"
`jowled	AJ	"N(`jowl)+AJR8"
`jubilant	AJ	"AJ"
judg`matic	AJ_ic	"AJ"
ju`dicial	AJ	"AJ"
ju`dicious	AJ	"AJ"
`jugate	AJ	"AJ"
`juicy	AJ	"N(`juice)+AJR14"
`jumbo	AJ	"AJ"
`junior	AJ	"AJ"
ju`ridical	AJ	"AJ"
jurispru`dential	AJ	"N(juris`prudence)+AJR17"
`just	AJ	"AJ"
jus`ticiable	AJ	"AJ"
`juvenile	AJ-to-N	"AJ"

`keen	AJ	"AJ"
`keyed	AJ	"N(`key)+AJR8"
`kind	AJ	"AJ"
kind`hearted	AJ	"AJ(`kind)+N(`heart)+AJR8"
`kindly	AJ	"AJ(`kind)+AJR13"
ki`netic	AJ_ic	"AJ"
`knobbed	AJ	"N(`knob)+AJR8"
`knockdown	AJ	"AJ"
`knowledgeable	AJ	"N(`knowledge)+AJR25"
`knurled	AJ	"N(`knurl)+AJR8"
`kosher	AJ	"AJ"

`labial	AJ-to-N	"AJ"
`labile	AJ	"AJ"
la`borious	AJ	"N(`labor)+AJR21"
lacka`daisic	AJ_ic	"AJ"
`lackluster	AJ	"AJ"
la`conic	AJ_ic	"AJ"
`laden	AJ	"V(`lade)+AJR30"
`lame	AJ	"AJ"
`languid	AJ	"AJ"
`lank	AJ	"AJ"
`lanky	AJ	"AJ"
la`pelled	AJ	"N(la`pel)+AJR8"
`large	AJ	"AJ"
`larval	AJ	"N(`larva)+AJR17"
la`ryngeal	AJ	"N(`larynx)+AJR17"
las`civious	AJ	"AJ"
`late	AJ	"AJ/AV"
`latent	AJ	"AJ"
`lateral	AJ	"AJ"
`latinate	AJ	"N(`latin)+AJR24"
latitudinal	AJ	"N(`latitude)+AJR17"
lati`tudinary	AJ	"N(`latitude)+AJR22"
`latter	AJ	"AJ"
`laudatory	AJ	"V(`laud)+AJR28"
`lavish	AJ-to-V	"AJ"
`lax	AJ	"AJ"
`laxative	AJ-to-N	"AJ"
`lazy	AJ	"AJ"
`leaden	AJ	"N(`lead)+AJR30"
`lean	AJ	"AJ"
`leathern	AJ	"AJ"
`leery	AJ	"AJ"
`left	AJ-to-N	"AJ"
`lefthand	AJ	"AJ"
`left-hand	AJ	"AJ"
left`handed	AJ	"AJ(`left)+N(`hand)+AJR8"
`leftover	AJ-to-N	"AJ"
`legal	AJ	"AJ"
le`gato	AJ	"AJ"
`legendary	AJ	"N(`legend)+AJR22"
`legged	AJ	"N(`leg)+AJR8"
`legible	AJ	"AJ"
le`gitimate	AJ	"AJ"
le`guminous	AJ	"N(`legume)+AJR21"
`lenient	AJ	"AJ"
len`ticular	AJ	"AJ"
`leonine	AJ	"N(`lion)+AJR38"
`lesbian	AJ-to-N	"AJ"
`lethal	AJ	"AJ"
le`thargic	AJ_ic	"N(`lethargy)+AJR20"
`level	AJ-to-V	"AJ"
`lewd	AJ	"AJ"
`lexical	AJ	"AJ"
`liable	AJ	"AJ"
`liberal	AJ-to-N	"AJ"
li`bidinous	AJ	"N(li`bido)+AJR21"
li`centious	AJ	"AJ"
`lifelong	AJ	"AJ"
`light	AJ	"AJ" ;not heavy/dark
light`hearted	AJ	"AJ(`light)+N(`heart)+AJR8"
`lightproof	AJ	"AJ"
`lightweight	AJ	"AJ"
`like	AJ	"AJ"
`likely	AJ	"AJ"
`limber	AJ-to-V	"AJ"
`limbic	AJ_ic	"AJ"
`limp	AJ	"AJ"
`limpid	AJ	"AJ"
`lineal	AJ	"AJ"
`linear	AJ	"AJ"
`lingual	AJ	"AJ"
;lin`guistic	AJ_ic	"AJ"
`liquid	AJ-to-N	"AJ"
`lite	AJ	"AJ"
`literal	AJ	"AJ"
`literary	AJ	"AJ"
`literate	AJ	"AJ"
`lithe	AJ	"AJ"
`litigious	AJ	"AJ"
`little	AJ	"AJ"
li`turgic	AJ_ic	"AJ"
`live	AJ	"AJ"
`livelong	AJ	"AJ"
`lively	AJ	"AJ(`live)+AJR13"
`livid	AJ	"AJ"
`loath	AJ	"AJ"
`loathsome	AJ	"V(`loath)+AJR15"
`local	AJ-to-N	"AJ"
`lofty	AJ	"AJ"
lo`gistic	AJ_ic	"AJ"
`lone	AJ	"AJ"
`lonely	AJ	"AJ"
`lonesome	AJ	"AJ"
`long	AJ	"AJ"
longi`tudinal	AJ	"N(`longitude)+AJR17"
long`standing	AJ	"AJ"
long`suffering	AJ	"AJ"
`longtime	AJ	"AJ"
`loose	AJ-to-V	"AJ"
`loose-leaf	AJ	"AJ"
lop`sided	AJ	"AJ"
lo`quacious	AJ	"AJ"
`loud	AJ	"AJ/AV"
`lousy	AJ	"N(`louse)+AJR14"
`lovelorn	AJ	"AJ"
`low	AJ	"AJ"
`lowercase	AJ	"AJ"
`lowering	AJ	"AJ" ;gloomy
`lowermost	AJ	"AJ(`low)+CMP+AJR33"
`lowly	AJ	"AJ(`low)+AJR13"
`loyal	AJ	"AJ"
lu`bricious	AJ	"AJ"
`lucid	AJ	"AJ"
`lucrative	AJ	"AJ"
`ludicrous	AJ	"AJ"
luke`warm	AJ	"AJ"
`lumbar	AJ	"AJ"
lumi`nescent	AJ	"AJ"
`luminous	AJ	"AJ"
`lunar	AJ	"AJ"
`lupine	AJ	"AJ"
`lurid	AJ	"AJ"
`luscious	AJ	"AJ"
`lush	AJ	"AJ"
`lustrous	AJ	"N(`luster)+AJR21"
lux`uriant	AJ	"N(`luxury)+AJR27"
`lyric	AJ_ic	"AJ"

ma`cabre	AJ	"AJ"
`macho	AJ	"AJ"
`mad	AJ	"AJ"
`madcap	AJ	"AJ"
magis`terial	AJ	"AJ"
mag`nanimous	AJ	"AJ"
mag`nificent	AJ	"AJ"
mag`niloquent	AJ	"AJ"
`main	AJ	"AJ"
`mainline	AJ-to-N	"AJ"
ma`jestic	AJ_ic	"N(`majesty)+AJR20"
`major	AJ-to-N-V	"AJ"
`makeshift	AJ	"AJ"
;maladaptive	AJ	"AJ"
;`maladroit	AJ	"AJ"
ma`larial	AJ	"N(ma`laria)+AJR17"
`male	AJ-to-N	"AJ"
ma`levolent	AJ	"AJ"
;malformed	AJ	"AJ"
ma`licious	AJ	"N(`malice)+AJR21"
;malignant	AJ	"AJ"
`malleable	AJ	"AJ"
;malnourished	AJ	"AJ"
`mammoth	AJ	"AJ"
`mandatory	AJ	"AJ"
`maned	AJ	"N(`mane)+AJR8"
`mangy	AJ	"N(`mange)+AJR14"
`manic	AJ_ic	"AJ"
`manifest	AJ-to-V	"AJ"
`manifold	AJ	"AJ"
ma`nipulable	AJ	"V(ma`nipulate)+AJR25"
`mannered	AJ	"N(`manner)+AJR8"
`mantic	AJ_ic	"AJ"
`manual	AJ	"AJ"
ma`rine	AJ	"AJ"
`marital	AJ	"AJ"
`maritime	AJ	"AJ"
`marriageable	AJ	"N(`marriage)+AJR25"
`martial	AJ	"AJ"
`masculine	AJ	"AJ"
`massive	AJ	"AJ"
ma`ternal	AJ	"AJ"
matri`lineal	AJ	"AJ"
mathe`matic	AJ_ic	"AJ"
ma`ture	AJ-to-V	"AJ"
`maudlin	AJ	"AJ"
`mawkish	AJ	"AJ"
`maximal	AJ	"AJ"
`meager	AJ	"AJ"
`meagre	AJ	"AJ" ;British
`mealy	AJ	"AJ"
`mean	AJ	"AJ"
`measly	AJ	"AJ"
`meddlesome	AJ	"V(`meddle)+AJR15"
`medial	AJ-to-N	"AJ"
medi`ocre	AJ	"AJ"
`medium	AJ	"AJ"
me`diaeval	AJ	"AJ"
me`dieval	AJ	"AJ"
`meek	AJ	"AJ"
`mellow	AJ-to-V	"AJ"
me`lodic	AJ_ic	"N(`melody)+AJR20"
melodra`matic	AJ_ic	"AJ"
`memorable	AJ	"AJ"
men`dacious	AJ	"AJ"
`menial	AJ	"AJ"
`mensurable	AJ	"AJ"
`menstrual	AJ	"AJ"
`mental	AJ	"AJ"
`mercantile	AJ	"AJ"
mer`curic	AJ_ic	"N(`mercury)+AJR20"
`mere	AJ	"AJ"
mere`tricious	AJ	"AJ"
me`ridional	AJ	"AJ"
meri`torious	AJ	"V(`merit)+AJR21"
`merry	AJ	"AJ"
`mesmeric	AJ_ic	"AJ"
meta`bolic	AJ_ic	"AJ"
meta`morphic	AJ_ic	"AJ"
;meta`physical	AJ	"DEG18+AJ(`physical)"
me`ticulous	AJ	"AJ"
`metro	AJ	"AJ"
metro`politan	AJ	"AJ"
`mettlesome	AJ	"N(`mettle)+AJR15"
`mezzo	AJ	"AJ"
mi`asmal	AJ	"N(mi`asma)+AJR17"
`micro	AJ	"AJ"
`mid	AJ	"AJ"
`middling	AJ	"AJ/AV"
`mild	AJ	"AJ"
`militant	AJ-to-N	"AJ"
`militarily	AJ	"N(`military)+AJR13"
mi`metic	AJ_ic	"AJ"
`mini	AJ	"AJ"
`miniature	AJ-to-N	"AJ"
`minimal	AJ	"AJ"
`minor	AJ-to-N	"AJ"
`minuscule	AJ	"AJ"
mi`nute	AJ	"AJ"
mi`raculous	AJ	"N(`miracle)+AJR21"
miscellaneous	AJ	"N(`miscellany)+AJR21"
mis`chievous	AJ	"N(`mischief)+AJR21"
`miscible	AJ	"AJ"
`miserable	AJ	"AJ"
mis`shapen	AJ	"PEJ2+N(`shape).VR0+PTC"
mne`monic	AJ_ic	"AJ"
`mobile	AJ	"AJ"
`moderate	AJ-to-V	"AJ"
`modern	AJ-to-N	"AJ"
`modest	AJ	"AJ"
`modish	AJ	"AJ"
`modular	AJ	"N(`module)+AJR31"
`moist	AJ	"AJ"
`molal	AJ	"AJ"
`molar	AJ	"AJ"
mo`lecular	AJ	"N(`molecule)+AJR31"
`molten	AJ	"V(`melt)+AJR30"
`momentary	AJ	"N(`moment)+AJR22"
mo`mentous	AJ	"AJ"
mo`nastic	AJ_ic	"AJ"
mon`aural	AJ	"AJ"
mone`tarily	AJ	"N(`monetary)+AJR13"
`moneyed	AJ	"N(`money)+AJR8"
`monied	AJ	"N(`money)+AJR8"
`monitory	AJ	"AJ"
mo`nocular	AJ	"AJ"
mo`notonous	AJ	"N(`monotone)+AJR21"
`monstrous	AJ	"N(`monster)+AJR21"
`moonlit	AJ	"AJ"
`moot	AJ	"AJ"
`moral	AJ-to-N	"AJ"
`morbid	AJ	"AJ"
`moribund	AJ	"AJ"
mo`rose	AJ	"AJ"
morpho`tactic	AJ_ic	"AJ"
`mortal	AJ-to-N	"AJ"
`motley	AJ	"AJ"
`mournful	AJ	"V(`mourn)+AJR9"
`mousy	AJ	"N(`mouse)+AJR14"
`mouthed	AJ	"N(`mouth)+AJR8"
muddle`headed	AJ	"V(`muddle)+N(`head)+AJR8"
`muggy	AJ	"AJ"
multi`farious	AJ	"AJ"
`multiple	AJ-to-N	"AJ"
multi`tudinous	AJ	"N(`multitude)+AJR21"
`mum	AJ	"AJ"
mun`dane	AJ	"AJ"
mu`nicipal	AJ	"AJ"
mu`nificent	AJ	"AJ"
`muscled	AJ	"N(`muscle)+AJR8"
`muscular	AJ	"N(`muscle)+AJR31"
`mustached	AJ	"N(`mustache)+AJR8"
`musty	AJ	"AJ"
`mutable	AJ	"AJ"
`mutant	AJ	"V(`mutate)+AJR27"
`mute	AJ	"AJ"
`muted	AJ	"AJ"
`mutinous	AJ	"N(`mutiny)+AJR21"
`mutual	AJ	"AJ"
my`opic	AJ_ic	"N(my`opia)+AJR20"
`mystic	AJ_ic	"AJ"

na`ive	AJ	"AJ"
`naked	AJ	"AJ"
namby-`pamby	AJ	"AJ"
`narrow	AJ-to-V	"AJ"
`nary	AJ	"AJ"
`nasal	AJ-to-N	"AJ"
`nascent	AJ	"AJ"
`nasty	AJ	"AJ"
`natal	AJ	"AJ"
`nationwide	AJ	"AJ"
`native	AJ-to-N	"AJ"
`natty	AJ	"AJ"
`natural	AJ	"AJ"
`natured	AJ	"N(`nature)+AJR8"
`naughty	AJ	"AJ"
`nauseous	AJ	"N(`nausea)+AJR21"
`nautical	AJ	"AJ"
`naval	AJ	"AJ"
`navigable	AJ	"V(`navigate)+AJR25"
ne`anderthal	AJ-to-N	"AJ"
`neap	AJ	"AJ"
`near	AJ-to-V	"AJ"
near`by	AJ	"AJ"
`nearsighted	AJ	"AJ(`near)+N(`sight)+AJR8"
`neat	AJ	"AJ"
`nebular	AJ	"N(`nebula)+AJR31"
`nebulous	AJ	"AJ"
`necessary	AJ	"AJ"
necro`mantic	AJ_ic	"AJ"
ne`crotic	AJ_ic	"AJ"
`nee	AJ	"AJ"
`negligent	AJ	"AJ"
`negligible	AJ	"AJ"
ne`gotiable	AJ	"V(ne`gotiate)+AJR25"
`nervy	AJ	"N(`nerve)+AJR14"
`nether	AJ	"AJ"
`nettlesome	AJ	"N(`nettle)+AJR15"
`neural	AJ	"AJ"
neurolin`guistic	AJ_ic	"AJ"
neuro`muscular	AJ	"AJ"
neu`rotic	AJ_ic	"AJ"
`neuter	AJ	"AJ"
`neutral	AJ	"AJ"
never-`ending	AJ	"AJ"
`new	AJ	"AJ"
new`born	AJ-to-N	"AJ"
new`fangled	AJ	"AJ"
new`found	AJ	"AJ"
`nice	AJ	"AJ"
`nifty	AJ	"AJ"
`nigh	AJ	"AJ/AV"
`nimble	AJ	"AJ"
`noble	AJ-to-N	"AJ"
noc`turnal	AJ	"AJ"
`nodular	AJ	"N(`nodule)+AJR31"
`noisome	AJ	"AJ"
`noisy	AJ	"N(`noise)+AJR14"
`nominal	AJ-to-N	"AJ"
noncha`lant	AJ	"AJ"
nondes`cript	AJ-to-N	"AJ"
`normative	AJ	"N(`norm)+AJR26"
`northbound	AJ	"AJ"
north`easterly	AJ	"AJ/AV"
north`eastern	AJ	"AJ"
`northerly	AJ	"AJ/AV"
`northern	AJ	"AJ"
north`westerly	AJ	"AJ/AV"
north`western	AJ	"AJ"
`nosed	AJ	"N(`nose)+AJR8"
nos`talgic	AJ_ic	"N(nos`talgia)+AJR20"
`nosy	AJ	"N(`nose)+AJR14"
no`torious	AJ	"AJ"
nou`veau	AJ	"AJ"
`novel	AJ	"AJ"
`noxious	AJ	"AJ"
`nuanced	AJ	"N(`nuance)+AJR8"
`nubile	AJ	"AJ"
`nuclear	AJ	"AJ"
`nude	AJ	"AJ"
`nugatory	AJ	"AJ"
`null	AJ-to-N	"AJ"
`numb	AJ-to-V	"AJ"
`numerable	AJ	"V(`numerate)+AJR25"
nu`meric	AJ_ic	"AJ(nu`meric)+AJR20"
`numerous	AJ	"AJ"
`numinous	AJ	"AJ"
numis`matic	AJ_ic	"AJ"
`nuptial	AJ-to-N	"AJ"
nu`tritious	AJ	"AJ"

`oaken	AJ	"N(`oak)+AJR30"
`obdurate	AJ	"AJ"
o`bedient	AJ	"V(o`bey)+AJR27"
o`beisant	AJ	"AJ"
o`bese	AJ	"AJ"
ob`jective	AJ	"AJ"
ob`jectionable	AJ	"V(ob`ject)+NR23+AJR25"
ob`lique	AJ	"AJ"
ob`livious	AJ	"AJ"
`oblong	AJ	"AJ"
ob`noxious	AJ	"AJ"
ob`scene	AJ	"AJ"
ob`scure	AJ-to-V	"AJ"
ob`sequious	AJ	"AJ"
ob`servant	AJ	"V(ob`serve)+AJR27"
obso`lescent	AJ	"AJ"
obso`lete	AJ	"AJ"
ob`stetric	AJ_ic	"AJ"
`obstinate	AJ	"AJ"
ob`streperous	AJ	"AJ"
ob`trusive	AJ	"V(ob`trude)+AJR26"
ob`tuse	AJ	"AJ"
`obverse	AJ	"AJ"
`obvious	AJ	"AJ"
oc`clusive	AJ-to-N	"V(oc`clude)+AJR26"
oc`cult	AJ-to-N	"AJ"
octa`hedral	AJ	"N(octa`hedron)+AJR17"
`octal	AJ	"AJ"
oc`tennial	AJ	"AJ"
`ocular	AJ	"AJ"
`odd	AJ	"AJ"
`odious	AJ	"AJ"
odor`iferous	AJ	"N(`odor)+AJR21"
off`beat	AJ	"AJ"
of`fensive	AJ	"V(of`fend)+AJR26"
offhand	AJ	"AJ"
of`ficious	AJ	"N(`office)+AJR21"
off`shore	AJ	"AJ"
off`stage	AJ	"AJ"
`ok	AJ-to-V	"AJ"
o`kay	AJ-to-V	"AJ"
`old	AJ	"AJ"
`olden	AJ	"AJ+AJR30"
ol`factory	AJ	"AJ"
o`lympic	AJ_ic	"AJ"
o`lympian	AJ-to-N	"AJ"
`ominous	AJ	"AJ"
om`nipotent	AJ	"AJ"
`omnipresent	AJ	"AJ"
om`niscient	AJ	"AJ"
`oncoming	AJ	"AJ"
`onerous	AJ	"AJ"
`onetime	AJ	"AJ"
`ongoing	AJ	"AJ"
`only	AJ	"AJ/AV/CJ"
onomato`poeic	AJ_ic	"N(onomato`poeia)+AJR20"
onomatopo`etic	AJ_ic	"N(onomato`poeia)+AJR20"
`onrushing	AJ	"AJ"
`oozy	AJ	"N(`ooze)+AJR14"
opa`lescent	AJ	"AJ"
o`paque	AJ	"AJ"
`open	AJ-to-V	"AJ"
`operable	AJ	"V(`operate)+AJR25"
`operant	AJ	"AJ"
oper`atic	AJ_ic	"N(`opera)+AJR20"
o`pinionated	AJ	"N(o`pinion)+VR3+AJR8"
oppor`tune	AJ	"AJ"
`opposite	AJ-to-N	"AJ"
op`probrious	AJ	"AJ"
`optative	AJ-to-N	"AJ"
`optic	AJ_ic	"AJ"
`optimal	AJ	"N(`optimum)+AJR17"
;opti`mistic	AJ	"AJ"
`opulent	AJ	"AJ"
o`racular	AJ	"N(`oracle)+AJR31"
`oral	AJ	"AJ"
`orangy	AJ	"N(`orange)+AJR14"
;ora`torical	AJ	"AJ"
or`chestral	AJ	"N(`orchestra)+AJR17"
`ordinal	AJ-to-N	"AJ"
`ordinary	AJ	"AJ"
orgi`astic	AJ_ic	"N(`orgy)+AJR20"
`ornamented	AJ	"N(`ornament)+AJR8"
or`nate	AJ	"AJ"
`ornery	AJ	"AJ"
ortho`dontic	AJ_ic	"AJ"
`orthodox	AJ	"AJ"
or`thogonal	AJ	"AJ"
ortho`paedic	AJ_ic	"AJ"
ortho`pedic	AJ_ic	"AJ"
os`motic	AJ_ic	"N(os`mosis)+AJR20"
`osseous	AJ	"AJ"
os`tensible	AJ	"AJ"
osten`tatious	AJ	"AJ"
`outer	AJ	"AJ"
out`door	AJ	"AJ"
out`doors	AJ	"AJ/AV"
out`landish	AJ	"AJ"
out`moded	AJ	"DEG6+N(`mode)+AJR8"
`outright	AJ	"AJ/AV"
`oval	AJ-to-N	"AJ"
`ovate	AJ	"AJ"
`overmuch	AJ	"AJ/AV"
o`vert	AJ	"AJ"

pa`cific	AJ_ic	"AJ"
`painstaking	AJ	"AJ"
`palatable	AJ	"N(`palate)+AJR25"
`pale	AJ-to-V	"AJ"
paleo`lithic	AJ_ic	"AJ"
paleo`zoic	AJ_ic	"AJ"
`pallid	AJ	"AJ"
`palpable	AJ	"AJ"
`paltry	AJ	"AJ"
pancre`atic	AJ_ic	"AJ"
pan`demic	AJ_ic	"AJ"
`panicky	AJ	"N(`panic)+AJR14"
pano`ramic	AJ_ic	"N(pano`rama)+AJR20"
`paperbound	AJ	"AJ"
`papillary	AJ	"AJ"
para`bolic	AJ_ic	"N(pa`rabola)+AJR20"
paradig`matic	AJ_ic	"N(`paradigm)+AJR20"
`parallel	AJ-to-V	"AJ"
para`lytic	AJ_ic	"AJ"
`paramount	AJ	"AJ"
para`noiac	AJ	"AJ"
`paranoid	AJ-to-N	"AJ"
para`plegic	AJ_ic	"AJ"
paren`thetic	AJ_ic	"AJ"
parlia`mentary	AJ	"N(`parliament)+AJR22"
pa`rochial	AJ	"N(`parish)+AJR17"
par`ticular	AJ	"AJ"
par`ticulate	AJ	"AJ"
`partitive	AJ	"AJ"
`passionate	AJ	"N(`passion)+AJR24"
`passive	AJ-to-N	"AJ"
pas`se	AJ	"AJ"
`past	AJ-to-N	"AJ"
`pasty	AJ	"N(`paste)+AJR14"
pa`ternal	AJ	"AJ"
patri`lineal	AJ	"AJ"
pa`thetic	AJ_ic	"AJ"
`patient	AJ	"AJ"
pa`tristic	AJ_ic	"AJ"
`peaceable	AJ	"N(`peace)+AJR25"
`pebbled	AJ	"N(`pebble)+AJR8"
`pebbly	AJ	"N(`pebble)+AJR14"
pec`toral	AJ	"AJ"
pe`culiar	AJ	"AJ"
pe`cuniary	AJ	"AJ"
pedi`atric	AJ_ic	"AJ"
`pedigreed	AJ	"N(`pedigree)+AJR8"
pe`jorative	AJ	"AJ"
pe`lagic	AJ_ic	"AJ"
`pelvic	AJ_ic	"N(`pelvis)+AJR20"
`penal	AJ	"AJ"
`pendulous	AJ	"AJ"
`penetrable	AJ	"V(`penetrate)+AJR25"
`penile	AJ	"N(`penis)+AJR39"
`penitent	AJ-to-N	"AJ"
peni`tential	AJ	"AJ(`penitent)+AJR17"
`pensive	AJ	"AJ"
`pent	AJ	"AJ"
pe`nultimate	AJ	"N(pe`nultima)+AJR24"
per`ceptible	AJ	"V(per`ceive)+AJR25"
per`ceptive	AJ	"V(per`ceive)+AJR26"
per`cipient	AJ	"AJ"
pe`remptory	AJ	"AJ"
pe`rennial	AJ-to-N	"AJ"
`perfect	AJ	"AJ"
per`functory	AJ	"AJ"
peripa`tetic	AJ_ic	"AJ"
pe`ripheral	AJ-to-N	"N(pe`riphery)+AJR17"
peri`phrastic	AJ_ic	"N(pe`riphrasis)+AJR20"
`perky	AJ	"AJ"
`permanent	AJ	"AJ"
`permeable	AJ	"V(`permeate)+AJR25"
per`missible	AJ	"V(per`mit)+AJR25"
per`missive	AJ	"V(per`mit)+AJR26"
per`nicious	AJ	"AJ"
perpen`dicular	AJ-to-N	"AJ"
per`petual	AJ	"AJ"
`personable	AJ	"N(`person)+AJR25"
perspi`cacious	AJ	"AJ"
per`spicuous	AJ	"AJ"
per`suasive	AJ	"V(per`suade)+AJR26"
`pert	AJ	"AJ"
perti`nacious	AJ	"AJ"
`pertinent	AJ	"AJ"
per`vasive	AJ	"V(per`vade)+AJR26"
per`verse	AJ	"AJ"
`pervious	AJ	"AJ"
`pesky	AJ	"AJ"
`pestilent	AJ	"AJ"
pes`tiferous	AJ	"AJ"
pesti`lential	AJ	"AJ"
`petaled	AJ	"N(`petal)+AJR8"
`petalled	AJ	"N(`petal)+AJR8"
pe`tit	AJ	"AJ"
pe`tite	AJ	"AJ"
petro`chemical	AJ	"AJ"
`petty	AJ	"AJ"
`petulant	AJ	"AJ"
`phallic	AJ_ic	"AJ"
phari`saic	AJ_ic	"N(`pharisee)+AJR20"
pharma`ceutical	AJ-to-N	"AJ"
pha`ryngeal	AJ	"N(`pharynx)+AJR17"
phe`nomenal	AJ	"N(phe`nomena)+AJR17"
phleg`matic	AJ_ic	"AJ"
`phobic	AJ_ic	"AJ"
`phony	AJ	"AJ"
phos`phoric	AJ_ic	"N(`phosphorus)+AJR20"
photo`genic	AJ_ic	"AJ"
`physical	AJ-to-N	"AJ"
physio`chemical	AJ	"AJ"
pian`issimo	AJ	"AJ"
pica`yune	AJ	"AJ"
`picky	AJ	"AJ"
pic`torial	AJ	"AJ"
;pictur`esque	AJ	"AJ"
`piecemeal	AJ	"AJ"
`piggyback	AJ	"AJ"
`pimpled	AJ	"N(`pimple)+AJR8"
`pious	AJ	"AJ"
`piquant	AJ	"AJ"
`piteous	AJ	"N(`pity)+AJR21"
pizzi`cato	AJ	"AJ"
pla`cental	AJ	"N(pla`centa)+AJR17"
`placid	AJ	"AJ"
`plain	AJ	"AJ"
`plaintive	AJ	"AJ"
`planar	AJ	"N(`plane)+AJR31"
`planetary	AJ	"N(`planet)+AJR22"
`plastic	AJ_ic	"AJ"
plati`tudinous	AJ	"N(`platitude)+AJR21"
`plausible	AJ	"AJ"
`pleasant	AJ	"V(`please)+AJR27"
`pleasurable	AJ	"N(`pleasure)+AJR25"
`plenary	AJ	"AJ"
plenipo`tentiary	AJ	"AJ"
`plenteous	AJ	"N(`plenty)+AJR21"
`plentiful	AJ	"AJ"
`pleural	AJ	"N(`pleura)+AJR17"
`pliant	AJ	"V(`ply)+AJR27"
`plump	AJ	"AJ"
plu`perfect	AJ-to-N	"AJ"
`plural	AJ-to-N	"AJ"
`plus	AJ	"AJ"
`plush	AJ	"AJ"
`plushy	AJ	"AJ"
pneu`matic	AJ_ic	"AJ"
;poetic	AJ_ic	"AJ"
`poignant	AJ	"AJ"
`pokey	AJ	"AJ"
`poky	AJ	"AJ"
`polar	AJ	"N(`pole)+AJR31"
po`lite	AJ	"AJ"
`politic	AJ_ic	"AJ"
poly`technic	AJ_ic	"AJ"
`ponderous	AJ	"AJ"
pon`tific	AJ_ic	"AJ"
`poor	AJ	"AJ"
`popular	AJ	"AJ"
`populous	AJ	"AJ"
`porcine	AJ	"AJ"
`portable	AJ-to-N	"AJ"
`posh	AJ	"AJ"
`positive	AJ-to-N	"AJ"
`possible	AJ	"AJ"
`postal	AJ	"AJ"
;postdoctoral	AJ	"AJ"
;postgraduate	AJ	"AJ"
`posthumous	AJ	"AJ"
post`mortem	AJ-to-N	"AJ"
post-`mortem	AJ-to-N	"AJ"
;postpaid	AJ	"AJ"
`potable	AJ	"AJ"
`potent	AJ	"AJ"
po`tential	AJ	"AJ"
`practicable	AJ	"AJ"
`practical	AJ	"AJ"
prag`matic	AJ_ic	"AJ"
`preachy	AJ	"V(`preach)+AJR14"
pre`carious	AJ	"AJ"
`precedented	AJ	"V(pre`cede)+NR17+AJR8"
`precious	AJ	"AJ"
pre`cipitable	AJ	"V(pre`cipitate)+AJR25"
pre`cipitant	AJ	"AJ"
pre`cipitate	AJ	"AJ"
pre`cipitous	AJ	"AJ"
pre`cise	AJ	"AJ"
pre`cocious	AJ	"AJ"
`predatory	AJ	"AJ"
pre`dominant	AJ	"AJ"
pre`dominate	AJ	"AJ"
pre`eminent	AJ	"AJ"
pre`fab	AJ	"AJ"
`prefatory	AJ	"N(`preface)+AJR23"
prefer`ential	AJ	"V(pre`fer)+NR26+AJR17"
`preferable	AJ	"V(pre`fer)+AJR25"
`pregnant	AJ	"AJ"
pre`hensile	AJ	"AJ"
pre`liminary	AJ-to-N	"AJ"
pre`mier	AJ	"AJ"
pre`miere	AJ	"AJ"
pre`monitory	AJ	"AJ"
`preparatory	AJ	"AJ"
pre`parative	AJ-to-N	"V(pre`pare)+AJR26"
pre`ponderant	AJ	"AJ"
pre`posterous	AJ	"AJ"
`prescient	AJ	"AJ"
`prescript	AJ	"AJ"
pre`scriptive	AJ	"V(pre`scribe)+AJR26"
`present	AJ	"AJ"
prestigious	AJ	"N(pres`tige)+AJR21"
pre`sumptive	AJ	"V(pre`sume)+AJR26"
pre`sumptuous	AJ	"V(pre`sume)+AJR21"
pre`tentious	AJ	"AJ"
`preterit	AJ-to-N	"AJ"
preter`natural	AJ	"AJ"
`pretty	AJ	"AJ"
`prevalent	AJ	"AJ"
`previous	AJ	"AJ"
`prickly	AJ	"N(`prickle)+AJR14"
`pricy	AJ	"N(`price)+AJR14"
`prim	AJ	"AJ"
`primal	AJ	"AJ"
`primary	AJ-to-N	"AJ"
`prime	AJ	"AJ"
pri`meval	AJ	"AJ"
`primitive	AJ-to-N	"AJ"
pri`mordial	AJ	"AJ"
`principal	AJ-to-N	"AJ"
`principled	AJ	"N(`principle)+AJR8"
`prior	AJ	"AJ"
pris`matic	AJ_ic	"N(`prism)+AJR20"
`prissy	AJ	"AJ"
pris`tine	AJ	"AJ"
`private	AJ	"AJ"
pro`bationary	AJ	"N(pro`bation)+AJR22"
problem`atic	AJ_ic	"N(`problem)+AJR20"
pro`crustean	AJ	"AJ"
`prodigal	AJ	"AJ"
pro`ductive	AJ	"V(pro`duce)+AJR26"
pro`fane	AJ-to-V	"AJ"
pro`ficient	AJ	"AJ"
`profligate	AJ-to-N	"AJ"
pro`found	AJ	"AJ"
pro`fuse	AJ	"AJ"
`prolate	AJ	"AJ"
pro`lific	AJ_ic	"AJ"
`prolix	AJ	"AJ"
`prominent	AJ	"AJ"
pro`miscuous	AJ	"AJ"
`prompt	AJ	"AJ"
`prone	AJ	"AJ"
`pronged	AJ	"N(`prong)+AJR8"
`proper	AJ	"AJ"
prophy`lactic	AJ_ic	"AJ"
pro`pitious	AJ	"AJ"
pro`portionate	AJ	"N(pro`portion)+AJR24"
pro`prietary	AJ	"AJ"
pro`saic	AJ_ic	"AJ"
pro`scriptive	AJ	"V(pro`scribe)+AJR26"
pro`sodic	AJ_ic	"N(`prosody)+AJR20"
pro`spective	AJ	"N(`prospect)+AJR26"
`prosperous	AJ	"V(`prosper)+AJR21"
pros`thetic	AJ_ic	"N(pros`thesis)+AJR20"
`prostrate	AJ-to-V	"AJ"
`protean	AJ	"AJ"
pro`tuberant	AJ	"AJ"
`proud	AJ	"AJ"
`provident	AJ	"AJ"
provi`dential	AJ	"N(`providence)+AJR17"
pro`vocative	AJ	"V(pro`voke)+AJR26"
`proximal	AJ	"AJ"
`proximate	AJ	"AJ"
`prudent	AJ	"AJ"
pru`dential	AJ	"AJ"
`prurient	AJ	"AJ"
psychi`atric	AJ_ic	"AJ"
`psychic	AJ_ic	"AJ"
psychoana`lytic	AJ_ic	"AJ"
psycholin`guistic	AJ_ic	"AJ"
psychoso`matic	AJ_ic	"AJ"
psy`chotic	AJ_ic	"AJ"
pu`bescent	AJ	"AJ"
`pubic	AJ_ic	"AJ"
`public	AJ-to-N	"AJ"
`puckish	AJ	"AJ"
`puddly	AJ	"N(`puddle)+AJR14"
`pudgy	AJ	"AJ"
`puerile	AJ	"AJ"
pug`nacious	AJ	"AJ"
puis`sant	AJ	"AJ"
pulchri`tudinous	AJ	"N(`pulchritude)+AJR21"
`pulmonary	AJ	"AJ"
punc`tilious	AJ	"AJ"
`punctual	AJ	"AJ"
`pungent	AJ	"AJ"
`punitive	AJ	"AJ"
`punky	AJ	"AJ"
`puny	AJ	"AJ"
`pure	AJ	"AJ"
`purgative	AJ-to-N	"V(`purge)+AJR26"
`purposive	AJ	"N(`purpose)+AJR26"
pur`suant	AJ	"V(pur`sue)+AJR27"
pusil`lanimous	AJ	"AJ"
`putative	AJ	"AJ"
`putrid	AJ	"AJ"
pyro`technic	AJ_ic	"AJ"

quad`rangular	AJ	"N(`quadrangle)+AJR31"
quad`ratic	AJ_ic	"AJ"
quad`rennial	AJ	"AJ"
quadri`partite	AJ	"AJ"
qua`druple	AJ-to-N-V	"AJ"
`quaint	AJ	"AJ"
`qualitative	AJ	"AJ"
`quantitative	AJ	"AJ"
`quarrelsome	AJ	"V(`quarrel)+AJR15"
`quasi	AJ	"AJ"
;quasicontinuous	AJ	"AJ"
;quasiperiodic	AJ_ic	"AJ"
;quasistationary	AJ	"AJ"
`quaternary	AJ	"AJ"
`quavery	AJ	"V(`quaver)+AJR14"
`queasy	AJ	"AJ"
`queazy	AJ	"AJ"
`queer	AJ	"AJ"
`queer-looking	AJ	"AJ"
`quenchless	AJ	"AJ"
`querulous	AJ	"AJ"
`quick	AJ	"AJ/AV"
qui`escent	AJ	"AJ"
`quiet	AJ-to-V	"AJ"
quintes`sential	AJ	"AJ"
quix`otic	AJ_ic	"AJ"
`quizzic	AJ_ic	"V(`quiz).NR0+AJR20"

rab`binic	AJ_ic	"N(`rabbi)+AJR20"
`rabid	AJ	"AJ"
`rackety	AJ	"AJ"
`racy	AJ	"AJ"
`radial	AJ-to-N	"AJ"
`radiant	AJ	"AJ"
`radical	AJ-to-N	"AJ"
radio`active	AJ	"AJ"
`raffish	AJ	"AJ"
`ragged	AJ	"N(`rag)+AJR8"
`raggedy	AJ	"N(`rag)+AJR8+AJR14"
`rakish	AJ	"AJ"
ram`bunctious	AJ	"AJ"
`rampant	AJ	"AJ"
`rancid	AJ	"AJ"
`random	AJ	"AJ"
`randy	AJ	"AJ"
`rangy	AJ	"AJ"
`rank	AJ	"AJ"
ra`pacious	AJ	"AJ"
`rapid	AJ	"AJ"
`rapt	AJ	"AJ"
`rash	AJ	"AJ"
`raspy	AJ	"V(`rasp)+AJR14"
`rattly	AJ	"V(`rattle)+AJR14"
`rare	AJ	"AJ"
`raucous	AJ	"AJ"
`raunchy	AJ	"AJ"
`ravenous	AJ	"V(`raven)+AJR21"
`raw	AJ	"AJ"
raw`boned	AJ	"AJ(`raw)+N(`bone)+AJR8"
re`actionary	AJ-to-N	"AJ"
`ready	AJ-to-V	"AJ"
`real	AJ	"AJ"
re`calcitrant	AJ	"AJ"
`recent	AJ	"AJ"
re`ceptive	AJ	"V(re`ceive)+AJR26"
re`cessionary	AJ	"V(re`cess)+NR23+AJR22"
re`cherche	AJ	"AJ"
re`ciprocal	AJ	"AJ"
`reckless	AJ	"AJ"
`recluse	AJ-to-N	"AJ"
re`clusive	AJ	"AJ"
re`combinant	AJ	"AJ"
`recondite	AJ	"AJ"
rec`tangular	AJ	"N(`rectangle)+AJR31"
`rectal	AJ	"N(`rectum)+AJR17"
re`cumbent	AJ	"AJ"
`recusant	AJ-to-N	"AJ"
re`demptive	AJ	"V(re`deem)+AJR26"
re`dundant	AJ	"AJ"
re`ferable	AJ	"V(re`fer)+AJR25" ;exception to Gemination
;refer`ential	AJ	"AJ"
re`flexive	AJ-to-N	"AJ"
;re`fractory	AJ	"AJ"
re`fulgent	AJ	"AJ"
re`gardless	AJ	"V(re`gard)+AJR11"
`registrable	AJ	"V(`registrate)+AJR25"
`regular	AJ-to-N	"AJ"
;`regulatory	AJ	"AJ"
re`lentless	AJ	"V(re`lent)+AJR11"
`relevant	AJ	"AJ"
re`liant	AJ	"V(re`ly)+AJR27"
re`ligious	AJ	"AJ"
re`luctant	AJ	"AJ"
;re`mediable	AJ	"AJ"
re`monstrant	N	"V(re`monstrate)+AJR27"
re`mote	AJ	"AJ"
`renal	AJ	"AJ"
`reparable	AJ	"V(re`pair)+AJR25"
re`pentant	AJ	"V(re`pent)+AJR27"
repe`titious	AJ	"V(re`peat)+AJR21"
re`petitive	AJ	"V(re`peat)+AJR26"
re`plete	AJ	"AJ"
`replicable	AJ	"V(re`plicate)+AJR25"
repor`torial	AJ	"V(re`port)+NR19+AJR17"
repre`hensible	AJ	"V(repre`hend)+AJR25"
repre`sentative	AJ-to-N	"V(repre`sentative)+AJR26"
re`pugnant	AJ	"AJ"
`requisite	AJ-to-N	"AJ"
re`semblant	AJ	"V(re`semble)+AJR27"
re`sentful	AJ	"V(re`sent)+AJR9"
`resident	AJ-to-N	"V(re`side)+AJR27"
;residual	AJ	"AJ"
re`siduary	AJ	"N(`residue)+AJR28"
re`silient	AJ	"V(re`sile)+AJR27"
re`sistant	AJ	"V(re`sist)+AJR27"
`resolute	AJ	"AJ"
`resonant	AJ-to-N	"AJ"
re`splendent	AJ	"AJ"
re`sponsible	AJ	"AJ"
re`sponsive	AJ	"V(re`spond)+AJR26"
`restive	AJ	"AJ"
re`storative	AJ	"V(re`store)+AJR26"
re`sultant	AJ	"V(re`sult)+AJR27"
re`tentive	AJ	"V(re`tain)+AJR26"
`reticent	AJ	"AJ"
`retinal	AJ	"N(`retina)+AJR17"
re`tributive	AJ	"AJ"
;retro`active	AJ	"AJ"
`retrograde	AJ	"AJ"
`revelatory	AJ	"V(re`veal)+AJR28"
re`verberant	AJ	"V(re`verberate)+AJR27"
`reverend	AJ	"AJ"
rever`ential	AJ	"N(`reverence)+AJR17"
`revocable	AJ	"V(re`voke)+AJR25"
revo`lutionary	AJ-to-N	"V(re`volve)+NR23+AJR22"
rhap`sodic	AJ_ic	"N(`rhapsody)+AJR20"
rheu`matic	AJ_ic	"N(`rheuma)+AJR20"
ri`bald	AJ	"AJ"
`ribboned	AJ	"N(`ribbon)+AJR8"
`rich	AJ	"AJ"
`rickety	AJ	"AJ"
ri`diculous	AJ	"V(`ridicule)+21"
`rife	AJ	"AJ"
`right	AJ-to-N-V	"AJ/AV"
`righthand	AJ	"AJ"
`right-hand	AJ	"AJ"
right`handed	AJ	"AJ(`right)+N(`hand)+AJR8"
`righteous	AJ	"AJ"
`rigid	AJ	"AJ"
`rimy	AJ	"N(`rime)+AJR14"
`rinky-dink	AJ	"AJ"
ri`parian	AJ	"AJ"
`ripe	AJ	"AJ"
`ripply	AJ	"V(`ripple)+AJR14"
`risible	AJ	"AJ"
ris`que	AJ	"AJ"
`riverine	AJ	"N(`river)+AJR38"
ro`bust	AJ	"AJ"
`rockbound	AJ	"AJ"
ro`coco	AJ	"AJ"
roly-`poly	AJ	"AJ"
ro`mantic	AJ_ic	"N(`romance)+AJR20"
`rosy	AJ	"N(`rose)+AJR14"
`rotten	AJ	"V(`rot)+AJR30"
ro`tund	AJ	"AJ"
`rough	AJ-to-V	"AJ"
`roughshod	AJ	"AJ"
`round	AJ-to-V	"AJ"
`roundabout	AJ	"AJ"
`rowdy	AJ-to-N	"AJ"
`royal	AJ	"AJ"
`rubicund	AJ	"AJ"
`ruddy	AJ	"AJ"
`rude	AJ	"AJ"
rudi`mentary	AJ	"N(`rudiment)+AJR22"
`rufous	AJ	"AJ"
`rugged	AJ	"AJ"
`runny	AJ	"V(`run)+AJR14"
`rural	AJ	"AJ"
`rustic	AJ_ic	"AJ"
`rustproof	AJ	"AJ"
`ruthless	AJ	"AJ"

`saccharine	AJ	"AJ"
`sacral	AJ	"AJ"
`sacred	AJ	"AJ"
sacri`legious	AJ	"N(`sacrilege)+AJR21"
`sacrosanct	AJ	"AJ"
`sad	AJ	"AJ"
`safe	AJ	"AJ/AV"
sa`gacious	AJ	"AJ"
`sage	AJ	"AJ"
`salable	AJ	"N(`sale)+AJR25"
`saleable	AJ	"N(`sale)+AJR25"
sa`lacious	AJ	"AJ"
`salaried	AJ	"N(`salary)+AJR8"
`salient	AJ	"AJ"
`saline	AJ	"AJ" ;salt+AJR38
`salivary	AJ	"N(sa`liva)+AJR22"
`sallow	AJ	"AJ"
`saltwater	AJ	"AJ"
sa`lubrious	AJ	"AJ"
`salutary	AJ	"AJ"
`same	AJ	"AJ"
`sane	AJ	"AJ"
`sanguinary	AJ	"AJ"
`sanguine	AJ	"AJ"
san`guineous	AJ	"AJ"
`sanitary	AJ	"AJ"
`sapiens	AJ	"AJ"
`sapient	AJ	"AJ"
`sappy	AJ	"AJ"
sar`castic	AJ_ic	"AJ"
sar`donic	AJ_ic	"AJ"
`sassy	AJ	"AJ"
`satiable	AJ	"AJ"
satis`factory	AJ	"AJ"
`saturable	AJ	"AJ"
`saucy	AJ	"AJ"
`savage	AJ-to-N-V	"AJ"
`savvy	AJ	"AJ"
`sawtooth	AJ	"AJ"
`scabious	AJ	"AJ"
`scabrous	AJ	"AJ"
`scalar	AJ	"N(`scale)+AJR31"
`scaly	AJ	"N(`scale)+AJR14"
`scant	AJ	"AJ"
`scanty	AJ	"AJ"
`scarce	AJ	"AJ"
`scary	AJ	"V(`scare)+AJR14"
scato`logic	AJ_ic	"AJ"
sche`matic	AJ_ic	"N(`schema)+AJR20"
schis`matic	AJ_ic	"AJ"
`schizoid	AJ-to-N	"AJ"
schizo`phrenic	AJ_ic	"AJ"
scho`lastic	AJ_ic	"AJ"
scien`tific	AJ_ic	"AJ"
`scottish	AJ	"AJ"
`scraggly	AJ	"AJ"
`scraggy	AJ	"AJ"
`scrawny	AJ	"AJ"
`scrubby	AJ	"AJ"
`scruffy	AJ	"AJ"
`scrumptious	AJ	"AJ"
`scrupulous	AJ	"N(`scruple)+AJR21"
`scrutable	AJ	"AJ"
`scrutinise	AJ	"N(`scrutiny)+VR6" ;British
`scrutinize	AJ	"N(`scrutiny)+VR6"
`scurrilous	AJ	"AJ"
`scurvy	AJ	"AJ"
`seamy	AJ	"AJ"
`seasonable	AJ	"N(`season)+AJR25"
`sec	AJ	"AJ"
`secondary	AJ	"OD(`second)+AJR22"
`secondhand	AJ	"AJ"
`secular	AJ	"AJ"
se`cure	AJ-to-V	"AJ"
se`date	AJ-to-V	"AJ"
`sedentary	AJ	"AJ"
sedi`mentary	AJ	"N(`sediment)+AJR22"
se`ditious	AJ	"AJ"
se`ductive	AJ	"V(se`duce)+AJR26"
`sedulous	AJ	"AJ"
`seemly	AJ	"AJ"
`seismic	AJ_ic	"AJ"
se`lect	AJ	"AJ"
self`conscious	AJ	"AJ"
self`same	AJ	"AJ"
se`mantic	AJ_ic	"AJ"
`seminal	AJ	"AJ"
semi`otic	AJ_ic	"AJ"
`senile	AJ	"AJ"
`sensate	AJ	"AJ"
`sensible	AJ	"AJ"
`sensitive	AJ	"N(`sense).VR0+AJR26"
`sensory	AJ	"N(`sense)+AJR23"
`sensuous	AJ	"N(`sense)+AJR21"
sen`tential	AJ	"N(`sentence)+AJR17"
`sentient	AJ	"AJ"
`separable	AJ	"AJ(`separate).VR0+AJR25"
`separate	AJ-to-V	"AJ"
`septate	AJ	"AJ"
sep`tennial	AJ	"AJ"
`septic	AJ_ic	"AJ"
`sepulchral	AJ	"N(`sepulcher)+AJR17"
`sequinned	AJ	"N(`sequin)+AJR8"
`sequent	AJ	"AJ"
se`quential	AJ	"N(`sequence)+AJR17"
seren`dipitous	AJ	"N(seren`dipity)+AJR21"
se`rene	AJ	"AJ"
se`rial	AJ-to-N	"AJ"
`seriate	AJ-to-V	"AJ"
`serious	AJ	"AJ"
`serpentine	AJ	"N(`serpent)+AJR38"
`servile	AJ	"AJ"
`severalfold	AJ	"AJ/AV"
se`vere	AJ	"AJ"
sfor`zando	AJ	"AJ"
`shabby	AJ	"AJ"
`shady	AJ	"N(`shade)+AJR14"
`shaky	AJ	"V(`shake)+AJR14"
`shallow	AJ	"AJ"
`shamefaced	AJ	"AJ"
`sharp	AJ	"AJ"
`shatterproof	AJ	"AJ"
`sheer	AJ	"AJ"
`shifty	AJ	"AJ"
`shiny	AJ	"N(`shine)+AJR14"
`shipshape	AJ	"AJ"
`shoddy	AJ	"AJ"
`shopworn	AJ	"AJ"
`short	AJ-to-V	"AJ"
`shortsighted	AJ	"AJ(`short)+N(`sight)+AJR8"
`showy	AJ	"V(`show)+AJR14"
`shrewd	AJ	"AJ"
`shrill	AJ	"AJ"
`shrunken	AJ	"V(`shrink).PTC+AJR30"
`shy	AJ	"AJ"
`sibilant	AJ-to-N	"AJ"
`sick	AJ	"AJ"
`sidearm	AJ	"AJ"
`sidelong	AJ	"AJ"
si`dereal	AJ	"AJ"
`sighted	AJ	"N(`sight)+AJR8"
sig`nificant	AJ	"AJ"
`silent	AJ	"AJ"
`silken	AJ	"AJ"
`silly	AJ	"AJ"
`similar	AJ	"AJ"
`simple	AJ	"AJ"
simple`minded	AJ	"AJ(`simple)+N(`mind)+AJR8"
`simplex	AJ	"AJ"
sim`plistic	AJ_ic	"AJ"
simul`taneous	AJ	"AJ"
sin`cere	AJ	"AJ"
`single	AJ-to-N	"AJ"
single`handed	AJ	"AJ(`single)+N(`hand)+AJR8"
`singular	AJ	"AJ"
`sinister	AJ	"AJ"
`sinistral	AJ	"AJ"
`sinuous	AJ	"AJ"
`skeletal	AJ	"N(`skeleton)+AJR17"
`skilful	AJ	"N(`skill)+AJR9"
`skilled	AJ	"N(`skill)+AJR8"
`skimpy	AJ	"V(`skimp)+AJR14"
`skinny	AJ	"AJ"
`slack	AJ-to-N-V	"AJ"
`sleazy	AJ	"N(`sleaze)+AJR14"
`sleek	AJ	"AJ"
`slender	AJ	"AJ"
`slick	AJ-to-V	"AJ"
`slight	AJ	"AJ"
`slim	AJ	"AJ"
`slimy	AJ	"N(`slime)+AJR14"
`slinky	AJ	"AJ"
`slippery	AJ	"V(`slip)+AJR14"
`slithery	AJ	"V(`slither)+AJR14"
`sloppy	AJ	"AJ"
`slow	AJ-to-V	"AJ"
`sluggish	AJ	"AJ"
`sly	AJ	"AJ"
`small	AJ	"AJ"
`smalltime	AJ	"AJ"
`smarmy	AJ	"AJ"
`smart	AJ	"AJ"
`smoky	AJ	"N(`smoke)+AJR14"
`smooth	AJ-to-V	"AJ"
`smudgy	AJ	"N(`smudge)+AJR14"
`smug	AJ	"AJ"
`snaky	AJ	"N(`snake)+AJR14"
`snappy	AJ	"AJ"
`snazzy	AJ	"AJ"
`sneaky	AJ	"V(`sneak)+AJR14"
`sneezy	AJ	"V(`sneeze)+AJR14"
`snide	AJ	"AJ"
`snippy	AJ	"AJ"
`snoopy	AJ	"V(`snoop)+AJR14"
`snooty	AJ	"AJ"
`snuffly	AJ	"V(`snuffle)+AJR14"
`snug	AJ	"AJ"
`snuggly	AJ	"V(`snuggle)+AJR14"
`sober	AJ-to-V	"AJ"
`sociable	AJ	"AJ"
`social	AJ	"AJ"
so`cietal	AJ	"N(so`ciety)+AJR17"
socioeco`nomic	AJ_ic	"AJ"
sociolin`guistic	AJ_ic	"AJ"
`sodden	AJ	"AJ"
`soft	AJ	"AJ"
soft`hearted	AJ	"AJ(`soft)+N(`heart)+AJR8"
`soggy	AJ	"AJ"
soi`gne	AJ	"AJ"
soi`gnee	AJ	"AJ"
`solar	AJ	"AJ"
`sole	AJ	"AJ"
`solemn	AJ	"AJ"
so`licitous	AJ	"AJ"
`solid	AJ-to-N	"AJ"
`solitary	AJ	"AJ"
`soluble	AJ	"AJ"
so`matic	AJ_ic	"AJ"
`somber	AJ	"AJ"
`sombre	AJ	"AJ"
`somnolent	AJ	"AJ"
`sonic	AJ_ic	"AJ"
`sonorant	AJ-to-N	"AJ"
`sonorous	AJ	"AJ"
sopo`rific	AJ_ic	"AJ"
`sordid	AJ	"AJ"
`sore	AJ-to-N	"AJ"
`sorry	AJ	"AJ"
`sound	AJ	"AJ"
`soundproof	AJ	"AJ"
`sour	AJ-to-N-V	"AJ"
`southbound	AJ	"AJ"
`southerly	AJ	"AJ/AV"
`southern	AJ	"AJ"
south`easterly	AJ	"AJ/AV"
south`eastern	AJ	"AJ"
south`westerly	AJ	"AJ/AV"
south`western	AJ	"AJ"
`sovereign	AJ-to-N	"AJ"
`spacious	AJ	"N(`space)+AJR21"
`spare	AJ	"AJ"
`sparse	AJ	"AJ"
spas`modic	AJ_ic	"AJ"
`spastic	AJ_ic	"AJ"
`spatial	AJ	"N(`space)+AJR17"
`special	AJ-to-N	"AJ"
spe`cific	AJ_ic	"AJ"
`specious	AJ	"AJ"
`spectacled	AJ	"N(`spectacles)+AJR8"
spec`tacular	AJ	"AJ"
`spectral	AJ	"AJ"
`specular	AJ	"AJ"
`spellbound	AJ	"AJ"
`spicy	AJ	"N(`spice)+AJR14"
`spiffy	AJ	"AJ"
`spiky	AJ	"N(`spike)+AJR14"
spiny	AJ	"N(`spine)+AJR14"
`spiral	AJ-to-N-V	"AJ"
`spirited	AJ	"N(`spirit)+AJR8"
`splendid	AJ	"AJ"
`splenetic	AJ_ic	"AJ"
`spongy	AJ	"N(`sponge)+AJR14"
`spontaneous	AJ	"AJ"
spo`radic	AJ_ic	"AJ"
`spotted	AJ	"N(`spot)+AJR8"
`sprightly	AJ	"AJ"
`spruce	AJ-to-V	"AJ"
`spry	AJ	"AJ"
`spurious	AJ	"AJ"
`squalid	AJ	"AJ"
`square	AJ-to-N-V	"AJ"
`squamous	AJ	"AJ"
`squeamish	AJ	"AJ"
`squinty	AJ	"V(`squint)+AJR14"
`squirmy	AJ	"V(`squirm)+AJR14"
`squishy	AJ	"AJ"
`stabile	AJ	"AJ"
`stable	AJ	"AJ"
stac`cato	AJ	"AJ"
`stagestruck	AJ	"AJ"
`stagnant	AJ	"AJ"
`staid	AJ	"AJ"
`stale	AJ-to-V	"AJ"
`stalwart	AJ	"AJ"
`stark	AJ	"AJ"
`statewide	AJ	"AJ"
`static	AJ_ic	"AJ"
`stationary	AJ	"AJ"
`statutory	AJ	"N(`statute)+AJR23"
`staunch	AJ	"AJ"
`steadfast	AJ	"AJ"
`steady	AJ-to-V	"AJ"
`stedfast	AJ	"AJ"
`steep	AJ	"AJ"
`stellar	AJ	"AJ"
stereo`phonic	AJ_ic	"AJ"
stereo`typic	AJ_ic	"N(`stereotype)+AJR20"
`sterile	AJ	"AJ"
`stern	AJ	"AJ"
`sternal	AJ	"AJ"
`stertorous	AJ	"AJ"
`sticky	AJ	"V(`stick)+AJR14"
`stiff	AJ	"AJ"
`still	AJ-to-V	"AJ"
`stillborn	AJ	"AJ"
`stilted	AJ	"AJ"
`stingy	AJ	"AJ"
sto`chastic	AJ_ic	"AJ"
`stocky	AJ	"AJ"
`stodgy	AJ	"AJ"
`stolid	AJ	"AJ"
`stony	AJ	"N(`stone)+AJR14"
`storied	AJ	"N(`story)+AJR8"
`stormbound	AJ	"AJ"
`stout	AJ	"AJ"
`straight	AJ	"AJ"
`straightaway	AJ	"AJ"
straight`forward	AJ	"AJ"
`strange	AJ	"AJ"
stra`tegic	AJ_ic	"N(`strategy)+AJR20"
`strenuous	AJ	"AJ"
`striated	AJ	"AJ"
`strict	AJ	"AJ"
`strident	AJ	"AJ"
`stringent	AJ	"AJ"
`stripy	AJ	"N(`stripe)+AJR14"
`strong	AJ	"AJ"
`stubborn	AJ	"AJ"
`stuffy	AJ	"AJ"
stu`pendous	AJ	"AJ"
`stupid	AJ	"AJ"
`sturdy	AJ	"AJ"
`stylish	AJ	"N(`style)+AJR10"
`suave	AJ	"AJ"
sub`altern	AJ-to-N	"AJ"
sub`jective	AJ	"AJ"
sub`junctive	AJ-to-N	"AJ"
sub`lime	AJ	"AJ"
sub`liminal	AJ	"AJ"
sub`missive	AJ	"V(sub`mit)+AJR26"
sub`ordinate	AJ-to-V	"AJ"
sub`servient	AJ	"AJ"
sub`sidiary	AJ-to-N	"AJ"
sub`stantial	AJ	"N(`substance)+AJR17"
`substantive	AJ-to-N	"AJ"
substi`tutionary	AJ	"V(`substitute)+NR23+AJR22"
subter`ranean	AJ	"AJ"
subter`raneous	AJ	"AJ"
`subtle	AJ	"AJ"
sub`versive	AJ	"V(sub`vert)+AJR26"
suc`cessive	AJ	"V(suc`ceed)+AJR26"
suc`cinct	AJ	"AJ"
`succulent	AJ	"AJ"
`such	AJ	"AJ/AV"
`suchlike	AJ	"AJ"
`sudden	AJ	"AJ"
suf`ficient	AJ	"V(suf`fice)+AJR27"
`sulfa	AJ	"AJ"
`sulky	AJ	"AJ"
`sullen	AJ	"AJ"
`sultry	AJ	"AJ"
`sumptuous	AJ	"AJ"
`sunburnt	AJ	"AJ"
`sundry	AJ	"AJ"
`sunken	AJ	"V(`sink).PTC+AJR30"
`sunlit	AJ	"AJ"
`sunshiny	AJ	"N(`sunshine)+AJR14"
`suntanned	AJ	"N(`suntan)+AJR8"
`super	AJ	"AJ"
su`perb	AJ	"AJ"
super`cilious	AJ	"AJ"
super`ficial	AJ	"AJ"
su`perfluous	AJ	"AJ"
su`perior	AJ-to-N	"AJ"
su`perlative	AJ-to-N	"AJ"
su`pernal	AJ	"AJ"
super`stitious	AJ	"AJ"
`supine	AJ	"AJ"
`supple	AJ	"AJ"
supple`mentary	AJ	"N(`supplement)+AJR22"
su`preme	AJ	"AJ"
`sure	AJ	"AJ"
sure`footed	AJ	"AJ(`sure)+N(`foot)+AJR8"
`surgical	AJ	"AJ"
`surly	AJ	"AJ"
sur`real	AJ	"DEG10+AJ(`real)"
surrep`titious	AJ	"AJ"
sus`ceptible	AJ	"AJ"
sus`picious	AJ	"AJ"
`svelte	AJ	"AJ"
`swank	AJ	"AJ"
`swanky	AJ	"AJ"
`swart	AJ	"AJ"
`swarthy	AJ	"AJ"
`sweet	AJ-to-N	"AJ"
sweet-`tempered	AJ	"AJ(`sweet)+N(`temper)+AJR8"
`swift	AJ	"AJ"
`swishy	AJ	"V(`swish)+AJR14"
syl`labic	AJ_ic	"N(`syllable)+AJR20"
syllo`gistic	AJ_ic	"AJ"
`sylvan	AJ	"AJ"
symbi`otic	AJ_ic	"AJ"
sym`bolic	AJ_ic	"N(`symbol)+AJR20"
sym`metric	AJ_ic	"N(`symmetry)+AJR20"
sympa`thetic	AJ_ic	"N(`sympathy)+AJR20"
sym`phonic	AJ_ic	"N(`symphony)+AJR20"
sympto`matic	AJ_ic	"AJ"
syn`aptic	AJ_ic	"N(syn`apsis)+AJR21"
syn`chronic	AJ	"N(`synchrony)+AJR21"
`synchronous	AJ	"N(`synchrony)+AJR21"
syner`gistic	AJ_ic	"N(`synergy)+NR31"
syn`onymous	AJ	"N(sy`nonymy)+AJR21"
syn`optic	AJ_ic	"AJ"
syn`tactic	AJ_ic	"N(`syntax)+AJR20"
syn`thetic	AJ_ic	"AJ"
`syrupy	AJ	"N(`syrup)+AJR14"
system`atic	AJ_ic	"AJ"
sys`temic	AJ_ic	"N(`system)+AJR20"

`tabular	AJ	"N(`table)+AJR31"
`tacit	AJ	"AJ"
`taciturn	AJ	"AJ"
`tacky	AJ	"AJ"
`tactile	AJ	"AJ"
`talented	AJ	"N(`talent)+AJR8"
`talkative	AJ	"V(`talk)+AJR26"
`tall	AJ	"AJ"
`tame	AJ-to-V	"AJ"
`tangible	AJ	"AJ"
`tantamount	AJ	"AJ"
`tardy	AJ	"AJ"
`tart	AJ-to-N	"AJ"
`tasty	AJ	"N(`taste)+AJR14"
`tatty	AJ	"AJ"
`taut	AJ	"AJ"
`tawdry	AJ	"AJ"
`tawny	AJ	"AJ"
`taxpaying	AJ	"AJ"
`technical	AJ	"AJ"
tec`tonic	AJ_ic	"AJ"
`tedious	AJ	"AJ"
`teenage	AJ	"AJ"
`teenaged	AJ	"AJ"
`teensy	AJ	"AJ"
`teetotal	AJ	"AJ"
`telltale	AJ	"AJ"
tem`pestuous	AJ	"N(`tempest)+AJR21"
`tempered	AJ	"N(`temper)+AJR8"
`temperate	AJ	"AJ"
`temporal	AJ	"AJ"
`temporary	AJ	"AJ"
`tenable	AJ	"AJ"
ten`acious	AJ	"AJ"
ten`dencious	AJ	"V(`tend)+AJR27+NR40+AJR21"
ten`dentious	AJ	"V(`tend)+AJR27+NR40+AJR21"
`tender	AJ	"AJ"
tender`hearted	AJ	"AJ(`tender)+N(`heart)+AJR8"
`tendriled	AJ	"N(`tendril)+AJR8"
`tendrilled	AJ	"N(`tendril)+AJR8"
`tenebrous	AJ	"AJ"
`tense	AJ-to-V	"AJ"
`tensile	AJ	"AJ"
`tentacled	AJ	"N(`tentacle)+AJR8"
`tentative	AJ	"AJ"
`tenuous	AJ	"AJ"
`tenured	AJ	"N(`tenure)+AJR8"
`tepid	AJ	"AJ"
`terminable	AJ	"V(`terminate)+AJR25"
`terminal	AJ	"AJ"
`ternary	AJ	"AJ"
terpsicho`rean	AJ	"N(terp`sichore)+AJR4"
ter`restrial	AJ-to-N	"AJ"
`terrible	AJ	"AJ"
ter`rific	AJ_ic	"AJ"
`terse	AJ	"AJ"
`tertiary	AJ	"AJ"
testa`mentary	AJ	"N(`testament)+AJR22"
`testate	AJ	"AJ"
tes`ticular	AJ	"N(`testicle)+AJR31"
`testy	AJ	"AJ"
`thalamic	AJ_ic	"N(`thalamus)+AJR20"
`thankful	AJ	"V(`thank)+AJR9" ;or N(`thanks).PL
`thankless	AJ	"V(`thank)+AJR11"
the`atric	AJ_ic	"N(`theater)+AJR20"
theo`retic	AJ_ic	"N(`theory)+AJR20"
the`matic	AJ_ic	"N(`theme)+AJR20"
thera`peutic	AJ_ic	"N(`therapy)+AJR20"
`thermal	AJ	"AJ"
`thespian	AJ	"AJ"
`thick	AJ	"AJ"
`thieving	AJ	"AJ"
`thin	AJ-to-V	"AJ"
`thorned	AJ	"N(`thorn)+AJR8"
`thorough	AJ	"AJ"
`thoroughbred	AJ-to-N	"AJ"
`thoroughgoing	AJ	"AJ"
`threadbare	AJ	"AJ"
`threelegged	AJ	"AJ(`three)+N(`leg)+AJR8"
`thunderstruck	AJ	"AJ"
`ticklish	AJ	"V(`tickle)+AJR10"
`tidy	AJ-to-V	"AJ"
`tight	AJ	"AJ"
`timeworn	AJ	"AJ"
`timid	AJ	"AJ"
`tingly	AJ	"V(`tingle)+AJR14"
`tiny	AJ	"AJ"
`tippy	AJ	"V(`tip)+AJR14"
`tipsy	AJ	"AJ"
`tiresome	AJ	"V(`tire)+AJR15"
`titian	AJ	"AJ"
`titular	AJ	"N(`title)+AJR31"
`toed	AJ	"N(`toe)+AJR8"
`toilsome	AJ	"V(`toil)+AJR15"
`tolerable	AJ	"V(`tolerate)+AJR25"
`tolerant	AJ	"AJ"
`tony	AJ	"AJ"
`toothsome	AJ	"N(`tooth)+AJR15"
`topgallant	AJ	"AJ"
`topnotch	AJ	"AJ"
`torpid	AJ	"AJ"
`torrid	AJ	"AJ"
`tortuous	AJ	"N(`torture)+AJR21"
`total	AJ	"AJ"
`tough	AJ	"AJ"
`toxic	AJ_ic	"AJ"
`tractable	AJ	"AJ"
`tragic	AJ_ic	"AJ"
tragi`comic	AJ_ic	"AJ"
`tranquil	AJ	"AJ"
trans`alpine	AJ	"LOC5+AJ(`alpine)"
transat`lantic	AJ	"LOC5+AJ(at`lantic)"
transcen`dental	AJ	"V(tran`scend)+AJR27+AJR17"
transconti`nental	AJ	"LOC5+N(`continent)+AJR17"
`transient	AJ	"AJ"
trans`lucent	AJ	"AJ"
trans`missible	AJ	"V(trans`mit)+AJR25"
transoce`anic	AJ_ic	"LOC5+N(`ocean)+AJR20"
transpa`cific	AJ_ic	"LOC5+AJ(pa`cific)"
trans`parent	AJ	"AJ"
trans`versal	AJ	"AJ"
trans`verse	AJ	"AJ"
trau`matic	AJ_ic	"N(`trauma)+AJR20"
`treacherous	AJ	"N(`treachery)+AJR21"
`treble	AJ-to-N-V	"AJ"
`trembly	AJ	"V(`tremble)+AJR14"
tre`mendous	AJ	"AJ"
`tremulous	AJ	"AJ"
`trenchant	AJ	"AJ"
`trident	AJ-to-N	"AJ"
tri`ennial	AJ	"AJ"
`trim	AJ	"AJ"
trini`tarian	AJ-to-N	"N(`trinity)+AJR4"
tri`partite	AJ	"AJ"
`triple	AJ-to-N-V	"AJ"
`triplex	AJ	"AJ"
`triplicate	AJ-to-V	"AJ"
`trite	AJ	"AJ"
tri`une	AJ	"AJ"
tri`valent	AJ	"AJ"
`trivial	AJ	"AJ"
`troublesome	AJ	"N(`trouble)+AJR15"
`troy	AJ	"AJ"
`truant	AJ	"AJ"
`truculent	AJ	"AJ"
`true	AJ	"AJ"
`tubular	AJ	"N(`tube)+AJR31"
tu`mescent	AJ	"AJ"
tu`multuous	AJ	"N(`tumult)+AJR21"
`turbaned	AJ	"N(`turban)+AJR8"
`turbanned	AJ	"N(`turban)+AJR8"
`turbid	AJ	"AJ"
`turbulent	AJ	"AJ"
`turgid	AJ	"AJ"
`turnup	AJ-to-N	"AJ"
`tusked	AJ	"N(`tusk)+AJR8"
`tutelary	AJ-to-N	"AJ"
`twin	AJ-to-N	"AJ"
`typic	AJ_ic	"N(`type)+AJR20"
ty`rannic	AJ_ic	"N(`tyranny)+AJR20"
`twinkly	AJ	"V(`twinkle)+AJR14"

u`biquitous	AJ	"AJ"
`ugly	AJ	"AJ"
ul`terior	AJ	"AJ"
`ultimate	AJ	"AJ"
`ultra	AJ	"AJ"
um`bilical	AJ	"AJ"
u`nanimous	AJ	"AJ"
`unary	AJ	"AJ"
unbe`known	AJ	"NEG4+AJR2+V(`know).PTC"
unbe`knownst	AJ	"NEG4+AJR2+V(`know).PTC"
un`churched	AJ	"NEG4+N(`church)+AJR8"
`unctuous	AJ	"AJ"
un`couth	AJ	"AJ"
undecomposable	AJ	"NEG4+REV2+V(com`pose)+AJR25"
`undulant	AJ	"AJ"
;uniaxial	AJ	"AJ"
;unidimensional	AJ	"AJ"
;unidirectional	AJ	"AJ"
`uniform	AJ	"AJ"
;uni`lateral	AJ	"AJ"
;uni`modal	AJ	"AJ"
;uni`modular	AJ	"AJ"
;uni`nominal	AJ	"AJ"
;uni`polar	AJ	"AJ"
u`nique	AJ	"AJ"
;`unisex	AJ	"AJ"
uni`tarian	AJ-to-N	"N(`unity)+AJR4"
`unitary	AJ	"N(`unit)+AJR22"
uni`valent	AJ	"AJ"
uni`variate	AJ	"AJ"
uni`versal	AJ-to-N	"AJ"
un`kempt	AJ	"AJ"
un`ruly	AJ	"AJ"
un`stinting	AJ	"AJ"
un`toward	AJ	"AJ"
un`wieldy	AJ	"AJ"
un`witting	AJ	"AJ"
`up	AJ	"AJ"
`upbeat	AJ	"AJ"
`upcoming	AJ	"AJ"
up`hill	AJ	"AJ"
`upper	AJ	"AJ"
`uppercase	AJ	"AJ"
`upright	AJ-to-V	"AJ"
up`river	AJ	"AJ/AV"
up`roarious	AJ	"AJ"
`upscale	AJ	"AJ/AV"
upside-`down	AJ	"AJ"
up`standing	AJ	"AJ"
`upstate	AJ	"AJ/AV"
up`stairs	AJ	"AJ/AV"
up`stream	AJ	"AJ/AV"
`uptown	AJ	"AJ/AV"
up`wind	AJ	"AJ/AV"
`urban	AJ	"AJ"
ur`bane	AJ	"AJ"
`urgent	AJ	"AJ"
`urinary	AJ	"N(`urine)+AJR22"
`usual	AJ	"AJ"
`uterine	AJ	"AJ"
`utile	AJ	"AJ"
utili`tarian	AJ-to-N	"N(u`tility)+AJR4"
u`topian	AJ	"N(u`topia)+AJR4"
`utmost	AJ-to-N	"AJ"
`utter	AJ	"AJ"
`uvular	AJ	"N(`uvula)+AJR31"
ux`orial	AJ	"AJ"
ux`orious	AJ	"AJ"

`vacant	AJ	"AJ"
`vacuous	AJ	"AJ"
`vaginal	AJ	"N(va`gina)+AJR17"
`vagrant	AJ-to-N	"AJ"
`vague	AJ	"AJ"
`vain	AJ	"AJ"
vale`dictory	AJ	"AJ"
`valiant	AJ	"AJ"
`valid	AJ	"AJ"
`valved	AJ	"N(`valve)+AJR8"
`vaned	AJ	"N(`vane)+AJR8"
`vapid	AJ	"AJ"
`varicolored	AJ	"AJ"
`varicose	AJ	"AJ"
`various	AJ	"V(`vary)+AJR21"
`vascular	AJ	"AJ"
`vast	AJ	"AJ"
vege`tarian	AJ-to-N	"AJ"
`vehement	AJ	"AJ"
ve`hicular	AJ	"N(`vehicle)+AJR31"
`veined	AJ	"N(`vein)+AJR8"
`velar	AJ-to-N	"N(`velum)+AJR31"
`venal	AJ	"AJ"
`venerable	AJ	"V(`venerate)+AJR25"
ve`nereal	AJ	"AJ"
`vengeful	AJ	"V(`venge)+AJR9"
`venial	AJ	"AJ"
`venous	AJ	"AJ"
`ventral	AJ	"AJ"
`venturesome	AJ	"V(`venture)+AJR15"
ve`racious	AJ	"AJ"
`verbal	AJ-to-N	"AJ"
ver`batim	AJ	"AJ/AV"
ver`bose	AJ	"AJ"
ver`boten	AJ	"AJ"
`verdant	AJ	"AJ"
`verdured	AJ	"N(`verdure)+AJR8"
ve`ridical	AJ	"AJ"
`veritable	AJ	"AJ"
ver`nacular	AJ-to-N	"AJ"
`vernal	AJ	"AJ"
`versatile	AJ	"AJ"
`vertebral	AJ	"AJ"
`vertebrate	AJ-to-N	"AJ"
`vertical	AJ	"AJ"
ve`sicular	AJ	"N(`vesicle)+AJR31"
`vesper	AJ	"AJ"
`vestal	AJ	"N(`vesta)+AJR17"
`veterinary	AJ	"AJ"
vex`atious	AJ	"V(`vex)+AJR21"
`viable	AJ	"AJ"
`vibrant	AJ-to-N	"V(`vibrate)+AJR27"
vi`carious	AJ	"AJ"
`vicinal	AJ	"AJ"
`vicious	AJ	"AJ"
`vigilant	AJ	"N(`vigil)+AJR27"
`vile	AJ	"AJ"
`vincible	AJ	"AJ"
`vindicable	AJ	"V(`vindicate)+AJR25"
vin`dictive	AJ	"AJ"
`violable	AJ	"V(`violate)+AJR25"
`violent	AJ	"AJ"
`viral	AJ	"N(`virus)+AJR17"
`virile	AJ	"AJ"
`virtual	AJ	"AJ"
`virulent	AJ	"AJ"
`visaged	AJ	"N(`visage)+AJR8"
`visceral	AJ	"N(`viscus).PL+AJR17"
`viscous	AJ	"AJ"
`visible	AJ	"AJ"
`visionary	AJ	"N(`vision)+AJR22"
`visual	AJ-to-V	"AJ"
`vital	AJ	"AJ"
`vitreous	AJ	"AJ"
vi`vace	AJ	"AJ/AV"
vi`vacious	AJ	"AJ"
`vivid	AJ	"AJ"
vi`viparous	AJ	"AJ"
`vocal	AJ-to-N	"AJ"
vo`calic	AJ_ic	"AJ"
`vocative	AJ-to-N	"AJ"
vo`ciferous	AJ	"AJ"
`void	AJ-to-V	"AJ"
`volatile	AJ	"AJ"
vol`canic	AJ_ic	"N(vol`cano)+AJR20"
vol`taic	AJ_ic	"AJ"
`voluble	AJ	"AJ"
vo`luminous	AJ	"N(`volume)+AJR21"
`voluntary	AJ	"AJ"
vo`luptuous	AJ	"AJ"
vo`racious	AJ	"AJ"
`votive	AJ	"AJ"
`vulgar	AJ	"AJ"
`vulnerable	AJ	"AJ"
`vulpine	AJ	"AJ"

`wacky	AJ	"AJ"
`wakeup	AJ	"AJ"
`wan	AJ	"AJ"
`wanton	AJ	"AJ"
`warm	AJ-to-V	"AJ"
warm`hearted	AJ	"AJ(`warm)+N(`heart)+AJR8"
`wary	AJ	"AJ"
`waterproof	AJ	"AJ"
`watertight	AJ	"AJ"
`wavy	AJ	"N(`wave)+AJR14"
`waxen	AJ	"N(`wax)+AJR18"
`wayfaring	AJ	"AJ"
`wayward	AJ	"AJ"
`weak	AJ	"AJ"
`wearisome	AJ	"AJ"
`weary	AJ-to-V	"AJ"
`weatherbeaten	AJ	"AJ"
`weatherproof	AJ	"AJ"
`wee	AJ	"AJ"
`weepy	AJ	"V(`weep)+AJR14"
`weird	AJ	"AJ"
`well	AJ	"AJ" ;healthy
`westbound	AJ	"AJ"
`westerly	AJ	"AJ/AV"
`western	AJ-to-N	"AJ"
`wet	AJ	"AJ"
`wheezy	AJ	"V(`wheeze)+AJR14"
`whimsical	AJ	"N(`whimsy)+AJR20+AJR17"
`whiny	AJ	"V(`whine)+AJR14"
`whiskered	AJ	"N(`whisker)+AJR8"
`whole	AJ-to-N	"AJ"
whole`hearted	AJ	"AJ(`whole)+N(`heart)+AJR8"
`wholesome	AJ	"N(`whole)+AJR15"
`wholly	AJ	"N(`whole)+AJR13"
`whorled	AJ	"N(`whorl)+AJR8"
`wicked	AJ	"AJ"
`wide	AJ	"AJ"
`widemouthed	AJ	"AJ(`wide)+N(`mouth)+AJR8"
wide`spread	AJ	"AJ"
`wierd	AJ	"AJ"
`wiggly	AJ	"V(`wiggle)+AJR14"
`wild	AJ-to-N	"AJ"
`wilful	AJ	"AJ"
`willing	AJ	"AJ"
`wily	AJ	"N(`wile)+AJR14"
`windblown	AJ	"AJ"
`windswept	AJ	"AJ"
`winsome	AJ	"V(`win)+AJR15"
`wintry	AJ	"N(`winter)+AJR14"
`winy	AJ	"N(`wine)+AJR14"
`wiry	AJ	"N(`wire)+AJR14"
`wise	AJ	"AJ"
`wishy-washy	AJ	"AJ"
`wistful	AJ	"AJ"
`wobbly	AJ	"V(`wobble)+AJR14"
`woebegone	AJ	"AJ"
`wondrous	AJ	"N(`wonder)+AJR21"
`wont	AJ-to-V	"AJ"
`wooded	AJ	"N(`wood)+AJR8"
`wooden	AJ	"N(`wood)+AJR18"
`woodsy	AJ	"N(`wood)+PL+AJR14"
`woolen	AJ-to-N	"N(`wool)+AJR18"
`woollen	AJ-to-N	"N(`wool)+AJR18"
`woozy	AJ	"AJ"
`workaday	AJ	"AJ"
world`wide	AJ	"AJ"
`worrisome	AJ	"V(`worry)+AJR15"
worth`while	AJ	"AJ"
`wretched	AJ	"AJ"
`wriggly	AJ	"V(`wriggle)+AJR14"
`wrong	AJ-to-N-V	"AJ"
`wroth	AJ	"AJ"
wrong`headed	AJ	"AJ(`wrong)+N(`head)+AJR8"
`wrought	AJ	"AJ"
`wry	AJ	"AJ"

`yolked	AJ	"N(`yolk)+AJR8"
`yon	AJ	"AJ"
`young	AJ	"AJ"
`yummy	AJ	"AJ"

x-rated	AJ	"AJ"
xeno`phobic	AJ	"N(xeno`phobia)+AJR20"

`zany	AJ	"AJ"
`zingy	AJ	"AJ"
`zippered	AJ	"N(`zipper)+AJR8"
`zippy	AJ	"AJ"

END
