; TAG.LEX  8-Mar-91

; Copyright (c) 1991 by the Summer Institute of Linguistics
; for academic use only

; morphotactics are not specified beyond Prefix, Root, and Suffix

; parts of speech:
; N     noun  (Bloomfield's static words)
; V     verb  (Bloomfield's transient words)
; AJ    adjective
; NUM   numeral
; CNJ	conjunction
; PRT	particle
; PRO	pronoun
; DEM	demonstrative/deictic
; DET	determiner
; PREP	preposition
; QUANT	quantifier

; glosses
; EXT	existential
; NEG	negative/negator
; ENC	enclitic
; LKR	linker
; INV	inversion marker

; derivational affixes
; VR    verbalizer
; AJR   adjectivalizer
; CAUS  causative

; modes and aspects (Bloomfield 1917:217)
; ACT   actual mode
; CON   contingent mode
; DUR   durative

; active and passive forms
; DP    direct passive (Bloomfield 1917:243)
; IP    instrumental passive (Bloomfield 1917:247)
; LP    local passive (Bloomfield 1917:250)

; nominal categories

; cases (Bloomfield 1917:161)
; S		subjective
; D		disjunctive
; L		local

; SG	singular
; PL	plural

; deictic proximity
; D1	proximal (here)
; D2	near distal (there)
; D3	far distal (over there)


ALTERNATION Begin       PARTICLE NUMERAL N1_ROOT N2_ROOT AJ_PREFIX AJ_ROOT AV_ROOT V_PREFIX
ALTERNATION Particle	End
ALTERNATION Aj_Prefix   AJ_PREFIX N2_ROOT
ALTERNATION V_Prefix    V_PREFIX
ALTERNATION V_ROOT      V_ROOT
ALTERNATION V_Root      V_SUFFIX
ALTERNATION N_Root      End
ALTERNATION Aj_Root     End
ALTERNATION Av_Root     End
ALTERNATION Numeral     End
ALTERNATION V_Suffix    End
ALTERNATION Enclitic    End

LEXICON INITIAL
  0                     Begin           ""

LEXICON V_PREFIX
  mag-                  V_Prefix        "CON:VR1-"
  nag-                  V_Prefix        "ACT:VR1-"
  maN-                  V_Prefix        "CON:VR2-"
  naN-                  V_Prefix        "ACT:VR2-"
  m-                   V_Prefix        "CON:VR4-"
  n-                   V_Prefix        "ACT:VR4-"
  m-                   V_Prefix        "CON:VR4-"
  n-                   V_Prefix        "ACT:VR4-"
  mak-                 V_Prefix        "CON:VR5-"
  nak-                 V_Prefix        "ACT:VR5-"
  mak-                 V_Prefix        "CON:VR5-"
  nak-                 V_Prefix        "ACT:VR5-"
  maki-                 V_Prefix        "CON:VR6-"
  naki-                 V_Prefix        "ACT:VR6-"
  i-                    V_Prefix        "IP-"
  pag-                  V_Prefix        "VR1-"
  paN-                  V_Prefix        "VR2-"
  paki-                 V_Prefix        "VR6-"
  pa-                   V_Prefix        "CAUS-"
  ka-                   V_Prefix        "VR7-"
  k-                   V_Prefix        "VR7-"
  I-                    V_Prefix        "ACT-"
  U-                    V_Prefix        "VR3-"
  RE-                   V_Prefix        "DUR-"
  0                     V_ROOT                  ""

LEXICON AJ_PREFIX
  ma-                   Aj_Prefix       "AJR-"
  RE-                   Aj_Prefix       "PL-"

LEXICON PARTICLE
; the disjun ctive particle
  na                   Particle        "< PRT D >"
; determiners
  a                    Particle        "< DET S >"
;  na                  Particle        "< DET D >"
  sa                    Particle        "< DET L >"
  ky                   Particle        "< DET L >"
; plural marker
  maa                  Particle        "< PRT PL >"
; personal pronouns
  ak                   Particle        "< PRO S.1SG >"
  k                    Particle        "< PRO D.2SG >"
  kin                  Particle        "< PRO L.1SG >"
  ikw                  Particle        "< PRO S.2SG >"
  k                    Particle        "< PRO S.2SG >"
  m                    Particle        "< PRO D.2SG >"
  iy                   Particle        "< PRO L.2SG >"
  siy                  Particle        "< PRO S.3SG >"
  niy                  Particle        "< PRO D.3SG >"
  kany                 Particle        "< PRO L.3SG >"
  sil                  Particle        "< PRO S.3PL >"
  nil                  Particle        "< PRO D.3PL >"
  kanil                Particle        "< PRO L.3PL >"
  kit                  Particle        "< PRO 1/2SG >"
; deictics
  it                   Particle        "< DEM S.D1 >"
  iyn                  Particle        "< DEM S.D3 >"
  dto                  Particle        "< DEM L.D1 >"
  doqn                 Particle        "< DEM L.D3 >"
  gayn                 Particle        "< DEM similar.to.S.D3 >"
; interrogatives
  an                   Particle        "< PRT what >"
  bkit                 Particle        "< PRT why >"
  papno                Particle        "< PRT how >"
; linker
  na                    Particle        "< PRT LKR >"     ; linker
; conjunctions
  at                    Particle        "< CNJ and >"
  bgo                  Particle        "< CNJ before >"
  dhil                 Particle        "< CNJ because >"
  dahil                 Particle        "< CNJ because >"
  dtapuwat             Particle        "< CNJ but >"
  dtapuwat             Particle        "< CNJ but >"
  hba                 Particle        "< CNJ while >"
  ku                   Particle        "< CNJ if/when >"
;  na                  Particle        "< CNJ when >"
  o                     Particle        "< CNJ or >"
  pa                  Particle        "< CNJ in.order.to >"
  yma                 Particle        "< CNJ while >"
; prepositions
  gya                  Particle        "< PREP similar.to >"
  gaya                  Particle        "< PREP similar.to >"
  hag                Particle        "< PREP until >"
  mul                  Particle        "< PREP from >"
  mul                  Particle        "< PREP from >"
  nsa                  Particle        "< PREP at/in/on >"
  pato                Particle        "< PREP toward >"
; inversion marker
  ay                    Particle        "< PRT INV >"
; existential
  my                   Particle        "< PRT EXT >"
  may                   Particle        "< PRT EXT >"
  myroqon              Particle        "< PRT EXT >"
  walq                 Particle        "< PRT EXT.NEG >"
; negators
  hindq                Particle        "< PRT NEG >"
; quantifiers
  iln                  Particle        "< QUANT how many >"
; enclitic adverbs
  dn                   Particle        "< PRT ENC >"
  mn                   Particle        "< PRT ENC >"
  n                    Particle        "< PRT ENC >"
; miscellaneous
  salmat               Particle        "< PRT thank.you >"

LEXICON V_ROOT
  aklq                V_Root          "< V think >"
  akyt                 V_Root          "< V climb >"
  lay                  V_Root          "< V offer >"
  akn                 V_Root          "< V appropriate >"
  ral                  V_Root          "< V study >"
  riq                  V_Root          "< V able >"
  way                  V_Root          "< V fight >"
  blak                 V_Root          "< V plan >"
  bigy                 V_Root          "< V give >"
  bint                V_Root          "< V suspect >"
  ba                  V_Root          "< V bear.fruit >"
  daqn                 V_Root          "< V pass.by >"
  dal                  V_Root          "< V carry >"
  dat                 V_Root          "< V come/arrive >"
  dyaq                 V_Root          "< V cheat >"
  dikdk                V_Root          "< V crush >"
  ding                 V_Root          "< V hear >"
  dpoq                 V_Root          "< V alight >"
  dsa                  V_Root          "< V suffer >"
  glit                 V_Root          "< V angry >"
  gpa                 V_Root          "< V crawl >"
  gawq                 V_Root          "< V do/make >"
  gis                 V_Root          "< V wake up >"
  gust                 V_Root          "< V want >"
  hbol                 V_Root          "< V chase >"
  hgis                 V_Root          "< V toss >"
  hmon                 V_Root          "< V challenge >"
  hnap                 V_Root          "< V seek >"
  htiq                 V_Root          "< V divide >"
  hla                  V_Root          "< V drag >"
  hil                 V_Root          "< V request >"
  hinlq               V_Root          "< V suspect >"
  hing                 V_Root          "< V ripen >"
  hintq                V_Root          "< V stop >"
  hlog                 V_Root          "< V fall/drop >"
  hli                  V_Root          "< V catch >"
  hul                  V_Root          "< V be late/last >"
  big                  V_Root          "< V like/want >"
  kbilq               V_Root          "< V on.both.sides >"
  kqin                 V_Root          "< V eat >"
  kya                  V_Root          "< V able >"
  kinqin               V_Root          "< V graze >"
  kta                  V_Root          "< V see >"
  lkad                 V_Root          "< V walk >"
  lgoq                 V_Root          "< V bathe >"
  ligts                V_Root          "< V save >"
  linamnm              V_Root          "< V tasty >"
  luks                 V_Root          "< V jump.over >"
  lnod                 V_Root          "< V drown >"
  lta                 V_Root          "< V float >"
  g                   V_Root          "< V become >"
  masd                 V_Root          "< V look at >"
  maty                 V_Root          "< V die >"
  pamat               V_Root          "< V look.down.on >" ; figurative
  paty                 V_Root          "< V kill >"
  pliq                 V_Root          "< V choose >"
  plit                 V_Root          "< V try >"
  pyag                 V_Root          "< V agree >"
  sbi                  V_Root          "< V say >"
  sbog                 V_Root          "< V scatter >"
  sagt                 V_Root          "< V answer >"
  salbo               V_Root          "< V meet >"
  sigw                 V_Root          "< V shout >"
  sump                V_Root          "< V overcome >"
  tagpq                V_Root          "< V meet >"
  takb                 V_Root          "< V run >"
  tlo                  V_Root          "< V defeat >"
  tlon                 V_Root          "< V defeat >"    ; irregular form
  tanw                 V_Root          "< V see.from.afar >"
  tay                 V_Root          "< V carried.along >"
  tanm                 V_Root          "< V plant >"
  taq                 V_Root          "< V consent >"
  twa                  V_Root          "< V laugh/smile >"
  twag                 V_Root          "< V call >"
  tink                 V_Root          "< V pricked.by.thorns >"
  tin                 V_Root          "< V look at >"
  tboq                 V_Root          "< V grow >"
  tlog                 V_Root          "< V sleep >"
  umpis                V_Root          "< V begin >"
  un                   V_Root          "< V get.ahead >"
  wkaq                 V_Root          "< V speak >"
  yri                  V_Root          "< V happen >"
  
; concrete nouns
LEXICON N1_ROOT
  gos                  N_Root          "< N1 current >"
  raw                  N_Root          "< N1 day/sun >"
  so                   N_Root          "< N1 dog >"
  balt                 N_Root          "< N1 skin/peel >"
  band                 N_Root          "< N1 direction >"
  bhay                 N_Root          "< N1 life >"
  bhoq                 N_Root          "< N1 bamboo >"
  ba                  N_Root          "< N1 fruit >"
  dan                  N_Root          "< N1 path/way >"
  dhon                 N_Root          "< N1 leaf >"
  damhan               N_Root          "< N1 grass.field >"
  dlo                  N_Root          "< N1 end >"
  gitnq                N_Root          "< N1 middle >"
  gbat                 N_Root          "< N1 forest >"
  hpon                 N_Root          "< N1 afternoon >"
  hukm                 N_Root          "< N1 judge >"
  log                  N_Root          "< N1 river >"
  kabil                N_Root          "< N1 side >"
  klaw                 N_Root          "< N1 owl >"
  kalunran             N_Root          "< N1 west >"
  kapart               N_Root          "< N1 part >"
  kaptol               N_Root          "< N1 piece >"
  katmran             N_Root          "< N1 laziness >"
  kaybgan              N_Root          "< N1 friend >"
  kayibgan             N_Root          "< N1 friend >"
  lamn                 N_Root          "< N1 flesh/muscle >"
  lpaq                 N_Root          "< N1 ground >"
  lus                 N_Root          "< N1 mortar >"
  paq                  N_Root          "< N1 leg/foot >"
  pag                 N_Root          "< N1 turtle >"
  palgid               N_Root          "< N1 surroundings >"
  panukl              N_Root          "< N1 thought >"
  paaatawn           N_Root          "< N1 physique/body >"
  pasgan               N_Root          "< N1 beach >"
  pnoq                 N_Root          "< N1 tree >"
;  pno_=sgi         N_Root          "< N1 banana.tree >"
  sgi                 N_Root          "< N1 banana >"
  salitq               N_Root          "< N1 word >"
  sandalq              N_Root          "< N1 moment >"
  susq                 N_Root          "< N1 snail >"
  tink                 N_Root          "< N1 thorn >"
  trhan               N_Root          "< N1 dwelling >"
  toqd                 N_Root          "< N1 stump >"
  tbig                 N_Root          "< N1 water >"
  ugq                 N_Root          "< N1 monkey >"
  us                   N_Root          "< N1 deer >"

; abstract nouns that form descriptive adjectives with ma-
LEXICON N2_ROOT
  bgal                 N_Root          "< N2 slowness >"
  bti                  N_Root          "< N2 goodness >"
  dno                 N_Root          "< N2 wisdom >"
  hbaq                 N_Root          "< N2 length >"
  hnaq                 N_Root          "< N2 weakness >"
  nam                  N_Root          "< N2 handsomeness >"
  laks                 N_Root          "< N2 strength >"
  lak                  N_Root          "< N2 size >"
  llim                 N_Root          "< N2 depth >"
  tbay                 N_Root          "< N2 firmness >"
  tlin                 N_Root          "< N2 swiftness >"
  ybo                 N_Root          "< N2 denseness.of.growth >"

; unaffixed adjectives
LEXICON AJ_ROOT
  ull                  Aj_Root         "< AJ foolish >"
  hing                 Aj_Root         "< AJ ripe >"

; unaffixed adverbs
LEXICON AV_ROOT
  khit                 Av_Root         "< AV even >"
  mnsan                Av_Root         "< AV once >"
  mulq                 Av_Root         "< AV again >"
  pagdka               Av_Root         "< AV immediately >"
  parti                Av_Root         "< AV always >"
  pho                  Av_Root         "< AV surely >"
  sigro                Av_Root         "< AV perhaps >"
  bus=laks            Av_Root         "< AV full.strength >"

LEXICON NUMERAL
  is                   Numeral         "< NUM one >"
  dalaw                Numeral         "< NUM two >"
  tatl                 Numeral         "< NUM three >"
  pat                  Numeral         "< NUM four >"
  lim                  Numeral         "< NUM five >"
  nim                  Numeral         "< NUM six >"
  pit                  Numeral         "< NUM seven >"
  wal                  Numeral         "< NUM eight >"
  siym                 Numeral         "< NUM nine >"
  sampq                Numeral         "< NUM ten >"
  dalawamp             Numeral         "< NUM twenty >"
  daqn                 Numeral         "< NUM hundred >"
  lbo                  Numeral         "< NUM thousand >"

LEXICON V_SUFFIX
  +in                   V_Suffix        "+DP"	; direct passive
  +an                   V_Suffix        "+LP"	; local passive
  0                     V_Suffix        ""

LEXICON End
  _                    Particle                "_LKR"  ; enclitic
  _t                    Particle                "_and"  ; enclitic
  _y                    Particle                "_INV"  ; enclitic
  =                     Begin                   "="             ; compound word
  0                     #               ""

END
