/*
 * MultiMail offline mail reader
 * color pairs #define'd here

 Copyright (c) 1996 John Zero <john@graphisoft.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#ifndef MMCOLOR_H
#define MMCOLOR_H

#define COL(x, y) COLOR_PAIR(((x) << 3) + y)

#define C_SBACK		COL(COLOR_WHITE, COLOR_BLACK)	//Start screen/backgnd
#define C_SBORDER	COL(COLOR_BLUE, COLOR_BLACK)	//Start screen/border
#define C_SSEPBOTT	COL(COLOR_MAGENTA, COLOR_BLACK)	//Start screen/bottom 
#define C_HELP1		COL(COLOR_WHITE, COLOR_BLACK)	//Help descriptions
#define C_HELP2		COL(COLOR_YELLOW, COLOR_BLACK)	//Help keys
#define C_HELP3		COL(COLOR_WHITE, COLOR_BLUE)	//Help 2 border
#define C_HELP4		COL(COLOR_YELLOW, COLOR_BLUE)	//Help 2 text
#define C_WELCOME1	COL(COLOR_YELLOW, COLOR_BLUE)	//Welcome border
#define C_WELCOME2	COL(COLOR_CYAN, COLOR_BLUE)	//Welcome names
#define C_ADDR1		COL(COLOR_WHITE, COLOR_GREEN)	//Address book/backgnd
#define C_ADDR2		COL(COLOR_GREEN, COLOR_GREEN)	//Address book/headers
#define C_ADDR3		COL(COLOR_RED, COLOR_GREEN)	//Address book/text
#define C_LISTWIN	COL(COLOR_WHITE, COLOR_BLUE)	//Letter list/top text1
#define C_WTEXT		COL(COLOR_WHITE, COLOR_RED)	//Warning/text
#define C_WTEXTHI	COL(COLOR_YELLOW, COLOR_RED)	//Warning/hilightext
#define C_LTEXT		(COL(COLOR_WHITE, COLOR_BLUE) | A_BOLD)	//Letter/text
#define C_LQTEXT	COL(COLOR_WHITE, COLOR_BLUE)	//Letter/quoted text
#define C_LTAGLINE	COL(COLOR_CYAN, COLOR_BLUE) | A_BOLD	//Letter/tagline
#define C_LTEAR		COL(COLOR_BLUE, COLOR_BLUE) | A_BOLD	//Letter/tear
#define C_LORIGIN	COL(COLOR_BLUE, COLOR_BLUE) | A_BOLD	//Letter/origin

#ifdef __PDCURSES__
#define C_LBOTTSTAT	COL(COLOR_WHITE, COLOR_MAGENTA)	//Letter/bottom statline
#else
#define C_LBOTTSTAT	(COL(COLOR_MAGENTA, COLOR_WHITE) | A_REVERSE)
#endif

#define C_LHEADTEXT	COL(COLOR_BLUE, COLOR_CYAN)	//Letter/header text
#define C_LHMSGNUM	COL(COLOR_WHITE, COLOR_CYAN) | A_BOLD	//msgnum 
#define C_LHFROM	COL(COLOR_GREEN, COLOR_CYAN) | A_BOLD	//from
#define C_LHTO		COL(COLOR_WHITE, COLOR_CYAN) | A_BOLD	//to
#define C_LHSUBJ	COL(COLOR_BLUE, COLOR_CYAN) | A_BOLD	//subject
#define C_LHDATE	COL(COLOR_WHITE, COLOR_CYAN) | A_BOLD	//date
#define C_LHBORDER	COL(COLOR_BLUE, COLOR_CYAN)	//border
#define C_LHFLAGSHI	COL(COLOR_YELLOW, COLOR_CYAN) | A_BOLD	//flags high
#define C_LHFLAGS	COL(COLOR_WHITE, COLOR_CYAN)	//flags
#define C_PBBACK	COL(COLOR_YELLOW, COLOR_BLUE) | A_BOLD	//Packet/header 
#define C_PMODESTAT	COL(COLOR_RED, COLOR_BLUE) | A_BOLD	//bw/qwk mode
#define C_PHEADTEXT	COL(COLOR_GREEN, COLOR_BLUE) | A_BOLD	//line text
#define C_PLINES	COL(COLOR_CYAN, COLOR_BLUE) | A_BOLD	//Packet/lines
#define C_LALBTEXT	COL(COLOR_WHITE, COLOR_BLUE) | A_BOLD	//Little area 
#define C_LALLINES	COL(COLOR_WHITE, COLOR_BLUE) | A_BOLD	//line text
#define C_ALREPLINE	COL(COLOR_YELLOW, COLOR_BLUE)	//Area list/reply area
#define C_ALPACKETLINE	COL(COLOR_CYAN, COLOR_BLUE)	//Area list/normal
#define C_ALINFOTEXT	COL(COLOR_YELLOW, COLOR_BLUE) | A_BOLD	//info win
#define C_ALINFOTEXT2	COL(COLOR_WHITE, COLOR_BLUE) | A_BOLD	//filled text
#define C_ALBTEXT	COL(COLOR_GREEN, COLOR_BLUE) | A_BOLD	//border text
#define C_ALBORDER	COL(COLOR_YELLOW, COLOR_BLUE) | A_BOLD	//border
#define C_ALHEADTEXT	COL(COLOR_MAGENTA, COLOR_BLUE) | A_BOLD	//header text
#define C_LETEXT	COL(COLOR_WHITE, COLOR_BLUE) | A_BOLD	//Letter text
#define C_LEGET1	COL(COLOR_CYAN, COLOR_BLUE)	//Letter/enter get1
#define C_LEGET2	COL(COLOR_GREEN, COLOR_BLUE) | A_BOLD	//get2
#define C_LLSAVETEXT	COL(COLOR_WHITE, COLOR_RED) | A_BOLD	//Letter/save
#define C_LLSAVEGET	COL(COLOR_YELLOW, COLOR_RED) | A_BOLD	//get
#define C_LLBBORD	COL(COLOR_YELLOW, COLOR_BLUE) | A_BOLD	//Letter list
#define C_LLTOPTEXT1	COL(COLOR_WHITE, COLOR_BLUE) | A_BOLD	//top text1
#define C_LLTOPTEXT2	COL(COLOR_GREEN, COLOR_BLUE) | A_BOLD	//areaname
#define C_LLHEAD	COL(COLOR_YELLOW, COLOR_BLUE) | A_BOLD	//headers
#define C_LLLINES	COL(COLOR_WHITE, COLOR_BLUE)	//Letter list/lines
#define C_TBBACK	COL(COLOR_YELLOW, COLOR_YELLOW) | A_BOLD //Tagline
#define C_TTEXT 	COL(COLOR_WHITE, COLOR_YELLOW) | A_BOLD	//Tagline/text
#define C_TKEYSTEXT	COL(COLOR_GREEN, COLOR_YELLOW) | A_BOLD	//key select
#define C_TENTER 	COL(COLOR_GREEN, COLOR_YELLOW) | A_BOLD	//Tagline/enter
#define C_TENTERGET	COL(COLOR_MAGENTA, COLOR_YELLOW) | A_BOLD //enter get
#define C_TLINES	COL(COLOR_MAGENTA, COLOR_YELLOW) | A_BOLD //lines
#define C_TERR1 	COL(COLOR_BLUE, COLOR_YELLOW) | A_BOLD	//Tagline/error1
#define C_TERR2 	COL(COLOR_RED, COLOR_YELLOW) | A_BOLD	//Tagline/error2
#define C_SHADOW	COL(COLOR_WHITE, COLOR_WHITE)	//All black!

void init_colors();

#endif
