/*
 * MultiMail offline mail reader
 * mmail class

 Copyright (c) 1996 Toth Istvan <stoty@vma.bme.hu>
 Copyright (c) 1998 William McBrine <wmcbrine@clark.net>,
                    Robert Vukovic <vrobert@uns.ns.ac.yu>

 Distributed under the GNU General Public License.
 For details, see the file COPYING in the parent directory. */

#include "mmail.h"
#include "compress.h"

const char *net_address::text()
{
	static char netText[25];

	if (point)
		sprintf(netText, "%u:%u/%u.%u", zone, net, node, point); 
	else
		sprintf(netText, "%u:%u/%u", zone, net, node);

	return netText;
}

void net_address::init(const char *source)
{
	if (sscanf(source, "%u:%u/%u.%u", &zone, &net, &node, &point) == 3)
		point = 0;
}

mmail::mmail()
{
	resourceObject = new resource();
};

mmail::~mmail()
{
	delete resourceObject;
};

void mmail::Delete()
{
	delete areaList;
	delete driverList;
	delete workList;
}

void mmail::selectPacket(const char *packetName)
{
  	char fname[255];

	resourceObject->set(PacketName, packetName);

	// Uncompression is done here
	sprintf(fname, "%s/%s", resourceObject->get(PacketDir),
		packetName);

	if (!resourceObject->get(oldPacketName) ||
                strcmp(packetName, resourceObject->get(oldPacketName)))
			uncompressFile(resourceObject, fname,
				resourceObject->get(WorkDir));
	resourceObject->set(oldPacketName, packetName);

	workList = new file_list(resourceObject->get(WorkDir));
	driverList = new driver_list(this);
	areaList = new area_list(this);
};

void mmail::saveRead()
{
	driverList->getReadObject(driverList->getDriver(REPLY_AREA + 1))->
		saveAll();
};
