unit rnrglob;

{

rnrglob.pas - constants, types, and global variables for rnr

}

{$I rnr-def.pas}

interface

{$ifdef mouse}

uses mouse;

{$endif}

const
  newsreadername='rnr';
  newsreaderversion='v2.21';
  releasedate='960909';

  oldnewsreadername='rusnews';

  faqcookie='<FAQ>';
  builtincookie='(builtin)';

  ifaceversionunix='unix';

  defaultmailmarkerline=
   '(begin your PRIVATE mail at this line, but no sooner)';

  defaultnewsmarkerline=
    '(begin your PUBLIC post at this line, but no sooner)';

{$ifdef tiny}
  maxarts=60;
  maxkills=50;
  maxjoined=120;
{$else}
  maxarts=1800;  {on my DOS machine, it maxes out at <1200 anyway}
  maxkills=200;
  maxjoined=150;
{$endif}

  maxlpp=50;
  maxcols=132;

  minlpp=8;
  mincols=32;

  eightbitclean=true;

  selheaderlines=1;
  headerbufsize=6144;
  headertlsize=256;

{$ifndef mouse}
  hasmouse=false;
{$endif}

  impossiblylargeart=maxlongint;
    {note:  needs to be the maximum `articlefilenametype' value}

  maxsubjectlen=70;
  maxfilenamelen=14;
  maxfromlen=20;
  maxgrouplen=50;

  maxpathlen=64;

{ a command can only be a path, unless it's options }
{
  maxcmdlen=128;
}

  shortstringlen=40;

  numhashedrefs=4;

  maxoverviewlines=4;

{ 36 is max 26 letters+max 10 digits }
  maxselections=36;

type
  articlefilenametype=longint;
  pathstring=string[maxpathlen];
{
  cmdstring=string[maxcmdlen];
}
  cmdstring=pathstring;
  shortstring=string[shortstringlen];
  subjstringt=string[maxsubjectlen];
  fnstringt=string[maxfilenamelen];
  datet=longint;  {year * 16384 + month * 1024 + dayofmonth * 32 + gmthour}
  fromstringt=string[maxfromlen];
  groupstringt=string[maxgrouplen];
{
  fnarray=array[1..maxarts] of fnstringt;
  fromarray=array[1..maxarts] of fromstringt;
  datearray=array[1..maxarts] of datet;
}
  headerbuft=array[1..headerbufsize] of char;
  headerlinet=
    record
      first: char;
      offset: integer;
    end;
  headertrackedlinest=array[1..headertlsize] of headerlinet;

  hashedt=array[1..2] of word;
{
  hashedarr=array[1..maxarts] of hashedt;
}
  ifacetype=(ifacewaffle, ifaceuupc, ifaceuufree, ifaceunknown);

{$ifdef mouse}
  mevent=
    record
      event, btnstatus, horiz, vert: word;
    end;
{$endif}

  sourcetype=(sourcegroup, sourcedir, sourcefolder);
  layoutt=(layoutfirst,layoutnormal,layoutsquashed,layoutlast);

  articlet=
    record
      filename: fnstringt;
      from: fromstringt;
      date: datet;
      basesubject: subjstringt;
      hmessageid: hashedt;
      hreferences: array[1..numhashedrefs] of hashedt;
{high nybble of indents used for auto-selected articles etc.}
      indents: byte;
      sizeink: byte;
      canonfirstchar: char;
      numcrossposts: byte;
    end;
  articlept=^articlet;

var
  oldfilemode: byte;

  articles: array[1..maxarts] of articlept;
  allocatedarts: integer;

  currdir: pathstring;
  currsource: string;
  currsourcekind: sourcetype;
  userid: shortstring;
  shadow: integer;
  numarts: integer;
  numjoined: integer;
  unscannedarts: boolean;

{
  indents: array[1..maxarts] of byte;
  sizeink: array[1..maxarts] of byte;
  basesubjs: array[1..maxarts] of subjstringt;
  canonfirstchars: array[1..maxarts] of char;
}

  joinedgroups: array[1..maxjoined] of groupstringt;

{
  filenamesp: ^fnarray;
  fromsp: ^fromarray;
  datesp: ^datearray;
  hmessageidsp: ^hashedarr;
  hreferencesp: array[1..numhashedrefs] of ^hashedarr;
}

  highestart: articlefilenametype;
  highestread: articlefilenametype;

  wafenv: pathstring;
  spooldir,temporarydir,userdir,configdir,outboxdir: pathstring;

  uucpname,smarthost,timezone: shortstring;

  fqdn,organ,backbone: string;

  outform: shortstring;

  smarthostdir: pathstring;

  newsname: shortstring;
  netmail: string;
  netnews: string;
  replyto: string;

  home: pathstring;

  joinfn: pathstring;
  joinf: text;
  rcfilename: pathstring;

  alreadyread: articlefilenametype;

  headerinmem: pathstring;
  headerbuf: headerbuft;
  headertrackedlines: headertrackedlinest;
  headerbytesinmem: integer;

  donegroup: boolean;

  browsedir: integer;

  browseonlysel: boolean;
  needtofindnextgroup: boolean;

  lowestartsearched: articlefilenametype;
  highestartsearched: articlefilenametype;

  readpagesback: integer;
  readunfiltered: boolean;
  antikilledonly: boolean;
  searchinheaders: boolean;
  searchinbody: boolean;
  searchthedate: boolean;
  searchinsubj: boolean;
  searchinname: boolean;
  searchtext: string;
  searchdatelow: datet;
  searchdatehigh: datet;

  gotoverbose: boolean;

  findgroupstring: string;
  browseuppersearchstring: string;
  nextwhilereading: boolean;
  editor: pathstring;
  editoroptions: cmdstring;
  vspeller: pathstring;
  vspelleroptions: cmdstring;

{so that shutdown can close them}
  haskillfile: boolean;
  hasantikillfile: boolean;
  killf,antikillf: text;

  fullname: string;
  iface: shortstring;
  xiface: ifacetype;
  ifaceversion: shortstring;
  uupcusr: pathstring;
  uupcsys: pathstring;
  console: boolean;
  port: integer;
  trusted: boolean;
  maymail: boolean;
  maypost: boolean;
  minutestorun: integer;
  forumsetl: string;
  mailfrom: string;
  newsfrom: string;
  lpp: integer;
  sellpp: integer;
  cols: integer;
  lowcolor: byte;
  highcolor: byte;
  oldtextattr: byte;
  lastfilen: pathstring;
  lastfolder: pathstring;
  comspec: pathstring;
  fileresult: integer;  {takes the place of IOresult with safereset/rewrite}
  execresult: integer;  {takes the place of doserror with execp}
  internalcmdlineparams: string;
  quotechar: char;
  bodyaddress: string;

{$ifdef timeout}
  minstart: integer;
{$endif}

{$ifdef mouse}
  hasmouse: boolean;
  mousevent: mevent;
  themouse: resetrec;
{$endif}

{keyboard mapping}

  browsemap: array[char] of char;
  selmap: array[char] of char;
  mainmap: array[char] of char;

implementation

end.
