/*--------------------------------------------------------------------
   Alged:  Algebra Editor    henckel@vnet.ibm.com

   Visit the Alged homepage!

	http://www.GeoCities.com/Paris/6502

   Copyright (c) 1994 John Henckel
   Permission to use, copy, modify, distribute and sell this software
   and its documentation for any purpose is hereby granted without fee,
   provided that the above copyright notice appear in all copies.
*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <conio.h>
#include <time.h>
#include "mouse.h"

#define MAXP 5
#define MAXM 50
typedef unsigned char uchar;

#ifndef __IBMC__
extern void _floatconvert();        /* force load float libs */
#pragma extref _floatconvert
#endif

/*-----------------------------------------------------------------
   The following is the fundamental data structure for alged.
   >> when you create a new node you need to set kind,nump,parm,
   and name (or value for NUMbers).
   >> tag is used to debug memory problems, if the node is allocated
   then it should be 12345, else it should not be.
   >> sx,sy,px,py,ay are set by the display functions and used by the
   findnode.  name is set for numbers only.
   >> ay is used to adjust the visual appearance of vertically stacked
   operations like EXP and DIV.
*/
typedef struct node {
  char name[8];
  struct node *parm[MAXP];
  short tag;
  double value;
  short sx,sy;       /* size */
  short px,py;      /* location on scrn */
  short ay;         /* adjust y */
  short kind;
  short nump;
  char *msg;
  struct node *next;
} node;


/* note: you may add to the end of this list, but don't insert or change
   the order */
enum KIND { EQU,FUN,ADD,SUB,MUL,DIV,EXP,VAR,NUM,BAD };
enum menui {
    SIM, ASS, PCO, PLY, SBS, ADZ, SUZ, CLR,
    DIS, COD, PRV, QUA, EXX, MUZ, DEL, LOD,
    CAL, CH8, NXT, FAP, EXJ, DIZ, INK, SAV,
    RAT, PPL, PP0, PPR, EQK, EXZ, ENT, WRI,
    HLP, PRI, ESC, CUB, GRF, XE0, P2K, P2L,
    P2R, P2T, XE1, DEK, DI2, SI2, COF, maxm };

/*--------------------------------------------------------------------
   MACROS
*/
#define setmax(x,y) if ((x)<(y)) x=(y)
#define relxy(x,y) gotoxy(wherex()+(x),wherey()+(y))
#define lf parm[0]
#define rt parm[1]
#define pause delay(1000)
/*-----------------------------------------------------------------
   Function Prototypes
*/
void checknull(void *p);
node *newnode(void);
node *newnum(double val);
node *newvar(char *s);
node *newoper(int kind);
void freenode(node *p);
void freetree(node *p);
void nodecpy(node *a, node *b);
void movenode(node *a, node *b);
node *cons(node *left,int opr,node *right);
node *deepcopy(node *p);
int equal(node *p,node *q);
node *lastnode(node *p);
node *prevnode(node *p);
int cmp(node *p,node *q);
int sortnode(node *p,int oper);
void primefact(node *p);
int rational_search(node *p);
int reduce(double *a,double *b);
int ration(node *p);
void associate(node *p);
int expjoin(node *p);
int nosubdiv(node *p);
int bisect(node *p);
int exexpand(node *p);
int comdeno(node *p);
int comfact(node *p);
int distribute2(node *p);
int distribute(node *p);
int distribute_c(node *p);
int fixassoc(node *p);
int movenums(node *p,int up,int oper);
int calcnode(node *p,int keeprat);
node *get_term(node *p, int oper, double *r);
int combine(node *p);
node *maketree(node **coef, int sz, node *base);
int findbase(node *a, node *b);
node **maketable(node *base, node *p, int *size);
node *polydiv(node *base, node *nm, node *dn);
void polycoef(node *base, node *p);
void quadratic(node *base,node *p);
void cross_eq(node *p, int i);
void cubic(node *base,node *pol);
node *nextfact(node *p,int i);
node *checkroot(node *base, node *p, node *den);
void factrpoly(node *base,node *p);
void twirl(void);
void dumpnode(node *p,int tab);
void resize(node *p,int ppr);
void leftpar(int h);
void rightpar(int h);
int fixattr(node *p);
void show(node *p,int ppr,int x,int y);
long countmem();
void show_menu(void);
int selection(int x, int y);
void display(node *p);
int debug(node *p);
void simplify(node *p);
void simplify2(node *p,int slow);
node *load(char *filename);
node *loadinfix(char *filename);
node *reverse(node *b);
void loadfile(char *fn);
void fprinttree(FILE *f,node *p);
void graph(node *fx,node *fy);
void putmsg(FILE *f,char *m);
void savefile(char *fn);
void fwritetree(FILE *f,node *p,int pr);
void writefile(char *fn);
node *find_node(node *p,int x,int y);
void substitution(node *p);
void insertkey(int opr);
char *keyin(char *pmt);
void showhelp(char *arextern0);
int loadmenu(char *arextern0);
/*-----------------------------------------------------------------
   some macros used by simplify
*/
#define swingb do { \
      p->rt = b->rt; \
      b->rt = b->lf; \
      b->lf = p->lf; \
      p->lf = b; } while(0)
#define swinga do { \
      p->lf = a->lf; \
      a->lf = a->rt; \
      a->rt = p->rt; \
      p->rt = a; } while(0)
#define aop(x) ((x)==ADD || (x)==SUB)

#define whole(x) (fmod((x),1)==0)

/* end of file alged.h */
#ifdef MAIN
#include "algmain.h"
#else
#include "algvars.h"
#endif
