comment ! 
FSU - ULTRA	The greatest random number generator that ever was
		or ever will be.  Way beyond Super-Duper.
		(Just kidding, but we think its a good one.)

Authors:	Arif Zaman (arif@stat.fsu.edu) and
		George Marsaglia (geo@stat.fsu.edu).

Date:		27 May 1992

Version:	1.05

Copyright:	To obtain permission to incorporate this program into
		any commercial product, please contact the authors at
		the e-mail address given above or at

		Department of Statistics and
		Supercomputer Computations Research Institute
		Florida State University
		Tallahassee, FL 32306.

See Also:	README		for a brief description
		ULTRA.DOC	for a detailed description

-----------------------------------------------------------------------
! 
;
; File: ULTRA_C.ASM  (Turbo C calling conventions)
;
	ifdef     __TINY__
		m equ tiny
	elseifdef __SMALL__
		m equ small
	elseifdef __COMPACT__
		m equ compact
	elseifdef __MEDIUM__
		m equ medium
	elseifdef __LARGE__
		m equ large
	elseifdef __HUGE__
		m equ huge
	endif
	DOSSEG
	.MODEL m,c

;===== GLOBAL FUNCTIONS, SUBROUTINES and VARIABLES =================
;
	public  i31bit, i15bit, i7bit,  i1bit,  uni,    duni
	public  i32bit, i16bit, i8bit,  rinit,  vni,    dvni
	public	swbstate, swbsize

;===== MACRO DEFINITIONS ===========================================
;
; RinitProcStart should take two 32-bit arguments conx and shrx
;   and place them in the data segment in congx and shrgx.
;   es and ds should both point to the data segment.
;   conx must be odd (so we or with 1 just to make sure).
; FillProc
;   DS is already the data segment. ES should also be made the same.

EnterProcedure   macro	saveregs
    if @DataSize eq 2
	mov  dx,@DATA
	push ds
	mov  ds,dx
    endif
    irp reg,saveregs
	ifidn	<reg>,<si>
	    push si
	elseifidn <reg>,<di>
	    push di
	endif
    endm
endm

ExitProcedure    macro	saveregs
    irp reg,saveregs
	ifidn	<reg>,<di>
	    pop di
	elseifidn <reg>,<si>
	    pop si
	endif
    endm
    if @DataSize eq 2
      pop ds
    endif
    ret
endm

Enter2arg	macro
  arg conx:dword, shrx:dword
  EnterProcedure <si,di>
    mov ax,ds
    mov es,ax
    mov ax,word ptr conx
    shl ax,1
    mov conglo,ax
    mov ax,word ptr conx+2
    rcl ax,1
    mov conghi,ax
    or  byte ptr conglo,1
    mov ax,word ptr shrx
    mov shrglo,ax
    mov ax,word ptr shrx+2
    mov shrghi,ax
endm

Exit2arg	macro
  ExitProcedure <di,si>
endm

EnterFill	macro
	push	si
	push	di
	mov	ax,ds
	mov	es,ax
endm

ExitFill	macro
	pop	di
	pop	si
	ret
endm

DwordFn macro
endm

WordFn  macro
endm

ByteFn  macro
endm

RealFn  macro
endm
 
DoubleFn macro
endm
 
.DATA
  INCLUDE ULTRADAT.INC

.CODE
  INCLUDE ULTRACOD.INC

END
