/* FITTYPES.H
   C include file defining types for Nonlinear Fitter dynamic-link libraries */

#define MaxParams 5        // Max number of variable parameters
#define MaxDataPoints 1024 // Max number of residuals (observations)
#define MaxOutVectors 10   // Max number of outputed vectors
#define VectorNameLen 20   // Outputed vector name max length
#define MaxAddParams 8     // Max number of additionally outputed parameters
#define ParamNameLen 9     // Parameter name max length

typedef double TDataArray[MaxDataPoints];
typedef TDataArray *PDataArray;
typedef PDataArray TOutVectorsArr[MaxOutVectors];
typedef double TParamArr[MaxParams];
typedef double TAddParArr[MaxAddParams];

typedef char TParamName[ParamNameLen+1];
typedef TParamName TAddNameArr[MaxAddParams];

typedef char TVectName[VectorNameLen+1];
typedef TVectName TVectNameArr[MaxOutVectors];

typedef char TErrMsg[81];

/* A user supplied function for setting up the number of residuals or
   observations. The function also returns the number and names
   of scalar values, outputed by Approx routine, and the number,
   names and pointers to the vector values, which can be outputed to
   a data file.
   This function returns zero on success and nonzero value to
   indicate that something was wrong and that the iteration
   process must not be started

   ParamFile:char *	- file name from InitData ParamFile field of
			  main window (input)

   DataPoints:int	- number of residuals or number of data points
                          which are approximated (output)

   OutVectors:int	- number of vectors which will be outputed to a
			  data file (output)

   AddOutValues:int	- number of additionally outputed by Approx routine
			  scalar values (output)

   OutVectorsArray:     - array of pointers to the data arrays which will be
   TOutVectorsArr         written to the data file in responce to Data to
                          File command. These arrays must be allocated in
			  the DLL (output)

   OutVectorsNames:     - names of vectors in OutVectorsArray
   TVectNameArr           (output)

   AddNames:TAddNameArr	- array of names of AddOutValues (output)

   ErrMsg:TErrMsg	- error message returned if initialization was not
    		          successful (output)
*/

int far pascal _export INITDATA(char *,
				 int *,
				 int *,
				 int *,
                                 TOutVectorsArr,
                                 TVectNameArr,
				 TAddNameArr,
				 TErrMsg);

/* A user supplied function for calculation of the residuals values.
   It returns zero on success and a value from 1 to 900 if something
   went wrong.

   Params:TParamArr	- vector containing the values of variable parameters
			  (input)

   Residuals:TDataArray	- vector containing residuals values, the sum of
                          squares of which is minimized (output)

   AddValues:TAddParArr	- array of additionally outputed scalar values which
			  will be displayed in iteration info panel and
                          may be printed or outputed to a file in responce
                          to Results to File command (output)

   DataPoints:int	- number of Residuals, set up by InitData (input)

   TypeOfCall:int	- 1 for call within iteration process, 2 for final
			  call after iteration process, 3 for call when
			  calculating errors

   ErrMsg:TErrMsg	- error message returned (along with a nonzero
                          return value) if something was wrong (output)
*/

int far pascal _export APPROX(TParamArr,
			      TDataArray,
			      TAddParArr,
			      int,
			      int,
                              TErrMsg);

