(* TESTFIT.PAS sample Pascal dynamic-link library for Nonlinear Fitter *)

library TESTFIT;

{$D Pascal test DLL for Nonlinear Fitter}
{$F+,N+,G+,R-,S-,Q-,E-,I-,X+,D-,L-,Y-}
{$I FITTYPES.INC}

var X,Y,Z,R:TDataArray;

const DataInitialized:boolean=false;

function StrLCopy(Dest,Source:PChar;MaxLen:word):PChar;
begin
  FillChar(Dest^,MaxLen+1,0);
  Move(Source^,Dest^,MaxLen);
  StrLCopy:=Dest;
end;

function InitData(ParamFile:PChar;
                  var DataPoints,OutVectors,AddOutValues:integer;
                  var OutVectorsArray:TOutVectorsArr;
                  var OutVectorsNames:TVectNameArr;
                  var AddNames:TAddNameArr;
                  var ErrMsg:TErrMsg):integer;
var k:integer;
    F:Text;
begin
  InitData:=0;
  if DataInitialized then exit;

  DataPoints:=0;
  OutVectors:=4;
  AddOutValues:=1;
  StrLCopy(AddNames[1],'a+b+c+d',SizeOf(AddNames[1])-1);
  StrLCopy(OutVectorsNames[1],'X',SizeOf(OutVectorsNames[1])-1);
  StrLCopy(OutVectorsNames[2],'Y',SizeOf(OutVectorsNames[2])-1);
  StrLCopy(OutVectorsNames[3],'Computed',SizeOf(OutVectorsNames[3])-1);
  StrLCopy(OutVectorsNames[4],'Residual',SizeOf(OutVectorsNames[4])-1);
  OutVectorsArray[1]:=@X;
  OutVectorsArray[2]:=@Y;
  OutVectorsArray[3]:=@Z;
  OutVectorsArray[4]:=@R;
  Assign(F,ParamFile);
  Reset(F);
  if (IoResult<>0) then
  begin
    InitData:=1;
    StrLCopy(ErrMsg,'Cannot open file',SizeOf(ErrMsg)-1);
    exit;
  end;
  while (not SeekEOF(F)) do
  begin
    Inc(DataPoints);
    ReadLn(F,X[DataPoints],Y[DataPoints]);
    if (IOResult<>0) then
    begin
      InitData:=2;
      StrLCopy(ErrMsg,'Error reading file',SizeOf(ErrMsg)-1);
      Close(F);
      exit;
    end;
  end;
  Close(F);
  DataInitialized:=true;
end;

function Approx(var Params:TParamArr;var Residuals:TDataArray;
                var AddValues:TAddParArr;DataPoints,TypeOfCall:integer;
		var ErrMsg:TErrMsg):integer;
var k:integer;
begin
  Approx:=0;
  if (TypeOfCall=2) then 
  begin
    for k:=1 to DataPoints do R[k]:=Residuals[k];	
    exit;
  end;

  for k:=1 to DataPoints do
  begin
    Z[k]:=Params[1]*sin(Params[2]*X[k])+Params[3]*cos(Params[4]*X[k]);
    Residuals[k]:=Z[k]-Y[k];
  end;

  if (TypeOfCall=3) then exit;

  AddValues[1]:=params[1]+params[2]+params[3]+params[4];
end;

exports
  InitData resident,
  Approx   resident;

Begin
End.
