Unit Errorify;
{* S Compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}

Interface

Uses Crt,Dos;

{ Errorify }
Type
    JumpBuf=Record
              DS,SS : Word;
              BP,BPOld : Word;
              CS,IP : Word;
            End;

Function SetJump(Var JR : JumpBuf) : Word;
Procedure LongJump(J : JumpBuf; RetCode : Word);

Type
    ErrorHandler1=Procedure(S : String);
Var
   NbCarriages : Word;
   More : Boolean;

Procedure WaitingForAKey;
Procedure WriteCarriage;

Function FileExists(Var S : String) : Boolean;

Var
   NbCR : Word;
   WaitOnError : Boolean;
   ErrorReturnInitialized : Boolean;
   ErrorReturn : JumpBuf;
   ErrorMessage : String;

Procedure Error(S : String);

Var
   CBreakReturn : JumpBuf;
   IgnoreCBreak : Boolean;

Procedure GetCBreakControl;
Procedure RestoreCBreakControl;

{ GetLib }
Procedure GetRuntime;
Procedure ResetRuntime;

{ Objectify }
Type
    Access=Array[0..1] Of Word;
    AccessPtr=^Access;

    HeaderPtr=^Header;
    Header=Record
             C0 : Word; { SizExports+SizName+1 => C0+10=#(Header+Exports) }
             SizCode : Word;
             OfsStart : Word;
             SizData : Word;
             SizImports : Word;
             CS,DS : Word;
           End;

    BlockPtr=^Block;
    Block=Record
            B0,BA : Pointer;
            Size0 : Word;
          End;

    EnvirPtr=^Envir;
    Envir=Record
            H : HeaderPtr;
            CS,DS : Block;
            Linked : Boolean;
            Next : EnvirPtr;
          End;
Var
   EnvirCour : Envir;

Procedure GetBlock(Var B : Block; Size : Word);
Procedure FreeBlock(Var B : Block; Size : Word);

Implementation

{ ********
  Errorify
  ******** }
{$F+}
Function SetJump(Var JR : JumpBuf) : Word;
Var
   J : JumpBuf;
Begin
{ MOV J.DS,DS }
  InLine($8C/$9E/J);
{ MOV J.SS,SS }
  InLine($8C/$96/J+2);
{ MOV J.BP,BP }
  InLine($89/$AE/J+4);
{ MOV J.BPOld,[BP] }
  InLine($8B/$46/$00);
  InLine($89/$86/J+6);
{ MOV J.CS,[BP+4] }
  InLine($8B/$46/$04);
  InLine($89/$86/J+8);
{ MOV J.IP,[BP+2] }
  InLine($8B/$46/$02);
  InLine($89/$86/J+10);
  JR:=J;
  SetJump:=0;
End;

Procedure LongJump(J : JumpBuf; RetCode : Word);
Begin
  If RetCode=0 Then RetCode:=1;
{ MOV AX,RetCode }
  InLine($8B/$86/RetCode);
{ MOV DS,J.DS }
  InLine($8E/$9E/J);
{ MOV SI,J.IP }
  InLine($8B/$B6/J+10);
{ MOV DI,J.CS }
  InLine($8B/$BE/J+8);
{ MOV BX,J.SS }
  InLine($8B/$9E/J+2);
{ MOV CX,J.BPOld }
  InLine($8B/$8E/J+6);
{ MOV BP,J.BP }
  InLine($8B/$AE/J+4);
{ MOV SS,BX }
  InLine($8E/$D3);
{ MOV [BP],CX }
  InLine($89/$4E/$00);
{ MOV [BP+4],DI }
  InLine($89/$7E/$04);
{ MOV [BP+2],SI }
  InLine($89/$76/$02);
{ MOV SP,BP }
  InLine($89/$EC);
{ POP BP }
  InLine($5D);
{ RETF 4 }
  InLine($CA/$04/$00);
End;
{$F-}

{ Fonctions de sortie }
Procedure WaitingForAKey;
Begin
  Write('-- Press any key --');
  Mem[0:1050]:=Mem[0:1052];
  While Not KeyPressed Do;
End;

Procedure WriteCarriage;
Begin
  Writeln;
  Inc(NbCarriages);
  If NbCarriages=24 Then
  Begin
    NbCarriages:=0;
    If More Then Begin WaitingForAKey;Writeln; End;
  End;
End;

{ FileExists }
{$I-}
Function FileExists(Var S : String) : Boolean;
Var
   F : File;
Begin
  Assign(F,S);Reset(F);Close(F);
  FileExists:=(IOResult=0) And (S<>'');
End;
{$I+}

{$F+}
Procedure Error(S : String);
Begin
  If ErrorReturnInitialized Then
  Begin
    ErrorMessage:=S;
    LongJump(ErrorReturn,1);
  End
  Else
  Begin
    Writeln(S,', line ',NbCR+1);
    If WaitOnError Then WaitingForAKey;
    ResetRuntime;
    Halt;
  End;
End;
{$F-}

{ CBreakControl }
Var
   OKeyBoardItStub : Pointer;
   ScanCode,PrevScanCode,Ignore : Byte;

{$F+}
{$R-}
{$S-}
Procedure KeyBoardItStub; Interrupt;
Label
     Arrachos,Suite,DontCare;
Begin
  Goto Suite;
Arrachos:
{ JMP FAR OldInt9 }
  InLine($EA/$00/$00/$00/$00);
Suite:
{ Handler }
  ScanCode:=Port[$60];
  If Ignore<>0 Then
  Begin
    Dec(Ignore);
    If IgnoreCBreak Then Goto DontCare
    Else
    Begin
      Port[$20]:=$20;
    { STI }
      InLine($FB);
      LongJump(CBreakReturn,1);
    End;
  End
  Else
    If PrevScanCode=$E0 Then
    Begin
      If ScanCode=$46 Then
      Begin
        Ignore:=1;
        Goto DontCare;
      End;
      PrevScanCode:=0;
    End
    Else
      If ScanCode=$E0 Then PrevScanCode:=$E0;

{ MOV SP,BP }
  InLine($89/$EC);
{ POP BP,ES,DS,DI,SI,DX,CX,BX,AX }
  InLine($5D/$07/$1F/$5F/$5E/$5A/$59/$5B/$58);
  Goto Arrachos;
DontCare:
{ Acknowledge }
  Port[$20]:=$20;
End;
{$S+}
{$R+}
{$F-}

Procedure GetCBreakControl;
Type
    PointerPtr=^Pointer;
Var
   P : PointerPtr;
Begin
  ScanCode:=0;
  PrevScanCode:=0;
  Ignore:=0;
  IgnoreCBreak:=True;
  GetIntVec($09,OKeyBoardItStub);
  P:=PointerPtr(@KeyBoardItStub);
  Inc(Word(P),$13);
  P^:=OKeyBoardItStub;
  SetIntVec($09,@KeyBoardItStub);
End;

Procedure RestoreCBreakControl;
Begin
  SetIntVec($09,OKeyBoardItStub);
End;

{ ******
  GetLib
  ****** }
Const
     DSegRef=0;GetMemRef=1;FreeMemRef=2;MemAvailRef=3;MaxAvailRef=4;
               RandomRef=5;RandomizeRef=6;
               Mul32Ref=7;Div32Ref=8;Mod32Ref=9;
               FileExistsRef=10;FileLengthRef=11;
               BloadRef=12;BSaveRef=13;
               AssignRef=14;ResetRef=15;RewriteRef=16;
               FileSizeRef=17;EOFRef=18;
               BReadRef=19;BWriteRef=20;
               CloseRef=21;
               MarkRef=22;ReleaseRef=23;
               FindFirstRef=24;FindNextRef=25;
               DosErrorRef=26;
               LastRef=27;
Var
   RuntimeLibRef : Array[DSegRef..LastRef-1] Of Pointer;

Var
   P : Pointer;
   L : LongInt;
   W : Word;
   A,B,C : LongInt;

{$F+}
{$R-}
{$S-}
Procedure GetMemStub;
Begin
  GetMem(P,$1234);
End;

Procedure FreeMemStub;
Begin
  FreeMem(P,$5678);
End;

Procedure MemAvailStub;
Begin
  L:=MemAvail;
End;

Procedure MaxAvailStub;
Begin
  L:=MaxAvail;
End;

Procedure RandomStub;
Begin
  W:=Random($1234);
End;

Procedure RandomizeStub;
Begin
  Randomize;
End;

{$R-}
Procedure Mul32Stub;
Begin
  A:=B*C;
End;

Procedure Div32Stub;
Begin
  A:=B Div C;
End;

Procedure Mod32Stub;
Begin
  A:=B Mod C;
End;
{$R+}

{$I-}
Function FileExists2(Var S : String) : Boolean;
Var
   F : File;
Begin
  Assign(F,S);Reset(F);Close(F);
  FileExists2:=(IOResult=0) And (S<>'');
End;
{$I+}

Function FileLength(Var S : String) : LongInt;
Var
   F : File;
Begin
  If FileExists(S) Then
  Begin
    Assign(F,S);Reset(F,1);
    FileLength:=FileSize(F);
    Close(F);
  End;
End;

Procedure BLoad(B : Pointer; Var S : String);
Var
   F : File;
   W : ^Word;
Begin
  If FileExists(S) Then
  Begin
    Assign(F,S);
    Reset(F,1);
    W:=B;BlockRead(F,W^,FileSize(F));
    Close(F);
  End;
End;

Procedure BSave(B : Pointer; Size : Word; Var S : String);
Var
   F : File;
   W : ^Word;
Begin
  If S<>'' Then
  Begin
    Assign(F,S);
    Rewrite(F,1);
    W:=B;BlockWrite(F,W^,Size);
    Close(F);
  End;
End;

Type
    FilePtr=^File;

Procedure Assign2(F : FilePtr; Var S : String);
Begin
  Assign(F^,S);
End;

Procedure Reset2(F : FilePtr; RecSize : Word);
Begin
  Reset(F^,RecSize);
End;

Procedure Rewrite2(F : FilePtr; RecSize : Word);
Begin
  Rewrite(F^,RecSize);
End;

Function FileSize2(F : FilePtr) : LongInt;
Begin
  FileSize2:=FileSize(F^);
End;

Function EOF2(F : FilePtr) : Boolean;
Begin
  EOF2:=EOF(F^);
End;

Procedure BRead(F : FilePtr; Var Buf; N : Word);
Begin
  BlockRead(F^,Buf,N);
End;

Procedure BWrite(F : FilePtr; Var Buf; N : Word);
Begin
  BlockWrite(F^,Buf,N);
End;

Procedure Close2(F : FilePtr);
Begin
  Close(F^);
End;

Procedure Mark2(Var P : Pointer);
Begin
  Mark(P);
End;

Procedure Release2(Var P : Pointer);
Begin
  Release(P);
End;

Procedure GetRuntime;
Var
   SP : ^String;
   PP : ^Pointer;
   I : Integer;
Begin
  RuntimeLibRef[DSegRef]:=Pointer(DSeg);
  SP:=@GetMemStub;PP:=@SP^[8];RunTimeLibRef[GetMemRef]:=PP^;
  SP:=@FreeMemStub;PP:=@SP^[16];RunTimeLibRef[FreeMemRef]:=PP^;
  SP:=@MemAvailStub;PP:=@SP^[4];RunTimeLibRef[MemAvailRef]:=PP^;
  SP:=@MaxAvailStub;PP:=@SP^[4];RunTimeLibRef[MaxAvailRef]:=PP^;
  SP:=@RandomStub;PP:=@SP^[8];RunTimeLibRef[RandomRef]:=PP^;
  SP:=@RandomizeStub;PP:=@SP^[4];RunTimeLibRef[RandomizeRef]:=PP^;
  SP:=@Mul32Stub;PP:=@SP^[16];RunTimeLibRef[Mul32Ref]:=PP^;
  SP:=@Div32Stub;PP:=@SP^[16];RunTimeLibRef[Div32Ref]:=PP^;
  SP:=@Mod32Stub;PP:=@SP^[16];RunTimeLibRef[Mod32Ref]:=PP^;
  RunTimeLibRef[FileExistsRef]:=@FileExists2;
  RunTimeLibRef[FileLengthRef]:=@FileLength;
  RunTimeLibRef[BLoadRef]:=@Bload;
  RunTimeLibRef[BSaveRef]:=@BSave;
  RunTimeLibRef[AssignRef]:=@Assign2;
  RunTimeLibRef[ResetRef]:=@Reset2;
  RunTimeLibRef[RewriteRef]:=@Rewrite2;
  RunTimeLibRef[FileSizeRef]:=@FileSize2;
  RunTimeLibRef[EOFRef]:=@EOF2;
  RunTimeLibRef[BReadRef]:=@BRead;
  RunTimeLibRef[BWriteRef]:=@BWrite;
  RunTimeLibRef[CloseRef]:=@Close2;
  SP:=@Mark2;PP:=@SP^[9];RunTimeLibRef[MarkRef]:=PP^;
  SP:=@Release2;PP:=@SP^[9];RunTimeLibRef[ReleaseRef]:=PP^;
  RunTimeLibRef[FindFirstRef]:=@FindFirst;
  RunTimeLibRef[FindNextRef]:=@FindNext;
  RunTimeLibRef[DosErrorRef]:=@DosError;
  If MemL[0:$200]<>0 Then Error('GetLib');
  MemL[0:$200]:=LongInt(@RunTimeLibRef);
End;

Procedure ResetRuntime;
Begin
  MemL[0:$200]:=0;
End;

{ *********
  Objectify
  ********* }
Procedure GetBlock(Var B : Block; Size : Word);
Var
   A : ^Access;
Begin
  If Size>$FFE0 Then Error('GetBlock : Size too big');
  If MaxAvail<Size+16 Then Error('GetBlock : memory full');
  GetMem(B.B0,Size+16);
  B.BA:=B.B0;
  B.Size0:=Size;
  A:=@B.BA;
  If A^[0]<>0 Then
    Begin
      Inc(A^[1],1);
      A^[0]:=0;
    End;
End;

Procedure FreeBlock(Var B : Block; Size : Word);
Begin
  If B.B0=Nil Then Error('FreeBlock : nil B.B0');
  FreeMem(B.B0,B.Size0+16);
  B.B0:=Nil;
End;

Begin
  GetRunTime;
  WaitOnError:=True;
  ErrorMessage:='';
  ErrorReturnInitialized:=False;
  EnvirCour.Linked:=False;
End.