{$DEFINE S0}
{* S command-line compiler, ver 1.00.
   Copyright (C) 1994, Henri LESOURD.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This compiler is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  *}
{$IFDEF S0}
Program S0;
{$ELSE}
Program CompTest;
{$ENDIF}

Uses
    Crt,
    Errorify,
    Symbolize,
    Lexify,
    Writify,
    Digitizify,
    Assemblify,
    Addressify,
    Expressify,
    Compilify
              ;

Var
   Res : TypedAddress;
   I : Integer;
   L : LongInt;
   S,S2 : String;
   B : BoxPtr;
Begin
{$IFDEF S0}
  WaitOnError:=False;
  Case ParamCount Of
    1: Begin
         FT:=COM;
         S:=ParamStr(1);
       End;
    2: Begin
         S:=ParamStr(2);
         If S[1]='/' Then
           Case S[2] Of
             'C','c': FT:=COM;
             'B','b': FT:=BOOT;
             'O','o': FT:=OBJ;
             Else
               Error('C,O,B expected for FicType');
           End
         Else
           Error('"S0 FName (/FicType)" expected');

         S:=ParamStr(1);
       End;
    Else
      Error('"S0 FName (/FicType)", FicType=C|B|O expected');
  End;
{$ELSE}
  S:='SymbTest';
  FT:=OBJ;
  ClrScr;
{$ENDIF}
  S2:=Concat(S,'.S');
  If Not FileExists(S2) Then
  Begin
    Write('File ',S2);
    Error(' not found');
  End
  Else
    StartLexify(S2);

  Case FT Of
    COM,BOOT:
         Begin
           NextWord;
           B:=DigitizeBody;
         End;
    OBJ: B:=DigitizePackage;
    Else
      Error('Bad FT');
  End;

{ COUILLE : Ca passe avec Digitize(0), alors ke le fic commence par VAR !!! }

  More:=False;
  Lisp:=True;
  NbCarriages:=1;
{$IFNDEF S0
  SetColorMode;
  If FT=OBJ Then AnalogizeModule(B) Else AnalogizeBody(B);
  TextAttr:=7;
  Writeln;}
{$ENDIF}
  EndLexify;
{ For I:=AX To rSS Do RegFree[I]:=False;}
  Init;
  StartAssemblify(S);
  NewLabel(EnterLab);
  Case FT Of
    COM:
      Begin
      { JMP +&H0C }
        PokeW($0CEB);
      { MOV BX,CS }
        PokeW($CB8C);
      { ADD BX,10 }
        PokeW($C383);
        PokeB($10);
      { POP CX }
        PokeB($59);
      { MOV CX,&H0011 }
        PokeB($B9);
        PokeW($0011);
      { PUSH BX }
        PokeB($53);
      { PUSH CX }
        PokeB($51);
      { RETF }
        PokeB($CB);
      { CALL -&H0E }
        PokeB($E8);
        PokeW($FFF1);
        Assemble(JMP,EnterLab,NullAddr);
      End;
    BOOT:
      Begin
      { JUMP 1E; NOP }
        PokeW($1CEB);
        PokeB($90);
      { CopyRight }
        PokeB(Ord('B'));
        PokeB(Ord('O'));
        PokeB(Ord('S'));
        PokeB(Ord(' '));
        PokeB(Ord('v'));
        PokeB(Ord('1'));
        PokeB(Ord('.'));
        PokeB(Ord('0'));
      { #Byte/Sect }
        PokeW($0200);
      { #Sect/Clus }
        PokeB($01);
      { #BootSection }
        PokeW($0001);
      { #FATs }
        PokeB($02);
      { #RootDir }
        PokeW($00E0);
      { #Sect }
        PokeW($0B40);
      { Suppt Descr }
        PokeB($F0);
      { #Sect/FAT }
        PokeW($0009);
      { #Sect/Track }
        PokeW($0012);
      { #Heads }
        PokeW($0002);
      { #ZOB }
        PokeW($0000);
      { JMP 07C0:0023 }
        PokeB($EA);
        PokeW($0023);
        PokeW($07C0);
      { JMP Start }
        Assemble(JMP,EnterLab,NullAddr);
      End;
  End;
  Case FT Of
    OBJ: CompilePackage(B);
    Else
      Begin
        CompileBody(B);
      End;
  End;
  EndAssemblify;
{$IFNDEF S0}
  WaitingForAKey;
{$ENDIF}
  ResetRuntime;
End.