! Draw the Mandelbrot Set using 200 iterations with a `corona'
! from 15...20 iterations.
! This program is designed to run under X11 in native mode.
! When running it under TXX, the SCALE constant must be decreased
! to 100. Of course, the bytecode program will be awfully slow.
! BSD: compile with `tx -O -P -l g xapfel.t'


#include "C:/v/t3xr5/graphics.inc"


const	SCALE = 100;


f(x, y) do
	var	cr, ci, zr, zi, ir;
	var	i;

	zr := 0;
	zi := 0;
	cr := x*SCALE/150;
	ci := y*SCALE/120;
	for (i=0, 200) do
		ir := zr*zr/SCALE - zi*zi/SCALE;
		zi := zr*zi/SCALE + zi*zr/SCALE;
		zr := ir + cr;
		zi := zi + ci;
		if (	zi > 2*SCALE \/ zr > 2*SCALE \/
			zi < %2*SCALE\/ zr < %2*SCALE
		) do
			if (i >= 15 /\ i < 20) return 0;
			return 1;
		end
	end
	return 0;
end


do
	var	x, y, r;
	var	e[event];

	g_init();
	for (y=179, %1, %1) do
		for (x=%360, 120) do
			r := f(x, y);
			g_point((x+120)*66, y*66, r->GCLEAR: GSET);
			g_point((x+120)*66, -y*66, r->GCLEAR: GSET);
		end
	end
	while (1) do
		g_event(e, 1);
		if (\g_reshaped()) leave;
	end
	g_end();
end

