#!/bin/sh

#	TX -- A driver for the T3X compiler, Tcode version
#	Copyright (C) 1998,1999,2000 Nils M Holm
#	For details, see `txtrn.t'.
#	For conditions of use, see the file LICENSE.

RELEASE="T3X Release 5.12"

TX=/usr/local/t3x
TXB=$TX/bin
USAGE="Usage: tx [-h] [-L] [-ikuOPV] [-o file] program"
HELP="       tx -h explains the options"
LICENSE="       tx -L prints the conditions of use"

OUTFILE=""
VERBOSE=n
OPTIMIZE=n
UNASM=n
INFO=n
PREP=n
RM=rm
TXOPT=txopt

while true; do
	case $1 in
	-u)
		INFO=y
		shift ;;
	-k)
		RM='echo keeping: '
		shift ;;
	-o)
		if [ $# -lt 2 ]; then echo $USAGE; exit 1; fi
		OUTFILE=$2
		shift; shift ;;
	-u)
		UNASM=y
		shift ;;
	-L)
		cat <<EOF

T3X -- A Compiler for the Procedural Language T, version 3X
Copyright (C) 1996-2000 Nils M. Holm.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS \`\`AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.

EOF
		exit 0 ;;
	-O)
		OPTIMIZE=y
		shift ;;
	-P)
		PREP=y
		shift ;;
	-V)
		VERBOSE=y
		shift ;;
	-h)
		echo
		echo $RELEASE
		echo
		echo $USAGE
		cat<<EOF

-i	print program information
-k	keep intermediate files
-o file	write output to the given file
-u	unassemble program to stdout
-O	run the Tcode optimizer
-P	run the preprocessor
-V	verbose operation

Each option must be prefixed with an extra '-'.
Use "txx file" to run a Tcode program.

EOF
		exit 0 ;;
	-*)
		echo $USAGE
		exit 1 ;;
	*)
		break ;;
	esac
done

if [ x$1 = x ]; then
	echo "$RELEASE"
	echo "$USAGE"
	echo "$HELP"
	echo "$LICENSE"
	exit 1
fi

if [ $UNASM = y ]; then
	$TXB/txx $TXB/ux.tcode <$1
	exit 0
fi

if [ $INFO = y ]; then
	$TXB/txx $TXB/txinfo.tcode <$1
	exit 0
fi

if [ x$OUTFILE = x ]; then
	OUTFILE=`basename $1 .t`
	if [ $OUTFILE = $1 ]; then
		echo "TX: input program has no .t suffix"
		exit 1
	fi
fi

rm -f TXPP.ERR TXTRN.ERR TXOPT.ERR

if [ $VERBOSE = y ]; then
	set -x
fi

if [ $PREP = y ]; then
	$TXB/txx $TXB/txpp.tcode <$1 >$OUTFILE.txpp
	if [ -f TXPP.ERR ]; then
		if [ x$OUTFILE != x ]; then
			rm -f $OUTFILE.tcode $OUTFILE.unopt $OUTFILE.s \
				$OUTFILE.o $OUTFILE.txpp
		fi
		rm -f TXPP.ERR TXTRN.ERR TXOPT.ERR TXCG.ERR
		exit 1
	fi
	$TXB/txx $TXB/txtrn.tcode <$OUTFILE.txpp >$OUTFILE
	$RM $OUTFILE.txpp
else
	$TXB/txx $TXB/txtrn.tcode <$1 >$OUTFILE
fi
if [ -f TXTRN.ERR ]; then
	if [ x$OUTFILE != x ]; then
		rm -f $OUTFILE.tcode $OUTFILE.unopt $OUTFILE.s $OUTFILE.o \
			$OUTFILE.txpp
	fi
	rm -f TXPP.ERR TXTRN.ERR TXOPT.ERR TXCG.ERR
	exit 1
fi
if [ $OPTIMIZE = y ]; then
	mv $OUTFILE $OUTFILE.unopt
	$TXB/txx $TXB/$TXOPT.tcode <$OUTFILE.unopt >$OUTFILE
	$RM $OUTFILE.unopt
	if [ -f TXOPT.ERR ]; then
		if [ x$OUTFILE != x ]; then
			rm -f $OUTFILE.tcode $OUTFILE.unopt $OUTFILE.s \
				$OUTFILE.o $OUTFILE.txpp
		fi
		rm -f TXPP.ERR TXTRN.ERR TXOPT.ERR TXCG.ERR
		exit 1
	fi
fi

exit 0
