!	CVEXE -- Convert Oxygene X.OUT files to DOS EXE files.
!	Copyright (C) 1998,2000 Nils M Holm
!	See the file LICENSE for conditions of use.
!
!	CVEXE is pretty obsolete, since SLD now has the -t option
!	which may be used to make it generate DOS EXE files
!	directly.

#r5;

interface	readpacked(3) = 11,
		writepacked(3),
		reposition(4),
		rename(2),
		memcopy(3),
		memcomp(3);

!-------------------- IOSTREAM DEFINITIONS START --------------------!
struct IOS =	IOS_FD,
		IOS_BUFFER,
		IOS_FLAGS,
		IOS_LEN,
		IOS_PTR,
		IOS_END;

const		IOF_READ	= 00001,
		IOF_WRITE	= 00002,
		IOF_EOF		= 00004;

const		SEEK_SET	= 0,
		SEEK_REL	= 1,
		SEEK_END	= 2;


ios_create(iostream, fd, buffer, len, mode) do
	iostream[IOS_FD] := fd;
	iostream[IOS_BUFFER] := buffer;
	iostream[IOS_FLAGS] := mode;
	iostream[IOS_LEN] := len;
	iostream[IOS_PTR] := 0;
	iostream[IOS_END] := 0;
	return iostream;
end


ios_flush(iostream) do
	var	k;

	if (iostream[IOS_FLAGS] & IOF_WRITE) do
		k := writepacked(iostream[IOS_FD], iostream[IOS_BUFFER],
			iostream[IOS_PTR]);
		if (k \= iostream[IOS_PTR]) return %1;
	end
	iostream[IOS_PTR] := 0;
	iostream[IOS_END] := 0;
	return 0;
end


ios_close(iostream) do
	if (ios_flush(iostream) < 0) return %1;
	close(iostream[IOS_FD]);
	iostream[IOS_FLAGS] := 0;
	return 0;
end


ios_wrch(iostream, ch) do
	if (	iostream[IOS_PTR] >= iostream[IOS_LEN] /\
		ios_flush(iostream) < 0
	)
		return %1;
	iostream[IOS_BUFFER]::iostream[IOS_PTR] := ch;
	iostream[IOS_PTR] := iostream[IOS_PTR]+1;
	return ch;
end


ios_write(iostream, buffer, len) do
	var	i, p, l, b;

	i := 0;
	p := iostream[IOS_PTR];
	l := iostream[IOS_LEN];
	b := iostream[IOS_BUFFER];
	while (len) do
		if (p >= l) do
			iostream[IOS_PTR] := p;
			if (ios_flush(iostream) < 0) return %1;
			p := iostream[IOS_PTR];
			l := iostream[IOS_LEN];
		end
		b::p := buffer::i;
		p := p+1;
		i := i+1;
		len := len-1;
	end
	iostream[IOS_PTR] := p;
	return i;
end


ios_more(iostream) do
	var	k;

	if (iostream[IOS_FLAGS] & IOF_READ) do
		k := readpacked(iostream[IOS_FD], iostream[IOS_BUFFER],
			iostream[IOS_LEN]);
		if (k < 0) return %1;
		if (k = 0)
			iostream[IOS_FLAGS] := iostream[IOS_FLAGS] | IOF_EOF;
		iostream[IOS_END] := k;
		iostream[IOS_PTR] := 0;
	end
	return k;
end


ios_rdch(iostream) do
	var	c;

	if (iostream[IOS_FLAGS] & IOF_EOF) return %1;
	if (	iostream[IOS_PTR] >= iostream[IOS_END] /\
		ios_more(iostream) < 1
	)
		return %1;
	c := iostream[IOS_BUFFER]::iostream[IOS_PTR];
	iostream[IOS_PTR] := iostream[IOS_PTR]+1;
	return c;
end


ios__read(iostream, buffer, len, ckln) do
	var	i, p, e, b;

	i := 0;
	p := iostream[IOS_PTR];
	e := iostream[IOS_END];
	b := iostream[IOS_BUFFER];
	while (len) do
		if (p >= e) do
			iostream[IOS_PTR] := p;
			if (ios_more(iostream) < 1) leave;
			p := iostream[IOS_PTR];
			e := iostream[IOS_END];
		end
		buffer::i := b::p;
		p := p+1;
		i := i+1;
		len := len-1;
		if (ckln /\ buffer::(i-1) = '\n') leave;
	end
	if (ckln) buffer::i := 0;
	iostream[IOS_PTR] := p;
	iostream[IOS_END] := e;
	return i;
end


ios_read(iostream, buffer, len) return ios__read(iostream, buffer, len, 0);


ios_rdwrd(s) return ios_rdch(s) | (ios_rdch(s) << 8);


ios_wrwrd(s, w) do
	ios_wrch(s, w & 255);
	ios_wrch(s, w >> 8);
end


ios_eof(iostream) return (iostream[IOS_FLAGS] & IOF_EOF) -> %1: 0;
!-------------------- IOSTREAM DEFINITIONS END --------------------!


const	BUFLEN=		1024;
const	EXECMAGIC_HI=	6514,
	EXECMAGIC_LO=	1060;

const	XHMAGIC = 0, XLMAGIC = 1, XFLAGS = 2, XLTEXT = 3, XLDATA = 4,
	XLBSS = 5, XLSYM = 6, XHDR = 8;


error(m) do
	select(1, 2);
	writes("CVEXE: ");
	writes(m);
	newline();
	halt;
end


wrb(out, s) do
	var	n;

	n := ('0' <= s::0 /\ s::0 <= '9'-> s::0-'0': s::0-'A'+10)<<4;
	n := n | ('0' <= s::1 /\ s::1 <= '9'-> s::1-'0': s::1-'A'+10);
	ios_wrch(out, n);
end


wrbs(out, s) do
	var	i;

	i := 0;
	while (s::i) do
		wrb(out, @s::i);
		i := i+2;
	end
end


exehdr(out, ltext, ldata) do
	const	delta = 64;	! size of non-{TEXT,DATA} area
	var	k, m, n;

	m := ltext mod 512;
	n := (ldata+delta) mod 512;
	k := ltext / 512 + (ldata+delta) / 512;
	ie (m+n >= 512) do
		if (m+n \= 512) k := k+1;
		m := m+n-512;
	end
	else do
		m := m+n;
	end
	! create EXE header
	wrbs(out, packed"4D5A");	! Magic
	ios_wrwrd(out, m);		! Size MOD 512
	ios_wrwrd(out, k+1);		! Size / 512 + 1
	ios_wrwrd(out, 0);		! Num. of RELOC entries
	ios_wrwrd(out, 2);		! (header size + 15) / 16
	ios_wrwrd(out, 0);		! MINALLOC
	ios_wrwrd(out, %1);		! MAXALLOC
	ios_wrwrd(out, ltext/16+2);	! Initial SS
	ios_wrwrd(out, %2);		! Initial SP
	ios_wrwrd(out, 0);		! Checksum (0=ignore)
	ios_wrwrd(out, 0);		! IEP, IP
	ios_wrwrd(out, 0);		! IEP, CS
	ios_wrwrd(out, 28);		! Offset of RELOC
	ios_wrwrd(out, 0);		! Number of overlays
	wrbs(out, packed"FFFFFFFF");
end


seginit(out, ltext, iep, txinit) do
	var	i;

	! DOS segment initialization code
	wrbs(out, packed"5A");			! POP DX
	wrbs(out, packed"8CC8");		! MOV AX,CS
	wrbs(out, packed"05");			! ADD AX,
		ios_wrwrd(out, ltext/16+2);	!	ltext/16+2
	wrbs(out, packed"8ED0");		! MOV SS,AX
	wrbs(out, packed"BCFEFF");		! MOV SP,$FFFE
	wrbs(out, packed"8ED8");		! MOV DS,AX
	wrbs(out, packed"8EC0");		! MOV ES,AX
	wrbs(out, packed"52");			! PUSH DX
	wrbs(out, packed"E9");			! JMP
		ios_wrwrd(out, txinit-iep-19);	!	_TXINIT
	! pad with NULs
	for (i=20, 33) ios_wrch(out, 0);	! DB 0
end


append(in, out, len) do
	var	buffer::1024;
	var	m, k;

	while (len) do
		m := len>1024-> 1024: len;
		k := ios_read(in, buffer, m);
		if (k \= m) error("file read error");
		if (ios_write(out, buffer, k) \= k)
			error("file write error");
		len := len - m;
	end
end


do
	var	in[IOS], inbuf::BUFLEN;
	var	out[IOS], outbuf::BUFLEN;
	var	hdr[8], jmp::3;
	var	i, iep, txinit;

	if (ios_create(in, 0, inbuf, BUFLEN, IOF_READ) = %1)
		error("cannot create input stream");
	if (ios_create(out, 1, outbuf, BUFLEN, IOF_WRITE) = %1)
		error("cannot create output stream");
	for (i=0, 8) do
		hdr[i] := ios_rdwrd(in);
		if (ios_eof(in)) error("short header");
	end
	if (hdr[XLMAGIC] \= EXECMAGIC_LO) error("magic match failed");
	if (hdr[XHMAGIC] \= EXECMAGIC_HI) error("magic match failed");
	if (hdr[XFLAGS]) error("unsupported module type (flags\\=0)");
	exehdr(out, hdr[XLTEXT], hdr[XLDATA]);
	if (ios_read(in, jmp, 3) \= 3) error("file read error");
	if (jmp::0 \= 232) error("bad input format"); ! E8h = call
	txinit := (jmp::2<<8 | jmp::1) + 3;
	iep := hdr[XLTEXT]-3; jmp::2 := iep>>8; jmp::1 := iep&255;
	if (ios_write(out, jmp, 3) \= 3) error("file write error");
	append(in, out, hdr[XLTEXT]-3);
	seginit(out, hdr[XLTEXT], iep+3, txinit);
	append(in, out, hdr[XLDATA]);
	ios_close(in);
	ios_close(ouT);
end

