;;------------------------------------------------
;;
;;	Fast Video Routines for DOS
;;	Copyright (C) 1995,1999 Nils M Holm
;;	Modified for use with T3X, 1997.
;;	Changed to small model and T3X calling
;;	conventins for use w/ S86, 1999.
;;	See LICENSE for conditions of use.
;;
;;------------------------------------------------


.bss

.globl	_vio_base, _vio_cols, _vio_lines, _vio_x, _vio_y
.globl	_vio_attr

_vio_base:	dw	*1
_vio_cols:	dw	*1
_vio_lines:	dw	*1
_vio_x:		dw	*1
_vio_y:		dw	*1
_vio_attr:	dw	*1


.text

.globl	_vio_init, _vio_move, _vio_sync, _vio_color
.globl	_vio_putc, _vio_puts, _vio_clear, _vio_clreol
.globl	_vio_index, _vio_revind, _vio_getc
.globl	_vio_mono, _vio_query, _vio_reinit, _vio_end


vio_addr:
	mov	ax,_vio_y
	mov	cx,_vio_cols
	shl	cx,1
	mul	cx
	mov	di,_vio_x
	shl	di,1
	add	di,ax
	ret


_vio_init:
	push	bp
	push	si
	push	di
	mov	_vio_cols,80
	mov	_vio_lines,25
	xor	ax,ax
	mov	_vio_x,ax
	mov	_vio_y,ax
	mov	_vio_attr,$0700
	mov	ax,$0F00
	int	$10
	cmp	al,7
	jz	ismono
	mov	_vio_base,$B800
	cmp	al,$26
	jz	is80x60
	cmp	al,2
	jae	isega
	mov	_vio_cols,40
	jmp	endinit
is80x60:
	mov	_vio_lines,60
	jmp	endinit
isega:	push	es
	xor	ax,ax
	mov	es,ax
	mov	si,$0484
	eseg
	mov	al,[si]
	xor	ah,ah
	inc	ax
	mov	_vio_lines,ax
	pop	es
	jmp	endinit
ismono:	mov	_vio_base,$0B000
endinit:	
	pop	di
	pop	si
	pop	bp
	ret


_vio_end:
	ret


_vio_reinit:
	ret


_vio_mono:
	mov	ax,$0F00
	int	$10
	cmp	al,2
	jz	mono
	cmp	al,7
	jz	mono
	xor	ax,ax
	ret
mono:	mov	ax,1
	ret


_vio_move:
	push	bp
	mov	bp,sp
	mov	ax,[bp+6]
	mov	_vio_x,ax
	mov	ax,[bp+4]
	mov	_vio_y,ax
	pop	bp
	ret


_vio_sync:
	push	bp
	push	si
	push	di
	mov	ax,$0200
	xor	bx,bx
	mov	dx,_vio_x
	mov	cx,_vio_y
	xchg	cl,ch
	or	dx,cx
	int	$10
	pop	di
	pop	si
	pop	bp
	ret


_vio_color:
	push	bp
	mov	bp,sp
	mov	ax,[bp+4]
	xchg	al,ah
	mov	_vio_attr,ax
	pop	bp
	ret


int_putc:
	cmp	al,$08
	jnz	nobs
	cmp	_vio_x,0
	jz	endputc
	dec	_vio_x
	sub	di,2
	ret
nobs:	cmp	al,$09
	jnz	notab
	push	ax
	mov	al,$20
dotab:	call	int_putc
	test	_vio_x,$07
	jnz	dotab
	pop	ax
	sub	di,2
	ret
notab:	cmp	al,$0A
	jnz	nolf
	inc	_vio_y
	call	vio_addr
	ret
nolf:	cmp	al,$0D
	jnz	nocr
	mov	_vio_x,0
	call	vio_addr
	ret
nocr:	eseg
	mov	[di],ax
	inc	_vio_x
	add	di,2
	mov	cx,_vio_x
	cmp	cx,_vio_cols
	jb	endputc
	mov	_vio_x,0
	inc	_vio_y
	push	ax
	call	vio_addr
	pop	ax
endputc:
	ret


_vio_putc:
	push	bp
	mov	bp,sp
	push	si
	push	es
	mov	ax,_vio_base
	mov	es,ax
	call	vio_addr
	mov	ax,[bp+4]
	or	ax,_vio_attr
	call	int_putc
	pop	es
	pop	si
	pop	bp
	ret


_vio_puts:
	push	bp
	mov	bp,sp
	push	si
	push	di
	push	es
	mov	ax,_vio_base
	mov	es,ax
	call	vio_addr
	mov	ax,_vio_attr
	mov	si,[bp+4]
	cld
nextps:	lodsb
	or	al,al
	jz	endps
	call	int_putc
	jmp	nextps
endps:
	pop	es
	pop	di
	pop	si
	pop	bp
	ret


_vio_clear:
	push	bp
	push	si
	push	di
	mov	ax,$0600
	xor	cx,cx
	mov	dx,_vio_lines
	mov	dh,dl
	or	dx,_vio_cols
	sub	dx,$0101
	mov	bx,_vio_attr
	int	$10
	xor	ax,ax
	mov	_vio_x,ax
	mov	_vio_y,ax
	pop	di
	pop	si
	pop	bp
	ret


_vio_clreol:
	push	bp
	push	si
	push	di
	push	es
	mov	ax,_vio_base
	mov	es,ax
	call	vio_addr
	mov	ax,32
	or	ax,_vio_attr
	mov	cx,_vio_cols
	sub	cx,_vio_x
	jz	endcl
	cld
doclr:	stosw
	loop	doclr
endcl:	pop	es
	pop	di
	pop	si
	pop	bp
	ret


_vio_index:
	push	bp
	mov	bp,sp
	push	si
	push	di
	mov	ax,$0601
	mov	ch,[bp+6]
	xor	cl,cl
	mov	dh,[bp+4]
	mov	dl,$4F
	mov	bx,_vio_attr
	int	$10
	pop	di
	pop	si
	pop	bp
	ret


_vio_revind:
	push	bp
	mov	bp,sp
	push	si
	push	di
	mov	ax,$0701
	mov	ch,[bp+6]
	xor	cl,cl
	mov	dh,[bp+4]
	mov	dl,$4F
	mov	bx,_vio_attr
	int	$10
	pop	di
	pop	si
	pop	bp
	ret


_vio_getc:
	push	bp
	push	si
	push	di
	xor	ax,ax
	int	$16
	or	al,al
	jz	isext
	xor	ah,ah
	jmp	retch
isext:	xchg	al,ah
	or	ax,$100
retch:	pop	di
	pop	si
	pop	bp
	ret


_vio_query:
	mov	ax,$0100
	int	$16
	jz	none
	xor	ax,ax
	dec	ax
	ret
none:	xor	ax,ax
	ret

