    title   SYSTEM call
    page    54,130
; This file is used by the Metaware High-C386 version of XLISP.
; It provides a "system()" call, which is broken in some versions of High-C.
; It also provides fast graphics for EGA/VGA only!
    .386p
    .xlisti
@system segment 'DATA'
    public  bytesperline
bytesperline    DD  -1      ; maximum x value -- graphics
commandBlock DD 0           ; env string offset
    DW  0           ; env string segment
commandTail DD  0           ; command tail offset
ctseg   DW  0           ; and its segment
savemode DB 0
@system ends
DGROUP  group   @system
system  segment use32 'CODE'
CGROUP  group   system
    assume  cs:CGROUP, ds:DGROUP
    public  ssystem
ssystem PROC    NEAR
    mov EAX, 8[ESP] ; argument (command string "tail")
    mov commandTail,EAX
    mov ctseg, DS       ; arg's segment
    mov EDX, 4[ESP]     ; command
    push    EBX
    push    ESI
    push    EDI
    mov EBX, OFFSET commandBlock
    mov EAX, 4b00h      ; exec
    int 21h
    jc  SHORT fail      ; fail if carry set
    xor eax, eax        ; return zero on success
fail:   pop EDI
    pop ESI
    pop EBX
    ret
ssystem endp



; Set pixel (EGA/VGA modes) Derived from Richard Wilton's book
    public setdrawmode
setdrawmode PROC NEAR
    mov dx, 3ceh
    mov ax, 205H        ; write mode 2, read mode 0
    out dx,ax
    mov EAX, 4[ESP]
    mov savemode, AL
    mov AH, 0
    test    AL, 80H
    jz  SHORT overmode
    mov AH, 18H
overmode:
    mov AL, 3
    out dx,ax
    ret
setdrawmode endp

    public unsetdrawmode
unsetdrawmode PROC NEAR
    mov dx, 3ceh
    mov ax, 0ff08h      ; restore defaults
    out dx, ax
    mov ax, 5
    out dx, ax
    mov ax, 3
    out dx, ax
    ret
unsetdrawmode endp


    public setpixel
setpixel PROC   NEAR
    push    EBP
    mov EBP, ESP        ; set up new stack base
    push    EBX         ; save BX
    push    ES          ;  and ES
ARGx    EQU DWORD PTR [EBP+8]
ARGy    EQU DWORD PTR [EBP+12]

    mov EAX, ARGy
    mov EBX, ARGx
    mov CL, BL          ; low byte of x
    imul    EAX, bytesperline   ; bytes per line * y address
    shr EBX, 3          ; x/8
    add EBX, EAX        ; byte offset
    add EBX, 0A0000H        ; address of display

    mov ax, 34H         ; 1 Meg address space
    mov ES, ax

    and CL, 7           ; x & 7
    xor CL, 7           ; number of bits to shift left
    mov AH, 1           ; shift mask

    shl AH, CL          ; bit mask is generated
    mov dx, 3ceh
    mov al, 8           ; set bit mask
    out dx,ax

    mov al,es:[ebx]
    mov al,savemode
    mov es:[ebx],al

    pop ES
    pop EBX
    pop EBP
    ret
setpixel endp
system  ends
end
