         TITLE     Ram-Resident Microsoft Mouse Driver

;Mouse Movement is mapped to up,down,left,right arrow keys
;Left Button  ==> <Esc>
;Right Button ==> <Enter>

CODE     SEGMENT
         ORG       100H
         ASSUME    CS:CODE,DS:CODE,ES:CODE
BEGIN:   JMP       START

fn_home        equ  4700h
fn_end         equ  4f00h
lt_arr         equ  4b00h
rt_arr         equ  4d00h
up_arr         equ  4800h
dn_arr         equ  5000h
carr_rtn       equ  1c0dh
esc_key        equ  011bh

mouse_int      equ  51
get_butt_press equ  5
read_mouse_mot equ  11
set_subr_mask  equ  12
set_sens       equ  15

lt_button      equ  0
rt_button      equ  1
horiz_sens     equ  10
vert_sens      equ  4

horiz_pos      dw   0
vert_pos       dw   0

USER_INPUT_MASK    PROC     FAR         
         STI
         PUSH      AX
         PUSH      BX
         PUSH      CX
         PUSH      DX
         PUSH      DI
         push       ds

         push       cs
         pop        ds
         CLD

          mov       ax,get_butt_press
          mov       bx,lt_button
          int       mouse_int
          cmp       bx,0
          je        chk_rt_button
          mov       ax,esc_key
          call      enter
          jmp       return

chk_rt_button:
          mov       ax,get_butt_press
          mov       bx,rt_button
          int       mouse_int
          cmp       bx,0
          je        chk_motion
          mov       ax,carr_rtn
          call      enter
          jmp       return

chk_motion:
         MOV       AX,read_mouse_mot
         INT       mouse_int
         mov        ax,horiz_pos
         add        ax,cx
         mov        horiz_pos,ax
         cmp        ax,0
         jnl        already_pos
         not        ax
         inc        ax

already_pos:
         CMP       aX,horiz_sens
         Jl        VERT
         cmp       horiz_pos,0
         JNS       RIGHT

LEFT:    MOV       AX,lt_arr
         mov       horiz_pos,0
         mov       vert_pos,0
         CALL      ENTER
         JMP       SHORT VERT

RIGHT:   MOV       AX,rt_arr
         mov       vert_pos,0
         mov       horiz_pos,0
         CALL      ENTER

VERT:    
         mov        ax,vert_pos
         add        ax,dx
         mov        vert_pos,ax
         cmp        ax,0
         jnl        already_pos1
         not        ax
         inc        ax
already_pos1:
         CMP       aX,vert_sens
         Jl        return
         CMP       vert_pos,0
         JNS       DOWN

UP:      MOV       AX,up_arr
         mov       vert_pos,0
         mov       horiz_pos,0
         CALL      ENTER
         JMP       RETURN

DOWN:    MOV       AX,dn_arr
         mov       vert_pos,0
         mov       horiz_pos,0
         CALL      ENTER

RETURN:
         pop       ds
         POP       DI
         POP       DX
         POP       CX
         POP       BX
         POP       AX
         RET
USER_INPUT_MASK    ENDP

ENTER    PROC      NEAR
         PUSH      ES
         PUSH      SI
         PUSH      DI
         MOV       DI,40H
         MOV       ES,DI
         MOV       BX,ES:[1CH]
         MOV       SI,BX
         ADD       BX,2
         CMP       BX,3EH
         JNE       HUNKY_DORY
         MOV       BX,1EH
HUNKY_DORY:
         CMP       BX,ES:[1AH]
         JE        END
         MOV       ES:[SI],AX
         MOV       ES:[1CH],BX
END:     POP       DI
         POP       SI
         POP       ES
         RET
ENTER    ENDP

DEVICE_DRIVER_END  LABEL    BYTE

START:
         MOV       DX,OFFSET USER_INPUT_MASK
         MOV       AX,set_subr_mask
         MOV       CX,0000000000001011B
         INT       mouse_int
         MOV       AX,set_sens
         MOV       CX,3
         MOV       DX,3
         INT       mouse_int
         LEA       DX,DEVICE_DRIVER_END
         INT       27H
CODE     ENDS
         END       BEGIN

