 /********************************************************
 *                                                       *
 *                      CLSDST                           *
 *                                                       *
 *  Function : This subroutine handle the VTAM style     *
 *             CLSDST request.                           *
 *  This function just sets appropriate values for the   *
 *  RQB fields and then calls the "pattach" subroutine.  *
 *  Here we use the following extern vars: - sem_no,     *
 *  pparm.                                               *
 *                                                       *
 *  Input    :  RQB, th.ra.wa.hh.hscb - CID.             *
 *  Output   :  Not applicable.                          *
 *                                                       *  
 * CopyRight 1995. Nicholas Poljakov all rights reserved.*
 *                                                       *
 ********************************************************/
#include <include.h>
#include <stdio.h>
#include <malloc.h>
#include <rpl.h>
#include <state1.h>
#include <string.h>

char *call_appl(void *);

int short sem_no;

clsdst(p_rpl)
struct rpl *p_rpl;
{
    struct rqb *p_rqb;
    char *p;


    /* Allocate a RQB */
    if ((p_rqb = calloc(1, sizeof(struct rqb))) == NULL) {
        return (-1);
    }

  /* Set RQB fields and call Pattach */

    p_rqb -> th.ra.stcb = APPL_CODE;
    p_rqb -> th.ra.code = 0x80; /* RQB */
    p_rqb -> th.ra.code = p_rqb -> th.ra.code & 0xfd; /* from = TOP */
    p_rqb -> th.ra.wa.rqba.rsrlen = sem_no + ST_N;
    if (p_rpl -> rsrv3 == 0) {
        /* primary LU */
        p_rqb -> th.ra.rparm.parm.parm1 = 3; /* CLSDST */
    }
    else
            {
                /* secondary LU */
                p_rqb -> th.ra.rparm.parm.parm1 = 4; /* TERMSESS */
            }
    p_rqb -> th.ra.wa.hh.hscb = p_rpl -> arg; /*it's CID*/

	call_appl(p_rqb);
        free(p_rqb);
}
