 /********************************************************
 *                                                       *
 *              C O N V E R T                            *
 *                                                       *
 * This function provides a service utility for the      *
 * ASCII/DKOI (EBCDIC) conversion. It works with the     *
 * specified character string and produces a converted   *
 * character string.                                     *
 *                                                       *
 * As the matter of fact, at present this subroutine     *
 * has sense for Russia only. For LU 6.2 customizing     *
 * you have to supply your own national alphabet.        *
 *                                                       *
 * Input : Pointer to "convert" structure.               *
 * Output: rc in "convert" struct. indicates             *
 * whether the conversion was successful or not.         *
 *                                                       *
 * CopyRight 1995. Nicholas Poljakov all rights reserved.*
 *                                                       *
 ********************************************************/
#include <convert.h>
#include <stdio.h>
#include <state1.h>

#define  ASCII_TO_EBCDIC    0
#define  EBCDIC_TO_ASCII    1
#define  ASCIIm_TO_EBCDIC   2
#define  EBCDIC_TO_ASCIIm   3
#define  ASCIIint_TO_EBCDIC 4
#define  EBCDIC_TO_ASCIIint 5
#define  AE                 0
#define  Aa                 1
#define  G                  2
int trans(void *, void *, int, char);

conv(ptr)
struct convert *ptr;
{
        char *in;
        char *out;
        int  length;
	char table;

        ptr -> rc = OK;
        switch (ptr -> direct) {
                case ASCII_TO_EBCDIC :
                case EBCDIC_TO_ASCII :
                case ASCIIm_TO_EBCDIC :
                case EBCDIC_TO_ASCIIm :
                case ASCIIint_TO_EBCDIC :
                case EBCDIC_TO_ASCIIint : break;
                default :
                         {
                             ptr -> rc = 0x00000401; /* Invalid direction */
                             return (0);
                         }
         }
         switch (ptr -> ch_set) {
                case AE :
		case Aa :
                case G : break;
                default :
                         {
                             ptr -> rc = 0x00000402; /* Invalid type */
                             return (0);
                         }
          }
          if (ptr -> target == NULL) {
                ptr -> rc = 0x00000404; /* Invalid first char. */
                return (0);
          }
          if (ptr -> source == NULL) {
                ptr -> rc = 0x00000403; /* Segment overlap */
                return (0);
          }
          in = ptr -> source;
          out = ptr -> target;
          length = ptr -> length;
          table = ptr -> direct;
          if (trans(out, in, length, table) == -1) {
                ptr -> rc = 0x00000405; /* Table error */
                return (0);
          }
}
