struct th0 {              /* transmission header               */
    unsigned fid:4;      /* format identifier                 */
    unsigned sgm:2;      /* segmenting: 0 - middle, 1 - last, */
                         /* 2 - first, 3 - only               */
    unsigned dgr:1;      /* datagram indicator                */
    unsigned efi:1;      /* expedited flow indicator          */
  union {
   struct {
    unsigned c:1;        /* circularity flag                  */
    unsigned tp:2;       /* transmission priority:            *
                          * 0 - low                           *
                          * 1 - middle                        *
                          * 2 - high                          */
    unsigned llc:2;      /* logical link control mode:        *
                          * 0 - connectionless mode           *
                          * 1 - n/a                           *
                          * 2 - connection mode               *
                          * 3 - connectionless responded mode */
    unsigned rs1:3;      /* reserved                  */
    unsigned rs2:8;      /* reserved                  */
    unsigned rs3:8;      /* reserved                  */
          } lan;
   struct {
    unsigned c:1;        /* circularity flag                  */
    unsigned rs1:2;      /* reserved                          */
    unsigned path:2;     /* flags for PATH                    *
                          * 2 - fields from HSCB              *
                          * 3 - header is ready               *
    unsigned tn:2;       /* network type                      *
                          * 1 - SNA                           *
                          * 2 - ROUTE                         *
                          * 3 - LAN                           */
    unsigned rs2:1;      /* reserved                  */
    unsigned vrn:3;      /* virtual route number      */
    unsigned tp:2;       /* transmisson priority      */
    unsigned ern:3;      /* explicite route number    */
    unsigned sess:8;     /* session number            */
          } rout;
        } t13;
 union {
    struct {
    unsigned daf:16;     /* destination address field */
    unsigned oaf:16;     /* origin address field      */
    unsigned snf:16;     /* sequense number field     */
    unsigned dcf:16;     /* data count field          */
           } stand;
    struct {
    struct hscb *hscb;
    struct nau *nau;
    short  rsv1;
           } conbl;
        } t411;
 };
#define FID8       0x8   /* format 8 - the only TH format supported */
#define TPLOW      0     /* transmission priority (low)             */
#define TPMIDDLE   1     /* transmission priority (middle)          */
#define TPHIGH     2     /* transmission priority (high)            */
#define LLCCL      0     /* llc connectionless mode                 */
#define LLCC       1     /* llc connectin mode                      */
#define LLCCLR     3     /* llc connectionless responded mode       */
#define NET_SNA    1     /* network type = SNA                      */
#define NET_ROUTE  2     /* network type = ROUTE                    */
#define NET_LAN    3     /* network type = LAN                      */
