#ifndef	MultiXHIncluded
#define	MultiXHIncluded

#define	MultiXVersion					230
#define MultiXOldestVersionSupported	220

#define	MUtilArrayIndexNew				-1
#define	MUtilQueueSeqInvalid			-1
#define	MUtilArrayIndexInvalid			-2
#define	MMdxXonChar						0x11
#define	MMdxXoffChar					0x13

#define	MMdxParityNone		0l
#define	MMdxParityEven		0x80000000l
#define	MMdxParityOdd		0xc0000000l
#define	MMdxNoXonXoff		0x20000000l
#define	MMdxWordSize8		0x10000000l


#define	Use16
#define	MsDosOs
#define StdCall 				__pascal
#define	NoNetworkTranslation
#define	TimerAjustValue			0l
/*
#define	BEGIN		{
#define	END			}
#define	ELSE		else
#define	IF if		(
#define	THEN		)
#define	AND			&&
#define	OR			||
#define	LAND		&
#define	LOR			|
#define	XOR			^
#define	MOD			%
#define	SLAND(x,y)	(x)	&= (y)
#define	SLOR(x,y)	(x)	|= (y)
#define	SXOR(x,y)	(x)	^= (y)
#define	LANDE		&=
#define	LORE		|=
#define	XORE		^=
#define	MODE		%=
#define	REPEAT		do
#define	UNTIL(x)	while	(x)
#define	WHILE		while	(
#define	FOREVER		for(;;)
#define	FOR			for	(
#define	DO			)
#define	GETS		=
#define	EQ			==
#define	NE			!=
#define	GE			>=
#define	LE			<=
#define	LT			<
#define	GT			>
#define	NOT			!
#define	LNEG		~
#define	NOTEQ		!=
*/

#define	On	1
#define	Off	0

#define	MswGet(x)	(UInt16)(((UInt32)(x))	>>	16)
#define	LswGet(x)	(UInt16)(((UInt32)(x))	LAND	0xffff)

#define	MswSet(x,y)	x	GETS	(y	<<	16)	LOR	LswGet(x)
#define	LswSet(X,y)	x	GETS	y	LOR	((UInt32)(x)	LAND	0xffff0000)


#define	MakeFp(_Seg,_Off)	((FarPtr)(((UInt32)_Seg<<16)	LOR	_Off))

#define	TypedMax(t,a,b)	(t)(((t)(a)	> (t)(b)	?	(a)	: (b)))
#define	TypedMin(t,a,b)	(t)(((t)(a)	< (t)(b)	?	(a)	: (b)))

#define	Max16(a,b)	TypedMax(Int16,a,b)
#define	Min16(a,b)	TypedMin(Int16,a,b)

#define	MaxU16(a,b)	TypedMax(UInt16,a,b)
#define	MinU16(a,b)	TypedMin(UInt16,a,b)

#define	Max32(a,b)	TypedMax(Int32,a,b)
#define	Min32(a,b)	TypedMin(Int32,a,b)

#define	MaxU32(a,b)	TypedMax(UInt32,a,b)
#define	MinU32(a,b)	TypedMin(UInt32,a,b)

#define	SwapInt16(_Num)	(UInt16)((((UInt16)(_Num))	>>	8)	LOR	(((UInt16)(_Num))	<<	8))


#define	MIntSwap(_Int)		\
	(sizeof((_Int))	EQ	sizeof(Int16)	?	\
	(int)SwapInt16((UInt16)(_Int))			:	\
	(int)SwapInt32((UInt32)(_Int)))

#define	MIntSwapSet(_Int)	_Int	=	MIntSwap(_Int)

#define	MNetToHostInt(_Int)	(_Int)
#define	MHostToNetInt(_Int)	(_Int)
#define	MNetToHostIntSet(_Int)
#define	MHostToNetIntSet(_Int)


#define	NullP			(void	*)0
#define	MByteArray(x)	struct	{char	Byte[x];}
#define	IsNullP(x)		((x)	EQ	NullP)
#define	NotNullP(x)		((x)	NE	NullP)
#define	IfNotNullP(x)	IF	(x)	NE NullP	THEN
#define	IfNullP(x)		IF	(x)	EQ NullP	THEN
#define	MCreateNew(_X)	IfNullP((_X)	GETS	MdxCalloc(sizeof(*(_X))))	FatalError("No	Memory");
#define	MOccurs(_X)		(sizeof(_X)	/ sizeof((_X)[0]))

#define	FatalError(_ErrorText)	FatalErrorHandler(_ErrorText)


typedef				int		Int16;
typedef	unsigned			UInt16;
typedef				long	Int32;
typedef	unsigned	long	UInt32;
typedef	unsigned	short	UShort;
typedef	unsigned	int		TBit;
typedef				int		Int;
typedef	unsigned	int		UInt;
typedef				char	Int8;
typedef	unsigned	char	UInt8;
typedef				double	Double64;
typedef				float	Float32;
typedef				Int32	TFileDescr;
typedef				Int32	TLinkDescr;
typedef				Int16	TSLinkDescr;
typedef				Int16	TPtrArrayIndex;
typedef				Int32	TIndex;
typedef				UInt16	TSIndex;
typedef				UInt16	TBufSize;
typedef				Int32	TCounter;
typedef				Int16	TSCounter;
typedef				UInt16	TMdxObjectId;
typedef				Int32	TQueueSeq;
typedef				UInt32	TBaudRate;
typedef				UInt32	TTimer;
typedef				UInt32	TTimerId;
typedef				UInt32	TTimerTag;
typedef				Int32	TReqSeq;
typedef				Int16	TSReqSeq;
typedef				Int32	TListKey;
typedef				UInt32	*UInt32Ptr;
typedef				Int8	*Int8Ptr;
typedef				UInt8	*UInt8Ptr;
typedef				void	Void;
typedef				Int32	TMdxMsgSize;
typedef				Int16	TMdxBlockNo;
typedef				UInt16	TMdxMsgPri;
typedef				Int32	TMdxProcId;
typedef				Int16	TMdxMsgCode;
typedef				UInt32	TMdxTime;
typedef				UInt16	TMdxVersion;
typedef				UInt8	TOnOff;
typedef				Int8	TSResult;
typedef				Int8	TSBoolean;


typedef	MByteArray(30)	TMdxLinkName;
typedef	MByteArray(80)	TMdxService;
typedef	MByteArray(20)	TMdxNetAddr;
typedef	MByteArray(10)	TMdxPassword;
typedef	MByteArray(24)	TMdxProcDescr;

#pragma	pack(1)

typedef union	TVarChar
{
	Int16	Len;
	Int8	Text[2];
} TVarChar;

#pragma	pack()

typedef	enum	/*	TMdxStartupAttributes	*/
{
	MdxStartAsGateWay		=	0x0001,
	MdxUseDualEventQueues	=	0x0002,
	MdxReportAllProcesses	=	0x0004,
	MdxReportAllLinks		=	0x0008,
	MdxStartAsRouter		=	0x0010,
	MdxDisplayVersion		=	0x4000
} TMdxStartupAttributes;


typedef enum
{

	MdxLinkTypeAcceptOnly		=	0,	/*	Indicates	a	server	link	type,
											usually	as a	result	of	accept
											on	tcp/ip	or	something	like	that
										*/
	MdxLinkTypeFirst			=	1,

	MdxLinkTypeAsyncLocal		=	1,
	MdxLinkTypeNetBios			=	2,
	MdxLinkTypeTcpIpSocket		=	3,
	MdxLinkTypeNPipe			=	4,
	MdxLinkTypeAsyncModem		=	5,
	MdxLinkTypeX25				=	6,
	MdxLinkTypeLoopBack			=	7,
	MdxLinkTypeSpxIpx			=	8,
	MdxLinkTypeLast
} TMdxLinkType;

typedef enum
{
	MdxL2DlcProtoNone		=		0,
	MdxL2DlcProtoHdlc		=		1
} TMdxL2DlcProtocol;


typedef enum
{
	Failure	=	0,
	Success	=	1
} TResult;

typedef enum
{
	False	=	0,
	True	=	1
} TBoolean;


typedef enum
{
	MdxCallOk,
	MdxInvalidPassword
} TMdxCallError;


typedef enum
{
	L1WarnDontFreeSendBuf	=	-300	,
	L1ErrLinkNameMissing			,
	L1ErrUnableToInitSocket			,
	L1ErrAcceptError				,
	L1ErrLinkNameTooLong			,
	L1ErrInvalidLinkType			,
	L1ErrTooManyLinks				,
	L1ErrInvalidL1Ld				,
	L1ErrUnableToOpenAsync			,
	L1ErrUnableToSetupAsync			,
	L1ErrUnableToCreateNPipe		,
	L1ErrIllegalOperation			,
	L1ErrInvalidReqCode				,
	L1ErrTimeout					,
	L2ErrTooManyLinks				,
	L2ErrTooManyConnectRetries		,
	L2ErrSendQueueFull				,
	L2ErrSendBufferEmpty			,
	L2ErrSendBufferTooBig			,
	L2ErrMaxResetCount				,
	L2ErrMaxPollCount				,
	L2ErrInvalidConnectMode			,
	L2ErrInvalidFd					,
	L2ErrInvalidApprSeq				,
	L2ErrInvalidFrameType			,
	L2ErrInvalidReqCode				,
	L2ErrConnectFailed				,
	L2ErrNoResetResponse			,
	L2ErrNoPollResponse				,
	L3ErrProcessAlreadyDefined		,
	L3ErrNoLinkAvailable			,
	L3ErrSendBufferEmpty			,
	L3ErrMsgCanceled				,
	L3ErrInvalidReqCode				,
	L3ErrProcessDoesNotExist		,
	L3ErrNoGateWayAvailable			,
	L4ErrMsgSendCanceled			,
	L4ErrInvalidReqCode				,
	L4ErrInvalidReqSeq				,
	L5ErrProcessClosed				,
	L5ErrInvalidReqCode				,
	L6ErrInvalidReqCode				,
	UtErrTooManyLinks				,
	UtErrInvalidHashTable			,
	UtErrDuplicateHashKey			,
	UtErrHashKeyNotFound			,
	UtErrInvalidStackTable			,
	UtErrInvalidParam				,
	TsrErrMsgNotFound				,
	L2ErrMissingBuffer
} TMdxError;

typedef enum
{
	DdeErrFirstError			=	-400,
	DdeErrLastError				=	-381,
	DbmErrFirstError			=	-380,
	DbmErrLastError				=	-330,
	MdxErrFirstError			=	-300,
	MdxErrLastError				=	-201,
	TpErrFirstError				=	-200,
	TpErrLastError				=	-101,
	MdErrSessionRestarted		=	-100,
	MdErrMsgTimedOut,
	MdErrMsgCanceled,
	MdErrInvalidProcId,
	MdErrUnableToOpenLink,
	MdErrInvalidLinkLd,
	MdErrInvalidDriverIndex,
	MdErrLinkDisconnected,
	MdErrDataReplyNotAllowed,
	MdErrInvalidReplyInfo,
	MdErrMsgIsEmpty,
	MdErrInvalidEventCode,
	MdErrLinkClosed,
	MdErrLinkAlreadyOpened,
	MdErrProcessNotReady,
	MdErrNoMemory,
	MdErrLinkTypeNotSupported,
	MdErrNoError	=	0
} TMdxApplError;


typedef enum
{
	MdxDdeErrInvalidMsgCode	=	-400,
	MdxDdeErrAdviseStopped,
	MdxDdeErrInvalidDataFormat,
	MdxDdeErrInvalidItem
} TMdxDdeError;



typedef enum
{
	MdxConnectModeListen,
	MdxConnectModeCall
} TMdxConnectMode;

typedef enum
{
	MdxTimerEvent						=	110,
	MdxStdInAvailable					=	111,
	MdxIdleEvent						=	120,
	MdxL1L2EvConnectEnabled				=	130,
	MdxL1L2EvAcceptEnabled				=	140,
	MdxL1L2EvReadEnabled				=	150,
	MdxL1L2EvWriteEnabled				=	160,
	MdxL1L2EvLinkDisconnected			=	170,
	MdxL2L3EvSendComplete				=	180,
	MdxL2L3EvRecvComplete				=	190,
	MdxL2L3EvLinkClosed					=	200,
	MdxL2L3EvConnectComplete			=	210,
	MdxL2L3EvQueuesReset				=	220,
	MdxL2L3EvTransmitEnabled			=	225,
	MdxL2L3EvResumeTransmision			=	227,
	MdxL3L4EvMsgCancled					=	230,
	MdxL3L4EvMsgSentOk					=	240,
	MdxL3L4EvMsgReceived				=	250,
	MdxL3L4EvProcessReady				=	260,
	MdxL3L4EvProcessFailed				=	270,
	MdxL4L5EvMsgReceived				=	280,
	MdxL4L5EvControlMsgReceived			=	285,
	MdxL4L5EvMsgCancled					=	290,
	MdxL4L5EvMsgSentOk					=	300,
	MdxL4L5EvProcessReady				=	310,
	MdxL4L5EvProcessFailed				=	320,
	MdxL4L5EvProcessRestarted			=	330,
	MdxL4L5EvProcessConnected			=	340,
	MdxL5L6EvMsgReceived				=	350,
	MdxL5L6EvControlMsgReceived			=	355,
	MdxL5L6EvCallReqReceived			=	360,
	MdxL5L6EvCallRejected				=	370,
	MdxL5L6EvMsgCancled					=	380,
	MdxL5L6EvMsgSentOk					=	390,
	MdxL5L6EvCallCompleted				=	400,
	MdxL5L6EvProcessReady				=	402,
	MdxL5L6EvProcessNotReady			=	404,

	MdxEvDataMsgReceived				=	410,
	MdxEvDataReplyReceived				=	420,
	MdxEvSendMsgCompleted				=	430,

	MdxEvCallReqReceived				=	440,
	MdxEvCallRejected					=	450,
	MdxEvCallCompleted					=	460,


	MdxEvProcessReady					=	462,
	MdxEvProcessNotReady				=	464,

	MdxEventApplInit					=	470,
	MdxEvLinkStatus						=	480,
	MdxEvProcessAdded					=	490,
	MdxEvProcessRemoved					=	491,
	MdxEvNonMultiXDataReceived			=	500,


	MdxApplEventCodeFirst				=	30000,
	MdxApplEventCodeLast				=	31000

} TMdxEventCode;

typedef enum
{
	/*	Application	Assigned	Attributes	*/

	MdxResponseRequired	=	0x0001,
	MdxReportSuccess	=	0x0002,
	MdxReportError		=	0x0004,
	MdxResendOnRestart	=	0x0008,
	MdxReportAll		=	0x0007,
	MdxSendReliable		=	0x000f,
	MdxUseDataBuffer	=	0x0010,
	MdxUseDbProtection	=	0x0020,
	MdxUseMultiCast		=	0x0040,
	MdxDontUseAllocMod	=	0x0100,

	/*	Kernel	Assigned	Attributes	*/

	MdxL6IsReplyMsg			=	0x1000
} TMdxSendAttr;

typedef enum
{
	MdxL2EventHandlerIndex			=	2,
	MdxL3EventHandlerIndex			=	3,
	MdxL4EventHandlerIndex			=	4,
	MdxL5EventHandlerIndex			=	5,
	MdxL6EventHandlerIndex			=	6,
	MdxL7EventHandlerIndex			=	7,
	MdxTimerMgrEventHandlerIndex	=	8,
	MdxLinkMgrEventHandlerIndex		=	9,
	MdxProcMgrEventHandlerIndex		=	10,
	MdxEventHandlerIndexLast
} TMdxEventHandlerIndex;


typedef enum
{
	MdxTpmFirstMsgCode			=	-32700,
	MdxTpmLastMsgCode			=	-32601,
	MdxMvxFirstMsgCode			=	-32500,
	MdxMvxLastMsgCode			=	-32401,
	MdxSqlFirstMsgCode			=	-32400,
	MdxSqlLastMsgCode			=	-32351,
	MdxDdeAdviseStartMsgCode	=	-32100,
	MdxDdeAdviseDataMsgCode		=	-32099,
	MdxDdeDataReqMsgCode		=	-32098,
	MdxDdeDataReplyMsgCode		=	-32097,
	MdxDdePokeMsgCode			=	-32096,
	MdxDdeExecuteMsgCode		=	-32095
} TMdxReservedMsgCodes;

typedef enum
{
	MdxDdeDataFormatIsText	=	1
} TMdxDdeDataFormat;


typedef enum
{
	MdxSeekStart,
	MdxSeekFwrd,
	MdxSeekBack,
	MdxSeekEnd
} TMdxMsgSeekOrigin;


#pragma	pack(2)

typedef	struct	TMdxMsg
{
	TMdxObjectId	Id;
	TMdxMsgSize		BytesRead;
	void			*Global;
}	TMdxMsg;

typedef	struct	TMdxProtocol
{
	TBoolean	Supported;
	void		(*StartupRoutine)(void);
	void		(*CleanUpRoutine)(void);
	TMdxError	(*ServiceRoutine)(void	*);
	void		(*EventHandler)(void	*);
	void		(*SetPoll)(void);
	void		(*CheckPoll)(void);
}	TMdxProtocol;

typedef enum
{
	MdxL2NetDriverIndex	=	0,
	MdxL2RawDriverIndex	=	2
} TMdxL2DriverIndex;

typedef enum
{
	MdxL3NetDriverIndex	=	0
} TMdxL3DriverIndex;

typedef enum
{
	MdxLinkClosed,
	MdxLinkDisconnected,
	MdxLinkWaitConnect,
	MdxLinkConnected
} TMdxLinkStatus;



typedef	struct	TMdxLinkParams
{
	TLinkDescr			Ld;
	TMdxLinkType		LinkType;
	TMdxLinkName		LinkName;
	TBaudRate			LinkBaud;
	TOnOff				UseDlcFraming;
	TOnOff				Ebcdic;
	TMdxNetAddr			NetAddr;
	TMdxL2DriverIndex	L2DriverIndex;
	TMdxL3DriverIndex	L3DriverIndex;
	TMdxLinkStatus		LinkStatus;
	TMdxService			Service;
	TMdxConnectMode		ConnectMode;
	TTimer				ConnectTimeout;
	TTimer				ConnectRetriesDelay;
	TBufSize			L1MaxSendSize;
	TCounter			MaxConnectRetries;	/*	L3	*/
	TTimer				IdleTimeout;		/*	L3	*/
	TTimer				ImAliveInterval;	/*	L3	*/
	TTimer				PollInterval;		/*	L2	*/
	TSCounter			MaxPollRetries;		/*	L2	*/
	TMdxProcId			DefaultProcId;
}	TMdxLinkParams;

typedef	struct	TMdxProcessParams
{
	TMdxProcId		ProcId;
	TMdxPassword	PasswordToSend;
	TMdxPassword	ExpectedPassword;
	TTimer			InactivityTimer;
	TTimer			ConnectRetriesInterval;
}	TMdxProcessParams;

typedef	struct	TMdxApplTimerInfo
{
	TTimerId		TimerId;
	Int16			Code;
	TTimer			Timer;
	TTimerTag		Tag1;
	TTimerTag		Tag2;
	TTimerTag		Tag3;
	TCounter		Count;
}	TMdxApplTimerInfo;




/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

/****	The internal structure of following structures are for			***/
/****	Application use.												***/

/**************************************************************************/
/**************************************************************************/
/**************************************************************************/
/**************************************************************************/

typedef	struct	TMdxEvent
{
	TMdxEventCode	Code;
	TLinkDescr		Ld;
	TMdxError		Error;
	TReqSeq			ReqSeq;
	TMdxProcId		ProcId;
	void			*Data;
	TBufSize		DataCount;
	TMdxEventHandlerIndex	DataDestructorIndex;
	TBoolean		KeepEvent;
	TMdxObjectId	Id;
	TTimer			EventTimer;
}	TMdxEvent;

/*	Send / Receive Msg Info */
typedef	struct	TMdxSRMsgInfo
{
	struct
	{
		TMdxMsg			*Msg;
		TMdxMsgCode		MsgCode;
		TMdxProcId		SentFrom;
		TQueueSeq		SenderMsgId;
		TMdxSendAttr	SendAttr;
		TMdxMsgPri		MsgPri;
	}	Received;
	struct
	{
		TMdxMsg			*Msg;
		TMdxMsgCode		MsgCode;
	}	Sent;
}	TMdxSRMsgInfo;

#pragma	pack()

typedef void			(cdecl	*	TEventHandler)(TMdxEvent	 *);
typedef	void			(cdecl	*	TEventDataDestructor)(TMdxEvent	*);

extern	TMdxProtocol		StdCall		ProtocolNotSupported(void);

extern	TMdxTime		StdCall	MdxGetTime(void);
extern	UInt32			StdCall	MdxTimeTo_time_t(TMdxTime);
extern	void			*StdCall	MdxAlloc(UInt32);
extern	void			*StdCall	MdxCalloc(UInt32);
extern	void			*StdCall	MdxRealloc(void	*,UInt32);
extern	void			StdCall	MdxFree(void	*);
extern	TTimer			StdCall	MdxGetCurrTimerValue(void);



extern	TTimerId		StdCall	MdxSetApplTimer(Int16,TTimer,TTimerTag,
													TTimerTag,TTimerTag,
													TCounter);
extern	void			StdCall	MdxClrTimer(TTimerId);
extern	TResult			StdCall	MdxGetApplTimerInfo(void	*,
														TMdxApplTimerInfo	*);


extern	TMdxMsg			*StdCall	MdxMsgNew(TMdxMsgSize);
extern	TMdxMsg			*StdCall	MdxMsgNewFile(Int8Ptr,UInt8Ptr,
												TSCounter);
extern	TMdxMsg			*StdCall	MdxMsgDup(TMdxMsg	*);
extern	TResult			StdCall	MdxMsgDelete(TMdxMsg	*);
extern	TResult			StdCall	MdxMsgAppend(TMdxMsg	*,void	*,
												TBufSize);
extern	TResult			StdCall	MdxMsgStore(TMdxMsg	*,TMdxMsgSize,void	*,
												TBufSize);
extern	TBufSize		StdCall	MdxMsgRead(TMdxMsg	*,void	*,
												TBufSize);
extern	TMdxMsgSize		StdCall	MdxMsgSeekRead(TMdxMsg	*,TMdxMsgSize,TMdxMsgSeekOrigin);
extern	TResult			StdCall	MdxMsgRewindRead(TMdxMsg	*);
extern	TMdxMsgSize		StdCall	MdxMsgSizeGet(TMdxMsg	*);
extern	TMdxError		StdCall	MdxSendMsg(TMdxProcId,TMdxMsg	*,
												TMdxMsgCode,TMdxMsgPri,
												TMdxSendAttr,TReqSeq,TTimer);
extern	TMdxError		StdCall	MdxSendData(TMdxProcId,void	*,
												TBufSize,TMdxMsgCode,
												TMdxMsgPri,TMdxSendAttr,
												TReqSeq,TTimer);
extern	TMdxError		StdCall	MdxReply(TMdxSRMsgInfo	*,TMdxError);
extern	TMdxError		StdCall	MdxReplyWithData(TMdxSRMsgInfo	*,
													TMdxError,void	*,
													TBufSize,TMdxMsgCode,
													TMdxMsgPri,TMdxSendAttr,
													TReqSeq,TTimer);
extern	TMdxError		StdCall	MdxReplyWithMsg(TMdxSRMsgInfo	*,
													TMdxError,TMdxMsg	*,
													TMdxMsgCode,TMdxMsgPri,
													TMdxSendAttr,TReqSeq,
													TTimer);
extern	TMdxError		cdecl	MdxL3SendNonMultiXData(TMdxProcId,
													UInt8Ptr,TBufSize);

extern	TMdxError		StdCall	MdxConnectProcess(TMdxProcessParams	*);
extern	TMdxError		StdCall	MdxDisconnectProcess(TMdxProcId);
extern	TMdxError		cdecl	MdxCheckProcessStatus(TMdxProcId);
extern	TMdxError		StdCall	MdxAcceptProcess(TMdxProcId,TMdxPassword	*);
extern	TMdxError		StdCall	MdxRejectProcess(TMdxProcId,
													TMdxCallError);


extern	TMdxError		cdecl	MdxOpenLink(TMdxLinkParams	*);
extern	TMdxError		cdecl	MdxCloseLink(TLinkDescr);
extern	TMdxError		cdecl	MdxCheckLinkStatus(TLinkDescr);
extern	TMdxError		cdecl	MdxGetLinkParams(TMdxLinkParams	*);


extern	void			cdecl	MultiXStart(TMdxProcId,Int8Ptr,
												TMdxStartupAttributes,
												TEventHandler);
extern	void			cdecl	MultiXWaitEvent(void);
extern	void			cdecl	MultiXCheckEvent(void);
extern	void			cdecl	MdxDeleteEvent(TMdxEvent	*);
extern	void			cdecl	FatalErrorHandler(Int8Ptr);
extern	TMdxProcId		cdecl	MdxGetMyId(TMdxProcDescr	*);
extern	TMdxError		cdecl	MdxCreateApplEvent(TMdxEventCode,void*,TBufSize);
extern	void			StdCall	TraceBuffer(Int16,void	*,TBufSize);
extern	int			StdCall	TruncSpace(void	*,int,TBoolean);

#endif	/*	MultiXHIncluded */
