;;*****************************************************************************
;;                    arptab.inc           arptab.inc
;;*****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*****************************************************************************
;;
;; The functions provided by this file are
;;
;;      ARP_TAB_DECLARE name
;;      ARP_TAB_DEFINE name
;;      ARP_TAB_GET_in_AX_out_SI_const_AX_BX_CX_BP_DI_ES name
;;      ARP_TAB_ADD_in_AX_BX_ES_out_SI_const_BX_DX_BP_DI_ES name
;;      
;;*****************************************************************************
;; arp table stuff.  only the routines below use this stuff

arp_entry STRUC                     ;; an entry in the arp table
    arp_ent_haddr   DW 3 dup (0)
    arp_ent_ipaddr  DW ?
arp_entry ENDS


;;******************************************************************************
;; ARP_TAB_DECLARE declares external data structures for the arp table
;;
ARP_TAB_DECLARE MACRO name
    .DATA
    global arp_&name&_table:arp_entry
    .CODE
ENDM

;;******************************************************************************
;; ARP_TAB_DEFINE defines and initilizes the arp table 
;;
ARP_TAB_DEFINE MACRO name
    .errb <name>

    .DATA
arp_&name&_table    arp_entry 256 dup (<>)

    .CODE
    mov CX, (size arp_entry)*256/2
    mov DI, offset arp_&name&_table
    mov AX, DS
    mov ES, AX
    xor AX, AX                          ;; null the table
    rep
    stosw
ENDM


;;******************************************************************************
;; ARP_TAB_GET returns in SI a pointer to the harware address for the computer 
;; that has an IP address whose LSB is in AX.   The zero flag is set if the 
;; routine was successful

ARP_TAB_GET_in_AX_out_SI_const_AX_BX_CX_BP_DI_ES MACRO name
    .errb <name>

    mov DX, AX                                          ;; save AX
    ARP_TAB_GET_ENTRY_in_AX_out_SI_const_BX_CX_DX_BP_DI_ES name
    mov AX, DX
    cmp AX, [SI+arp_ent_ipaddr] 
ENDM


;;******************************************************************************
;; ARP_TAB_ADD_in_AX_BX_ES adds the hardware address pointed to by BX:ES to the 
;; table 'name' for the computer whose IP address ends in AX.  SI:DS points
;; to the hardware address of the new entry
;;
ARP_TAB_ADD_in_AX_BX_ES_out_SI_const_BX_DX_BP_DI_ES MACRO name
    .errb <name>

    mov CX, AX                      ;; save AX
    ARP_TAB_GET_ENTRY_in_AX_out_SI_const_BX_CX_DX_BP_DI_ES name

    mov AX, ES:[BX]                 ;; copy the hardware address
    mov [SI+arp_ent_haddr], AX
    mov AX, ES:[BX+2]
    mov [SI+arp_ent_haddr+2], AX
    mov AX, ES:[BX+4]
    mov [SI+arp_ent_haddr+4], AX

    mov [SI+arp_ent_ipaddr], CX
ENDM


;;******************************************************************************
;; ARP_TAB_GET_ENTRY_returns in SI a pointer to the harware address for the 
;; computer that has an IP address whose LSB is in AX.   

ARP_TAB_GET_ENTRY_in_AX_out_SI_const_BX_CX_DX_BP_DI_ES MACRO name
    .errb <name>

    mov AL, AH                      ;; byte swap
    xor AH, AH
    shl AX, 1                       ;; multiply by 8
    shl AX, 1
    shl AX, 1
    mov SI, AX                      ;; put it in BX
    add SI, OFFSET arp_&name&_table
ENDM

