;;****************************************************************************
;;                     pcroute.asm         pcroute.asm
;;****************************************************************************
;;
;;  Copyright (C) 1989 Northwestern University, Vance Morrison
;;
;;
;; Permission to view, compile, and modify for LOCAL (intra-organization) 
;; USE ONLY is hereby granted, provided that this copyright and permission 
;; notice appear on all copies.  Any other use by permission only.
;;
;; Northwestern University makes no representations about the suitability 
;; of this software for any purpose.  It is provided "as is" without expressed 
;; or implied warranty.  See the copywrite notice file for complete details.
;;
;;*************************************************************************
;;
;; pcroute is the main module for the pcroute program.  This program makes a 
;; PC into an IP router.  Nothing real is done in this file
;;
;; AUTHOR: Vance Morrison
;; DATE:   5/24/89
;; ADDRESS: morrison@accuvax.nwu.edu
;;****************************************************************************

    DOSSEG
    include declare.inc         ;; contains all macro definitions
    include config.inc          ;; except these
    include dlog.inc 

    .stack 200H

    .data
    db  'Copywrite (c) 1989, Vance Morrison, Northwestern University',13,10,0
    db  '    '
    db  'VERSION 2.23 ', 0

    DLOG_DECLARE %dlog          ;; declared here since only needed during config

;;************************************************************************
    .code

pcroute:
    mov AX, @DATA
    mov DS, AX
    cld                         ;; direction is always forward

    DB_DEFINE                   ;; define debugging routines

    DLOG_DEFINE %dlog

    DLOG_PRINT %dlog, <******* PCroute starting *******>
    CONFIG terminate, %dlog
    DLOG_PRINT %dlog, <******* PCroute closing log file *******>
    DLOG_CLOSE %dlog

    SCHED_RUN                   ;; this never returns 

    terminate:
        mov AH, 4CH             ;; terminate program
        int 21H
END pcroute
