/*
 * Decompiled with CFR 0.152.
 */
package com.uptimenotifier.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class ClientProperties
extends Properties {
    static final String DEF_PROPS = "notifier.properties";

    public ClientProperties(Properties properties) throws Exception {
        super(properties);
        try {
            File propsFile = new File(this.getProperty("propertiesFile", DEF_PROPS));
            if (propsFile.canRead()) {
                this.loadPropertiesFile(propsFile);
            } else {
                propsFile = new File(this.getProperty("java.class.path", DEF_PROPS) + "/" + properties.getProperty("propertiesFile", DEF_PROPS));
                if (propsFile.canRead()) {
                    this.loadPropertiesFile(propsFile);
                } else {
                    propsFile = new File(this.getProperty("user.dir", DEF_PROPS) + "/" + this.getProperty("propertiesFile", DEF_PROPS));
                    if (propsFile.canRead()) {
                        this.loadPropertiesFile(propsFile);
                    } else {
                        propsFile = new File(this.getProperty("user.home", DEF_PROPS) + "/" + this.getProperty("propertiesFile", DEF_PROPS));
                        if (propsFile.canRead()) {
                            this.loadPropertiesFile(propsFile);
                        }
                    }
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void loadPropertiesFile(File aPropsFile) throws Exception {
        try {
            Properties fileProps = new Properties();
            fileProps.load(new FileInputStream(aPropsFile));
            Enumeration<Object> e = fileProps.keys();
            while (e.hasMoreElements()) {
                String aFileKey = e.nextElement().toString();
                if (this.getProperty(aFileKey) != null && this.getProperty(aFileKey).length() != 0) continue;
                this.setProperty(aFileKey, fileProps.getProperty(aFileKey));
            }
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        DEF_PROPS = DEF_PROPS;
    }
}

