/*--------------------------------------------*/
/*                   SOM                      */
/*         Self Organizing Map                */
/*          by Luca Marchese                  */
/*                                            */
/*tipo(type):                                 */
/*autoorganizzante(self_organizing)           */
/*parametri da definire(parameters to define):*/
/*dimensione pattern input(input pattern dim) */
/*nome file apprendimento(learning file)      */
/*numero iterazioni (iterations numbers)      */
/*--------------------------------------------*/


#include <stdio.h>
#include <math.h>
#include <conio.h>

     float in[100];
     float out[100];
     float w[100][100];
     int pat_dim;

   main()
     {
      char t_f[100];
      char t_v[100];
      int nep;
      FILE *fpl;
      FILE *fpv;
      printf("TRAINING FILE:");
      scanf("%s",t_f);
      printf("VALIDATION FILE:");
      scanf("%s",t_v);
      printf("ITERATIONS/STEP:");
      scanf("%d",&nep);
      printf("PATTERN DIMENSION:");
      scanf("%d",&pat_dim);
      if(!(fpl=fopen(t_f,"r")))
                {
                 puts("errore apertura file");
                 return;
                }
      if(!(fpv=fopen(t_v,"r")))
               {
                puts("errore apertura file");
                return;
               }
      gotoxy(33,19);
      puts("LEARNING...");
      learn(nep,fpl);
      test(fpv);
      fclose(fpl);
      fclose(fpv);
      return;
     }



   learn(nep,fpl)
      int nep;
      FILE *fpl;
    {
     int j=0;
     int k=0;
     int z=0;
     float ca=0.1; /*costante di apprendimento*/
     rand_w();     /*learning constant*/
     while(k!=nep)
      {
       gotoxy(31,18);
         printf("--------------");
       gotoxy(31,19);
       printf("  ITERATION %d ",k);
       while(1)
        {
         j=0;
         while(j!=pat_dim) fscanf(fpl,"%f",&in[j++]);
         if(feof(fpl)) break;
         gotoxy(31,20);
         printf("--------------");
         gotoxy(31,21);
         printf("  PATTERN %d  ",z);
         gotoxy(31,22);
         printf("--------------");
         z++;
         exec();
         adjust(ca); 
        }
       z=0;
       ca=ca/1.3;
       fseek(fpl,0,0);
       k++;
      }
     return;
    }


   rand_w()
   /*inizializzazione random*/
   /*dei pesi con valori    */
   /*compresi tra 0.0 e 1.0 */
   /*random initialization of weights*/
     {
      int k=0;
      int j=0;
      float w1;
      float w2;
      float wx;
      while(k!=100)
        {
         j=0;
         while(j!=pat_dim)
              {
               w1=rand();
               w2=rand();
               if(w1>w2) wx=w2/w1;
               else wx=w1/w2;
               w[j++][k]=wx;
              }
         k++;
        }
     }




test(fpv)
  FILE *fpv;
    {
     int j=0;
     int k=0;
     char conf[10];
       while(1)
        {
         endfile:
         j=0;
         while(j!=pat_dim) fscanf(fpv,"%f",&in[j++]);
         
         if(feof(fpv)) 
           {
            fseek(fpv,0,0);
            k=0;
            goto endfile;
           }
         clrscr();
                 
         exec();
         display();
         k++;
         gotoxy(40,21);
         puts("TESTING...");
         gotoxy(40,22);
         printf("PATTERN N.%d\n",k);
         gotoxy(40,23);
         printf("CONTINUO?(Y/N)");
         scanf("%s",conf);
         if((!strncmp(conf,"n",1)) || (!strncmp(conf,"N",1))) return;
        }
    }





   exec()
    {   
     int k=0;
     int j=0;
     /*inizializzazione dello strato output*/
     /*initialization of the output layer*/
     while(k!=100) out[k++]=0;
     /*trasferimento pattern su strato output*/
     /*con collegamento totale tra neuroni   */
     /*transfer of the pattern to output layer*/
     /*with global connection between neurons*/
     k=0;
     while(k!=100) 
         {
           j=0;
           while(j!=pat_dim) out[k]=out[k]+in[j]*w[j++][k];
           k++;
         }
     /*sullo strato di output collegamento*/
     /*a "cappello messicano"             */
     /*mexican bonnet weights*/
     k=0;
     while(k!=100)
              {
               out[k]=out[k]+0.1*(out[k-1]+out[k+1]-out[k-2]-out[k+2]);
               k++;
              }
     return;
    }



    adjust(ca)
      float ca;
      {
       char resp[10];
       int j=0;
       int k=0;
       int win_idx=0;
       float win_val=0;
       /*ricerca neurone winner*/
       /*search for winner neuron*/
       while(k!=100)
           {
            if(out[k]>win_val) 
                   {
                     win_idx=k;
                     win_val=out[k];
                   }
            k++;
           }
       /*aggiustamento pesi neurone winner*/
       /*e adiacenti neuroni              */
       /*updating weights of winner and nearest neighbors*/
       j=0;
       while(j!=pat_dim)
           {
      
            w[j][win_idx]=w[j][win_idx]+ca*(in[j]-w[j][win_idx]);
            w[j][win_idx-1]=w[j][win_idx-1]+ca*(in[j]-w[j][win_idx-1]);
            w[j][win_idx-2]=w[j][win_idx-2]+ca*(in[j]-w[j][win_idx-2]);
            w[j][win_idx+1]=w[j][win_idx+1]+ca*(in[j]-w[j][win_idx+1]);
            w[j][win_idx+2]=w[j][win_idx+2]+ca*(in[j]-w[j][win_idx+2]);
  
            j++;
           }
       return;
      }




    display()
        {
         int k=0;
         int x,y;
         float win_val=0;
         float win_ndx;
         char outs[101];
         char r[10];
         while(k!=pat_dim) printf("   %f\n",in[k++]);
         gotoxy(40,5);
         puts("GRIGLIA NEURODI OUTPUT");
         gotoxy(40,7);
         puts("*=NEURODO VINCENTE");
         gotoxy(40,9);
         puts("0123456789");
         k=0;
         while(k!=100) 
             {
              if(win_val<out[k]) 
                       {
                        win_val=out[k];
                        win_ndx=k;
                       }
              k++;
             }
         k=0;
         while(k!=100) 
                {
                 if(k==win_ndx) outs[k]='*';
                 else outs[k]=197;
                 k++;
                }
         outs[k]=0;
         x=40;
         y=10;
         k=0;
         while(x!=50)
             {
         y=10;
         while(y!=20)
             {
         gotoxy(x,y);

         putch(outs[k]);
         k++;
         y++;
         printf("%d",y-11); 
             }
         x++;
       
             }
         return;
        }





