/*
 *  files.h --
 *      Interface for the file manipulation procedures.
 *
 *  Author:
 *      See-Mong Tan
 *  Modified by:
 *	Rich Braun @ Kronos, 2/15/91
 */

#define BASIC_BLOCKSIZE ((u_long) 1024)	/* preferred block size in bytes */
#define FS_BLOCKSIZE ((u_long) 1024)	/* file system block size */

#ifndef MAXFILENAMELEN		/* 15 bytes to store null-terminated name */
#define MAXFILENAMELEN 15
#endif				/* 8 + 1 + 3 + 1 = 15 */

#ifndef MAXPATHNAMELEN
#define MAXPATHNAMELEN 128	/* 128 chars for maximum file name */
#endif

/* UNIX file access permissions */

#define UPERM_FILE   0100000L
#define UPERM_DIR     040000L
#define UPERM_EXEC      0111L
#define UPERM_SEARCH    0111L
#define UPERM_WRITE     0222L
#define UPERM_READ      0444L
#define UPERM_WORLD     0007L
#define UPERM_GROUP     0070L
#define UPERM_OWNER     0700L

  /* what is requested */
#define UCHK_RD	(UPERM_OWNER & UPERM_READ)	/* rd by owner */
#define UCHK_WR (UPERM_OWNER & UPERM_WRITE)	/* write by owner */

  /* get file attributes by dos call */
extern bool_t file_getattr(char *, struct nfsfattr *);
  /* free blocks on disk */
extern long files_freeblocks(int, long *, long *);
  /* read directory on disk */
extern bool_t file_rddir(u_long, u_long, struct udirect *);
  /* all converts all alpahabets in string to lower case */
extern char *strtolower(char *);
  /* create a file with specified permissions */
extern enum nfsstat file_create(char *, struct nfssattr *, struct nfsfattr *);
  /* read a file block */
extern int file_read(u_long, u_long, u_long, char *);
  /* write a file block */
extern enum nfsstat file_write(u_long, u_long, u_long, char *);
  /* set file type */
extern enum nfsstat file_setperm(u_long, long);
  /* set file time */
extern enum nfsstat file_settime(u_long, long);
  /* set file size */
extern enum nfsstat file_setsize(u_long, long);
  /* set file size */
extern enum nfsstat file_setowner(u_long, long, long);
  /* unlink a file */
extern enum nfsstat file_unlink(char *);
  /* rename a file */
extern enum nfsstat file_rename(char *, char *);
  /* validate a path */
extern enum nfsstat validate_path(char *);
