/*
 *  novell.h --
 *      Netware definitions for SOS.
 *
 *  Author:
 *	Rich Braun @ Kronos, 2/15/91
 */

#pragma pack(1)			/* Pack all data structures */

#define MAXNOVELLID 200
#define IDFILE      "NOVELL.ID"

/* Novell-to-Unix UID mapping is accomplished by creating a text file */
/* containing entries in the following format:			      */

/* user  username   123  432					      */
/* offset           200						      */
/* protection       775						      */
/* group	     20						      */

/* The offset value is used if the sequence of user IDs on the Novell */
/* and the Unix systems is the same.  This value is added to the      */
/* Novell ID to get the Unix ID.				      */

/* The group number is returned for every file on the server.  No     */
/* support currently exists for directory trustee lookup.	      */

/* The protection field is used for all directories on the Novell     */
/* file system; it is read as an octal integer.			      */

/* Each user-ID line has four fields.  The last two fields are 32-bit */
/* decimal integers; field 3 is the Unix ID number, and field 4 is    */
/* the Novell object number corresponding to the given user.	      */
/* If a file's owner ID is not given in this file, the Novell user-ID */
/* number will be passed directly to Unix without any mapping.	      */

/* Macro for invoking the Novell API */
#define novell_API(FCN, ARGS, RESULTS, REGSIN, REGSOUT, SEGREGS) \
	   REGSIN.h.ah = FCN; \
	   REGSIN.x.si = (u_short) ARGS; \
	   REGSIN.x.di = (u_short) RESULTS; \
	   intdosx (&REGSIN, REGSOUT, SEGREGS);

/* system call definitions */

	/* Scan File Information E3(0F) */
struct _sfireq {
	u_short	len;
	u_char	func;
	u_short	seq;
	char	handle;
	u_char	attrib;
	u_char	pathlen;
	char	path[MAXPATHNAMELEN];
    };

struct _fileinfo {
	u_char	attrib;
	u_char	xattrib;
	u_long	size;
	u_short	cdate;
	u_short	adate;
	u_long	utime;
	u_long	ownerID;
	u_long	atime;
	char	res[56];
    };

struct _sfirep {
	u_short	len;
	u_short	seq;
	char	filename[14];
	struct _fileinfo info;
    };

	/* Set File Information E3(10) */

struct _setfireq {
	u_short	len;
	u_char	func;
	struct _fileinfo info;
	u_char  handle;
	u_char  search;
	u_char  pathlen;
	u_char  path[MAXPATHNAMELEN];
    };

struct _setfirep {
	u_short	len;
    };

	/* Scan Directory for Trustees E2(0C) */
struct _sdftreq {
	u_short	len;
	u_char	func;
	u_char	handle;
	u_char	seq;
	u_char	pathlen;
	char	path[MAXPATHNAMELEN];
    };

struct _sdftrep {
	u_short	len;
	char	name [16];
	u_long	ctime;
	u_long	ownerID;
	u_long	trustee [5];
	u_char	rights [5];
    };

	/* Scan Directory Information E2(02) */
struct _sdireq {
	u_short len;
	u_char  func;
	u_char	handle;
	u_short seq;
	u_char  pathlen;
	char	path[MAXPATHNAMELEN];
    };

struct _sdirep {
	u_short	len;
	char	name [16];
	u_long	ctime;
	u_long	ownerID;
	u_char	rights;
	u_char  res;
	u_short dirnum;
    };

#pragma pack()
