(* program S2S.PAS

Changes strings into strings by a conversion table (.CTB)

aug 25, added option to exclude treatment of strings inside
specified markers; this version is 'hard-coded' to
exclude treatment of text from '{' to '}'.


aug 22, 1993, conversion protected
(once converted, part of string will no more be
reconverted)

aug 23: add sorting conversion table so that long sources are
examined first


written by jukka-pekka.takala@helsinki.fi

*)


const StrL=10;
      ArrSiz = 255;
var   ArrS_R : integer;

const OvrLen = 10; {length for overlap strings}
      CommCh = ';'; {character to start a comment line in .CTB}
      SplitCh = ^i;  {character that separates source & target in .CTB.
                      TAB (^i) or space recommended }
      ProtCh = #1;  {'protects' converted parts of string;
                      must not appear in text or in .CTB }
      BegExcl = '{';
      EndExcl = '}';
var   TreatOn : Boolean;
      ExclOn  : Boolean;

type Str=String[StrL];

var fi,fo, ftbl: text;
    fin,fon,ftbln:string[50];
type TblLineT = record
                  ExmStr:Str;
                  OutStr:Str;
                  end;
type TblArrT = Array[1..ArrSiz] of TblLineT;
var  TblArr : TblArrT;
    GtLine : String[230];
type
    CVSAT =  Array[1..230] of Str;
var ConvS_Arr : CVSAT;
    OutLine : String;
    OutCh : Char;
    i : integer;
    Reverse : boolean;


Procedure DoError;
 var hl:string[60];
begin
 hl := paramstr(0);
 while pos('\',hl)>0 do delete(hl,1,pos('\',hl));
 while pos('.',hl)>0 do delete(hl,pos('.',hl),4);
 writeln('Format: ');
 writeln( hl, ' INFILE OUTFILE TABLE.CTB [/R] [/X]');
 writeln;
 writeln('Normally source string left, target right: /R reverses');
 write('When "/X" is specified, text between "',BegExcl,'" and "',EndExcl);
 writeln('" will not be converted'); writeln;
 writeln('''outfile'' will be overwritten without warning');
 writeln('Max length of strings in conversion table ',StrL);
 writeln('Max no. of such strings: ',ArrSiz);
 writeln('Limit to line length in source file: none');
 writeln(
  'Current separator character in conversion table: ASCII ',ord(SplitCh));
 writeln(
  'Table or text must currently not include this character : ASCII ',ord(ProtCh));
 halt;
end;

Function UpStr(s: String): String;
 var i : byte;
begin
 for i := 1 to length(s) do
  UpStr[i] := upcase(s[i]);
end;

Procedure ChkLegal( l:string; fn:string );  {must not contain ProtCh}
begin
  if pos( ProtCh, l ) > 0 then
   begin
    writeln(
      ^g,'illegal chracter (ASCII ',ord(ProtCh), ') in ',fn,'.  Aborted.');
    halt;

   end;
end;

Procedure Swap_S(var s1:Str; var s2:str);
var tmp:str;
begin
 tmp := s1;
 s1:=s2;
 s2:=tmp;
end;

Procedure Bsort(var TbA:TblArrT; c: integer);
  var x : TblLineT; i, j : integer; sorted: boolean;
begin
repeat
sorted := true;
  for i := 1 to c-1 do
   begin
     if length( TbA[ i+1 ].ExmStr) > length(TbA[i].ExmStr) then
        begin
          x:=TbA[i]; TbA[i] := TbA[i+1]; TbA[i+1] := x;
          sorted := false;
        end;
   end;
until sorted;
end;

Procedure InitTable;
 var Line : string;
     count:byte;
 begin
   {check file.ext for some security }
   if copy(Ftbln,pos('.',Ftbln),4) <> '.CTB'
     then begin writeln('Need a *.CTB file'); halt; end;
   if copy(Fon,pos('.',Ftbln),4) = '.CTB'
     then begin writeln('cannot output to *.CTB file'); halt; end;
   FillChar( TblArr, SizeOf(TblArr), 0);
   reset(Ftbl);
   count:= 1;
   repeat
    readln(Ftbl, Line);
     if  (Line[ 1 ] <> ';') and (Line <>'') then
      begin
          ChkLegal(Line, Ftbln);
          TblArr[count].ExmStr:= copy(Line,1,pos(SplitCh,line)-1);
          TblArr[count].OutStr:= copy(
            Line, pos(SplitCh,line)+1, Length( Line ) - pos(SplitCh,line)+1);
       If reverse then with TblArr[count] do Swap_s(ExmStr, OutStr);
       count := count + 1;
       if count > ArrSiz then begin
            writeln('table too big, max ',arrsiz ); halt; end;
      end;
   until eof(Ftbl);
   ArrS_R := Count - 1;
   Bsort(TblArr,ArrS_R);
 end;


Procedure Treat(var l : String;
                    var CVSA: CVSAT;
                    i:byte);
    var j,k : byte;
 Begin
   j := Pos(TblArr[i].ExmStr, l );
   while j > 0 do
   Begin
     Delete( l , j,
             Length(TblArr[i].ExmStr));
     for K := 1 to length(TblArr[i].ExmStr)    {insert protchar string}
       do Insert( ProtCh, l, j);
     CVSA[j] := TblArr[i].OutStr;
     j := Pos(TblArr[i].ExmStr, l );
   end;
  End;

procedure  Merge(var s: string; CVSA:CVSAT);
  var k : byte; l :string;
begin
 l := '';
 for k := 1 to length(s) do
  if s[k] <> ProtCh then l := l + s[k]
    else l:=l+CVSA[k];
 s:=l;
end;

Procedure Conv(var s : string );
    var i : byte;
  begin
   FillChar(ConvS_Arr, SizeOf(ConvS_Arr), 0);
   For i := 1 to ArrS_R do
     if TblArr[i].ExmStr <>'' then
        Treat( s, ConvS_Arr, i );
   Merge(S, ConvS_Arr);
end;

Procedure Parse(var s : string);
  var s1,s2 : string;
begin
  if TreatOn then
     if pos(BegExcl,s) < 1
         then Conv(s)
       else
       begin
            s1:=copy(s,1,pos(BegExcl,s));
            s2:=copy(s,pos(BegExcl,s)+1,length(s));
            conv(s1);
            TreatOn := False;
            Parse(s2);
            s:=s1+s2;
      end
    else {TreatOn=false}
      if pos(EndExcl,s) < 1
         then {do nothing} begin end
       else
        begin
           s1:=copy(s,1,pos(EndExcl,s));
           s2:=copy(s,pos(EndExcl,s)+1,length(s));
           TreatOn := True;
           Parse(s2);
           s := s1 + s2;
        end;
end;

Procedure Switches;
 var parm : string[10];
begin
 parm := upStr(paramstr(4))+upStr(paramstr(5));
 Reverse := pos('/R', Parm) > 0;
 ExclOn  := pos('/X', Parm) > 0;
end;


 begin
   if (paramcount<3) or (paramcount>5) then DoError;
   Switches;
   fin:=paramstr(1); fin:=upStr(fin);
   fon:=paramstr(2); fon:=upStr(fon);
   if fin=fon then begin writeln(
        'source and target must be different');
        halt; end;
   assign(fi,fin);
   assign(fo,fon);
   ftbln:=paramstr(3); ftbln:=upStr(ftbln);
   assign(ftbl, ftbln);

   InitTable;

   reset(fi);
   rewrite(fo);
   OutLine := '';

   TreatOn := True;

   repeat
     While Eoln(Fi) and (not eof(Fi)) do
      begin
        ReadLn(Fi);
        Writeln(Fo);
        OutLine := '';
     End;
     Read(Fi, GtLine);
     ChkLegal( GtLine, Fin);
     OutLine := OutLine+GtLine;
      if Length(OutLine) > 1 then
       if ExclOn then
         Parse(Outline)
          else Conv(Outline);
      If eoln(Fi) then
         Write(Fo, Outline)
       Else
        Begin
         Write(Fo, Copy(OutLine, 1, Length(OutLine)-OvrLen ));
         Delete(OutLine, 1, Length(OutLine)-OvrLen );
        End;
    until Eof(Fi);
    close(fi);
    write(fo,^z);
    close(fo);
    end.
