/* tagvalue.h -- possible tag file definitions */
#ifndef	_TAGVALUE_H
#define	_TAGVALUE_H

/* Internal Spool Control Definitions */

#define	TV_DataFileName		"$DF"	/* name of data file which corresponds to this tagfile
					   this is a partially qualified name */

#define	TV_CurrentJobType	"$JT"	/* current Job Type */
#define	TV_JobState		"$JS"	/* current state of job */
#define		TVJS_Ready	"ready"	/* ready to run	*/
#define		TVJS_OnHold	"hold"	/* on hold */
#define		TVJS_Running	"running"

#define	TV_StartTime		"$JST"	/* job start time */

#define	TV_NextJobTypes		"$NJT"	/* sequence of comma separated next job types with args */
					/* $NJT 0 arg1, 5 arg2, 2, 4 */
#define		TVJT_XLATE	"1"	/* translate list job. arg is listname */
#define		TVJT_LPR	"2"	/* send out via LPR to remote host */
#define		TVJT_LPD	"3"	/* insert into novell queue */
#define		TVJT_MAILER	"4"	/* deposit into mailqueue
#define		TVJT_QCLEAN	"5"	/* delete referenced job from novell queue */

#define	TV_CleanUpJobType	"$CJT"	/* Job Type Cleanup Function to Call */
					/* duh, probably not needed here ... */

#define	TV_CompanionJob		"$CJ"	/* if this is set, the 'companion job
					   is on the same server, is on hold and
					   is waiting for 'change to client rights
					 */

#define	TV_SpoolFileSize	"$SFS"	/* size of spool data file */

/* Internal Job Type Specific Definitions */

#define	TV_SLPR_PrintType	"!PT"	/* print type command for output LPR */
#define		TVSPT_CIF	"c"	/* Plot CIF FIle */
#define		TVSPT_DVI	"d"	/* print DVI file */
#define		TVSPT_FORMATTED	"f"	/* print formatted file, our default */
#define		TVSPT_PLOTFILE	"g"	/* SYSV Plot data */
#define		TVSPT_LITERAL	"l"	/* print, leaving control chars */
#define		TVSPT_DITROFF	"n"	/* ditroff format */
#define		TVSPT_PRFORMAT	"p"	/* use PR to print the file */
#define		TVSPT_FORTRAN	"r"	/* use fortran conversion */
#define		TVSPT_TROFFOUT	"t"	/* print this TROFF output file */
#define		TVSPT_VERBATIM	"v"	/* send this file literally to the printer w/ no changes */

/* Generic Data Definitions */

#define	TV_SourceHost		"<Host"	/* which host originated this job */
#define	TV_SourceIHost		"<IHost"	/* internet host name */
#define	TV_SourceHostType	"<Type" /* type of host */
#define		TVSHT_Novell	"novell"	/* type was Novell server */
#define		TVSHT_Remote	"remote"	/* type was something remote */

#define	TV_SourceObject		"<Object" /* source userid, or username */
#define	TV_SourceQueue		"<Queue"  /* source queue name
					     a print queue name, if a print job
					     or mailqueue or workqueue for mail jobs */

#define	TV_SourceJobId		"<Id"	/* queue job number for print queue */

#define	TV_DestHost		">Host"	/* destination host name	*/
#define	TV_DestHostType		">Type"	/* as above */
#define	TV_DestObject		">Object" /* target userid, mailbox, etc */
#define	TV_DestQueue		">Queue"  /* target queue name, as for source */

				/* queue job entry stuff */
#define	TV_QClientId		"+CID"	/* queue job client ID (long) (source) */
#define TV_QJobType		"+JT"	/* queue job type (form # too) */
#define	TV_QJStime		"+QST"	/* Target execution time */
					/* form is YY MM DD HH mm SS  */
					/* space separated 2 digit decimal numbers */

#define	TV_QJFlags		"+QJF"	/* queue job flags.. hold, etc */
#define		TVQJF_AUTORESTART 0x8	/* restart job if server dies */
#define		TVQJF_RESTART	  0x10	/* restart job if server aborts job */
#define		TVQJF_USERHOLD	  0x40	/* on user hold */
#define		TVQJF_OPRHOLD	  0x80	/* on operator hold */
#define	TV_QFilename		"+QJN"	/* queue job file name */
#define	TV_QJDescription	"+QJD"	/* queue job description */

				/* client record area stuff */
#define	TV_CTabSize		"+CTS"	/* client tab size */
#define	TV_CWidth		"+CWD"	/* page width */
#define	TV_CCopies		"+CCOPIES" /* number of copies */
#define	TV_CFlags		"+CF"	/* client flags */
#define		TVCF_NOFF	0x8	/* no form feed */
#define		TVCF_BANNER	0x80	/* do print banner */
#define		TVCF_TEXT	0x40	/* if set, is text otherwise stream */
#define		TVCF_NOTIFY	0x10	/* feh ? */

#define	TV_CFormName		"+CFN"	/* client form name */
#define	TV_CBannerName		"+CBN"	/* client banner name */
#define	TV_CBannerFileName	"+CBFN"	/* client banner file name */
#define	TV_CHeaderFileName	"+CHFN"	/* client header file name */
#define	TV_CDirectory		"+CD"	/* client directory path */

#define	TV_MailRespond		"+MR"	/* 822 respond to mail address */
#define	TV_WSM				"+WSM"	/* when send message ?*/
#define	    TVWSM_ERROR		"error"	/* send mail on error */
#define		TVWSM_QUEUED	"queued"	/* send mail when queued */
#define		TVWSM_PRINTED	"printed"	/* send mail when printed */

#ifdef	COMMENTS_ON

mail jobs:
	from user bkc@draco.erc.clarkson.edu to fibler@omnigate.clarkson.edu

	SourceHost	draco.erc.clarkson.edu
	SourceObject	bkc
	SourceQueue	mailqueue
	DestHost	omnigate.clarkson.edu
	DestObject	fibler
	DestQueue	workqueue (or blank)

print jobs:
	user bkc from queue draco/testps to draco/realps, job 119

	SourceHost	draco
	SourceObject	bkc
	SourceQueue	testps
	SourceJobId	119
	DestHost	draco
	DestObject	bkc
	DestQueue	realps


#endif
#endif
