@echo off
echo  .              
echo  Purpose:    Move the User Object to the new container.
echo  .              
echo  Important:  Run MOVE-ME.BAT  first!
echo  .               
echo  .       = Description =        = Type =         = Sample =
echo  Par: 1  New user object name   common           dcollins
echo  Par: 2  Old user object name   distinguished    dcollins.saturn.hq.dart
echo  Par: 3  New container name     distinguished    mercury.hq.dart
echo  Par: 4  New default server     common           mercury
echo  Par: 5  Old default group      common           finance
echo  Par: 6  New default group      common           is
echo  .
echo  Note:  if the sample does not have a leading period (.) then don't
echo  use one.  (use exactly the same syntax.)
echo  .
if [%1] == [] goto error
if [%2] == [] goto error
if [%3] == [] goto error
if [%4] == [] goto error
if [%5] == [] goto error
if [%6] == [] goto error
if not exist k:\usr\*.* goto error

Rem  If user object does not exist then 'error' out.
n4object %2 "/c=user" /l
if not errorlevel 1 goto error

Rem  If server object does not exist then 'error' out.
n4object %4 "/c=NCP Server" /l
if not errorlevel 1 goto error

Rem  If group object does not exist then 'error' out.
n4object %5 "/c=group" /l
if not errorlevel 1 goto error

Rem  If group object does not exist then 'error' out.
n4object %6 "/c=group" /l
if not errorlevel 1 goto error

echo  .  Press anykey to start the 'move' or else CTRL-C
pause

rem  Log the command parameter used to help in later debugging.
nlogmsg h:\move-me.log "move-me1 %1 %2 %3 %4 %5 %6"

@echo on

h:
cd\

n4objmgr move .%2 .%3
pause

:server-loop
n4attr %1.%3 "Message Server" O %4 /O=H:\MOVE-ME.LOG
if errorlevel 1 pause
if errorlevel 1 goto server-loop

Rem  Document in the description attribute the change...

n4attr %1.%3 "Description" + "<date> <time> - moved from %5"

n4attr - %1.%3 %5 /O=H:\MOVE-ME.LOG
if errorlevel 1 pause
n4attr + %1.%3 %6 /O=H:\MOVE-ME.LOG
if errorlevel 1 pause

md k:\usr\%1
rights k:\usr\%1 r w c e m f /name=.%1.%3


cd\

goto exit

:error

echo  Error occurred!

:exit
echo .
echo Now run MOVE-ME2.BAT

