program setip;
{$m 5000,0,1000}

uses dos, crt, novell, strnttt5, MiscTTT5;

type
	Pchar = ^char;

const datecode = '14 October 92';

var
  logfile : text;
  logfilename : string;
  debug : boolean;
  subnet_start, subnet_end : integer;
  subnet_base : string;
  prog_name : string;
  option : array [1..6] of string;
  count : integer;
  valid_ip : boolean;
  open_count : integer;
  handle : longint;
  retcode : integer;
  ip_address : string;
  name, realname : string;
  station : integer;
	NewEnv0, NewEnv, p : Pchar;
	i : integer;
	EnvPtr : ^word;		{Will point at PefixSeg:$2C}
	SaveEnvSeg : word;
	PromptIndex : integer;

procedure write_debug(debug_string : string);
begin
 writeln('DEBUG: ',debug_string);
 writeln('Press ENTER to continue....'); readln;
end;

function Env_Size : integer;
	{Returns number of bytes needed for existing environment}
var	i,sz : integer;
begin
	sz := 0;
	for i := 1 to EnvCount do
		sz := sz + 1 + length(EnvStr(i));
	sz := sz + 4 + length(Paramstr(0));  {Program path at end}
	Env_Size := sz;
end;

function VarIndex(v : string) : integer;
	{Returns index of 'v=' string in environment}
var	i : integer;
begin
	for i := 1 to length(v) do v[i] := UpCase(v[i]);
	v := v + '=';
	i := 1;
	while (i<=EnvCount) and (copy (EnvStr(i),1,length(v))<>v) do
		i := i+1;	{Assumes variable names upper case in env}
	if i>EnvCount then i:=0;
	VarIndex := i;
end;

procedure Put0Term (var p:Pchar; s:string);
	{Copies s to 0-terminated string at p, and makes p point at char
	 after last in destination}
var	i : integer;
begin
	for i := 1 to length(s) do
	  begin
		p^ := s[i];
		inc(p);
	  end;
	p^ := #0;
	inc(p);
end;


procedure set_environment;
begin
        {Get memory for copy of environment}
	GetMem (NewEnv0, Env_Size + 16 {space to go up to next segment} +
	    length('NCSA01=') + length('myip~'+ip_address) + 1 {space for expansion});
	NewEnv := ptr (seg(NewEnv0^)+1, 0);	{Make sure 0 offset}

	PromptIndex := VarIndex('NCSA01');
	p := NewEnv;
	for i := 1 to EnvCount do if i<>PromptIndex then
		Put0Term (p, EnvStr(i));	{Copy all but prompt}

	Put0Term (p, 'NCSA01=myip~'+ip_address);	{Insert new variable}

	Put0Term (p, '');		{Place tail of environment}
	Put0Term (p, #1#0+ParamStr(0));	{Word(1) indicates one item, then}
					{ program path}
	EnvPtr := ptr (PrefixSeg, $2c);

	SaveEnvSeg := EnvPtr^;		{Declare new environment}
	EnvPtr^ := seg(NewEnv^);

        {Get memory for copy of environment}
	GetMem (NewEnv0, Env_Size + 16 {space to go up to next segment} +
	    length('MYIP=') + length(ip_address) + 1 {space for expansion});
	NewEnv := ptr (seg(NewEnv0^)+1, 0);	{Make sure 0 offset}

	PromptIndex := VarIndex('MYIP');
	p := NewEnv;
	for i := 1 to EnvCount do if i<>PromptIndex then
		Put0Term (p, EnvStr(i));	{Copy all but prompt}

	Put0Term (p, 'MYIP='+ip_address);	{Insert new variable}

	Put0Term (p, '');		{Place tail of environment}
	Put0Term (p, #1#0+ParamStr(0));	{Word(1) indicates one item, then}
					{ program path}
	EnvPtr := ptr (PrefixSeg, $2c);

	SaveEnvSeg := EnvPtr^;		{Declare new environment}
	EnvPtr^ := seg(NewEnv^);
end;

procedure reset_environment;
begin
	EnvPtr^ := SaveEnvSeg;		{Restore environment segment}
					{Probably not important, but safer}
end;

procedure help;
begin
 clrscr;
 writeln('SET-IP compiled ',datecode,'          mbramwel@novell.business.uwo.ca');
 writeln;
 writeln('Set-IP checks the novell network to see if a range of ip addresses are');
 writeln('being used.  The first un-used ip address is grabbed and an environment');
 writeln('variable called NCSA01 is created for use with NCSA.  A variable called');
 writeln('MYIP is created for use with ms-kermit.');
 writeln;
 writeln('A logfile is stored in Z:\SYSTEM\TCPIP\month.LOG  Make sure people have ');
 writeln('write access to SYS:SYSTEM/TCPIP');
 writeln;
 writeln('SET-IP <ip-base> <subnet-start> <subnet-stop> <program-name> <options>');
 writeln;
 writeln('Example:');
 writeln('set-ip 129.100.22 200 220 f:\apps\ncsa\telbin.exe -h y:config.tel hydra.uwo.ca');
 writeln;
 writeln('The above will check from 129.100.22.200 to 129.100.22.220 looking for a free');
 writeln('address and if it finds one, it will run NCSA Telnet reading the config file');
 writeln('stored on drive Y:  We only keep one copy of config.tel on the server.');
 writeln;
 writeln('Sample    TELNET.BAT');
 writeln('--------------------');
 writeln('f:\apps\ncsa\ipxpkt 0x60');
 writeln('set-ip 129.100.29 120 125 f:\apps\ncsa\telbin.exe -h f:\apps\ncsa\config.tel %1');

 halt;
end;

procedure check_for_ip; { scan novell for semaphore ip address }
begin
 for count := subnet_start to subnet_end do
 begin
   ip_address := subnet_base + '.' + int_to_str(count);
   if debug then write_debug('Trying to find '+ip_address);
   open_semaphore(ip_address, 1, open_count, handle, retcode);
   if debug then write_debug('Semaphore Retcode='+int_to_str(retcode));
   if debug then write_debug('Open count='+int_to_str(open_count));
   if open_count = 1 then
     begin { we have an address! }
       valid_ip := true;
     end
   else
     begin { address is in-use }
       close_semaphore(handle, retcode);
     end;
  if valid_ip then exit;
 end;
end;

procedure setup;
begin
  debug := false;
  if paramstr(1) = '' then help; { base ip address  xxx.xxx.xxx }
  if paramstr(2) = '' then help; { subnet starting point }
  if paramstr(3) = '' then help; { subnet ending point }
  if paramstr(4) = '' then help; { name of program to shell }
  subnet_base := paramstr(1);
  subnet_start := str_to_int(paramstr(2));
  subnet_end := str_to_int(paramstr(3));
  if subnet_start = 0 then help;
  if  subnet_end  = 0 then help;
  for count := 1 to 6 do option[count] := paramstr(count+4);
  valid_ip := false;
  check_for_ip;
end;

procedure log_it(info: string);
begin
  logfilename := 'z:\system\tcpip\'+extractwords(2,1,date)+'.log';
  assign(logfile,logfilename);
  if exist(logfilename) then append(logfile) else rewrite(logfile);
  writeln(logfile, name+' '+date+' '+time+' '+info);
  close(logfile);
end;

procedure run_software;
var shell_string : string;
begin
  if debug then write_debug('we will now try to run the stuff');
  getstation(station,retcode);
  getuser(station,name,retcode);
  get_realname(name,realname,retcode);
  if realname = '' then realname := name;
  writeln(' TCP/IP Network Address for ',realname,' = ',ip_address);
  {shell_string := ' -e "myip='+ip_address+'"';}
  shell_string := '';
  set_environment;
  if getenv('NCSA01') <> 'myip~'+ip_address
     then
     begin
       beep;
       writeln;
       writeln('Unable to set your IP Address.');
       writeln('One possible problem could be "not enough environment space".');
       writeln;
       writeln('Add the following line to your config.sys on your bootdisk,');
       writeln;
       writeln('shell=command.com /e:512 /p');
       writeln;
       writeln('Tested with dos version 3.3 and up.');
       halt;
       end;
  for count := 5 to 9 do
      if paramstr(count) <> '' then shell_string := shell_string + ' ' + paramstr(count);
  if debug then write_debug(shell_string);
  swapvectors;
  log_it(ip_address+' '+paramstr(4)+' '+shell_string);
  exec(getenv('COMSPEC'), '/C '+paramstr(4)+' '+shell_string);
{  exec(getenv('COMSPEC'), '/C ' + getenv('COMSPEC'));}
  if doserror <> 0 then writeln('Dos Error ',doserror);
  swapvectors;
reset_environment;
end;

procedure display_message;
begin
 writeln('There are ',subnet_end - subnet_start + 1,' connections available for this server.');
 writeln;
 writeln('Sorry, all of the network connections are in use.  Please try again later.');
 writeln('If you see this message often, please contact the network manager.');
end;

begin
 setup;
 if valid_ip then run_software else display_message;
end.
